<?php
class AvlFleet_model extends CI_Model
{
	public function count( $filter_company, $filter = '' )
	{
		return $this->get_all( $filter_company, $filter, NULL, 1, 'COUNT(*)' );
	}
	
	public function get_all( $filter_company = NULL, $filter = NULL, $per_page = NULL, $page_num = 1, $fields_get = '*' )
	{
		$where		= SQL::get_or_filter( $filter_company, 'ui_company' );
		$is_count	= -1 != str_starts_with( 'COUNT', $fields_get );
		
		SQL::prepare_filter( $where, $filter, $is_count );
		
		$sql = 'SELECT ' . $fields_get . '	FROM avl_fleet
											INNER JOIN users ON af_uid = uid
											LEFT JOIN users_info ON af_uid = ui_uid ' .
											$where;
		
		if ( NULL != $per_page )
		{
			$sql .= ' LIMIT '. (string)intval( $per_page ) .
					' OFFSET '.(string)intval( ($page_num-1)*$per_page );
		}
		
		if ( $is_count )
		{
			return $this->db->get_var( $sql );
		}
		else
		{
			return $this->db->get_results( $sql, ARRAY_A );
		}
	}
	
	public function add( $name, $uid )
	{
		$umodel	= load_model('User_model');
		$com_id	= $umodel->get_company( intval( $uid ) );
		
		if ( NULL != $com_id )
		{
			$fields = array( 'name', 'uid', 'company' );
			$values = array( $name, $uid, $com_id );
			
			$this->db->query( SQL::make_insert_pdo( 'avl_fleet', $fields, '', 'af_' ), $values );
			
			return $this->db->insert_id();
		}
		
		return NULL;
	}
	
	public function delete( $id )
	{
		$this->db->query( 'UPDATE avl_hardware SET ahw_fleet = NULL WHERE ahw_fleet = ?', array( $id ) );
		$this->db->query( 'DELETE FROM avl_fleet WHERE af_id = ?', array( $id ) );
	}

	public function exists( $fleet )
	{
		return $this->db->get_var( 'SELECT 1 AS exists from avl_fleet WHERE af_id = ? LIMIT 1', array( $fleet ) );
	}
	
	public function company_owns_fleet( $com_id, $fleet )
	{
		return $this->db->get_var( 'SELECT 1 FROM avl_fleet WHERE af_company = ? AND af_id = ? LIMIT 1', array( $com_id, $fleet ) );
	}
	
	public function company_owns_fleet_from_df( $com_df_id, $fleet )
	{
		return $this->db->get_var( 'SELECT 1 FROM company WHERE com_df_id = ? AND com_id IN ( SELECT af_company FROM avl_fleet WHERE af_id = ? LIMIT 1 )', array( $com_df_id, $fleet ) );
	}
	
	public function user_owns_fleet( $uid, $fleet )
	{
		return $this->db->get_var( 'SELECT 1 FROM avl_fleet WHERE af_uid = ? AND af_id = ? LIMIT 1', array( $uid, $fleet ) );
	}
	
	public function update( $name, $id )
	{
		$this->db->query( SQL::make_update_pdo( 'avl_fleet', array( 'name', 'id' ), 'id', '', 'af_' ), array( $name, $id ) );
	}
	
	public function delete_from_company( $com_id )
	{
		$this->db->query( 'DELETE FROM avl_fleet WHERE af_company = ?', array( $com_id ) );
	}
}
