<?php
class AvlEvent_model extends CI_Model
{
	public static function get_company_filter( $filter_company = NULL, $field_name = 'ahw_company' )
	{
		return SQL::get_or_filter( $filter_company, $field_name );
	}
	
	function add( $imei, $evcode, $lat, $long, $date, $gpsstatus, $gpssatnum, $gsmsignal, $speed, $heading, $hdop, $altitude )
	{
		$fields =	array( 
			'imei'		=> $imei, 
			'code'		=> $evcode, 
			'lat'		=> $lat,
			'long'		=> $long,
			'timestamp'	=> $date, 
			'gpsstatus'	=> "'" . $gpsstatus . "'", 
			'gpssatnum'	=> $gpssatnum, 
			'gsmsignal'	=> $gsmsignal, 
			'speed'		=> $speed, 
			'heading'	=> $heading, 
			'hdop'		=> $hdop, 
			'altitude'	=> $altitude,
			'pos'		=> "ST_SetSRID(ST_MakePoint($long,$lat), 4326)"
		);
		
		$sql			=	SQL::make_insert( 'avl_event', $fields, '', 'ae_', TRUE );
		
		$this->db->query( $sql );
		
		return $this->db->insert_id();
	}
	
	function get_tour( $imei, $start_time, $end_time, $filter = NULL, $extra_fields = '', $gmt = 0 )
	{
		$where = "ae_imei = $imei AND ae_timestamp >= $start_time+$gmt AND ae_timestamp <= $end_time+$gmt AND ae_gpsstatus != 'V'";
		
		SQL::prepare_filter( $where, $filter );
		
		$sql = "SELECT avl_hardware.*, ae_id, ae_speed, ae_timestamp, ae_altitude, ae_imei, ae_code, 
						ae_lat, ae_long, ae_hdop, ae_gpsstatus, ae_gpssatnum, ae_gsmsignal, ae_heading,
						(	CASE WHEN ( ( EXTRACT( EPOCH FROM ( NOW() ) )::bigint ) - ae_timestamp > 86400 )
							THEN 'NOREPORT'
							ELSE 
								CASE WHEN ( ae_speed > 0 ) THEN 'MOVING'
								ELSE
									CASE WHEN ( ae_gpsstatus = 'V' ) THEN 'NOGPS'
									ELSE 'STOPPED'
									END
								END
							END
						) state
						$extra_fields
				FROM avl_event
				INNER JOIN avl_hardware ON ahw_imei = ae_imei
				$where
				ORDER BY ae_timestamp ASC";
		
		return $this->db->get_results( $sql, ARRAY_A );
	}
	
	public function delete_from_company( $com_id )
	{
		$this->db->query( 'DELETE FROM avl_event WHERE ae_imei IN ( SELECT ahw_imei FROM avl_hardware WHERE ahw_company = ? )', array( $com_id ) );
	}
	
	public function get_last_valid_position( $imei )
	{
		return $this->db->get_row( "SELECT * FROM avl_event WHERE ae_imei = ? AND ae_gpsstatus != 'V' ORDER BY ae_timestamp DESC LIMIT 1", ARRAY_A, array( $imei ) );
	}
}
