<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 

class SmsSender
{
	const SMS_SOFT_MODE = 1;
	const SMS_SMSMASIVOS_MODE = 2;
	 
	protected $com;
	
	protected function get_company( $com_id )
	{
		$Company_model = load_model('Company_model');
		
		$this->com = $Company_model->get( $com_id, ARRAY_A );
	}
	
	public function send_software( $text, $phone, $com_id )
	{
		$db = db_get();
		$db->set_qd( array( $text, $phone, $com_id ) );
		$db->query( 'INSERT INTO sms_pending ( sms_txt, sms_destination, sms_com_id ) VALUES ( ?, ?, ? )' );
		
		return TRUE;
	}
	
	public function send_smsmasivos( $text, $phone, $com_id )
	{
		$user = $this->com['com_sms_user'];
		$password = $this->com['com_sms_password'];
		$url = "https://servicio.smsmasivos.com.ar/enviar_sms.asp?api=1&usuario={$user}&clave={$password}&tos={$phone}&texto=" . urlencode($text);
		
		$cinit = curl_init();
		curl_setopt($cinit, CURLOPT_URL, $url);
		curl_setopt($cinit, CURLOPT_HEADER,0);
		curl_setopt($cinit, CURLOPT_FOLLOWLOCATION, 1);
		curl_setopt($cinit, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($cinit, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($cinit, CURLOPT_SSL_VERIFYPEER, 0);
		$response = curl_exec($cinit);
		curl_close($cinit);
		
		return $response;
	}
	
	public function send( $text, $phone, $com_id )
	{
		$resp = FALSE;
		$this->get_company( $com_id );
		
		switch ( intval( $this->com['com_sms_mode'] ) )
		{
			case self::SMS_SOFT_MODE:
			{
				$resp = $this->send_software( $text, $phone, $com_id );
				break;
			}
			case self::SMS_SMSMASIVOS_MODE:
			{
				$resp = $this->send_smsmasivos( $text, $phone, $com_id );
				break;
			}
		}
		
		return $resp;
	}
}
