<?php
//EXAMPLE:
//png_painter_apply('polygon.png', array(0x40, 0x00, 0x00), array(0xFF,0x00,0x00));
/*
	aplies a dark red to the black zones of the images, and a pure red to the white zones
	it maintains original alpha channel
	
	and generates a file with an unique signature for that image/colors combination
	
	you can call this function every thime, if it's cached, return the cached image, or if it's
	not cached it generates it on th fly
	
*/

//interpolates two colors in a magical way 
function png_paint_byte($val,$a,$b)
{
	$v = ((float)$val)/255.0; //norm
	$a = ((float)$a)/255.0; //norm
	$b = ((float)$b)/255.0; //norm
	$d = $b-$a;//delta
	return round(($v*$d+$a)*255.0);
}

//generates a unique cache name based on the input file, and the two colors
function png_get_cache_name($input,$color1,$color2)
{
	return md5($input.serialize($color1).serialize($color2)).'.png';
}

function png_painter_apply($file_name,$bg_color,$ft_color, $CACHE_FOLDER_PATH = './', $CACHE_URL_PATH = './', $ret_real_path = false, $opacity = 1.0 )
{
	$file = png_get_cache_name($file_name,$bg_color,$ft_color);
	$fname = $CACHE_FOLDER_PATH.$file;
	
	if(!file_exists($fname))  //if don't exists create it, else return from cache
	{
		$src = imagecreatefrompng($file_name) or die('Problem with source');
		$out = ImageCreateTrueColor(imagesx($src),imagesy($src)) or die('Problem In Creating image');
		//resets alpha channels
		imagealphablending($src, false);
		imagesavealpha($src, true);
		imagealphablending($out, false);
		imagesavealpha($out, true);
		// scan image pixels
		for ($x = 0; $x < imagesx($src); $x++) 
		{
			for ($y = 0; $y < imagesy($src); $y++)
			{
				$src_pix = imagecolorat($src,$x,$y); //get orig pixel
				$pA = imagecolorsforindex( $src, $src_pix ); //rgba 
				$r = png_paint_byte($pA['red'],$bg_color[0],$ft_color[0]);
				$g = png_paint_byte($pA['green'],$bg_color[1],$ft_color[1]);
				$b = png_paint_byte($pA['blue'],$bg_color[2],$ft_color[2]);

				//$pA['alpha'] = 0: opaco / 127 = transparente*/
				$cur_opacity =  -$pA['alpha']/127.0 + 1.0;  //pasa de 0..127 a 1.0 .. 0.0
				$new_alpha = (1.0 - $cur_opacity*$opacity) * 127.0; //back to old format
				$color = imagecolorallocatealpha($out,$r, $g, $b, round($new_alpha));  //creates new color

				imagesetpixel($out, $x, $y, $color);  //write pixel to output
			}
		}

		// write $out to disc
		imagepng($out, $fname,9) or die('Problem saving output image');
		imagedestroy($src);
		imagedestroy($out);
	}
	
	if ( $ret_real_path )
		return $CACHE_FOLDER_PATH.$file;
	
	return $CACHE_URL_PATH.$file;
}
