<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');  

class Openkey
{
	public function send_openkey_image( $re_id )
	{
		$RadarEvent_model = load_model('RadarEvent_model');
		
		$re = $RadarEvent_model->get( $re_id );
		
		if ( empty( $re['com_openkey_hostname'] ) )
		{
			$RadarEvent_model->update_upload_state( $re_id, RadarEventUploadStatus::NOT_REQUIRED );
			
			return TRUE;
		}
		
		$ftp = load_library('ftp');
		
		$config['hostname'] = $re['com_openkey_hostname'];
		
		if ( strpos( $re['com_openkey_hostname'], ':' ) > 0 )
		{
			$hostparts = explode( ':', $re['com_openkey_hostname'] );
			$config['hostname'] = $hostparts[0];
			$config['port'] = $hostparts[1];
		}
		
		$config['username'] = $re['com_openkey_user'];
		$config['password'] = $re['com_openkey_pass'];
		$config['passive']  = TRUE;
		
		if ( $ftp->connect( $config ) )
		{
			$date = date( "d-m-y-H-i-s", $re['re_timestamp'] );
			
			$filename = $re['com_openkey_abbr'] . '-' . $date . '-' . $re['re_max_speed'] . '-' . $re['re_speed'] . '-' . $re['re_plate'] . '.jpg';
			
			if ( $ftp->upload( FINESPATH . $re['re_image'], '/' . $filename ) )
			{
				$RadarEvent_model->update_upload_state( $re_id, RadarEventUploadStatus::UPLOADED );
				
				$ftp->close();
				
				return TRUE;
			}
			
			$ftp->close();
		}
		
		$RadarEvent_model->update_upload_state( $re_id, RadarEventUploadStatus::NOT_UPLOADED );
		
		return FALSE;
	}
}