<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 

class Meitrack
{
	protected $listener_host	= '127.0.0.1';
	protected $listener_port	= 4560;
	
	protected function send_to_listener( $to_ip, $to_port, $imei, $cmd )
	{
		$retry	= 4;
		
		do
		{
			$up['cmd']	= 'update_ip';
			$up['ip']	= $to_ip;
			$up['port']	= $to_port;
			$up['imei']	= $imei;
			$mid		= json_encode($up);
			$fp			= @fsockopen( "udp://" . $this->listener_host, $this->listener_port, $errno, $errstr );
			
			if ( $fp )
			{
				if ( @fwrite( $fp, $mid ) && @fwrite( $fp, $cmd ) )
				{
					@fclose($fp);
					
					return TRUE;
				}

				usleep(250000);
				
				@fclose($fp);
			}
			else
			{
				usleep(250000);
			}
		} while ( --$retry );
	}
	
	protected function create_msg_from_packet( $imei, $packet, $type = 'Q' )
	{
		$pt2	= ",$imei,$packet";
		$pt1	= "@@$type" . ( strlen($pt2) + 5 );
		$msg	= $pt1 . $pt2 . '*';
		
		return $msg . $this->get_checksum( $msg ) . "\r\n";
	}
	
	public function send_cmd( $imei, $cmd, $param1 = null, $param2 = null, $param3 = null, $param4 = null, $param5 = null, $param6 = null )
	{
		$packet = "";
		
		switch ( strtoupper( $cmd ) )
		{
			case 'A10':	$packet = "A10";															break;
			case 'A11':	$packet = "A11,$param1";													break;
			case 'A12':	$packet = "A12,$param1,$param2";											break;
			case 'A13':	$packet = "A13,$param1";													break;
			case 'A14':	$packet = "A14,$param1";													break;
			case 'A15':	$packet = "A15,$param1,$param2";											break;
			case 'A16':	$packet = "A16,$param1";													break;
			case 'A21':	$packet = "A21,$param1,$param2,$param3,$param4,$param5,$param6";			break;
			case 'A22':	$packet = "A22,$param1";													break;
			case 'A23':	$packet = "A23,$param1,$param2";											break;
			case 'A73':	$packet = "A73,$param1";													break;
			case 'B07':	$packet = "B07,$param1";													break;
			case 'B21':	$packet = "B21,$param1";													break;
			case 'B91':	$packet = "B91,$param1,$param2";											break;
			case 'B92':	$packet = "B92,$param1,$param2";											break;
			case 'B93':	$packet = "B93,$param1";													break;
			default:
			{
			}
		}
		
		if ( !empty( $packet ) )
		{
			$this->send_msg( $imei, $this->create_msg_from_packet( $imei, $packet ) );
		}
	}
	
	public function send_msg( $imei, $msg )
	{
		$ahm = load_model('AvlHardware_model');
		
		$hw		= $ahm->get_ip_port( $imei );
		$ip		= $hw['ahw_ip'];
		$port	= $hw['ahw_port'];
		
		if ( isset( $ip ) && is_string( $ip ) && filter_var( $ip, FILTER_VALIDATE_IP ) )
		{
			if ( is_array( $msg ) )
			{
				$msg = json_encode( $msg );
			}
			
			return $this->send_to_listener( $ip, $port, $imei, $msg );
		}
		
		return FALSE;
	}
	
	public function get_checksum( $data )
	{
		$checksum	= 0;
		$len		= strlen( $data );
		
		for ( $i = 0; $i < $len; $i++)
		{
			$checksum += ord( substr( $data, $i, 1 ) );

			if ( $i > 0 )
			{
				if ( $data[$i] == '*')
				{
					break;
				}
			}
		}
		
		$s = (string)dechex( $checksum );
		
		$slen = strlen( $s );
		
		if ( $slen > 2 )
		{
			$s = substr( $s, $slen - 2 );
		}
		
		return strtoupper( $s );
	}
	
	public function get_default_config()
	{
		$cfg['sims']		= 0;
		$cfg['domo_alr']	= 0;
		$cfg['heart_alr']	= 1200;
		$cfg['speed_alr']	= 50;
		$cfg['time_alr']	= 600;
		$cfg['head_alr']	= 40;
		$cfg['dist_alr']	= 300;
		$cfg['park_alr']	= 1000;
		$cfg['gsm']			= "internet.ctimovil.com.ar:gprs::reddomo.com.ar:4550:0";
		$cfg['sec_gsm']		= ":";
		$cfg['dns']			= "";
		$cfg['upgr_ver']	= "";
		$cfg['firm_ver']	= "";
		$cfg['in1']			= "0:0";
		$cfg['in2']			= "0:0";
		$cfg['out1']		= 0;
		$cfg['out2']		= 0;
		$cfg['out3']		= 0;
		$cfg['out4']		= 0;
		$cfg['sleep_lvl']	= 1;
		$cfg['antitheft']	= 0;
		$cfg['accel_alr']	= 0;
		$cfg['decel_alr']	= 0;
		$cfg['event_flg']	= "FFFFFFFFFFFFFFFF";
		
		return $cfg;
	}
	
	public function gen_config( $imei, $config )
	{
		$cmd['cmd']		= 'config_set';
		$cmd['imei']	= $imei;
		$cmd['config']	= $config;
		return json_encode($cmd);
	}
	
	/** THIS IS JUST TO PRINT THE CONFIG MESSAGE REFERENCE */
	public function default_config()
	{
		$cmd['cmd'] = 'config_set';
		$cmd['imei'] = '1234456789';
		$cmd['config'] = $this->get_default_config();
		
		echo json_enc( $cmd );
	}
	
	public function default_config_response()
	{
		$cmd['cmd'] = 'config_response';
		$cmd['imei'] = '123456789';
		$cmd['result'] = 'OK';
		
		echo json_enc( $cmd );
	}
	
	public function config_auto_cast( &$cfg )
	{
		foreach ( $cfg as $k=>$v )
		{
			if ( (string)intval( $v ) == $v )
			{
				$cfg[$k] = intval($v);
			}
			else if ( (string)floatval( $v ) == $v )
			{
				$cfg[$k] = floatval($v);
			}
		}
		
		if ( !isset( $cfg['sleep_lvl'] ) )
		{
			$cfg['sleep_lvl'] = 0;
		}

		$cfg['out1']		= isset( $cfg['out1'] ) ? 1 : 0;
		$cfg['out2']		= isset( $cfg['out2'] ) ? 1 : 0;
		$cfg['out3']		= isset( $cfg['out3'] ) ? 1 : 0;
		$cfg['out4']		= isset( $cfg['out4'] ) ? 1 : 0;
	}
}