<?php
require_once( LIBSPATH . 'frames/frame_utils.php' );
require_once( LIBSPATH . 'graphs/graphfilter.php' );
require_once( LIBSPATH . 'hwstats.php' );
require_once( 'geocode.php' );

class ServiceState
{
	const HIGH = 1;
	const MEDIUM = 0;
	const LOW  = -1;
}

class HardwareMap extends FilteredGraph
{
	private static function prepare_map()
	{
		self::init_filters( -600 );
		
		if ( self::$hours_to_show < 0 ) //set defaults
		{
			self::$hours_to_show = 1;
			self::$secs_to_show = self::$hours_to_show*3600;
			self::$signal_filter =  GraphFilter::UGLY;
		}
		
		self::update_time( self::$final_datetime, self::$secs_to_show , false );
	}
	
	public static function createmap( $data, $envelope_class="map_canvas", $bg_class="mapa_bg", $data_fake_raw = NULL, $data_receiver_raw = NULL, $data_radar_raw = NULL )
	{
		$db = db_get();
		
		$map_error = '';
		$test_states_count = array(
			TestState::DEAD => 0,
			TestState::LOW => 0,
			TestState::GOOD => 0,
			TestState::EXCELLENT => 0
		);
		$test_states_gprs_count = array(
			TestState::DEAD => 0,
			TestState::LOW => 0,
			TestState::GOOD => 0,
			TestState::EXCELLENT => 0
		);
		
		$geocode_failed = FALSE;
		
		if ( isset( $data ) )
		{
			foreach ( $data as &$row )
			{
				$row['thours'] = self::$hours_to_show;
				
				// Set the hw state
				$state = self::get_tests_state_from_test_count( $row['count'], $row['com_hw_state_low'], $row['com_hw_state_good'] );
				
				// Set tests as the TOTAL test count
				$tests = $row['count'];
				
				// Adds the hw to the current count of states
				if ( isset( $row['hw_imei'] ) )
				{
					$test_states_gprs_count[$state]++;
				}
				else
				{
					$test_states_count[$state]++;
				}
				
				$row['tests_state'] = array( 'state' => $state, 'count' => $tests );
				
				if ( $row['hw_core'] == 1 )
				{
					$row['hw_icon'] = 'NUCLEATOR';
				}
				
				//resolves coords if not in db
				if ( $row['hw_lat'] == 0 && $row['hw_long'] == 0 && !$geocode_failed )
				{
					$gdc_status = '';
					$loc = '';
					
					if ( isset( $row['loc_desc'] ) )
					{
						$loc = ', ' . $row['loc_desc'];
					}
					
					$coords = Geocode::GetLatLong($row['hw_address'], $row['loc_name'] . $loc, $gdc_status);
					
					if ( $coords )
					{
						$row['hw_lat'] = $coords->lat;
						$row['hw_long'] = $coords->lng;
						
						$db->set_qd(array($row['hw_lat'],$row['hw_long'], $row['hw_id']));	
						$db->query('UPDATE hardware SET hw_lat = ?, hw_long = ? WHERE hw_id = ?');
					}
					else
					{
						$map_error .= '<script>console.log("ERROR al conectar a google maps geocode: '.$gdc_status.' '.$row['hw_address'].'");</script>';
						
						$geocode_failed = TRUE;
					}
				}
			}
		}
		
		// Only analize if the filter is for GOOD or BAD
		if ( self::$signal_filter !=  GraphFilter::UGLY )
		{
			$tdata = array();
			
			foreach ( $data as $key => $arr )
			{
				$remove		= false;
				$somebad	= false;
				$state		= $data[$key]['tests_state']['state'];
				
				if ( self::$signal_filter == GraphFilter::GOOD )
				{
					if ( !( $state == TestState::DEAD || $state == TestState::LOW ) )
					{
						$tdata[] = $data[$key];
					}
				}
				else if ( self::$signal_filter ==  GraphFilter::BAD )
				{
					if ( $state != TestState::EXCELLENT )
					{
						$tdata[] = $data[$key];
					}
				}
			}
			
			$data = $tdata;
		}
		
		$js_fake_data = "null";
		
		if ( isset( $data_fake_raw ) )
		{
			foreach ( $data_fake_raw as &$row )
			{
				//resolves coords if not in db
				if( $row['hwf_lat'] == 0 && $row['hwf_long'] == 0 )
				{
					if ( !$geocode_failed )
					{
						$gdc_status = '';
						$coords = Geocode::GetLatLong($row['hwf_address'], $row['loc_name'] . ', ' . $row['loc_desc'], $gdc_status);
						
						if( $coords )
						{
							$row['hwf_lat'] = $coords->lat;
							$row['hwf_long'] = $coords->lng;
							$db->set_qd(array($row['hwf_lat'],$row['hwf_long'], $row['hwf_id']));	
							$db->query('UPDATE hardware_fake SET hwf_lat = ?, hwf_long = ? WHERE hwf_id = ?');
						}
						else
						{
							$map_error .= '<script>console.log("ERROR al conectar a google maps geocode: '.$gdc_status.' '.$row['hwf_address'].'");</script>';
							$geocode_failed = TRUE;
						}
					}
					
					unset( $row );
				}
			}
			
			$js_fake_data = json_encode( array_values( $data_fake_raw ) );
		}
		
		$js_receiver_data = "null";
		
		if ( isset( $data_receiver_raw ) )
		{
			$js_receiver_data = json_encode( array_values( $data_receiver_raw ) );
		}
		
		$js_radar_data = "null";
		
		if ( isset( $data_radar_raw ) )
		{
			$js_radar_data = json_encode( array_values( $data_radar_raw ) );
		}
		
		$js_data = json_encode( $data );
		$map_html = $map_error.'
		<script type="text/javascript">
			function load_map()
			{
				map_make( \''.$envelope_class.'\', map_data, map_fake_data, map_receiver_data, map_radar_data );
			}
			
			function on_site_loaded()
			{
				load_map();
			}
			
			var map_data			= '.$js_data.';
			var map_fake_data		= '.$js_fake_data.';
			var map_receiver_data	= '.$js_receiver_data.';
			var map_radar_data		= '.$js_radar_data.';
			
			$(function()
			{
				if ( site_loaded )
				{
					load_map();
				}
				
				kajax_register_unload_callback(function()
				{
					delete map_data;
					delete map_fake_data;
					map_reset();
					return true;
				});
			});
		</script>
		';

		return array( 'html' => $map_html, 'states' => $test_states_count, 'states_gprs' => $test_states_gprs_count, 'data' => $data );
	}
	
	public static function prepare_receivers( &$receivers )
	{
		if ( isset( $receivers ) )
		{
			$recmod = load_model('ReceiverTicks_model');
			
			foreach ( $receivers as &$row )
			{
				$health = $recmod->get_health_percent( $row['com_id'] );
				
				$state = TestState::DEAD;
				
				if ( $health > 0 && $health < 60 )
				{
					$state = TestState::LOW;
				}
				else if ( $health >= 60 && $health < 90 )
				{
					$state = TestState::GOOD;
				}
				else if ( $health >= 90 )
				{
					$state = TestState::EXCELLENT;
				}
				
				$row['tests_state'] = array( 'state' => $state, 'count' => $health );
			}
		}
	}
	
	public static function prepare_radars( &$radars )
	{
		if ( isset( $radars ) )
		{
			foreach ( $radars as &$radar )
			{
				$count = $radar['count'];
				$state = TestState::DEAD;
				
				if ( $count > 0 && $count < 6 )
				{
					$state = TestState::LOW;
				}
				else if ( $count >= 6 && $count < 11 )
				{
					$state = TestState::GOOD;
				}
				else if ( $count >= 11 )
				{
					$state = TestState::EXCELLENT;
				}
				
				$radar['tests_state'] = array( 'state' => $state, 'count' => $count );
			}
		}
	}
	
	protected static function build_filters()
	{
		$filter = array();
		
		if ( NULL != get_var('groups') )
		{
			$groups_filter = SQL::get_or_filter( get_var('groups'), 'hwgl_group' );
			
			if ( isset( $groups_filter ) && !empty( $groups_filter ) )
			{
				$groups_filter =  ' AND ' . $groups_filter;
			}
			
			$filter[] = array(
				'join'			=>	'hardware_group_link',
				'on'			=>	'hw_id = hwgl_hw_id' . $groups_filter
			);
		}
		
		return $filter;
	}
	
	public static function createmap_hw($hw_id, $envelope_class="map_canvas", $bg_class="mapa_bg")
	{
		self::prepare_map();
		
		$res = load_model('Test_model')->get_hw_id( self::$unix_time1, self::$unix_time2, $hw_id, self::build_filters() );
		
		return self::createmap($res, $envelope_class, $bg_class);
	}
	
	public static function createmap_user($envelope_class="map_canvas", $bg_class="mapa_bg")
	{
		$user_id = User()->get_type_id();
		
		self::prepare_map();
		
		$res = load_model('Test_model')->get_user_id( self::$unix_time1, self::$unix_time2, $user_id, self::build_filters() );
		
		return self::createmap($res, $envelope_class, $bg_class);
	}
	
	public static function createmap_company_meta($envelope_class="map_canvas",$bg_class="mapa_bg")
	{
		self::prepare_map();
		
		$company_ids = User()->get_company_ids();
		
		$res = load_model('Test_model')->get_all( self::$unix_time1, self::$unix_time2, $company_ids, self::build_filters() );
		
		$res_fake = load_model('HardwareFake_model')->get_all( $company_ids );
		
		$res_receiver = load_model('Company_model')->get_receivers( $company_ids );
		
		$res_radar = load_model('RadarTest_model')->get_all( self::$unix_time1, self::$unix_time2, $company_ids );
		
		self::prepare_receivers( $res_receiver );
		
		self::prepare_radars( $res_radar );
		
		return self::createmap( $res, $envelope_class, $bg_class, $res_fake, $res_receiver, $res_radar );
	}
	
	public static function createmap_company($envelope_class="map_canvas",$bg_class="mapa_bg")
	{
		return self::createmap_company_meta( $envelope_class, $bg_class );
	}
	
	public static function createmap_god($envelope_class="map_canvas", $bg_class="mapa_bg")
	{
		self::prepare_map();
		
		$res = load_model('Test_model')->get_all( self::$unix_time1, self::$unix_time2, NULL, self::build_filters() );
		
		$res_receiver = load_model('Company_model')->get_receivers();
		
		$res_radar = load_model('RadarTest_model')->get_all( self::$unix_time1, self::$unix_time2, NULL );
		
		self::prepare_receivers( $res_receiver );
		
		self::prepare_radars( $res_radar );
		
		return self::createmap( $res, $envelope_class, $bg_class, null, $res_receiver, $res_radar );
	}
	
	public static function createmap_company_id( $company_id )
	{
		self::prepare_map();
		
		$res = load_model('Test_model')->get_all( self::$unix_time1, self::$unix_time2, $company_id, self::build_filters() );
		
		return HW_Stats::create_tests_data( $res );
	}
}