<?php 
require_once( LIBSPATH . 'graphs/graphfilter.php' );

class HW_Stats extends FilteredGraph
{
	public static function get_god_query($time_start, $time_end, $time_span = 0)
	{
		$tltos			= TESTS_LOG_TIMEOUT_SECONDS; // 1 hour * 96
		$test_log		= 'tests_log';
		$t				= time();
		$groups_join	= '';
		
		if ( $t - $time_start > $tltos )
		{
			$test_log	= 'tests_log_history';
		}
		
		if ( '' != self::$group_filter )
		{
			$groups_join	= 'INNER JOIN hardware_group_link ON hw_id = hwgl_hw_id AND ' . self::$group_filter;
		}

		$sql = 'SELECT ui_name, ui_lastname, ui_uid, com_name, com_hw_report_freq, com_hw_state_low, com_hw_state_good, hardware.*, loc_name, loc_desc, tl_from_time AS time, tl_tests_count AS count
				FROM hardware
				LEFT JOIN users_info ON hw_user = ui_id
				LEFT JOIN ' . $test_log . ' ON tl_hw_id = hw_id AND tl_from_time >= '.($time_start-$time_span).' AND tl_from_time <= '.$time_end.' '.
				$groups_join . ' 
				INNER JOIN company ON hw_df_company = com_df_id AND hw_df_receiver = com_rec_id
				INNER JOIN locations ON hw_city = loc_id 
				WHERE TRUE ';
		
		if ( ( $hw_code = get_var('gf_hw_code') ) != NULL )
		{
			$sql .= ' AND hw_code = ' . hexdec( $hw_code ); 
		}
		
		if ( ( $hw_serial = get_var('gf_hw_serial') ) != NULL )
		{
			$sql .= ' AND hw_serial = ' . hexdec( $hw_serial ); 
		}
		
		return $sql;
	}
	
	public static function get_order_query()
	{
		return ' ORDER BY hw_df_company, hw_df_receiver, hw_code ASC ';
	}
	
	public static function get_map_order_query()
	{
		return ' ORDER BY tl_from_time ASC';
	}

	public static function get_meta_company_query($time_start, $time_end, $time_span = 0)
	{
		$query = self::get_god_query($time_start, $time_end, $time_span);
		$query .= ' AND com_df_id = ?';
		return $query;
	}
	
	public static function get_company_query($time_start, $time_end, $time_span = 0)
	{
		$query = self::get_god_query($time_start, $time_end, $time_span);
		$query .= ' AND com_id = ?';
		return $query;
	}

	public static function get_company_meta_query($time_start, $time_end, $time_span = 0)
	{
		$query = self::get_god_query($time_start, $time_end, $time_span);
		$query .= ' AND com_df_id = ?';
		return $query;
	}
	
	public static function get_hw_query( $time_start, $time_end, $time_span = 0 )
	{
		$query = self::get_god_query($time_start, $time_end, $time_span);
		
		$query .= ' AND hw_id = ?';

		return $query;
	}
	
	public static function get_user_query( $time_start, $time_end, $time_span = 0 )
	{
		$query = self::get_god_query($time_start, $time_end, $time_span);
		
		$query .= ' AND hw_user = ?';
		
		return $query;
	}
	
	public static function createtestdata_hw( $hw_id )
	{
		self::update_time();
		
		$res = load_model('Test_model')->get_hw_id( self::$unix_time1, self::$unix_time2, $hw_id );
		
		return self::create_tests_data($res, self::$unix_time1, self::$unix_time2);
	}
	
	public static function createtestdata_company( $com_id = NULL )
	{
		self::update_time();
		
		$company_id = ( NULL == $com_id ) ? User()->get_type_id() : $com_id;
		
		$db = db_get();
		
		$query = self::get_company_query(self::$unix_time1, self::$unix_time2, FrameUtils::$TESTS_LOG_TIMESPAN_SEC) . self::get_map_order_query();
		
		$db->set_qd(array($company_id));
		
		$res = $db->get_results($query ,ARRAY_A);
		
		return self::create_tests_data($res, self::$unix_time1, self::$unix_time2);
	}

	public static function createtestdata_company_meta()
	{
		self::update_time();

		$com_df_id = User()->get_df_code();

		$db = db_get();

		$query = self::get_company_meta_query(self::$unix_time1, self::$unix_time2, FrameUtils::$TESTS_LOG_TIMESPAN_SEC) . self::get_map_order_query();

		$db->set_qd(array($com_df_id));

		$res = $db->get_results($query ,ARRAY_A);

		return self::create_tests_data($res, self::$unix_time1, self::$unix_time2);
	}
	
	public static function createtestdata_god()
	{
		self::update_time();
		
		$db = db_get();
		
		$query = self::get_god_query(self::$unix_time1, self::$unix_time2, FrameUtils::$TESTS_LOG_TIMESPAN_SEC) . self::get_map_order_query();
		
		$res = $db->get_results($query ,ARRAY_A);
		
		return self::create_tests_data($res, self::$unix_time1, self::$unix_time2);
	}
	
	public static function create_tests_data( $data )
	{
		$test_states_count = array(
			TestState::DEAD => 0,
			TestState::LOW => 0,
			TestState::GOOD => 0,
			TestState::EXCELLENT => 0
		);
		
		if ( isset( $data ) )
		{
			foreach ( $data as &$row )
			{
				$state = self::get_tests_state_from_test_count( $row['count'], $row['com_hw_state_low'], $row['com_hw_state_good'] );
				
				$test_states_count[$state]++;
			}
		}

		return $test_states_count;
	}


	public static function magic_round($n)
	{
		if( $n > 13.0 )
		{
			return floor($n);
		}
		else
		{
			return round($n);
		}
	}
	
	public static function create_real_count( &$row, $time_start, $time_end  )
	{
		$count	= count( $row['rtime'] );
		
		if ( $count < 2 )
		{
			return; // abort
		}
		
		$ct				= 0;
		$index			= $count - 2;	// for 1 hour map this should be 0
		$actual			= $count - 1;	// Current hour index
		$x1				= $row['rtime'][$index];	// first log row
		$diff 			= $time_start - $x1;		// Time elapsed since the beginning of the hour
		$ct1			= 0;
		$ct2			= 0;
		$cur_secs		= $time_end - self::round_unixtime( $time_end );
		
		if ( $row['com_hw_report_freq'] >= 10 && $cur_secs <= $row['com_hw_report_freq']*60 )
		{
			$row['count'] = $row['rcount'][$index];
			return;
		}
		
		// here we calculate the parcial count, from the first log
		if ( $diff > 0 && $diff <= FrameUtils::$TESTS_LOG_TIMESPAN_SEC )
		{
			$r1		= $diff / FrameUtils::$TESTS_LOG_TIMESPAN_SEC ;
			$ct1	= $row['rcount'][$index] * ( 1.0 - $r1 );
		}
		else
		{
			$ct1	= $row['rcount'][$index];
		}
		
		// here we calculate the parcial count, from the last log
		if ( $count > 1 )
		{
			$x2		= $row['rtime'][$actual]; //last log row
			$diff2	= $time_end - $x2;
	
			if ( $diff2 > 0  && $diff2 <= FrameUtils::$TESTS_LOG_TIMESPAN_SEC )
			{
				$r2 = $diff2 / FrameUtils::$TESTS_LOG_TIMESPAN_SEC;
				
				$ct2 = $row['rcount'][$actual] * $r2;
			}
			else
			{
				$ct2 = $row['rcount'][$actual];
			}
		}
		
		// Sums the last hour and the current ( but the result is reflected as one hour test log )
		$ct += self::magic_round( $ct1 + $ct2 );
		
		// Sums all the rest of the hours ( including the last complete hour )
		if ( $count > 2 )
		{
			for( $i = 0; $i < $count - 2 ; $i++ )
			{
				$ct += $row['rcount'][$i];
			}
		}
		
		$row['count'] = $ct;
	}
}
