<?php
require_once( 'graphfilter.php' );

class GraphView extends FilteredGraph
{
	protected static function get_company_filter()
	{
		$user = User();
		
		$filter_company	= NULL;
		$company		= NULL != get_var( 'company' ) ? intval( get_var( 'company' ) ) : 0;
		
		if ( $user->get_type() == USER_TYPE_GOD )
		{
			if ( $company > 0 )
			{
				$filter_company = array( $company );
			}
		}
		else if ( $user->get_type() == USER_TYPE_CPNY_META )
		{
			$filter_company = $user->get_child_companies();
		}
		else if ( $user->get_type() >= USER_TYPE_CPNY_RO && $user->get_type() < USER_TYPE_CPNY_META )
		{
			$filter_company = array( $user->get_company() );
		}
		
		return $filter_company;	
	}
	
	protected static function get_tests_from_time_range( $start_time, $end_time, $filter_company = NULL, $showgroups = FALSE )
	{
		$tlcmod		= load_model( 'TestsLogCompany_model' );
		$tlcgmod	= load_model( 'TestsLogCompanyGroup_model' );
		
		if ( $showgroups )
		{
			$q1		= $tlcmod->get_tests_from_time_range_query( $start_time, $end_time, $filter_company );
			$q2		= $tlcgmod->get_tests_from_time_range_query( $start_time, $end_time, $filter_company, get_var('groups') );
			$qunion	= "( $q1 ) UNION ALL ( $q2 )";
			$sql	= "SELECT * FROM ( $qunion ) AS results ORDER BY time ASC, type ASC";
			
			return db_get()->get_results( $sql, ARRAY_A );
		}
		
		return $tlcmod->get_tests_from_time_range( $start_time, $end_time, $filter_company );
	}
	
	protected static function get_tests_from_time_range_rows( $start_time, $end_time, $filter_company = NULL, $showgroups = FALSE )
	{
		$tlcmod		= load_model( 'TestsLogCompany_model' );
		$tlcgmod	= load_model( 'TestsLogCompanyGroup_model' );
		
		if ( $showgroups )
		{
			$q1		= $tlcmod->get_tests_from_time_range_query( $start_time, $end_time, $filter_company );
			$q2		= $tlcgmod->get_tests_from_time_range_query( $start_time, $end_time, $filter_company );
			$qunion	= "( $q1 ) UNION ALL ( $q2 )";
			$sql	= "SELECT * FROM ( $qunion ) AS results ORDER BY time ASC, type ASC";
			$sql	= 'SELECT COUNT(DISTINCT q1.time) FROM (' . $sql . ') AS q1';
			
			return db_get()->get_var( $sql );
		}
		
		return $tlcmod->get_tests_from_time_range_total_rows( $start_time, $end_time, $filter_company );
	}
	
	public static function gen_company_test_graph()
	{
		$commod			= load_model( 'Company_model' );
		$groupsmod		= load_model( 'HardwareGroup_model' );
		$hwmod			= load_model( 'Hardware_model' );
		$company_filter = self::get_company_filter();
		$all_com		= $commod->get_all_names( $company_filter );
		$company		= User()->get_company();
		$showgroups		= NULL != $company_filter && !User()->is_logged_as_company_meta();
		$groups			= $groupsmod->get_all( $company_filter );
		
		if ( User()->is_logged_as_god() )
		{
			$company	= NULL != get_var( 'company' ) ? intval( get_var( 'company' ) ) : 0;
			$all_com	= $commod->get_all_names();
			
			$time_offset	= 60 * 5;
		}
		else
		{
			$time_offset	= $commod->get_freq( $company ) * 60;
		}
		
		if ( $showgroups )
		{
			$rows_f		= array( array( 'com_id' => $company_filter[0], 'com_name' => $commod->get_company_name( $company_filter[0] ) ) );
			
			if ( NULL != $groups )
			{
				foreach ( $groups AS $g )
				{
					array_push( $rows_f, array(  'com_id' => $g['hwg_id'], 'com_name' => $g['hwg_name'] ) );
				}
			}
		}
		else
		{
			$rows_f		= $all_com;
		}

		self::init_filters( -$time_offset );
			
		if( self::$hours_to_show < 0 ) //set defaults
		{
			self::$hours_to_show	= 72;
			self::$secs_to_show		= self::$hours_to_show * 3600;
		}

		self::update_time( self::$final_datetime, self::$secs_to_show , self::$hours_to_show == 1 );
		
		return array( 
				'rows_filtered' => $rows_f,
				'companies' => $all_com,
				'data' => NULL != get_var('ghours') ? self::get_tests_from_time_range( self::$unix_time1, self::$unix_time2, $company_filter, $showgroups ) : NULL,
				'hours' => self::$hours_to_show,
				'date_str' => self::$final_datetime_str,
				'company' => $company,
				'groups' => $groups,
				'max_hval' => $showgroups ? $hwmod->count( $company_filter ) : 0
		);
	}
	
	public static function gen_company_percent_graph()
	{
		self::init_filters();
		
		if( self::$hours_to_show < 0 ) //set defaults
		{
			self::$hours_to_show	= 72;
			self::$secs_to_show		= self::$hours_to_show * 3600;
		}
		
		self::update_time( self::$final_datetime, self::$secs_to_show , self::$hours_to_show == 1 );
		
		$commod			= load_model( 'Company_model' );
		$tlmod			= load_model( 'TestsLog_model' );
		$groupsmod		= load_model( 'HardwareGroup_model' );
		$company		= User()->get_company();
		$group_com_f	= 0 != $company ? $company : NULL;
		
		if ( User()->is_logged_as_god() )
		{
			$company	= NULL != get_var( 'company' ) ? intval( get_var( 'company' ) ) : 0;
		}
		else if ( User()->is_logged_as_company_meta() )
		{
			$group_com_f= User()->get_child_companies();
		}
		
		return array( 
				'companies' => $commod->get_all_names(),
				'data' => $tlmod->get_tests_states_by_hour_prog( self::$unix_time1, self::$unix_time2, self::get_company_filter(), self::$group_filter ),
				'hours' => self::$hours_to_show,
				'date_str' => self::$final_datetime_str,
				'company' => $company,
				'groups' => $groupsmod->get_all( $group_com_f, ARRAY_A )
		);
	}
	
	public static function gen_company_repeated_messages_by_mac()
	{
		self::init_filters();
		
		if( self::$hours_to_show < 0 ) //set defaults
		{
			self::$hours_to_show	= 24;
			self::$secs_to_show		= self::$hours_to_show * 3600;
		}
		
		self::update_time( self::$final_datetime, self::$secs_to_show , self::$hours_to_show == 1 );
		
		$commod			= load_model( 'Company_model' );
		$dfmod			= load_model( 'DataFrames_model' );
		$groupsmod		= load_model( 'HardwareGroup_model' );
		$company		= User()->get_company();
		$group_com_f	= 0 != $company ? $company : NULL;
		
		if ( User()->is_logged_as_god() )
		{
			$company	= NULL != get_var( 'company' ) ? intval( get_var( 'company' ) ) : 0;
		}
		else if ( User()->is_logged_as_company_meta() )
		{
			$group_com_f= User()->get_child_companies();
		}
		
		return array( 
				'companies' => $commod->get_all_names(),
				'data' => $dfmod->get_repeated_messages_by_time( self::$unix_time1, self::$unix_time2, self::get_company_filter(), self::$group_filter ),
				'hours' => self::$hours_to_show,
				'date_str' => self::$final_datetime_str,
				'company' => $company,
				'groups' => $groupsmod->get_all( $group_com_f, ARRAY_A )
		);
	}
	
	public static function gen_company_repeated_messages()
	{
		self::init_filters();
		
		if( self::$hours_to_show < 0 ) //set defaults
		{
			self::$hours_to_show	= 24;
			self::$secs_to_show		= self::$hours_to_show * 3600;
		}
		
		self::update_time( self::$final_datetime, self::$secs_to_show , self::$hours_to_show == 1 );
		
		$commod			= load_model( 'Company_model' );
		$dfmod			= load_model( 'DataFrames_model' );
		$groupsmod		= load_model( 'HardwareGroup_model' );
		$company_filter = self::get_company_filter();
		$all_com		= $commod->get_all_names( $company_filter );
		$company		= User()->get_company();
		$showgroups		= NULL != $company_filter && !User()->is_logged_as_company_meta();
		$groups			= $groupsmod->get_all_names( $company_filter );
		
		if ( User()->is_logged_as_god() )
		{
			$company	= NULL != get_var( 'company' ) ? intval( get_var( 'company' ) ) : 0;
			$all_com	= $commod->get_all_names();
		}
		
		if ( $showgroups )
		{
			$rows_f		= array( array( 'com_id' => $company_filter[0], 'com_name' => $commod->get_company_name( $company_filter[0] ) ) );
			
			if ( NULL != $groups )
			{
				foreach ( $groups AS $g )
				{
					array_push( $rows_f, array(  'com_id' => $g->id, 'com_name' => $g->name ) );
				}
			}
		}
		else
		{
			$rows_f		= $all_com;
		}
		
		$data = $dfmod->get_repeated_from_time_range( self::$unix_time1, self::$unix_time2, $company_filter );
		
		if ( $showgroups )
		{
			if ( NULL != $groups )
			{
				foreach ( $groups AS $g )
				{
					$group_res = $dfmod->get_repeated_from_time_range_group( self::$unix_time1, self::$unix_time2, $company_filter, $g->id );
					
					if ( NULL != $group_res )
					{
						$data = array_merge( $data, $group_res );
					}
				}
			}
		}
		
		$sorter = new array_sorter( $data, 'time', false );
		
		if ( isset( $data ) )
		{
			$data = $sorter->sortit();
		}
		
		return array( 
				'rows_filtered' => $rows_f,
				'companies' => $all_com,
				'data' => $data,
				'hours' => self::$hours_to_show,
				'date_str' => self::$final_datetime_str,
				'company' => $company,
				'groups' => $groups,
				'max_hval' => 0
		);
	}
	
	public static function gen_receiver_ticks_graph()
	{
		$commod			= load_model( 'Company_model' );
		$rtp			= load_model( 'ReceiverTicksPeriod_model' );
		$company_filter = self::get_company_filter();
		$all_com		= $commod->get_all_names( $company_filter );
		$company		= User()->get_company();
		
		if ( User()->is_logged_as_god() )
		{
			$company	= NULL != get_var( 'company' ) ? intval( get_var( 'company' ) ) : 0;
			$all_com	= $commod->get_all_names();
		}

		$rows_f		= $all_com;

		self::init_filters( -RECEIVER_TICKS_PERIOD_TIME );
		
		if( self::$hours_to_show < 0 ) //set defaults
		{
			self::$hours_to_show	= 24;
			self::$secs_to_show		= self::$hours_to_show * 3600;
		}
		
		self::update_time( self::$final_datetime, self::$secs_to_show , self::$hours_to_show == 1 );
		
		return array( 
				'rows_filtered' => $rows_f,
				'companies' => $all_com,
				'data' => $rtp->get_ticks_from_time_range( self::$unix_time1, self::$unix_time2, $company_filter ),
				'total_rows' => $rtp->get_ticks_from_time_range_rows( self::$unix_time1, self::$unix_time2, $company_filter ),
				'hours' => self::$hours_to_show,
				'date_str' => self::$final_datetime_str,
				'company' => $company,
				'max_hval' => 0
		);
	}
	
	public static function gen_hardware_installed_by_month()
	{
		$hwmod			= load_model('Hardware_model');
		$commod			= load_model( 'Company_model' );
		
		$company_filter = self::get_company_filter();
		$all_com		= ( User()->is_logged_as_god() ) ? $commod->get_all_names() : $commod->get_all_names( $company_filter );
		$company		= User()->get_company();
		$months_to_show	= get_var_def( 'months', 48 );
		
		if ( isset( $months_to_show ) )
		{
			$start_time	= strtotime("-$months_to_show months");
			$end_time	= time();
		}
		else
		{
			$start_time	= NULL;
			$end_time	= NULL;
		}
		
		$vis_data = $hwmod->get_instalation_by_month( $start_time, $end_time, $company_filter );
		
		return array( 
				'rows_filtered' => $all_com,
				'companies' => $all_com,
				'data' => $vis_data,
				'months' => $months_to_show,
				'company' => $company,
				'max_hval' => 0,
				'total_rows' => isset( $vis_data ) ? count( array_unique(array_map(function ($i) { return $i['tlc_from_time']; }, $vis_data) ) ) : 0
		);
	}
	
	public static function gen_hw_events_by_time()
	{
		self::init_filters();
		
		if( self::$hours_to_show < 0 ) //set defaults
		{
			self::$hours_to_show	= 24;
			self::$secs_to_show		= self::$hours_to_show * 3600;
		}

		self::update_time( self::$final_datetime, self::$secs_to_show , self::$hours_to_show == 1 );
		
		$commod			= load_model( 'Company_model' );
		$dfmod			= load_model( 'DataFrames_model' );
		$company_filter = self::get_company_filter();
		$all_com		= $commod->get_all_names( $company_filter );
		$company		= User()->get_company();
		
		if ( User()->is_logged_as_god() )
		{
			$company	= NULL != get_var( 'company' ) ? intval( get_var( 'company' ) ) : 0;
			$all_com	= $commod->get_all_names();
		}

		$rows_f		= $all_com;

		return array( 
				'rows_filtered' => $rows_f,
				'companies' => $all_com,
				'data' => $dfmod->get_messages_by_company( self::$unix_time1, self::$unix_time2, $company_filter ),
				'hours' => self::$hours_to_show,
				'date_str' => self::$final_datetime_str,
				'company' => $company,
				'max_hval' => 0
		);
	}
}
