<?php
require_once( LIBSPATH . 'frames/frame_utils.php' );
require_once( LIBSPATH . 'graphs/graphview.php' );
require_once( LIBSPATH . 'hwstats.php' );

class HardwareGraph extends GraphView
{
	public static function create_graph( $type, $data = null )
	{
		$db = db_get();
		
		self::init_filters();

		if( self::$hours_to_show < 0 ) //set defaults
		{
			self::$hours_to_show	= 24;
			self::$secs_to_show		= self::$hours_to_show * 3600;
			self::$signal_filter	= GraphFilter::UGLY;
		}

		$func					= null;
		$arrs					= null;
		
		switch ( $type )
		{
			case USER_TYPE_GOD:
			{
				$func = 'HW_Stats::get_god_query';
				break;
			}
			case USER_TYPE_CPNY_META:
			{
				$arrs = array( User()->get_df_code() );
				$func = 'HW_Stats::get_company_meta_query';
				break;
			}
			case USER_TYPE_CPNY:
			{
				$arrs = array( User()->get_type_id() );
				$func = 'HW_Stats::get_company_query';
				break;
			}
			case USER_TYPE_USER:
			{
				$arrs = array( User()->get_type_id() );
				$func = 'HW_Stats::get_user_query';
				break;
			}
			case USER_TYPE_HW:
			{
				$arrs = array( $data );
				$func = 'HW_Stats::get_hw_query';
				break;				
			}
		}

		$first		= true;
		$data_table	= array();
		$hw_keys	= array();
		
		for( $i = self::$hours_to_show; $i > 0; $i-- )
		{
			$t2	= self::$final_datetime - 3600 * ( $i - 1 );
			$t1	= $t2 - 3600; //1hr 
			
			$db->set_qd( $arrs );
			
			$sql = call_user_func( $func, $t1, $t2 ) . HW_Stats::get_order_query();
			$res = get_var('ghours') != NULL || USER_TYPE_HW == $type ? $db->get_results( $sql, ARRAY_A ) : NULL;
			
			if ( isset( $res ) )
			{
				foreach ( $res as $d )
				{
					$key = '';
					
					if ( $first )
					{
						$u_id_txt = ( $d['hw_df_company'] ).'-'.( $d['hw_df_receiver'] ).'-'.dechex( $d['hw_code'] ).'-'.dechex( $d['hw_serial'] );
						
						$name = '';
						$dir = '';
						
						if ( $d['ui_name'] != null && $d['ui_lastname'] != null )
						{
							$name = $d['ui_name'] . ' ' . $d['ui_lastname']; 
						}
						
						if ( $d['hw_name'] != '' )
						{
							if ( $name != '' )
							{
								$dir = ', ';
							}
							
							$dir .= $d['hw_name'];
						}
						
						$namedata = '';
						
						if ( '' != $name || '' != $dir )
						{
							$namedata = ' ( ' . $name . $dir . ' )';
						}
						
						$key = $u_id_txt . $namedata;
						
						$hw_keys[ $d['hw_id'] ] = $key;
						
						$data_table[ $key ] = array();
					}
					else
					{
						$key = $hw_keys[ $d['hw_id'] ];
					}
					
					$data_table[ $key ][] = isset( $d['count'] ) ? $d['count'] : 0;
				}
			}
			else
			{
				break;
			}
			
			$first = false;
		}
		
		// Avoid processing this if there's no filter
		if ( self::$signal_filter !=  GraphFilter::UGLY )
		{
			foreach ( $data_table as $key => $arr )
			{
				$c			= 0;
				$s			= count( $arr );
				$l			= $s - 2;
				$remove		= false;
				$somebad	= false;
				
				for ( $i = 0; $i < $s; $i++ )
				{
					if( $c < $l )	//doesn't take in account the last hour
					{
						if ( self::$signal_filter ==  GraphFilter::GOOD )
						{
							if ( $arr[$i] <= GraphFilter::GOOD_BAD_THRESHOLD )
							{
								$remove = true;
								break;
							}
						}
						else if ( self::$signal_filter ==  GraphFilter::BAD )
						{
							if ( $arr[$i] <= GraphFilter::GOOD_BAD_THRESHOLD )
							{
								$somebad = true;
								break;
							}
						}
					}
					
					$c++;
				}
				
				if ( 	( self::$signal_filter ==  GraphFilter::GOOD && $remove ) || 
						( self::$signal_filter ==  GraphFilter::BAD && !$somebad ) )
				{
					unset( $data_table[$key] );
				}
			}
		}
		
		$commod			= load_model( 'Company_model' );
		$all_com		= $commod->get_all_names();
		$company_filter = self::get_company_filter();
		$company		= NULL != get_var( 'company' ) ? intval( get_var( 'company' ) ) : 0;
		$groupsmod		= load_model( 'HardwareGroup_model' );
		
		if ( NULL != $company_filter )
		{
			$com_f		= array( array( 'com_id' => $company_filter[0], 'com_name' => $commod->get_company_name( $company_filter[0] ) ) );
		}
		else
		{
			$com_f		= $all_com;
		}
		
		$arr = array(
			'companies_filtered' => $com_f,
			'companies' => $all_com,
			'data' => get_var('ghours') || USER_TYPE_HW == $type ? $data_table : null,
			'hours' => self::$hours_to_show,
			'final_datetime' => self::$final_datetime,
			'date_str' => self::$final_datetime_str,
			'signal_filter' => self::$signal_filter,
			'groups' => $groupsmod->get_all( User()->get_company() )
		);
		
		if ( USER_TYPE_HW == $type )
		{
			$hwmodel = load_model('Hardware_model');
			
			$arr['hw']	= $hwmodel->get( $data );
		}
		
		return $arr;
	}
	
	public static function creategraph_god()
	{
		return self::create_graph( USER_TYPE_GOD );
	}
	
	public static function creategraph_user()
	{
		return self::create_graph( USER_TYPE_USER );
	}
	
	public static function creategraph_company()
	{
		return self::create_graph( USER_TYPE_CPNY );
	}

	public static function creategraph_company_meta()
	{
		return self::create_graph( USER_TYPE_CPNY_META );
	}
	
	public static function creategraph_hw( $hw_id )
	{
		return self::create_graph( USER_TYPE_HW, $hw_id );
	}
	
	public static function creategraph( $hw_id = NULL )
	{
		if ( NULL != $hw_id )
		{
			return self::creategraph_hw( $hw_id );
		}
		else
		{
			switch ( User()->get_type() )
			{
				case USER_TYPE_USER:		return self::creategraph_user();
				case USER_TYPE_CPNY_RO:
				case USER_TYPE_CPNY:		return self::creategraph_company();
				case USER_TYPE_CPNY_META:	return self::creategraph_company_meta();
				case USER_TYPE_GOD:			return self::creategraph_god();
			}
		}
	}
}
