<?php
require_once( LIBSPATH . 'frames/frame_utils.php' );

class GraphFilter
{
	const GOOD					= 2;	//only good hw
	const BAD					= 1;	//only bad hw
	const UGLY					= 0;	//all hardware
	const GOOD_BAD_THRESHOLD	= 10; 
}

class FilteredGraph
{
	public static $unix_time1;
	public static $unix_time2;
	public static $final_datetime			= 0;
	public static $secs_to_show				= 0;
	public static $group_filter				= '';
	public static $final_datetime_str	= '';

	protected static $hours_to_show			= 0;
	protected static $rhours_to_show		= 1;
	protected static $signal_filter			= GraphFilter::UGLY;
	
	public static function is_rounded_time( $unixtime )
	{
		return self::round_unixtime( $unixtime ) == $unixtime;
	}
	
	public static function round_unixtime( $unixtime )
	{
		return floor( $unixtime / FrameUtils::$TESTS_LOG_TIMESPAN_SEC ) * FrameUtils::$TESTS_LOG_TIMESPAN_SEC; //rounds to neares past hour
	}

	//returns an array of expected rows from tests_logs
	public static function get_expected_tl_timestamps()
	{
		$u2	= self::round_unixtime( self::$unix_time2 );
		$u1	= self::round_unixtime( self::$unix_time1 );
		$c	= ( ($u2-$u1) / FrameUtils::$TESTS_LOG_TIMESPAN_SEC );
		
		$ret = array();
		
		for( $i = 0; $i<=$c;$i++) //iterates and build timestamps arrays by hour
		{
			$ret[] = $u1 + $i*FrameUtils::$TESTS_LOG_TIMESPAN_SEC;
		}

		return $ret;
	}
	
	public static function update_time($time_end=false, $time_span = false, $ignore = true)
	{
		$IGNORE_SECONDS = 0;
		
		if($ignore)
		{
			$IGNORE_SECONDS = FrameUtils::$TESTS_LOG_IGNORE_LAST_SECONDS;
		}
	
		if(false == $time_end)
		{
			$time_end = time();
		}
	
		if(false == $time_span)
		{
			$time_span = FrameUtils::$TESTS_LOG_TIMESPAN_SEC;
		}
		
		self::$unix_time2		= $time_end - $IGNORE_SECONDS;
		self::$unix_time1		= self::$unix_time2 - $time_span;
	}
	
	//read graph filters from GET
	public static function init_filters( $time_offset = 0 )
	{
		$filter_get				= get_var('gfilter');
		$hours_get				= get_var('ghours');
		$to_date_get			= get_var('gtodate');
		$to_date				= get_timestamp_from_date_time( $to_date_get );

		self::$rhours_to_show	= $hours_get;
		
		if( !$to_date )
		{
			$to_date = time() + $time_offset;
		}
		
		$filter = GraphFilter::UGLY;
		
		switch( $filter_get )
		{
			case 'BAD':		$filter = GraphFilter::BAD;		break;
			case 'GOOD':	$filter = GraphFilter::GOOD;	break;
		}
		
		if(!$hours_get)
		{
			$hours_get = -1;
		}

		self::$group_filter 		= SQL::get_or_filter( get_var('groups'), 'hwgl_group' );
		self::$final_datetime		= $to_date; //rounds up to the next hour
		self::$hours_to_show		= $hours_get;
		self::$secs_to_show 		= self::$hours_to_show*3600;
		self::$signal_filter		= $filter;
		self::$final_datetime_str	= strftime ('%d/%m/%Y %H:%M',$to_date);
	}

	protected static function get_tests_state_from_test_count( $tests, $low_rep, $good_rep )
	{
		if ( self::$hours_to_show <= 0 )
		{
			self::$hours_to_show = 1;
		}
		
		$state = TestState::DEAD;
		
		if ( $tests <= 0 )
		{
			return $state;
		}
		
		$tests = floor( $tests / self::$hours_to_show );
		
		if ( $tests <= $low_rep )
		{
			$state =  TestState::LOW;
		}
		else if ( $tests <= $good_rep )
		{
			$state =  TestState::GOOD;
		}
		else
		{
			$state =  TestState::EXCELLENT;
		}
		
		return $state;
	}
	
	public function get_filtered_date()
	{
		return self::$final_datetime_str;
	}
}
