<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

require_once( LIBSPATH . 'frames/frame_utils.php' );

class GlobalEvents
{
	protected $hw_id			= NULL;
	protected $user_id			= NULL;
	protected $user				= NULL;
	protected static $hwevmod	= NULL;
	
	function __construct( $config = array() )
	{
	}
	
	public function search( $user, $from, $to, $signal_frames = NULL, $hw_id = NULL, $user_id = NULL, $hw_serial = NULL, $hw_code = NULL )
	{
		$gevmod		= load_model('GlobalEvent_model');
		$events		= array();
		$this->user	=	$user;
		$type		=	GlobalEventType::DOMO;
		$sf_var		=	'';
		
		if ( isset( $signal_frames ) )
		{
			$type		=	GlobalEventType::DOMO_SIGNAL;
			$sf_var		=	'&sf=1';
		}

		$error_str = '';
		
		if( NULL == $from || NULL == $to || strlen( trim ( $from ) ) == 0 || strlen( trim ( $to ) ) == 0 )
		{
			$ok			= FALSE;
			$error_str	= 'Debe elejir ambas fechas';
		}
		else
		{
			$ok			= TRUE;
			
			if( NULL != $hw_id && intval( $hw_id ) > 0 )
			{
			 	$this->hw_id = intval( $hw_id );
			}
			else if( NULL != $user_id && intval( $user_id ) > 0 )
			{
				$this->user_id = intval($user_id);
			}
			
			$query		= '';
			$querydata	= array();
			
			if( $this->hw_id )
			{
				$query .= 'AND hw_id = ' . $this->hw_id . ' ';
			}
			else if( $this->user_id )
			{
				$query .= 'AND hw_user = ' . $this->user_id . ' ';
			}
			else
			{
				switch ( $this->user->get_type() )
				{
					case USER_TYPE_USER:
						$query .= 'AND hw_user = ' . $this->user->get_type_id() . ' ';
						break;
					case USER_TYPE_CPNY:
					case USER_TYPE_CPNY_RO:
						$query .= 'AND hw_company = ' . $this->user->get_type_id() . ' ';
						break;
					case USER_TYPE_CPNY_META:
						$query .= 'AND ' . SQL::get_or_filter( $this->user->get_company_ids(), 'hw_company' );
					case USER_TYPE_GOD:
						//get all hardware
						break;
				}
			}
			
			if ( NULL != $hw_serial )
			{
				$query .= 'AND ' . SQL::get_or_filter_exploded( $hw_serial, 'hw_serial', ',', SQLConvertType::HEXDEC );
			}
			
			if ( NULL != $hw_code )
			{
				$query .= 'AND ' . SQL::get_or_filter_exploded( $hw_code, 'hw_code', ',', SQLConvertType::HEXDEC );
			}
			
			$filter = array( 
				array(
					'order_by'		=> array( get_var_def( 'order_by', 'ge_time' ), get_var_def( 'order_by2', 'hw_code' ) ),
					'order_fields'	=> array( 'ge_time', 'hw_name', 'hw_serial', 'hw_code', 'ui_lastname' ),
					'order_dir'		=> array( get_var_def( 'order_dir', 'DESC' ), get_var_def( 'order_dir2', 'ASC' ) )
				)
			);
			
			$query_filter = SQL::build_query_filter( $filter );
			$order_by = substr( $query_filter['order'], strlen( 'ORDER BY ' ) );
		}
		
		if( $ok )
		{
			$frames		= $gevmod->get_events( get_timestamp_from_date_time( $from ), get_timestamp_from_date_time( $to ), $query, $type, $order_by );
			
			if( isset( $frames ) )
			{
				foreach($frames as $frame)
				{
					$events[] = $gevmod->parse_frame( $frame, $this->user );
				}
			}
		}
		
		return array( 'result' => $ok, 'error_msg' => $error_str, 'events' => $events );
	}
}