<?php
class Transcoder
{
	public static function zdecode($string)
	{
		$data = base64_decode($string);
		$ucomp = gzinflate($data);
		return json_decode(strtolower($ucomp));
	}
	
	public static function zencode($array)
	{
		$data = json_encode($array);
		$comp = gzdeflate($data,7);
		return base64_encode($comp);
	}

	public static function encode($array)
	{
		return json_encode($array);
	}

	public static function decode($string)
	{
		return json_decode($string);
	}
	
	public static function jsondecode($string)
	{
		$ret = array();
		$frames = self::zdecode($string);
		
		if ( isset( $frames ) && !empty( $frames ) )
		{
			foreach ( $frames as $frame )
			{
				$string = implode(array_map("chr", $frame));
				
				array_push( $ret, json_decode( $string ) );
			}
		}
		
		return $ret;
	}
}
