<?php
require_once( FRAMES_PATH . 'framecfg.php' );

class FrameNoiseCfg extends FrameCfg
{
	protected $hwnl = null;
	protected $hwsl = null;
	
	public function __construct()
	{
		$this->hwnl = load_model('HardwareNoiseLog_model');
		$this->hwsl = load_model('HardwareSignalLog_model');
	}
	
	protected function add_noise_cmd( $com_id )
	{
		if ( strlen( $this->m_Fields['frame_data'] ) >= 4 )
		{
			$val = -hexdec( substr( $this->m_Fields['frame_data'], 0, 2 ) );
			
			$this->hwnl->add( $this->m_Fields['hw_serial'], $com_id, $this->m_Fields['hw_timestamp'], 
								hexdec( substr( $this->m_Fields['frame_data'], 0, 2 ) ),
								hexdec( substr( $this->m_Fields['frame_data'], 2, 2 ) )
			);
		}
	}
	
	protected function add_signal_cmd( $com_id )
	{
		if ( strlen( $this->m_Fields['frame_data'] ) >= 2 )
		{
			$val = -hexdec( $this->m_Fields['frame_data'] );
			
			$this->hwsl->add( $this->m_Fields['hw_serial'], $com_id, $this->m_Fields['hw_timestamp'], $val );
		}
	}
	
	public function process( $com_id )
	{
		if ( $this->is_response_ok() )
		{
			$cmd = short_to_string( $this->m_Fields['cmd'] );
			
			if ( 'DB' == $cmd )
			{
				$this->add_signal_cmd( $com_id );
			}
			else if ( 'RC' == $cmd )
			{
				$this->add_noise_cmd( $com_id );
			}
		}
	}
}
