<?php
require_once( FRAMES_PATH . 'frame.php' );

class FrameKPanel extends Frame
{
	private function _read_header($raw)
	{
		$data = array();
		$data[0] = FrameUtils::pack_bytes($raw,0,4); // hw_serial
		$data[1] = FrameUtils::pack_bytes($raw,4,2); // hw_code
		$data[2] = FrameUtils::pack_bytes($raw,6,2); // secuence
		$data[3] = FrameUtils::pack_bytes($raw,8,1); // age
		$data[4] = FrameUtils::pack_bytes($raw,9,1); // jump
		$data[5] = FrameUtils::pack_bytes($raw,10,1); // prefix
		$data[6] = FrameUtils::pack_bytes($raw,11,1); // flags
		$data[7] = FrameUtils::pack_bytes($raw,12,2); // fixed flag
		$data[8] = FrameUtils::pack_bytes($raw,14,1); // msg id
		$data[9] = FrameUtils::pack_bytes($raw,15,1); // partition
		$data[10] = FrameUtils::pack_bytes($raw,16,4); // partition mask
		$data[11] = FrameUtils::pack_bytes($raw,20,2); // partition state
		$data[12] = FrameUtils::pack_bytes($raw,22,4); // led state
		$data[13] = FrameUtils::pack_bytes($raw,26,1); // sound state
		$data[14] = count($raw) >= 28 ? FrameUtils::pack_bytes($raw,27,1) : 0; // state
		return FrameUtils::array_to_frame($data, FrameUtils::$TPL_KEYBOARD_CONFIG_RECEIVE);
	}
	
	public function decode($raw)
	{
		$this->m_Raw	= $raw;
		$this->m_Fields	= $this->_read_header($raw);
	}
	
	public function process( $com_id )
	{
		$state = isset( $this->m_Fields['state'] ) && $this->m_Fields['state'] == EVT_CFG_STATE_TYPE::RESP_TIMEOUT ? 'ERROR_TIMEOUT' : 'EXECUTED';
		
		load_model('KPanelMsgSend_model')->set_state_on_response( $com_id, $this->m_Fields['msg_id'], $state );
	}
}