<?php
require_once( FRAMES_PATH . 'frame.php' );
require_once( FRAMES_PATH . 'actions.php' );

class FrameCityMeshCfg extends Frame
{
	protected $hwccmod = null;
	
	private function _read_header($raw)
	{
		$data = array();
		$data[0] = FrameUtils::pack_bytes($raw,0,4); // timestamp
		$data[1] = FrameUtils::pack_bytes($raw,4,4); // serial
		$data[2] = FrameUtils::pack_bytes($raw,8,2); // code
		$data[3] = FrameUtils::pack_bytes($raw,10,1); // msg_type
		$data[4] = $raw[11] >> 4; // mode
		$data[5] = ( ( $raw[11] & 0x0F ) << 8 ) | FrameUtils::pack_bytes($raw,12,1); // cmd
		$data[6] = $raw[13]; // val
		$data[7] = $raw[14]; // msg_type_val
		$data[8] = $raw[15] >> 4; // force
		$data[9] = $raw[15] & 0x0F; // checksum
		
		return FrameUtils::array_to_frame($data, FrameUtils::$TPL_FRAME_CONFIG_CITYMESH);
	}
	
	protected function is_response()
	{
		if ( $this->m_Fields['mode'] == EVT_CFG_MODE::RESP_QUERY || $this->m_Fields['mode'] == EVT_CFG_MODE::RESP_WRITE )
		{
			return TRUE;
		}
		
		return FALSE;
	}
	
	protected function add_cmd( $batch_id )
	{
		$this->hwccmod->add(	$this->m_Fields['hw_serial'], $this->m_Fields['hw_timestamp'], $this->m_Fields['hw_code'], 
								$this->m_Fields['msg_type'], $this->m_Fields['mode'], $this->m_Fields['cmd'], $this->m_Fields['val'], $this->m_Fields['msg_type_val'],
								$this->m_Fields['force'], $this->m_Fields['checksum'], 'OK', $batch_id );
	}
	
	public function process( $batch_id )
	{
		// If is response, we need to update the state of a event
		if ( $this->is_response() )
		{
			if (
				(	
					$this->m_Fields['msg_type'] != FrameType::DOMOTIC_ACTION && 
					$hwcc_id = $this->hwccmod->exists( $this->m_Fields['hw_serial'], $this->m_Fields['msg_type'], $this->m_Fields['cmd'] )
				)
				||
				(
					$this->m_Fields['msg_type'] == FrameType::DOMOTIC_ACTION && 
					$hwcc_id = $this->hwccmod->exists_type( $this->m_Fields['hw_serial'], $this->m_Fields['msg_type'], $batch_id )
				)
			)
			{
				switch ( intval( $this->m_Fields['force'] ) )
				{
					case EVT_CFG_STATE_TYPE::RESP_OK:
					{
						$this->hwccmod->update_state( $hwcc_id, 'EXECUTED' ); break;
					}
					case EVT_CFG_STATE_TYPE::RESP_INVALID_CMD:
					{
						$this->hwccmod->update_state( $hwcc_id, 'ERROR_INVALID_CMD' ); break;
					}
					case EVT_CFG_STATE_TYPE::RESP_INVALID_VAL:
					{
						$this->hwccmod->update_state( $hwcc_id, 'ERROR_INVALID_VAL' ); break;
					}
					case EVT_CFG_STATE_TYPE::RESP_TIMEOUT:
					{
						$this->hwccmod->update_state( $hwcc_id, 'ERROR_TIMEOUT' ); break;
					}
					case EVT_CFG_STATE_TYPE::RESP_ERROR:
					{
						$this->hwccmod->update_state( $hwcc_id, 'ERROR' ); break;
					}
				}
			}
			else
			{
				$this->add_cmd( $batch_id );
			}
			
			switch( $this->m_Fields['msg_type'] )
			{
				case FrameType::DOMOTIC_ACTION:
				{
					Actions::handle_domotic_response( $this->m_Fields['hw_serial'], $this->m_Fields['val'] );
					
					break;
				}
				case FrameType::CONFIG_MANUAL:
				case FrameType::CONFIG_A:
				{
					Actions::handle_config_response(	$this->m_Fields['hw_serial'], 
														$this->m_Fields['msg_type'],
														$this->m_Fields['cmd'],
														$this->m_Fields['val'],
														intval( $this->m_Fields['force'] ) == EVT_CFG_STATE_TYPE::RESP_OK
					);
					
					break;
				}
			}
		}
		// only if exists ( otherwise it might be a response from an older call )
		// reset response
		else if ( ( 0x18 == $this->m_Fields['msg_type'] && 0x03 == $this->m_Fields['mode'] && 0x552 == $this->m_Fields['cmd'] ) &&
				$hwcc_id = $this->hwccmod->exists( $this->m_Fields['hw_serial'], 0x47, 0x111, 0x00 )
			)
		{
			$this->hwccmod->update_state( $hwcc_id, 'EXECUTED' );
			
			Actions::handle_reset_response( $this->m_Fields['hw_serial'] );
		}
		else
		{
			$this->add_cmd( $batch_id );
		}
	}
	
	public function decode($raw)
	{
		$this->m_Raw	= $raw;
		$this->m_Fields	= $this->_read_header($raw);
		$this->hwccmod	= load_model('HardwareCityMeshCommand_model');
	}
	
	public function get_frame_data_str()
	{
		return 
			str_pad( dechex( $this->m_Fields['hw_timestamp'] ), 8, '0', STR_PAD_LEFT ) . ' ' .
			str_pad( dechex( $this->m_Fields['hw_serial'] ), 8, '0', STR_PAD_LEFT ) . ' ' .
			str_pad( dechex( $this->m_Fields['hw_code'] ), 4, '0', STR_PAD_LEFT ) . ' ' . 
			str_pad( dechex( $this->m_Fields['msg_type'] ), 2, '0', STR_PAD_LEFT ) . ' ' .
			dechex( $this->m_Fields['mode'] ) . ' ' . 
			str_pad( dechex( $this->m_Fields['cmd'] ), 3, '0', STR_PAD_LEFT ) . ' ' . 
			str_pad( dechex( $this->m_Fields['val'] ), 2, '0', STR_PAD_LEFT ) . ' ' . 
			str_pad( dechex( $this->m_Fields['msg_type_val'] ), 2, '0', STR_PAD_LEFT ) . ' ' . 
			dechex( $this->m_Fields['force'] ) . ' ' . 
			dechex( $this->m_Fields['checksum'] );
	}
} 
