<?php
require_once( FRAMES_PATH . 'frame.php' );

class FrameCfg extends Frame
{
	protected $hwccmod = null;
	
	public function __construct()
	{
		$this->hwccmod = load_model('HardwareConfigCommand_model');
	}
	
	private function _read_header($raw)
	{
		$data = array();
		$data[0] = FrameUtils::pack_bytes($raw,0,4);
		$data[1] = FrameUtils::pack_bytes($raw,4,4);
		$data[2] = FrameUtils::pack_bytes($raw,8,1);
		$data[3] = FrameUtils::pack_bytes($raw,9,1);
		$data[4] = FrameUtils::pack_bytes($raw,10,2);
		$data[5] = FrameUtils::pack_bytes($raw,12,1);
		
		return FrameUtils::array_to_frame($data, FrameUtils::$TPL_FRAME_CONFIG);
	}
	
	protected function is_response()
	{
		if ( $this->m_Fields['mode'] == EVT_CFG_MODE::RESP_QUERY || $this->m_Fields['mode'] == EVT_CFG_MODE::RESP_WRITE )
		{
			return TRUE;
		}
		
		return FALSE;
	}
	
	protected function is_response_ok()
	{
		return $this->is_response() && EVT_CFG_STATE_TYPE::RESP_OK == intval( $this->m_Fields['state_type'] );
	}
	
	protected function add_cmd( $batch_id )
	{
		$this->hwccmod->add( $this->m_Fields['hw_serial'], $this->m_Fields['hw_timestamp'], $this->m_Fields['state_type'], $this->m_Fields['mode'], $this->m_Fields['cmd'], $this->m_Fields['data_count'], $this->m_Fields['frame_data'], 'OK', $batch_id );
	}
	
	public function process( $batch_id )
	{
		// If is response, we need to update the state of a event
		if ( $this->is_response() )
		{
			// only if exists ( otherwise it might be a response from an older call )
			if ( $hwcc_id = $this->hwccmod->exists( $this->m_Fields['hw_serial'], $this->m_Fields['cmd'] ) )
			{
				switch ( intval( $this->m_Fields['state_type'] ) )
				{
					case EVT_CFG_STATE_TYPE::RESP_OK:
					{
						$this->hwccmod->update_state( $hwcc_id, 'EXECUTED' ); break;
					}
					case EVT_CFG_STATE_TYPE::RESP_INVALID_CMD:
					{
						$this->hwccmod->update_state( $hwcc_id, 'ERROR_INVALID_CMD' ); break;
					}
					case EVT_CFG_STATE_TYPE::RESP_INVALID_VAL:
					{
						$this->hwccmod->update_state( $hwcc_id, 'ERROR_INVALID_VAL' ); break;
					}
					case EVT_CFG_STATE_TYPE::RESP_TIMEOUT:
					{
						$this->hwccmod->update_state( $hwcc_id, 'ERROR_TIMEOUT' ); break;
					}
					case EVT_CFG_STATE_TYPE::RESP_ERROR:
					{
						$this->hwccmod->update_state( $hwcc_id, 'ERROR' ); break;
					}
				}
			}
			else
			{
				$this->add_cmd( $batch_id );
			}
		}
		else
		{
			$this->add_cmd( $batch_id );
		}
	}
	
	public function decode($raw)
	{
		$this->m_Raw	= $raw;
		$this->m_Fields	= $this->_read_header($raw);
		
		if ( $this->m_Fields['data_count'] > 0 )
		{
			$this->m_Fields['frame_data'] = FrameUtils::frame_to_hexa_string( $raw, $this->m_Fields['data_count'] > 8 ? 8 : $this->m_Fields['data_count'], /** header size **/13 );
		}
		else
		{
			$this->m_Fields['frame_data'] = null;
		}
	}
	
	public function get_frame_data_str()
	{
		return 
			str_pad( dechex( $this->m_Fields['hw_timestamp'] ), 8, '0', STR_PAD_LEFT ) . ' ' .
			str_pad( dechex( $this->m_Fields['hw_serial'] ), 8, '0', STR_PAD_LEFT ) . ' ' .
			str_pad( dechex( $this->m_Fields['state_type'] ), 2, '0', STR_PAD_LEFT ) . ' ' .
			str_pad( dechex( $this->m_Fields['mode'] ), 2, '0', STR_PAD_LEFT ) . ' ' .
			short_to_string( $this->m_Fields['cmd'] ) . ' ' .
			str_pad( dechex( $this->m_Fields['data_count'] ), 2, '0', STR_PAD_LEFT ) . ' ' .
			$this->m_Fields['frame_data'];
	}
}
