<?php
require_once( 'frame_types.php' );
	/*
	 * El arreglo describe la estructura del paquete
	  * lo primero es el nombre
	* lo segundo es la cantidad de bits que ocupa
	*/
class TestState
{
	const EXCELLENT	= 'excellent';
	const GOOD		= 'good';
	const LOW		= 'low';
	const DEAD		= 'dead';
}

class FrameUtils
{
	//diferencia en segundos entre un timestamp de unix y uno de domo
	//10957(dias) * 24 * 60 * 60 = catidad de segundos entre 1/1/1970 y 1/1/2000
	private static $TIMESTAMP_DOMO_UNIX_DIFF = 946684800;
	public static $TESTS_LOG_TIMESPAN_SEC = 3600;
	public static $TESTS_LOG_IGNORE_LAST_SECONDS = 420; //ignora los ultimos 7 minutos
	
	//bytes, para evitar errores en codificacion ;)
	private static $HMAC_KEY = "E8FACC6E87238207DE946CE8183ECB997D2F38794416FA6245A58F2F32B9B24F";
	
	public static $SAMPLES = array(
		 '01234556781862BCFA67C147AB671515F25E99ECB0FFFFFFFF93',
		 '01234456781862BCFA67C147AB672215F261219C50FFFFFFFF7A',
	  	 '012344A6785662BCFA67C147AB672215F2623A0750FFFFFFFF8D',
		 '012344A678692111FA67C147AB672215F263362430FFFFFFFFAE',
	);
	
	
	
	/*
	 * 
	 * Los templates indican la cantidad de words (4 bits) que ocupa cada campo
	 * 
	 * usado  como parámetro para parse_framedata() 
	 */
	public static $TPL_FRAME_HEADER = array(
	'packet_type' => 2,//varlor 01
	'company_code' => 2,
	'receiver_code' => 2,
	'hw_code' => 4,
	'msg_type' => 2
	);
	
	public static $TPL_FRAME_FOOTER = array(
	'hw_serial' => 8,
	'hw_timestamp' => 8, //segundos desde 00:00 1/1/2000
	'msg_id' => 4,
	'reserved' => 8, 
	'checksum_total' => 2  //para validar sumar todos los caracteres da 255
	);

	//'tipo_mensaje' = 0x18
	public static $TPL_FRAME_INCOMING = array(
	'evt_qualifier' => 1,
	'evt_code' => 3,
	'partition' => 2,
	'zone' => 3,
	'checksum_sia' => 1,
	);
	
	//'tipo_mensaje' = 0x66
	public static $TPL_FRAME_TESTING = array(
	'hdw_version' => 2, 
	'firm_version' => 2,
	'io_states' => 2,
	'io_conf' => 2,
	'reserved2' => 1,
	'checksum_sia' => 1,
	);
	
	//'tipo_mensaje' = 0x69
	public static $TPL_FRAME_OUTGOING = array(
	'L' => 1,   //campo sin nombre? vale 0x4
	'MNO' => 3, //campo sin nombre? vale 0x111?
	'io_states' => 2, //1 = salidas deseadas
	'io_conf' => 2, //1 = salidas, 0 = entradas
	'TU' => 2, // vale 0x11
	);
	
	public static $TPL_FRAME_RESPONSE = array(
	'L' => 1,   //campo sin nombre? vale 0x2
	'MNO' => 3, //campo sin nombre? vale 0x111?
	'io_states' => 2, 
	'io_conf' => 2, //1 = salidas, 0 = entradas
	'reserved2' => 1,
	'checksum_sia' => 1,
	);	
	
	public static $TPL_FRAME_RAW = array(
	'frame_data' => 10,
	);
										
	//'tipo_mensaje' = 0x89
	public static $TPL_KEYCHAIN_INCOMING = array(
	'evt_qualifier' => 1,
	'keychain_id_part_1' => 3,
	'partition' => 1,
	'button' => 1,
	'keychain_id_part_2' => 3,
	'checksum_sia' => 1
	);
	
	// config messages
	public static $TPL_FRAME_CONFIG = array(
	'hw_timestamp' => 8,
	'hw_serial' => 8,
	'state_type' => 2,
	'mode' => 2,
	'cmd' => 4,
	'data_count' => 2
	);
	
	
	// citymesh config messages
	public static $TPL_FRAME_CONFIG_CITYMESH = array(
	'hw_timestamp' => 8,
	'hw_serial' => 8,
	'hw_code' => 4,
	'msg_type' => 2,
	'mode'  => 1,
	'cmd' => 3,
	'val' => 2,
	'msg_type_val' => 2,
	'force' => 1,
	'checksum' => 1
	);
	
	// citymesh keyboard config message
	// MC0 MC1 MC2 MC3 AC0 AC1 0A SEC VEJ JUP PC FL 19 02 SC PT PM0 PM1 PM2 PM3 PS0 PS1 LS0 LS1 LS2 LS3 
	public static $TPL_KEYBOARD_CONFIG_RECEIVE = array(
	'hw_serial' => 8,
	'hw_code' => 4,
	'secuence' => 4,
	'age' => 2,
	'jump' => 2,
	'prefix' => 2,
	'flags' => 2,
	'fixed_flag' => 4,
	'msg_id' => 2,
	'partition' => 2,
	'partition_mask' => 8,
	'partition_state' => 4,
	'led_state' => 8,
	'sound_state' => 2,
	'state' => 2
	);
	
	// citymesh keyboard config message send
	// ML0 ML1 ML2 ML3 00 00 0A 00 00 00 00 00 19 02 SC PT CR K1 K2 K3 Kn
	public static $TPL_KEYBOARD_CONFIG_SEND = array( 
	'hw_serial' => 8,
	'hw_code' => 4,
	'secuence' => 4,
	'trash' => 8,
	'fixed_flag' => 4,
	'msg_id' => 2,
	'partition' => 2,
	'reports_count' => 2,
	'msg' => 0
	);
	
	
	/*
	 * Bit operation
	 * 
	 */
	
	public static function pack_bytes($bytes, $start = 0, $ct = -1)
	{
		$res = 0;
		
		if($ct == -1)
		{
			$ct = count($bytes)-$start;
		}
		
		$j=1;
		
		for($i=$start;$i<$start+$ct;$i++)
		{
			$bt = $bytes[$i];
			$res = $res ^ $bt << (($ct-$j)*8);
			$j++;
		}
		
		return $res;
	}
	
	/*
	 * Size counts
	 */
	
	public static function bit_count($template)
	{
		$count=0;
		
		foreach($template as $name => $words)
		{
			$count+=$words*4;
		}
		
		return $count;
	}
	
	public static function total_bits($template)
	{
		$arr = array_merge(self::$TPL_FRAME_HEADER, $template, self::$TPL_FRAME_FOOTER);
		return self::bit_count($arr);
	}
	
	public static function byte_count($template)
	{
		return self.bit_count($template)/8;
	}
	
	public static function total_bytes($template)
	{
		return self.byte_count($template)/8;
	}
	
	//copies an array to a frame
	public static function array_to_frame($arr, $template)
	{
		$frame = array();
		$i=0;
		
		foreach($template as $name => $bits)
		{
			$frame[$name] = $arr[$i];
			$i++;
		}
		
		return $frame;
	}
	
	public static function calculate_signature($data)
	{
		return base64_encode(hash_hmac('sha256',$data,FrameUtils::get_hmac_key(),true));
	}
	
		
	private static function get_hmac_key()
	{
		return self::$HMAC_KEY;
	}
	
	public static function get_posted_frames()
	{
		if(isset($_POST["frames"]) && isset($_POST["signature"]))
		{
			$r = array();
			
			$r['frames'] = str_replace(" ","+",$_POST["frames"]);
			$r['signature'] =  str_replace(" ","+",$_POST["signature"]);
			
			return $r;
		}
		else
		{
			return null;
		}
	}
	
	//converts hexa string to an array of words (4 bits)
	private static function framedata_to_bitword($frame_data)
	{
		$arr = str_split($frame_data, 2);
		$words = array();
		
		foreach( $arr as $hexa )
		{
			$byte = hexdec($hexa);
			$words = array_merge($words, self::unpack_word($byte));
		}
		
		return $words;
	}
	
	public static function frame_to_hexa_string($frame, $size, $offset)
	{
		$hstr	= '';
		$fsize	= count($frame);
		$offset	= $offset > $fsize ? $fsize - 1 : $offset;
		$end	= $offset+$size > $fsize ? $fsize : $offset+$size;
		
		for( $i = $offset; $i < $end; $i++ )
		{
			$hstr .= str_pad( dechex( $frame[$i] ), 2, '0', STR_PAD_LEFT );
		}
		
		return $hstr;
	}
	
	private static function unpack_word($byte) //unpacks a byte in 2 words
	{
		$word = array();
		$word[]= $byte >> 4;
		$word[]= $byte & 0x0F;
		return $word;
	}
	
	private static function pack_words($words, $start = 0, $ct = -1) //packs and array of words into an integer
	{
		$res = 0;
		
		if($ct == -1)
		{
			$ct = count($words)-$start;
		}
	
		$j=1;
		
		for($i=$start;$i<$start+$ct;$i++)
		{
			$wd = $words[$i];
			$res = $res ^ $wd << (($ct-$j)*4);
			$j++;
		}
		
		return $res;
	}
	
	/* bitwise magic! give the function a hex string with the frame data, and a template to parseit
	 * it will give you an assosiative array with the names and the values..
	 * Example: parse_framedata("4411ff5522", FrameUtils::$TPL_FRAME_INCOMING) ;
	 * Returns: array(5) { ["evt_qualifier"]=> int(4) ["evt_code"]=> int(1041) ["partition"]=> int(255) ["zone"]=> int(1362) ["checksum_sia"]=> int(2) } 
	 */
	public static function parse_framedata($frame_data, $template) //$frame_data = string que representa 5 bytes en exa
	{
		$warr = self::framedata_to_bitword($frame_data); //convert hexa string to array of words
		$msg = array();
	
		$waindex = 0;
		
		foreach($template as $name => $word_ct)
		{
			$msg[$name] = self::pack_words($warr,$waindex,$word_ct);
			$waindex+=$word_ct;
		}
		
		return $msg;
	}
	
	
	/*
	 * SAMPLE MANIP
	 */
	public static function get_sample($index)
	{
		$arr = array();
		$sample = self::$SAMPLES[$index];
		
		for($i=0;$i<strlen($sample);$i+=2)
		{
			$num = $sample[$i].$sample[$i+1];
			$arr[] = hexdec($num);	
		}
		
		return $arr;
	}
	
	public static function timestamp_unixtodomo($unix_time)
	{
		return 	$unix_time - self::$TIMESTAMP_DOMO_UNIX_DIFF;	
	}
	
	public static function timestamp_domotounix($domo_time)
	{
		return 	$domo_time + self::$TIMESTAMP_DOMO_UNIX_DIFF;
	}
	
	public static function get_tests_received_lasthour($hw_id)
	{
		$t2 = time()-self::$TESTS_LOG_IGNORE_LAST_SECONDS;
		$t1 = $t2-self::$TESTS_LOG_TIMESPAN_SEC-self::$TESTS_LOG_IGNORE_LAST_SECONDS; 
		return self::get_tests_received_time_range($hw_id, $t1, $t2);
	}
	
	public static function get_tests_received_time_range($hw_id,$unix_time1,$unix_time2)
	{
		$db = db_get();
				
		$time_gap = self::$TESTS_LOG_TIMESPAN_SEC;
		
		//get the tests-log rows between $unix_time1 and $unix_time2
		$rows = $db->get_results("SELECT tl_from_time AS time, tl_tests_count AS count FROM tests_log
		WHERE tl_hw_id = $hw_id AND
					tl_from_time + $time_gap >= $unix_time1 AND tl_from_time < $unix_time2
		ORDER BY tl_from_time ASC", ARRAY_A);
		
		$ct = 0;
		
		if($rows)
		{
			$x1 = $rows[0]['time']; //first log row
			$diff = $unix_time1 - $x1;
	
			
			//here we calculate the parcial count, from the first log
			if( $diff > 0 && $diff <= self::$TESTS_LOG_TIMESPAN_SEC)  
			{
				$r1 =  $diff / (self::$TESTS_LOG_TIMESPAN_SEC) ;
				$ct += round( $rows[0]['count']*(1.0-$r1) ); 
			}
			else
			{
				$ct += $rows[0]['count']; 
			}
			
								
			//here we calculate the parcial count, from the last log
			if(count($rows) > 1)
			{
				$x2 = $rows[count($rows)-1]['time']; //last log row
				$diff = $unix_time2 - $x2;
				
				if( $diff > 0  && $diff <= self::$TESTS_LOG_TIMESPAN_SEC) 
				{
					$r2 = $diff / self::$TESTS_LOG_TIMESPAN_SEC;
					$ct += round( $rows[count($rows)-1]['count']*$r2 );
				}
				else{
					$ct += $rows[count($rows)-1]['count'];
				}
				
				//we count all the logs inbetween
				for( $i = 1;$i<count($rows)-1;$i++)
				{
					$ct += $rows[$i]['count'];
				}
			}
		}

		return $ct;
	}
}
