<?php

if ( !function_exists( 'get_called_class' ) )
{
	function get_called_class()
	{
		$bt = debug_backtrace();
		$l = 0;
		do
		{
			$l++;
			$lines = file($bt[$l]['file']);
			$callerLine = $lines[$bt[$l]['line']-1];
			preg_match('/([a-zA-Z0-9\_]+)::'.$bt[$l]['function'].'/', $callerLine, $matches);
		} while ($matches[1] === 'parent' && $matches[1]);

		return $matches[1];
	}
}

class ConstClass
{
	private static $CONST_CACHE = NULL;

	public static function getConst($name)
	{
		if(self::$CONST_CACHE == NULL)
		{
			$oClass = new ReflectionClass(get_called_class()); //php voodoo
			self::$CONST_CACHE = $oClass->getConstants();
		}

		if(array_key_exists($name,self::$CONST_CACHE))
		{
			return self::$CONST_CACHE[$name];
		}
		else
		{
			return null;
		}
	}
}

class FrameType
{
	const TEST = 0x66;
	const SIGNAL_TEST = 0x18;
	const SIGNAL_INFO = 0x65;
	const CORE_TEST = 0x67;
	const CORE_TEST_NEW = 0x22;
	const DOMOTIC_ACTION = 0x69;
	const RESET = 0x47;
	const CONFIG_A = 0x56;
	const CONFIG_MANUAL = 0x59;
	const KEYCHAIN = 0x89;
	const KPANEL = 0xBD;
	const DTRANS = 0xDD;
}

class KPANEL_TYPE
{
	const TYPE_585 = 0x585;
	const TYPE_832 = 0x832;
}

class EVT_CODES_FRAME_x18
{
	const RESET_RESPONSE = 0x552;
	const SIGNAL_TEST = 0x6a3;
	const SIGNAL_XBEE_TEST = 0x6a3;
	const SIGNAL_3G_TEST = 0x6a4;
}

class EVT_CODE_IGNORE
{
	const EVT_CODE = 0x111;
}

class EVT_CODE_CONFIG_A extends ConstClass
{
	const ABONADO_PARTE_1 = 0x805; // configurar Nro de abonado (primeros dos numeros) (hexa)
	const ABONADO_PARTE_2 = 0x806; // configurar Nro de abonado (ultimos dos numeros)  (hexa)
	const PERIODO_TESTEO = 0x802; // Periodo de testeo (valor en minutos)
	const SENSOR_SIRENA = 0x804; //   Sensor de sirena  (valor: 0x40 es activo bajo, 0x10 activo alto, 0x00 es inactivo)
	const INTENTOS_BUSQ_SEÑAL = 0x809; //Intentos de busqueda de señal (cantidad)
	const REPORTE_LINEA_TEL = 0x80B; //Reporte de falta de linea telefonica (0x00: inactivo, cualquier otro valor: activo)
	const BUSQUEDA_MODEM_ENCENDER = 0x80C; //Búsqueda de módem al encender (0x00: inactivo, cualquier otro valor: activo)
	const PASAR_LINEA_TEL = 0x807; //pasar a linea telefonica (valor 0x00)
	const AUTOCONFIGURACION_CUENTA = 0x80E; // (0x00: inactivo, cualquier otro valor: activo)
	const CAMBIO_LINEA_FORZADO = 0x80F; //Cambio a linea forzado (0x00: activo, cualquier otro valor: inactivo)
	const TIEMPO_ESPERA_ACK = 0x81B;//Tiempo de espera de ACK (valor en decimas de segundo)
	const TIMEOUTS_ACK_PERMITIDOS = 0x81C; // Timeouts de ACK permitidos (cantidad)
};

class EVT_QUALIFIER
{
	const INTERROGAR = 0x7;
	const CONFIG = 0x4;
	const RESPUESTA = 0x2; //no usar para enviar, solo para chequear respuesta
	const COMANDO = 0x1; //tipo reset
}

class ACTION_TYPE
{
	const DOMOTIC = 'DOMOTIC_ACTION';
	const RESET= 'RESET';
	const CONFIG_A = 'CONFIG_A';
	const CONFIG_MANUAL = 'CONFIG_MANUAL';
}

function act_frametype_to_name($frame_type)
{
	switch($frame_type)
	{
		case FrameType::RESET: return ACTION_TYPE::RESET;
		case FrameType::CONFIG_A: return ACTION_TYPE::CONFIG_A;
		case FrameType::CONFIG_MANUAL: return ACTION_TYPE::CONFIG_MANUAL;
		case FrameType::DOMOTIC_ACTION: return ACTION_TYPE::DOMOTIC;
	}
	return "UNK_FRM";
}

class EVT_CFG_STATE_TYPE
{
	const SEND = 0x00;
	const SEND_FORCED = 0x01;
	const RESP_OK = 0x00;
	const RESP_ERROR = 0x01;
	const RESP_INVALID_CMD = 0x02;
	const RESP_INVALID_VAL = 0x03;
	const RESP_TIMEOUT = 0x04;
}

class EVT_CFG_MODE
{
	const SEND_QUERY = 0x07;
	const SEND_WRITE_APPLY = 0x03;
	const SEND_WRITE = 0x04;
	const RESP_QUERY = 0x02;
	const RESP_WRITE = 0x01;
}
