<?php
require_once 'frame_utils.php';
require_once 'actions.php';

class Frame
{
	protected $m_Fields = NULL;
	protected $m_Raw = NULL;

	private function _read_header($raw)
	{
		$data = array($raw[0],$raw[1],$raw[2],null,$raw[5]);
		$data[3] = FrameUtils::pack_bytes(array($raw[3],$raw[4])); 
		return FrameUtils::array_to_frame($data, FrameUtils::$TPL_FRAME_HEADER);
	}
	
	private function _read_footer($raw)
	{
		$p = count($raw)-15; //15 bytes de footer
		$data = array();
		$data[0] = FrameUtils::pack_bytes($raw,$p,4);
		$data[1] = FrameUtils::pack_bytes($raw,$p+4,4);
		$data[2] = FrameUtils::pack_bytes($raw,$p+8,2);
		$data[3] = FrameUtils::pack_bytes($raw,$p+10,4);
		$data[4] = FrameUtils::pack_bytes($raw,$p+14,1);
		
		$result = FrameUtils::array_to_frame($data, FrameUtils::$TPL_FRAME_FOOTER);
		$result['hw_timestamp'] = FrameUtils::timestamp_domotounix($result['hw_timestamp']);
		return $result;
	}
	
	public function getData($field)
	{
		return 	$this->m_Fields[$field];
	}
	
	public function get_fields()
	{
		return $this->m_Fields;
	}
	
	public function get_raw_data()
	{
		return $this->m_Raw;
	}
	
	public function get_type()
	{
		return $this->_get_body_type();
		
	}
	
	private function _get_body_type()
	{
		return $this->getData('msg_type');
	}
	
	public function check_response()
	{
		$hw_serial = $this->get_hw_serial();

		switch($this->_get_body_type())
		{
			case FrameType::DOMOTIC_ACTION:
			{
				$resp_body = $this->_read_response_body($this->m_Raw);
				
				Actions::handle_domotic_response(
					$hw_serial,
					$resp_body['io_states'],
					$resp_body['io_conf']
				);
				
				break;
			}
			case FrameType::CONFIG_MANUAL:
			case FrameType::CONFIG_A:
			{
				$incom_body = FrameUtils::parse_framedata($this->m_Fields['frame_data'], FrameUtils::$TPL_FRAME_INCOMING);

				if($incom_body['evt_qualifier'] == EVT_QUALIFIER::RESPUESTA)
				{
					Actions::handle_config_response(
						$this->m_Fields['company_code'],
						$this->m_Fields['receiver_code'],
						$this->m_Fields['hw_code'],
						$this->_get_body_type(),
						$incom_body['evt_code'],
						$incom_body['partition'] //partition = value

					);

				}
				break;
			}
		}
	}
	
	protected function _read_custom_body($raw, $frame_tpl)
	{
		$data='';
		for($i=0;$i<5;$i++) //cuerpo de 40bits
		{
			$data.=str_pad( dechex($raw[$i+6]),'2',0, STR_PAD_LEFT); //+6 skips header
		}
		return FrameUtils::array_to_frame(array($data), $frame_tpl);
	}
	
	private function _read_response_body($raw)
	{
		return FrameUtils::array_to_frame(array_slice($raw,6,26), FrameUtils::$TPL_FRAME_RESPONSE); 
		//warning, array_to_frame works for response, but use parse_framedata for other frames
	}

	public function get_hw_serial()
	{
		return sprintf('%u', $this->m_Fields['hw_serial'] );  //because php doenst support unsigned ints
	}
						
	private function _read_body($raw)
	{
		return $this->_read_custom_body($raw, FrameUtils::$TPL_FRAME_RAW);
	}
	
	private function _query_hardware_non_filtered( $qdn, &$hw )
	{
		$db = db_get();
		
		$query_unfiltered = 'SELECT hardware_events_tpl.*, hardware.* FROM hardware_events_tpl, hardware
			WHERE 
				hw_id = het_hw_id AND
				hw_df_company = ? AND
				hw_df_receiver = ? AND 
				hw_code = ? AND
				het_code = ? AND
				het_type = ? AND
				het_qualifier = ? 
				ORDER BY het_zone ASC, het_partition ASC';
				
		$db->set_qd( $qdn );
		$hw = $db->get_row( $query_unfiltered );
		
		if ( isset( $hw ) ) {
			if ( isset( $hw->het_notifications ) && isset( $hw->het_mail ) && "" != $hw->het_mail ) {
				return $hw->het_mail;
			}
		}
		
		return "";
	}
	
	private function event_allowed( $hw_id )
	{
		$hwmod	= load_model( 'Hardware_model' );
		$hours	= $hwmod->hours_get_day( $hw_id );
		$now	= time();
		
		if ( isset( $hours ) ) {
			foreach ( $hours as $hour ) {
				$ini = strtotime( date( 'Y-m-d ' . $hour->hh_init ) );
				$end = strtotime( date( 'Y-m-d ' . $hour->hh_end  ) );
				
				if ( $now >= $ini && $now <= $end ) {
					return false;
				}
			}
		}
		
		return true;
	}
	
	private function _extract_phones( &$mails )
	{
		$mnew	= '';
		$phones	= array();
		$m		= explode( ',', $mails );
		
		foreach ( $m as $mail ) {
			$mail = trim( $mail );
			
			if ( FALSE != strstr( $mail, '@' ) ) {
				$mnew	.= $mail . ',';
			} else {
				if ( strlen($mail) ) {
					array_push( $phones, $mail );
				}
			}
		}
		
		if ( $mnew != '' ) {
			$mnew = substr( $mnew, 0, strlen( $mnew ) - 1 );
		}
		
		$mails = trim( $mnew );
		
		return $phones;
	}
	
	private function _send_event_notification( $company_code, $receiver_code, $hw_code, $evt_code, $zone, $msg_type, $qualifier, $partition, $timestamp )
	{
		$db = db_get();
		$mails = "";
		
		$qd = array (	$company_code, 
						$receiver_code, 
						$hw_code,
						$evt_code,
						$zone,
						$msg_type,
						$qualifier,
						$partition
					);
		
		$query = 'SELECT hardware_events_tpl.*, hardware.* FROM hardware_events_tpl, hardware
			WHERE 
				hw_id = het_hw_id AND
				hw_df_company = ? AND
				hw_df_receiver = ? AND 
				hw_code = ? AND
				het_code = ? AND
				het_zone = ? AND
				het_type = ? AND
				het_qualifier = ? AND
				het_partition = ?';
		
		$db->set_qd( $qd );
		
		$hw = $db->get_row( $query );
		
		if ( !isset( $hw ) )
		{
			$qd = array (	$company_code, 
							$receiver_code, 
							$hw_code,
							$evt_code,
							$msg_type,
							$qualifier
						);
			
			$query = 'SELECT hardware_events_tpl.*, hardware.* FROM hardware_events_tpl, hardware
				WHERE 
					hw_id = het_hw_id AND
					hw_df_company = ? AND
					hw_df_receiver = ? AND 
					hw_code = ? AND
					het_code = ? AND
					het_type = ? AND
					het_qualifier = ?';
			
			$db->set_qd( $qd );
			
			$hw = $db->get_row( $query );
			
			if ( !isset( $hw ) || !isset( $hw->het_notifications ) || 't' !== $hw->het_notifications )
			{
				return;
			}
		}
		else if ( !isset( $hw->het_notifications ) || 't' !== $hw->het_notifications )
		{
			return;
		}
		
		if ( isset( $hw->het_mail ) && '' != $hw->het_mail ) {
			$mails = $hw->het_mail;
		} else {
			$qdn = array (	$company_code, 
							$receiver_code, 
							$hw_code,
							$evt_code,
							$msg_type,
							$qualifier );

			$mails = $this->_query_hardware_non_filtered( $qdn, $hw );
		}
		
		$mails = str_replace( ' ', '',  $mails );
		$phones = $this->_extract_phones( $mails );
		
		$query = "SELECT * FROM hardware LEFT JOIN users_info ON hw_user = ui_id LEFT JOIN users ON uid = ui_uid WHERE hw_df_company = ? AND hw_df_receiver = ? AND hw_code = ?";
		
		$db->set_qd( array( $company_code, $receiver_code, $hw_code ) );
		
		$user = $db->get_row( $query );

		if ( isset( $user ) && isset( $user->umail ) && '' != $user->umail ) {
			$mails.= ( '' == $mails ) ? $user->umail : ',' . $user->umail;
		}
		
		//log_error( "Trying to send an event message to:\n" . json_enc( $hw ) );

		// 															check if the event is filtered
		if ( isset( $user ) && isset( $hw ) && ( 'f' === $hw->het_filter_act || $this->event_allowed( $hw->hw_id ) ) ) {
			if ( '' != $mails ) {
				$uname = '';
				
				if ( isset( $user->ui_name ) && isset( $user->ui_lastname ) ) {
					$uname	= $user->ui_name . ' ' . $user->ui_lastname;
				}
				
				$subj 	= 'DOMO: ' . $hw->het_var . ' en ' . $user->hw_name;
				
				$eventt	= strftime( "%A %e de %B a las %H:%M:%S", $timestamp );
				
				$zone = hexdec( str_replace( 'a', '0', dechex( $zone ) ) );
				$partition = hexdec( str_replace( 'a', '0', dechex( $partition ) ) );
				
				$msg =	"Esta es una notificación automática de DOMO:\n";
				$msg.=	"En " . $user->hw_name . ", " . $uname . ", dirección: " . $user->hw_address . ".\n";
				$msg.=	"Siendo el día " . $eventt . "\n";
				$msg.=	"Se ha detectado " . $hw->het_var . " en la zona/usuario " . $zone . ", partición " . $partition . ".\n";
				$msg.=	"Palabra Clave: " . $user->ui_passkey . "\n";
				$msg.=	"Observación: " . $user->ui_observations . "\n";
				$msg.=	"Información del punto fijo:\n" . $user->hw_info;

				//log_error( $hw );
				
				//log_error( "sending mail:\to: $mails\nSubject: $subj\n$msg" );
				
				simple_mail( "no-responder@reddomo.com.ar", $mails, $subj, $msg );
			}
			
			if ( !empty( $phones ) ) {
				foreach( $phones as $phone ) {
					if ( isset( $phone ) && '' != $phone ) {
						$subj 	= 'DOMO: ' . $hw->het_var . ' en ' . $user->hw_name;
						
						load_library('SmsSender');
						CI()->smssender->send( $subj, $phone, $GLOBALS['company']['com_id'] );
					}
				}
			}
		}
	}
	
	private function _send_keychain_event_notification( $key_id, $com_id, $button, $timestamp, $hw_serial )
	{
		$db = db_get();
		
		$keymodel = load_model( 'Keychain_model' );
		
		$ktpl = $keymodel->get_key_tpl_by_id( $key_id, $com_id );
		
		if ( isset( $ktpl ) && !empty( $ktpl ) )
		{
			//trace( json_enc( $ktpl ) );
			$hwmodel= load_model( 'Hardware_model' );
			$hw		= $hwmodel->get_from_serial( $hw_serial );
			$kevtpl	= $ktpl[ $button - 1 ];
			$phones = $this->_extract_phones( $kevtpl['ktpl_contact'] );
			$mails	= $kevtpl['ktpl_contact'];
			
			if ( '' != $mails ) {
				$subj 	= 'Llavero de ' . $kevtpl['key_owner_name'] . ' ' . $kevtpl['key_owner_lastname'] . ' - ' . $kevtpl['ktpl_description'];
				$eventt	= strftime( "%A %e de %B a las %H:%M:%S", $timestamp );
				
				$msg =	"Fecha del evento: " . $eventt . "\n";
				$msg.=	"Mensaje: " . $kevtpl['ktpl_sms'] . "\n\n";
				$msg.=	"Información personal del propietario del llavero: \n";
				$msg.=	"Nombre: " . $kevtpl['key_owner_name'] . ' ' . $kevtpl['key_owner_lastname'] . "\n";
				$msg.=	"DNI: " . $kevtpl['key_owner_dni'] . "\n";
				$msg.=	"Teléfonos de Contacto: " . $kevtpl['key_owner_cellphone'] . " " . $kevtpl['key_owner_phone'] . " " . $kevtpl['key_owner_phone_alt'] . "\n";
				$msg.=	"EMail: " . $kevtpl['key_owner_mail'] . "\n";
				
				if ( isset( $hw->hw_address ) ) {
					$msg.=	"Dirección aproximada del evento: " . $hw->hw_address . "\n";
				}
				
				if ( '' != $kevtpl['key_observations'] ) {
					$msg.= "\nObservaciones: " . $kevtpl['key_observations'];
				}

				//trace( "Sending mail to: $mails\nSubject: $subj\n\n$msg" );
				
				simple_mail( "no-responder@reddomo.com.ar", $mails, $subj, $msg );
			}
			
			if ( !empty( $phones ) ) {
				foreach( $phones as $phone ) {
					$sms_txt = $kevtpl['ktpl_sms'];
					
					if ( isset( $hw->hw_address ) ) {
						$sms_txt.= "\nDir. Aprox: " . $hw->hw_address;
					}
					
					load_library('SmsSender');
					CI()->smssender->send( $sms_txt, $phone, $GLOBALS['company']['com_id'] );
					
					//trace( "sending sms:\n" . $kevtpl['ktpl_sms'] . " " . $phone . " " . $GLOBALS['company']['com_id'] );
				}
			}
		}
	}
	
	public function add_global_event_domo( $msg_type, $hw_serial, $encoded_frame_data, $event_id, $timestamp )
	{
		$gemodel	= load_model('GlobalEvent_model');
		$hwevmod	= load_model('HardwareEvents_model');
		$hwmod		= load_model('Hardware_model');
		$frame_data = FrameUtils::parse_framedata( $encoded_frame_data, FrameUtils::$TPL_FRAME_INCOMING );
		$hw			= $hwmod->get_from_serial( $hw_serial, ARRAY_A );
		$emergency	= FALSE;
		
		$desc = 't:'.dechex($msg_type).
				' ca:'.dechex($frame_data['evt_qualifier']).
				' ce:'.dechex($frame_data['evt_code']).
				' cp:'.dechex($frame_data['partition']).
				' z:'.dechex($frame_data['zone']);
		
		$rdesc = $hwevmod->get_event_desc( $hw['hw_id'], $hw['hw_company'], $msg_type, $frame_data, $emergency );
		
		if ( isset( $rdesc ) )
		{
			$desc .= ' ' . $rdesc;
		}
		
		$gemodel->add( GlobalEventType::DOMO, $event_id, $hw['hw_uid'], $hw['hw_id'], $hw['hw_serial'], $hw['hw_code'], $hw['hw_company'], $timestamp, $desc, $emergency ? 1 : 0 );
	}
	
	public function add_global_event_domo_signal( $msg_type, $hw_serial, $encoded_frame_data, $event_id, $timestamp )
	{
		$gemodel	= load_model('GlobalEvent_model');
		$hwmod		= load_model('Hardware_model');
		$frame_data = FrameUtils::parse_framedata( $encoded_frame_data, FrameUtils::$TPL_FRAME_INCOMING );
		$hw			= $hwmod->get_from_serial( $hw_serial, ARRAY_A );
		$emergency	= FALSE;
		$desc = 't:'.dechex($msg_type).
				' ca:'.dechex($frame_data['evt_qualifier']).
				' ce:'.dechex($frame_data['evt_code']).
				' cp:'.dechex($frame_data['partition']).
				' z:'.dechex($frame_data['zone']);
		
		$gemodel->add( GlobalEventType::DOMO_SIGNAL, $event_id, $hw['hw_uid'], $hw['hw_id'], $hw['hw_serial'], $hw['hw_code'], $hw['hw_company'], $timestamp, $desc, 0 );
	}
	
	public function add_global_event_dkeep( $key_id, $frame_data, $event_id, $timestamp, $com_id, $hw_serial )
	{
		$gemodel	= load_model('GlobalEvent_model');
		$keymodel	= load_model('Keychain_model');
		$key		= $keymodel->get_by_id( $key_id, $com_id );
		
		if ( isset( $key ) )
		{
			$ktpl		= $keymodel->get_key_tpl_by_id( $key_id, $com_id );
			$button		= $frame_data['button'];
			
			if ( isset( $ktpl ) && !empty( $ktpl ) )
			{
				$kevtpl	= $ktpl[ $button - 1 ];
				
				$desc	= $kevtpl['ktpl_description'];
				
				$gemodel->add( GlobalEventType::DKEEP, $event_id, $key['key_uid'], $key['key_id'], $hw_serial, $key['key_id'], $key['key_company'], $timestamp, $desc, 1 );
			}
		}
	}
	
	public function add_todb()
	{
		$Hardware_model = load_model('Hardware_model');
		
		$table = 'data_frames';
		$prefix= 'df_';
		$add_global_event = TRUE;
		
		switch($this->_get_body_type())
		{
			case FrameType::TEST: 
			case FrameType::CORE_TEST:
			{
				$table = 'test_frames';
				$prefix= 'tf_';
				$add_global_event = FALSE;
				
				break;
			}
			case FrameType::CORE_TEST_NEW:
			{
				$Hardware_model->update_core_from_serial( $this->get_hw_serial(), 1 );
				
				break;
			}
			case FrameType::SIGNAL_TEST:
			case FrameType::DTRANS:
			{
				$incom_body = FrameUtils::parse_framedata($this->m_Fields['frame_data'], FrameUtils::$TPL_FRAME_INCOMING);
				
				if($incom_body['evt_code'] == EVT_CODES_FRAME_x18::SIGNAL_TEST)
				{
					$table = 'signal_frames';
					$prefix= 'sf_';
					$add_global_event = FALSE;
				}
				else if($incom_body['evt_code'] == EVT_CODES_FRAME_x18::RESET_RESPONSE)
				{ //this is done here and no tin check_response for PERFORMANCE reasons (avoid double frame parsing)
					$hw_serial = $this->get_hw_serial();
					Actions::handle_reset_response(	$this->m_Fields['company_code'],
						$this->m_Fields['receiver_code'],
						$this->m_Fields['hw_code']);
				}
				else
				{
					$this->_send_event_notification(
								$this->m_Fields['company_code'], 
								$this->m_Fields['receiver_code'], 
								$this->m_Fields['hw_code'],
								$incom_body['evt_code'],
								$incom_body['zone'],
								$this->_get_body_type(),
								$incom_body['evt_qualifier'],
								$incom_body['partition'],
								$this->m_Fields['hw_timestamp']
					);
				}
				
				break;
			}
			case FrameType::SIGNAL_INFO:
			{
				$incom_body = FrameUtils::parse_framedata($this->m_Fields['frame_data'], FrameUtils::$TPL_FRAME_INCOMING);
				
				$now = pp_date_now();
				$tot_signal = intval( $incom_body['partition'] );
				$cur_signal = intval( $incom_body['zone'] ) >> 4;
				
				if($incom_body['evt_code'] == EVT_CODES_FRAME_x18::SIGNAL_XBEE_TEST)
				{
					db_get()->query( 'UPDATE hardware SET hw_inst_time = ?, hw_setup_signal = ?, hw_setup_signal_filtered = ?, hw_setup_signal_total_xbee = ? WHERE hw_serial = ?', 
										array( $now, $cur_signal, $cur_signal, $tot_signal, $this->get_hw_serial() ) );
				}
				else if($incom_body['evt_code'] == EVT_CODES_FRAME_x18::SIGNAL_3G_TEST)
				{
					db_get()->query( 'UPDATE hardware SET hw_inst_time_3g = ?, hw_setup_signal_3g = ?, hw_setup_signal_total_3g = ? WHERE hw_serial = ?', 
										array( $now, $cur_signal, $tot_signal, $this->get_hw_serial() ) );
				}
				
				$Hardware_model->update_is_city7( $this->get_hw_serial(), 1 );
				
				break;
			}
			case FrameType::KEYCHAIN:
			{
				$incom_body = FrameUtils::parse_framedata($this->m_Fields['frame_data'], FrameUtils::$TPL_KEYCHAIN_INCOMING);
				
				if ( 1 == $incom_body['evt_qualifier'] )
				{
					$keymodel	= load_model( 'Keychain_model' );
					$key		= ( intval( $incom_body['keychain_id_part_1'] ) << 10 ) + ( intval( $incom_body['keychain_id_part_2'] ) >> 2 & 0xFFF );
					
					//if ( $keymodel->valid_event( $key, $GLOBALS['company']['com_id'], $incom_body['button'], $this->m_Fields['hw_timestamp'], $this->get_hw_serial() ) )
					{
						$event_id = $keymodel->add_event( $key, $GLOBALS['company']['com_id'], $incom_body['button'], $this->m_Fields['hw_timestamp'], $this->get_hw_serial() );
						
						$this->_send_keychain_event_notification( $key, $GLOBALS['company']['com_id'], $incom_body['button'], $this->m_Fields['hw_timestamp'], $this->get_hw_serial() );
						
						$this->add_global_event_dkeep( $key, $incom_body, $event_id, $this->m_Fields['hw_timestamp'], $GLOBALS['company']['com_id'], $this->get_hw_serial() );
					}
				}
				
				return;
			}
			case FrameType::KPANEL:
			{
				$incom_body = FrameUtils::parse_framedata($this->m_Fields['frame_data'], FrameUtils::$TPL_FRAME_INCOMING);
				
				if ( $incom_body['evt_qualifier'] == 0xA && ( $incom_body['evt_code'] == KPANEL_TYPE::TYPE_585 || $incom_body['evt_code'] == KPANEL_TYPE::TYPE_832 ) )
				{
					$Hardware_model->update_is_kpanel( $this->get_hw_serial(), $incom_body['evt_code'] );
				}
				
				break;
			}
		}
		
		$Hardware_model->update_last_message( $this->get_hw_serial() );
		
		$query = SQL::make_insert_pdo( $table, array_keys($this->m_Fields), '', $prefix );
		
		CI()->db->query( $query, array_values( $this->m_Fields ) );
		
		if ( $add_global_event )
		{
			if ( 'data_frames' == $table )
			{
				$this->add_global_event_domo( $this->_get_body_type(), $this->get_hw_serial(), $this->m_Fields['frame_data'], CI()->db->insert_id(), $this->m_Fields['hw_timestamp'] );
			}
			else
			{
				// Disabled, it seems that we will not need this
				//$this->add_global_event_domo_signal( $this->_get_body_type(), $this->get_hw_serial(), $this->m_Fields['frame_data'], CI()->db->insert_id(), $this->m_Fields['hw_timestamp'] );
			}
		}
	}
	
	//decodifica el buffer tcp, desde un array(num,num,etc)
	public function decode($raw)
	{
		$this->m_Raw = $raw;
		$this->m_Fields = array_merge($this->_read_header($raw),$this->_read_body($raw),$this->_read_footer($raw));
	}
	
	private function _dump($TITLE, $data)
	{
		$s="\n----------BEGIN $TITLE----------\n";
		foreach( $data as $name => $value )
		{
			$s.=sprintf("%s = 0x%x\n",$name,$value);
		}
		$s.="----------END $TITLE----------\n";
		return $s;
	}
	
	public function dump_frame()
	{
		return $this->_dump('FRAME',$this->m_Fields);
	}
}
