<?php
require_once( FRAMES_PATH . 'actions.php' );

class CitymeshActions
{
	protected $action = array();
	protected $hwmod;
	
	function __construct( $action_data )
	{
		$this->action = $action_data;
		$this->hwmod = load_model('Hardware_model');
	}
	
	public function is_switchable( $index )
	{
		return $this->action['conf'][$index]=='1';
	}
	
	public function is_enabled( $index )
	{
		return $this->action['states'][$index]=='1';
	}
	
	public function get_id()
	{
		return $this->action['hw_id'];
	}
	
	public function get_serial()
	{
		return $this->action['hw_serial'];
	}
	
	public function get_code()
	{
		return $this->action['hw_code'];
	}
	
	public function get_name( $index )
	{
		return $this->hwmod->get_action_desc( $this->get_id(), $index ); 
	}
	
	public function get_action_id( $index )
	{
		return Actions::get_action_id_by_hw_id( $this->get_id(), $index );
	}
}
