<?php
require_once('frame_utils.php');
require_once('citymeshactions.php');

class Actions
{
	public static $SEND_PENDING = "SEND_PENDING";
	public static $WAITING_RESPONSE = "WAITING_RESPONSE";
	public static $EXECUTED = "EXECUTED";
	public static $FAILED ="FAILED";
	public static $ACTION_FORCED_TIMEOUT = 60; //in seconds
	public static $CONFIG_FORCED_TIMEOUT = 60; //in seconds
	public static $ACTION_NOT_FORCED_TIMEOUT = 1920; //in seconds
	public static $CONFIG_NOT_FORCED_TIMEOUT = 1920; //in seconds
	
	private static function xdecbin($dec)
	{//convierte a binario y rellena con 0 a la izq para que tenga 8 de length
		$bin = decbin($dec);
		return str_pad($bin, 8, "0", STR_PAD_LEFT);
	}

	private static function get_last_test_frame($hw_id)
	{
		$db = db_get();
		
		$db->set_qd( array( $hw_id ) );
		
		//Obtine el ultimo test_frame para saber el estado actual
		return $db->get_row('SELECT t.* FROM test_frames as t, hardware as h WHERE h.hw_id = ? 
					  	AND t.tf_company_code = h.hw_df_company AND t.tf_receiver_code = h.hw_df_receiver AND t.tf_hw_code =  h.hw_code 
					  	ORDER BY tf_id DESC LIMIT 1', ARRAY_A );
	}
	
	private static function get_last_response_frame($hw_id)
	{
		$db = db_get();
		
		$db->set_qd( array( $hw_id, 0x69 ) );
		
		return $db->get_row('SELECT d.* FROM data_frames as d, hardware as h WHERE h.hw_id = ?
					  	AND d.df_company_code = h.hw_df_company AND d.df_receiver_code = h.hw_df_receiver AND d.df_hw_code =  h.hw_code
					  	AND d.df_msg_type = ? ORDER BY df_id DESC LIMIT 1', ARRAY_A );
	}
	
	public static function get_last_states( $hw_id )
	{
		$last_test = self::get_last_test_frame( $hw_id );
		$last_response = self::get_last_response_frame( $hw_id );
		
		$time_t = $last_test['tf_hw_timestamp'];
		$time_r = $last_response['df_hw_timestamp'];
		
		if($last_test && $time_t>$time_r) //gets the most recent available data
		{
			$pre='tf_';
			$full_data = $last_test;
			$data = FrameUtils::parse_framedata($last_test['tf_frame_data'],FrameUtils::$TPL_FRAME_TESTING);
		}
		else if($last_response)
		{
			$pre='df_';
			$full_data = $last_response;
			$data = FrameUtils::parse_framedata($last_response['df_frame_data'],FrameUtils::$TPL_FRAME_RESPONSE);
		}
		else
		{
			return false;
		}
		
		//retorna 2 strings de bits: states = estado de los switchs / conf = configuracion (0:entrada, 1:salida)
		return new CitymeshActions( 
			array( 'states' =>	self::xdecbin($data['io_states']),
				'conf' =>	self::xdecbin($data['io_conf']),
				'io_states' => $data['io_states'],
				'io_conf' => $data['io_conf'],
				'hw_id' => $hw_id,
				'hw_serial' => $full_data[$pre.'hw_serial'],
				'hw_code' => $full_data[$pre.'hw_code'],
				'hw_df_receiver' => $full_data[$pre.'receiver_code'],
				'hw_df_company' => $full_data[$pre.'company_code']
			)
		 );
	}
	
	//adds an action to the db
	public static function send_action( $hw_id, $switch_num, $state, $com_id, $hw_serial, $hw_code, $forced = 1 )
	{
		$db = db_get();
		$HardwareCityMeshCommand_model = load_model('HardwareCityMeshCommand_model');
		$CityMeshConfigLog_model = load_model('CityMeshConfigLog_model');
		
		$value = $state ? ( 1 << $switch_num ) : ( ( 1 << $switch_num ) ^ 0xFF );
		
		$fields = array(
			'al_hw_id' => $hw_id,
			'al_hw_switch' => $switch_num,
			'al_send_states' => self::xdecbin( $value ),
			'al_state' => self::$SEND_PENDING,
			'al_force_send' => $forced
		);
		
		$db->set_qd(array_values($fields));
		$query = SQL::make_insert_pdo( 'actions_log', array_keys($fields), '', '');
		$db->query($query);
		
		$id = $db->last_insert_id();
		
		$db->trans_start();
		
		$batch_id = 0;
		$timestamp = time();
		$force = $forced;
		$retry_count = 4;
		$mode = $state ? 0x4 : 0x5;
		$CONFIG_TIMEOUT = $force ? self::$ACTION_FORCED_TIMEOUT : self::$ACTION_NOT_FORCED_TIMEOUT;
		
		$HardwareCityMeshCommand_model = load_model('HardwareCityMeshCommand_model');
		
		$HardwareCityMeshCommand_model->add( $hw_serial, $timestamp, $hw_code, FrameType::DOMOTIC_ACTION, $mode, 0x11, $value, 0x11, $force, 0, 'PENDING_SEND', $batch_id, $retry_count, $CONFIG_TIMEOUT, 10000 );
		
		$msg = citymesh_command_msg( 'Queued Command', $hw_serial, $timestamp, $hw_code, FrameType::DOMOTIC_ACTION, $mode, 0x11, $value, 0x11, $force, 0 );
		
		$CityMeshConfigLog_model->add( $com_id, $timestamp, $msg );
		
		$db->trans_complete();
		
		return $id;
	}
	
	public static function send_reset( $hw_id, $com_id, $hw_code, $hw_serial )
	{
		return self::send_config_action( $hw_id, FrameType::RESET, EVT_QUALIFIER::COMANDO, EVT_CODE_IGNORE::EVT_CODE, 0x11, $com_id, $hw_code, $hw_serial );
	}
	
	//adds an action to the db
	public static function send_config_action($hw_id,  /* FrameType */ $frame_type, /* EVT_QUALIFIER */ $qualifier , /* EVT_CODE_CONFIG_A or custom */ $evt_code, $value, $com_id, $hw_code, $hw_serial, $forced = 1 )
	{
		$db = db_get();
		$HardwareCityMeshCommand_model = load_model('HardwareCityMeshCommand_model');
		$CityMeshConfigLog_model = load_model('CityMeshConfigLog_model');
		
		$fields = array(
			'ac_hw_id' => $hw_id,
			'ac_tag' => act_frametype_to_name($frame_type),
			'ac_frame_type'  => $frame_type,
			'ac_evt_qualifier'  => $qualifier,
			'ac_evt_code'  => $evt_code,
			'ac_value'  => $value,
			'ac_state' => self::$SEND_PENDING,
			'ac_ex_company_id' => $com_id,
			'ac_ex_hw_code' => $hw_code,
			'ac_force_send' => $forced
		);

		$db->set_qd( array_values( $fields ) );
		$db->query( SQL::make_insert_pdo( 'actions_config', array_keys($fields), '', '') );
		$id = $db->last_insert_id();
		
		$db->trans_start();
		
		$batch_id = 0;
		$timestamp = time();
		$force = $forced;
		$retry_count = 4;
		$CONFIG_TIMEOUT = $force ? self::$CONFIG_FORCED_TIMEOUT : self::$CONFIG_NOT_FORCED_TIMEOUT;
		
		$HardwareCityMeshCommand_model = load_model('HardwareCityMeshCommand_model');
		
		$HardwareCityMeshCommand_model->add( $hw_serial, $timestamp, $hw_code, $frame_type, $qualifier, $evt_code, $value, 0x11, $force, 0, 'PENDING_SEND', $batch_id, $retry_count, $CONFIG_TIMEOUT, 1000 );
		
		$msg = citymesh_command_msg( 'Queued Command', $hw_serial, $timestamp, $hw_code, $frame_type, $qualifier, $evt_code, $value, 0x11, $force, 0 );
		
		$CityMeshConfigLog_model->add( $com_id, $timestamp, $msg );
		
		$db->trans_complete();
		
		return $id;
	}

	public static function get_action_status($action_id)
	{
		return db_get()->get_var('SELECT al_state FROM actions_log WHERE al_id = ? LIMIT 1', array($action_id) );
	}
	
	public static function get_action_id_by_hw_id( $hw_id, $switch_num )
	{
		return db_get()->get_var('SELECT al_id FROM actions_log WHERE al_hw_id = ? AND al_hw_switch = ? ORDER BY al_time DESC LIMIT 1', array( $hw_id, $switch_num ) );
	}
	
	public static function get_config_status($action_id)
	{
		$db = db_get();
		$db->set_qd(array($action_id));
		return $db->get_row('SELECT ac_state, ac_response FROM actions_config WHERE ac_id = ? LIMIT 1');
	}
	
	public static function handle_timeouts()
	{
		$db = db_get();
		
		$db->set_qd(array(self::$FAILED,self::$ACTION_FORCED_TIMEOUT));
		$db->query( 'UPDATE actions_log SET al_state = ? WHERE al_force_send = 1 AND ' . SQL::secs_from_ts( 'al_time' ) . ' > ?');

		$db->set_qd(array(self::$FAILED,self::$CONFIG_FORCED_TIMEOUT));
		$db->query( 'UPDATE actions_config SET ac_state = ? WHERE ac_force_send = 1 AND ' . SQL::secs_from_ts( 'ac_time' ) . ' > ?');
		
		$db->set_qd(array(self::$FAILED,self::$ACTION_NOT_FORCED_TIMEOUT));
		$db->query( 'UPDATE actions_log SET al_state = ? WHERE al_force_send = 0 AND ' . SQL::secs_from_ts( 'al_time' ) . ' > ?');

		$db->set_qd(array(self::$FAILED,self::$CONFIG_NOT_FORCED_TIMEOUT));
		$db->query( 'UPDATE actions_config SET ac_state = ? WHERE ac_force_send = 0 AND ' . SQL::secs_from_ts( 'ac_time' ) . ' > ?');
	}
	
	private static function get_user_config_actions( $state, $hw_serial, $frame_type, $code, $select = "*" )
	{
		$sql = "SELECT $select FROM actions_config INNER JOIN hardware ON ac_hw_id = hw_id WHERE ac_state = ? AND ac_frame_type = ? AND ac_evt_code = ? AND hw_serial = ? ORDER BY ac_time DESC";
		
		return db_get()->get_results( $sql, ARRAY_A, array( $state, $frame_type, $code, $hw_serial ) );
	}
	
	private static function update_config_state($actions, $value, $state)
	{
		$db = db_get();
		
		if( $actions )
		{
			foreach($actions as $action)
			{
				$db->set_qd( array( $state, $value, $action['ac_id'] ) );
				
				$db->query('UPDATE actions_config SET ac_state = ?, ac_response = ? WHERE ac_id = ?');
			}
		}
	}
	
	public static function handle_reset_response( $hw_serial )
	{
		$actions = self::get_user_config_actions( self::$WAITING_RESPONSE, $hw_serial, FrameType::RESET, EVT_CODE_IGNORE::EVT_CODE );
		
		self::update_config_state( $actions, 1, self::$EXECUTED );
	}
	
	public static function handle_config_response( $hw_serial, $frame_type, $code, $value, $got_response )
	{
		$actions = self::get_user_config_actions( self::$WAITING_RESPONSE, $hw_serial, $frame_type, $code );
		
		self::update_config_state( $actions, $value, $got_response ? self::$EXECUTED : self::$FAILED );
	}
	
	public static function set_config_cancelled( $com_id )
	{
		db_get()->query( 'UPDATE actions_config SET ac_state = ? WHERE ac_ex_company_id = ? AND ( ac_state = ? OR ac_state = ? )', array( self::$FAILED, $com_id, self::$SEND_PENDING, self::$WAITING_RESPONSE ) );
	}
	
	public static function set_actions_cancelled( $com_id )
	{
		db_get()->query( 'UPDATE actions_log al 
							SET al_state = ?
							FROM hardware hw 
							WHERE hw_id = al_hw_id AND hw_company = ? AND ( al_state = ? OR al_state = ? )', array( self::$FAILED, $com_id, self::$SEND_PENDING, self::$WAITING_RESPONSE ) );
	}

	/*----------------*/

	/*--domotic response--*/

	private static function make_user_domotic_action_select($return, $state, $hw_serial)
	{
		return 	"SELECT $return FROM actions_log WHERE al_state = '$state'
					AND al_hw_id = ( SELECT hw_id FROM hardware WHERE hw_serial = $hw_serial) ORDER BY al_time DESC";
	}

	private static function get_user_domotic_actions($state, $hw_serial, $select = "*")
	{
		return db_get()->get_results( self::make_user_domotic_action_select($select, $state, $hw_serial ),ARRAY_A );
	}
	
	public static function handle_domotic_response( $hw_serial, $states )
	{
		$actions = self::get_user_domotic_actions( self::$WAITING_RESPONSE, $hw_serial );
		
		if($actions)
		{
			$db = db_get();
			
			$states = self::xdecbin($states);
			
			foreach($actions as $action)
			{
				$sw = 7-$action['al_hw_switch'];
				$st = $action['al_send_states'];
				
				if($states[$sw] == $st[$sw])
				{
					$db->query('UPDATE actions_log SET al_state = ? WHERE al_id = ?', array(self::$EXECUTED, $action['al_id'] ));
				}
			}
		}
	}
	
	private static function get_company_domotic_actions($state, $company_code, $receiver_code, $select = "*")
	{
		$query = "SELECT $select FROM actions_log INNER JOIN hardware
				ON al_hw_id = hw_id
				WHERE hw_df_company = $company_code AND hw_df_receiver = $receiver_code AND al_state = '$state'";
		
		return db_get()->get_results( $query, ARRAY_A );
	}
	
	public static function set_config_waiting_response( $com_id )
	{
		db_get()->query('UPDATE actions_config SET ac_state = ? WHERE ac_ex_company_id = ? AND ac_state = ?', array( self::$WAITING_RESPONSE, $com_id, self::$SEND_PENDING ) );
	}
	
	public static function set_waiting_response( $com_id )
	{
		db_get()->query( 'UPDATE actions_log al 
							SET al_state = ?
							FROM hardware hw 
							WHERE hw_id = al_hw_id AND hw_company = ? AND al_state = ?', array( self::$WAITING_RESPONSE, $com_id, self::$SEND_PENDING ) );
	}
}
