<?php
class UserDbType
{
	const DB_USER_TYPE_CPNY_RO		= 5;
	const DB_USER_TYPE_CPNY_RW		= 6;
	const DB_USER_TYPE_CPNY_META	= 7;
}

class UserInfoType
{
	const USER_INFO_TYPE_NORMAL = 0;
	const USER_INFO_TYPE_DSHIELD = 1;
}

class DomoUser
{
	protected $id = 0;
	protected $type = 0;
	protected $real_type = 0;
	protected $name = '';
	protected $first_name = '';
	protected $last_name = '';
	protected $mail = '';
	protected $phone = '';
	protected $address = '';
	protected $city = 0;
	protected $company = 0;
	protected $type_id = 0;
	protected $users_count = 0;
	protected $logins_count = 0;
	protected $actions_count = 0;
	protected $df_com_code;
	protected $df_com_rec;
	protected $support = "";
	protected $suspended = false;
	protected $user_info_row = null;
	protected $com = null;
	protected $session = null;
	protected $hw_state_low = 0;
	protected $hw_state_good = 0;
	protected $child_com = null;
	protected $config_hw = false;
	protected $cu_type = false;
	protected $ui_type = false;
	protected $dshield_guard = false;
	protected $access_control = false;
	protected $radar_validator = false;
	
	static public $instance = null;
	
	static function fix_db_type( $type )
	{
		if ( $type == UserDbType::DB_USER_TYPE_CPNY_RW )
		{
			return USER_TYPE_CPNY_RW;
		}
		else if ( $type == UserDbType::DB_USER_TYPE_CPNY_RO )
		{
			return USER_TYPE_CPNY_RO;
		}
		else if ( $type == UserDbType::DB_USER_TYPE_CPNY_META )
		{
			return USER_TYPE_CPNY_META;
		}

		return $type;
	}

	static function to_db_type( $type )
	{
		if ( $type == USER_TYPE_CPNY_RW )
		{
			return UserDbType::DB_USER_TYPE_CPNY_RW;
		}
		else if ( $type == USER_TYPE_CPNY_RO )
		{
			return UserDbType::DB_USER_TYPE_CPNY_RO;
		}
		else if ( $type == USER_TYPE_CPNY_META )
		{
			return UserDbType::DB_USER_TYPE_CPNY_META;
		}
	}
	
	static function db_type_name( $type )
	{
		switch( $type )
		{
			case USER_TYPE_CPNY: return 'USER_TYPE_CPNY';
			case USER_TYPE_CPNY_META: return 'USER_TYPE_CPNY_META';
			case USER_TYPE_CPNY_RO: return 'USER_TYPE_CPNY_RO';
			case USER_TYPE_CPNY_RW: return 'USER_TYPE_CPNY_RW';
			case USER_TYPE_GOD: return 'USER_TYPE_GOD';
			case USER_TYPE_HW: return 'USER_TYPE_HW';
			case USER_TYPE_USER: return 'USER_TYPE_USER';
		}
		
		return '';
	}
	
	protected function print_log_as_error( $userdata, $uid, $type )
	{
		trace( $userdata['session_name'] . ' ( ' . $userdata['session_uid'] . ' ) tried to log as ' . self::db_type_name( $type ) . ' ( uid: ' . $uid . ' ) that not belongs to him' );
		trace_json( $userdata );
	}
	
	function log_as( $uid, &$session )
	{
		$type		= self::fix_db_type( CI()->User_model->get_type( $uid ) );
		$sec		= TRUE;
		$userdata	= $session->all_userdata();
		
		if ( $type <= $this->get_real_type() )
		{
			if ( $this->get_real_type() == USER_TYPE_CPNY_META )
			{
				if ( $type == USER_TYPE_CPNY || $type == USER_TYPE_CPNY_RO )
				{
					if ( !( $this->is_child_company( $uid ) || CI()->Company_model->is_child_company_user( $this->get_real_id(), $uid ) ) )
					{
						$sec = FALSE;
						
						$this->print_log_as_error( $userdata, $uid, $type );
					}
				}
				else if ( $type == USER_TYPE_USER )
				{
					if ( CI()->User_model->get_company( $uid ) != $this->get_company() )
					{
						$sec = FALSE;
						
						$this->print_log_as_error( $userdata, $uid, $type );
					}
				}
			}
			else if ( $this->get_real_type() == USER_TYPE_CPNY )
			{
				if ( $type == USER_TYPE_CPNY || $type == USER_TYPE_CPNY_RO )
				{
					if ( $uid != $this->get_real_id() )
					{
						$sec = FALSE;
						
						$this->print_log_as_error( $userdata, $uid, $type );
					}
				}
				else if ( $type == USER_TYPE_USER )
				{
					if ( CI()->User_model->get_company( $uid ) != $this->get_company() )
					{
						$sec = FALSE;
						
						$this->print_log_as_error( $userdata, $uid, $type );
					}
				}
			}
			
			if ( TRUE == $sec )
			{
				$userdata['session_cuid'] = $uid;
			}
		}
		else if ( USER_TYPE_GOD != $this->get_real_type() )
		{
			$this->print_log_as_error( $userdata, $uid, $type );
			
			return FALSE;
		}
		
		if ( $type == USER_TYPE_CPNY && $this->get_real_type() == USER_TYPE_GOD )
		{
			$userdata['session_lcuid'] = $uid;	  // Last company uid
		}
		
		$session->set_userdata( $userdata );
		
		return $sec;
	}
	
	function __construct( $params )
	{
		$this->session = $params['session'];
		
		$this->get_user_data( $params['uid'] );
		
		self::$instance = $this;
	}
	
	function get_user_data( $id )
	{
		$row = CI()->User_model->get( $id );
		
		CI()->User_model->get_company( $id );
		
		$this->real_type = self::fix_db_type( CI()->User_model->get_type( $this->get_real_id() ) );
		
		if ( isset( $row ) )
		{
			$this->id			= $row->uid;
			$this->type			= DomoUser::fix_db_type( $row->utype );
			$this->name			= $row->uname;
			$this->mail			= $row->umail;
			$this->suspended	= $row->ustate == 'SUSPENDED' ? true : false;
		}
		
		switch ( $this->type )
		{
			case USER_TYPE_USER:	$this->get_user_info_data();	break;
			case USER_TYPE_CPNY_META:
			case USER_TYPE_CPNY:	$this->get_company_info_data();	break;
			case USER_TYPE_GOD:		$this->get_god_info_data();		break;
			case USER_TYPE_CPNY_RW:
			case USER_TYPE_CPNY_RO: $this->get_company_user_data(); break;
		}
	}

	function is_suspended()
	{
		return $this->suspended;
	}
	
	function get_company_user_data()
	{
		$cumod	= load_model( 'CompanyUser_model' );
		$row	= $cumod->get( $this->id );

		if ( isset( $row ) )
		{
			if ( USER_TYPE_CPNY_RW == $this->type )
			{
				$this->type = USER_TYPE_CPNY;
			}
			
			$this->config_hw = $row->cu_config_hw > 0;
			$this->cu_type = $row->cu_type;
			
			$this->dshield_guard = $row->cu_dshield_guard;
			$this->access_control = $row->cu_access_control;
			
			$this->get_company_info_data( $row->cu_com_id );
			
			$this->last_name = $this->name;
		}
	}
	
	function get_user_info_data()
	{
		$row = CI()->User_model->get_info( $this->id );
		
		if ( isset( $row ) )
		{
			$this->type_id		= $row->ui_id;
			$this->first_name	= $row->ui_name;
			$this->last_name	= $row->ui_lastname;
			$this->phone		= $row->ui_phone;
			$this->address		= $row->ui_address;
			$this->city			= $row->ui_city;
			$this->company		= $row->ui_company;
			$this->df_com_code	= $row->com_df_id;
			$this->df_com_rec	= $row->com_rec_id;
			$this->support		= $row->ui_support;
			$this->user_info_row= $row;
			$this->ui_type		= $row->ui_type;
			
			$cmod	= load_model( 'Company_model' );
			$row				= $cmod->get( $this->company );
			$this->com			= $row;
			$this->hw_state_low = $row->com_hw_state_low;
			$this->hw_state_good= $row->com_hw_state_good;
		}
	}

	function get_user_info()
	{
		return $this->user_info_row;
	}
	
	// THIS GOES IN COMPANY CLASS
	function get_company_info_data( $from_com_id = 0 )
	{
		$cmod	= load_model( 'Company_model' );
		
		if ( 0 == $from_com_id )
		{
			$row = $cmod->get_from_user( $this->id );
			
			if ( !isset( $row ) )
			{
				$cumod = load_model( 'CompanyUser_model' );
				
				$cuser = $cumod->get( $this->id );
				
				if ( isset( $cuser ) )
				{
					$row = $cmod->get( $cuser->cu_com_id );
				}
				else
				{
					echo "Error fatal";
					exit;
				}
			}
		}
		else
		{
			$row = $cmod->get( $from_com_id );
		}
		
		if ( isset( $row ) )
		{
			$this->type_id		= $row->com_id;
			$this->last_name	= $row->com_name;
			$this->city			= $row->com_city;
			$this->phone		= $row->com_phone;
			$this->company		= $row->com_id;
			$this->df_com_code	= $row->com_df_id;
			$this->df_com_rec	= $row->com_rec_id;
			$this->support		= $row->com_support;
			$this->com			= $row;
			$this->hw_state_low = $row->com_hw_state_low;
			$this->hw_state_good= $row->com_hw_state_good;
			$this->config_hw	= true;
			$this->radar_validator = $row->com_radar_validator ? true : false;
		}
		else
		{
			echo "Error fatal";
			exit;
		}
	}
	
	function get_company_info()
	{
		return $this->com;
	}
	
	function get_users_count()
	{
		return $this->users_count;
	}
	
	function get_logins_count()
	{
		return $this->logins_count;
	}
	
	function get_actions_count()
	{
		return $this->actions_count;
	}
	
	function get_god_info_data()
	{
		$this->config_hw = true;
	}
	
	function get_id()
	{
		return $this->id;
	}
	
	function get_user_id()
	{
		return $this->session['session_cuid'];
	}
	
	function get_type()
	{
		return $this->type;
	}
	
	function get_name()
	{
		return $this->name;
	}
	
	function get_fullname()
	{
		switch ( $this->type )
		{
			case USER_TYPE_USER:	return $this->first_name.' '.$this->last_name;
			case USER_TYPE_CPNY_RO:
			case USER_TYPE_CPNY_META:
			case USER_TYPE_CPNY:	return $this->last_name;
			case USER_TYPE_GOD:		return 'Deitres';
		}
	}
	
	function get_mail()
	{
		return $this->mail;
	}
	
	function get_phone()
	{
		return $this->phone;
	}
	
	function get_address()
	{
		return $this->address;
	}
	
	function get_company()
	{
		return $this->company;
	}
	
	function get_df_code()
	{
		return $this->df_com_code;
	}
	
	function get_df_rec()
	{
		return $this->df_com_rec;
	}
	
	function get_city()
	{
		return $this->city;
	}
	
	function get_support()
	{
		return $this->support;
	}
	
	/** This is the id of the type of the object, for users is the id of the user info, for company the id of the company */
	function get_type_id()
	{
		return $this->type_id;
	}
	
	//return true if the current user owns the hw_id
	function owns_hw( $hw_id, $use_real_type = FALSE )
	{
		$type = $use_real_type ? $this->get_real_type() : $this->get_type();
		
		if ( USER_TYPE_CPNY_META == $type )
		{
			return (bool) CI()->Company_model->owns_hw_from_df( $this->get_df_code(), $hw_id );
		}
		else if ( USER_TYPE_CPNY == $type || USER_TYPE_CPNY_RO == $type )
		{
			return (bool) CI()->Company_model->owns_hw( $this->get_type_id(), $hw_id );
		}
		else if ( USER_TYPE_GOD == $type )
		{
			return true;
		}
		
		return (bool) CI()->User_model->owns_hw( $this->get_type_id(), $hw_id );
	}
	
	function owns_mac( $hw_serial, $use_real_type = FALSE )
	{
		$type = $use_real_type ? $this->get_real_type() : $this->get_type();
		
		if ( USER_TYPE_CPNY_META == $type )
		{
			return (bool) CI()->Company_model->owns_mac_from_df( $this->get_df_code(), $hw_serial ); 
		}
		else if ( USER_TYPE_CPNY == $type || USER_TYPE_CPNY_RO == $type )
		{
			return (bool) CI()->Company_model->owns_mac( $this->get_type_id(), $hw_serial );
		}
		else if ( USER_TYPE_GOD == $type )
		{
			return true;
		}
		
		return (bool) CI()->User_model->owns_mac( $this->get_type_id(), $hw_serial );
	}
	
	function owns_hw_fake( $hwf_id, $use_real_type = FALSE )
	{
		$type = $use_real_type ? $this->get_real_type() : $this->get_type();
		
		if ( USER_TYPE_CPNY_META == $type )
		{
			return (bool) CI()->Company_model->owns_hw_fake( $this->get_df_code(), $hwf_id );
		}
		else if ( USER_TYPE_CPNY == $type || USER_TYPE_CPNY_RO == $type )
		{
			return (bool) CI()->Company_model->owns_hw_fake( $this->get_type_id(), $hwf_id );
		}
		else if ( USER_TYPE_GOD == $type )
		{
			return true;
		}
		
		return false;
	}
	
	function owns_user( $uid, $use_real_type = FALSE )
	{
		$type = $use_real_type ? $this->get_real_type() : $this->get_type();
		
		if ( USER_TYPE_CPNY_META == $type )
		{
			return (bool) CI()->Company_model->owns_user_from_df( $this->get_df_code(), $uid );
		}
		else if ( USER_TYPE_CPNY == $type || USER_TYPE_CPNY_RO == $type )
		{
			return (bool) $this->get_user_id() == $uid || CI()->Company_model->owns_user( $this->get_type_id(), $uid );
		}
		else if ( $type == USER_TYPE_GOD )
		{
			return true;
		}

		return $uid == $this->get_real_id();
	}
	
	function owns_company_user( $uid, $use_real_type = FALSE )
	{
		$type = $use_real_type ? $this->get_real_type() : $this->get_type();
		
		if ( USER_TYPE_CPNY_META == $type )
		{
			return (bool) CI()->Company_model->owns_company_user_from_df( $this->get_df_code(), $uid );
		}
		else if ( USER_TYPE_CPNY == $type || USER_TYPE_CPNY_RO == $type )
		{
			return (bool) CI()->Company_model->owns_company_user( $this->get_type_id(), $uid );
		}
		else if ( $type == USER_TYPE_GOD )
		{
			return true;
		}

		return $uid == $this->get_real_id();
	}
	
	function owns_imei( $imei, $use_real_type = FALSE )
	{
		load_model( 'AvlHardware_model' );
		
		$type = $use_real_type ? $this->get_real_type() : $this->get_type();
		
		if ( USER_TYPE_CPNY_META == $type )
		{
			return (bool) CI()->AvlHardware_model->company_owns_imei_from_df( $this->get_df_code(), $imei );
		}
		else if ( USER_TYPE_CPNY == $type || USER_TYPE_CPNY_RO == $type )
		{
			return (bool) CI()->AvlHardware_model->company_owns_imei( $this->get_type_id(), $imei );
		}
		else if ( USER_TYPE_GOD == $type )
		{
			return true;
		}
		
		return (bool) CI()->AvlHardware_model->user_owns_imei( $this->get_id(), $imei );
	}
	
	function owns_fleet( $fleet, $use_real_type = FALSE )
	{
		load_model( 'AvlFleet_model' );
		
		$type = $use_real_type ? $this->get_real_type() : $this->get_type();
		
		if ( USER_TYPE_CPNY_META == $type )
		{
			return (bool) CI()->AvlFleet_model->company_owns_fleet_from_df( $this->get_df_code(), $imei );
		}
		else if ( USER_TYPE_CPNY == $type || USER_TYPE_CPNY_RO == $type )
		{
			return (bool) CI()->AvlFleet_model->company_owns_fleet( $this->get_type_id(), $imei );
		}
		else if ( USER_TYPE_GOD == $type )
		{
			return true;
		}
		
		return (bool) CI()->AvlFleet_model->user_owns_fleet( $this->get_type_id(), $fleet );
	}
	
	function owns_group( $group, $use_real_type = FALSE )
	{
		load_model( 'HardwareGroup_model' );
		
		$type = $use_real_type ? $this->get_real_type() : $this->get_type();
		
		if ( USER_TYPE_CPNY_META == $type )
		{
			return (bool) CI()->HardwareGroup_model->company_owns_group_from_df( $this->get_df_code(), $group );
		}
		else if ( USER_TYPE_CPNY == $type || USER_TYPE_CPNY_RO == $type )
		{
			return (bool) CI()->HardwareGroup_model->company_owns_group( $this->get_type_id(), $group );
		}
		else if ( USER_TYPE_GOD == $type )
		{
			return true;
		}
		
		return false;
	}
	
	function owns_keychain( $key_uid, $use_real_type = FALSE )
	{
		load_model( 'Keychain_model' );
		
		$type = $use_real_type ? $this->get_real_type() : $this->get_type();
		
		if ( USER_TYPE_CPNY_META == $type )
		{
			return (bool) CI()->Keychain_model->company_owns_keychain_from_df( $this->get_df_code(), $key_uid );
		}
		else if ( USER_TYPE_CPNY == $type || USER_TYPE_CPNY_RO == $type )
		{
			return (bool) CI()->Keychain_model->company_owns_keychain( $this->get_type_id(), $key_uid );
		}
		else if ( USER_TYPE_GOD == $type )
		{
			return true;
		}
		
		return (bool) CI()->Keychain_model->owns_keychain( $this->get_id(), $key_uid );
	}
	
	function owns_radar( $rd_id, $use_real_type = FALSE )
	{
		load_model( 'Radar_model' );
		
		$type = $use_real_type ? $this->get_real_type() : $this->get_type();
		
		if ( USER_TYPE_CPNY_META == $type )
		{
			return (bool) CI()->Radar_model->company_owns_from_df( $this->get_df_code(), $rd_id );
		}
		else if ( USER_TYPE_CPNY == $type || USER_TYPE_CPNY_RO == $type )
		{
			return (bool) CI()->Radar_model->company_owns( $this->get_type_id(), $rd_id );
		}
		else if ( USER_TYPE_GOD == $type )
		{
			return true;
		}
		
		return false;
	}
	
	function owns_person( $urfid_id, $use_real_type = FALSE )
	{
		load_model( 'RfidUser_model' );
		
		$type = $use_real_type ? $this->get_real_type() : $this->get_type();
		
		if ( USER_TYPE_CPNY_META == $type )
		{
			return (bool) CI()->RfidUser_model->owns_person_from_df( $this->get_df_code(), $urfid_id );
		}
		else if ( USER_TYPE_CPNY == $type || USER_TYPE_CPNY_RO == $type )
		{
			return (bool) CI()->RfidUser_model->owns_person( $this->get_type_id(), $urfid_id );
		}
		else if ( $type == USER_TYPE_GOD )
		{
			return true;
		}
		
		return false;
	}
	
	function owns_guest( $urfid_id, $use_real_type = FALSE )
	{
		load_model( 'RfidUser_model' );
		
		$type = $use_real_type ? $this->get_real_type() : $this->get_type();
		
		if ( USER_TYPE_USER == $type )
		{
			load_model('RfidUserPlot_model');
			
			return CI()->RfidUserPlot_model->same_uid_plot( $this->get_user_id(), $urfid_id );
		}
		else if ( USER_TYPE_CPNY_META == $type )
		{
			return (bool) CI()->RfidUser_model->owns_person_from_df( $this->get_df_code(), $urfid_id );
		}
		else if ( USER_TYPE_CPNY == $type || USER_TYPE_CPNY_RO == $type )
		{
			return (bool) CI()->RfidUser_model->owns_person( $this->get_type_id(), $urfid_id );
		}
		else if ( $type == USER_TYPE_GOD )
		{
			return true;
		}
		
		return false;
	}
	
	function owns_rfid( $rfid_serial, $use_real_type = FALSE )
	{
		load_model( 'Rfid_model' );
		
		$type = $use_real_type ? $this->get_real_type() : $this->get_type();
		
		if ( USER_TYPE_CPNY_META == $type )
		{
			return (bool) CI()->Rfid_model->owns_rfid_from_df( $this->get_df_code(), $rfid_serial );
		}
		else if ( USER_TYPE_CPNY == $type || USER_TYPE_CPNY_RO == $type )
		{
			return (bool) CI()->Rfid_model->owns_rfid_from_company( $this->get_type_id(), $rfid_serial );
		}
		else if ( $type == USER_TYPE_GOD )
		{
			return true;
		}
		
		return (bool) CI()->Rfid_model->owns_rfid( $this->get_user_id(), $rfid_serial );
	}
	
	function owns_photo( $rp_id, $use_real_type = FALSE )
	{
		load_model( 'RfidPhoto_model' );
		
		$type = $use_real_type ? $this->get_real_type() : $this->get_type();
		
		if ( USER_TYPE_CPNY_META == $type )
		{
			return (bool) CI()->RfidPhoto_model->owns_rfid_from_df( $this->get_df_code(), $rp_id );
		}
		else if ( USER_TYPE_CPNY == $type || USER_TYPE_CPNY_RO == $type )
		{
			return (bool) CI()->RfidPhoto_model->owns_rfid_from_company( $this->get_type_id(), $rp_id );
		}
		else if ( $type == USER_TYPE_GOD )
		{
			return true;
		}
		
		return false;
	}
	
	function get_hw_count( $user_real_type = false )
	{
		$type = $user_real_type ? $this->get_real_type() : $this->type;
		
		switch ( $type )
		{
			case USER_TYPE_USER:
			{
				return $this->User_model->get_hw_count( $this->get_type_id() );
			}
			case USER_TYPE_CPNY:
			case USER_TYPE_CPNY_RO:
			{
				return load_model('Company_model')->get_hw_count( $this->get_type_id() );
			}
			case USER_TYPE_CPNY_META:
			{
				return load_model('Company_model')->get_hw_count( $this->get_type_id(), TRUE );
			}
			case USER_TYPE_GOD:
			{
				return load_model('Hardware_model')->count();
			}
		}
	}
	
	/** @return If the current user id is the same to the initial user that loged in. */
	function is_real_user()
	{
		return $this->session['session_uid'] == $this->session['session_cuid'];
	}
	
	function get_real_type()
	{
		return $this->real_type;
	}
	
	function get_hw_state_low()
	{
		return $this->hw_state_low;
	}

	function get_hw_state_good()
	{
		return $this->hw_state_good;
	}
		
	function get_real_id()
	{
		return $this->session['session_uid'];
	}
	
	function get_last_company_uid()
	{
		return $this->session['session_lcuid'];
	}
	
	function is_god()
	{
		return $this->get_real_type() >= USER_TYPE_GOD;
	}

	function is_company()
	{
		return $this->get_real_type() >= USER_TYPE_CPNY && $this->get_real_type() < USER_TYPE_GOD;
	}
	
	function is_company_meta()
	{
		return $this->get_real_type() == USER_TYPE_CPNY_META;
	}
	
	function is_god_or_company()
	{
		return $this->is_god() || $this->is_company() || $this->is_company_meta();
	}
	
	function is_logged_as_god()
	{
		return $this->get_type() >= USER_TYPE_GOD;
	}
	
	function is_logged_as_company()
	{
		return $this->get_type() >= USER_TYPE_CPNY && $this->get_type() < USER_TYPE_GOD;
	}
	
	function is_logged_as_company_ro()
	{
		return $this->get_type() >= USER_TYPE_CPNY_RO && $this->get_type() < USER_TYPE_GOD;
	}
	
	function is_logged_as_company_meta()
	{
		return $this->get_type() == USER_TYPE_CPNY_META;
	}
	
	function is_logged_as_god_or_meta_company()
	{
		return $this->is_logged_as_god() || $this->is_logged_as_company_meta();
	}
	
	function is_logged_as_god_or_company()
	{
		return $this->is_logged_as_god() || $this->is_logged_as_company() || $this->is_logged_as_company_meta();
	}
	
	function is_logged_as_user()
	{
		return $this->get_type() < USER_TYPE_CPNY_RO;
	}
	
	function can_see_user( $uid, $block = true )
	{
		if ( $this->get_real_type() == USER_TYPE_USER )
		{
			if ( $this->get_real_id() != $uid )
			{
				if ( $block )
				{
					echo 'You cannot access here...';
					exit;
				}
				
				return false;
			}
		}
		else
		{
			if ( !$this->owns_user( $uid ) )
			{
				if ( $block )
				{
					echo 'You cannot access here...';
					exit;
				}
				else
				{
					return false;
				}
			}
		}
		
		return true;
	}
	
	function get_child_companies( $with_meta = FALSE )
	{
		if ( NULL == $this->child_com )
		{
			$coms	= 	$with_meta ?
						CI()->Company_model->get_companies_from_df_with_meta( $this->get_df_code() ) :
						CI()->Company_model->get_companies_from_df( $this->get_df_code() );
			
			if ( isset( $coms ) )
			{
				$this->child_com = array();
				
				foreach( $coms as $com )
				{
					array_push( $this->child_com, $com['com_id'] );
				}
			}
		}
		
		return $this->child_com;
	}
	
	function get_company_ids()
	{
		return $this->is_logged_as_company_meta() ? $this->get_child_companies() : $this->get_company();
	}
	
	function get_company_ids_with_meta()
	{
		return $this->is_logged_as_company_meta() ? $this->get_child_companies( TRUE ) : $this->get_company();
	}
	
	function is_child_company( $uid )
	{
		return CI()->Company_model->is_child_company( $this->get_real_id(), $uid );
	}
	
	function is_company_healthy()
	{
		if ( 0 != $this->company )
		{
			$rtmod = load_model('ReceiverTicks_model');
			
			return $rtmod->is_healthy( $this->company );
		}
		
		return false;
	}
	
	function can_config_hw()
	{
		return $this->config_hw;
	}
	
	function is_normal_dshield_admin()
	{
		return $this->cu_type == CompanyUserType::NORMAL;
	}
	
	function is_guard()
	{
		return $this->cu_type == CompanyUserType::GUARD;
	}
	
	function get_company_user_type()
	{
		return $this->cu_type;
	}
	
	function can_write()
	{
		return $this->is_logged_as_god() || $this->is_logged_as_company();
	}
	
	function is_professional()
	{
		return $this->cu_type == CompanyUserType::PROFESSIONAL;
	}
	
	function can_control_dshield()
	{
		return ( $this->is_guard() && $this->dshield_guard ) || $this->is_normal_dshield_admin() || $this->is_god();
	}
	
	function can_access_control()
	{
		return $this->access_control || $this->is_god();
	}
	
	function is_dshield_user()
	{
		return $this->type == USER_TYPE_USER && $this->ui_type == UserInfoType::USER_INFO_TYPE_DSHIELD;
	}
	
	function is_radar_validator()
	{
		return $this->radar_validator;
	}
}

