<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 

class CitymeshGSM
{
	protected $listener_host	= '127.0.0.1';
	protected $listener_port	= 4561;
	
	protected function send_to_listener( $to_ip, $to_port, $imei, $cmd )
	{
		$retry	= 4;
		
		do
		{
			$up['cmd']	= 'update_ip';
			$up['ip']	= $to_ip;
			$up['port']	= $to_port;
			$up['imei']	= $imei;
			$mid		= json_encode($up);
			$fp			= @fsockopen( "udp://" . $this->listener_host, $this->listener_port, $errno, $errstr );
			
			if ( $fp )
			{
				if ( @fwrite( $fp, $mid ) && @fwrite( $fp, $cmd ) )
				{
					@fclose($fp);
					
					return TRUE;
				}

				usleep(250000);
				
				@fclose($fp);
			}
			else
			{
				usleep(250000);
			}
		} while ( --$retry );
	}

	public function send_msg( $imei, $msg )
	{
		$ahm = load_model('Hardware_model');
		
		$hw		= $ahm->get_ip_port( $imei );
		$ip		= $hw['hw_ip'];
		$port	= $hw['hw_port'];
		
		if ( isset( $ip ) && is_string( $ip ) && filter_var( $ip, FILTER_VALIDATE_IP ) )
		{
			if ( is_array( $msg ) )
			{
				$msg = json_encode( $msg );
			}
			
			return $this->send_to_listener( $ip, $port, $imei, $msg );
		}
		
		return FALSE;
	}

	public function config_auto_cast( &$cfg )
	{
		foreach ( $cfg as $k=>$v )
		{
			if ( (string)intval( $v ) == $v )
			{
				$cfg[$k] = intval($v);
			}
			else if ( (string)floatval( $v ) == $v )
			{
				$cfg[$k] = floatval($v);
			}
		}		
	}

	public function gen_config( $imei, $config )
	{
		$cmd['cmd']		= 'config_set';
		$cmd['imei']	= $imei;
		$cmd['config']	= $config;
		return json_encode($cmd);
	}

	public function default_config()
	{
		$cfg['gsm']			= "internet.ctimovil.com.ar:gprs::reddomo.com.ar:4550:0";
		$cfg['test_alr']	= 0;
		$cfg['recv']		= ":";
		$cfg['upgr_ver']	= "";
		$cfg['firm_ver']	= "";

		return $cfg;
	}
}
