<?php

function datetime_noms( $datetime )
{
	$date			= explode( '.', $datetime );
	return $date[0];
}

function timestamp_to_str( $timestamp, $def_val = '', $include_seconds = FALSE )
{
	if ( NULL == $timestamp )
	{
		return $def_val;
	}
	
	return strftime ('%d/%m/%Y %H:%M' . ( $include_seconds ? ':%S' : '' ), $timestamp );
}

function timestamp_to_date_str( $timestamp, $def_val = '' )
{
	if ( NULL == $timestamp )
	{
		return $def_val;
	}
	
	return strftime ('%d/%m/%Y', $timestamp );
}

function timestamp_to_time_str( $timestamp, $def_val = '', $include_seconds = TRUE )
{
	if ( NULL == $timestamp )
	{
		return $def_val;
	}
	
	return strftime ('%H:%M' . ( $include_seconds ? ':%S' : '' ), $timestamp );
}

function get_size($path)
{
	$bytes = array('B','KB','MB','GB','TB');
	
	if (file_exists($path))
		$size = filesize($path);
	else
		return '';	
	
	foreach($bytes as $val)
	{
		if($size > 1024){
			$size = $size / 1024;
		} else break;
	}
	return round($size, 2)." ".$val;
}

function get_ext($file)
{
	$arr = explode('.', $file);
	return strtolower($arr[count($arr)-1]);
}

function trace( $err )
{
	//if ( TRUE == DEBUG )
	{
		$file = @fopen ( ROOTPATH . '/traced_errors', 'a' );
		@fputs ( $file, $err."\n" );
		@fclose ($file);
	}
}

function add_include_path($path)
{
	set_include_path( get_include_path() . PATH_SEPARATOR . $path );
}

/** pretty-prints json data, for human readability */
function json_pp( $json, $html = false )
{
	$nl = $html ? "<br/>\n" : "\n";
	$tab = $html ? "&nbsp;&nbsp;&nbsp;&nbsp;" : "	";
	$new_json = "";
	$indent_level = 0;
	$in_string = false;

	$len = strlen($json);

	for($c = 0; $c < $len; $c++)
	{
		$char = $json[$c];
		switch($char)
		{
			case '{':
			case '[':
				if(!$in_string)
				{
					$new_json .= $char . $nl . str_repeat($tab, $indent_level+1);
					$indent_level++;
				}
				else
				{
					$new_json .= $char;
				}
				break;
			case '}':
			case ']':
				if(!$in_string)
				{
					$indent_level--;
					$new_json .= $nl . str_repeat($tab, $indent_level) . $char;
				}
				else
				{
					$new_json .= $char;
				}
				break;
			case ',':
				if(!$in_string)
				{
					$new_json .= "," . $nl . str_repeat($tab, $indent_level);
				}
				else
				{
					$new_json .= $char;
				}
				break;
			case ':':
				if(!$in_string)
				{
					$new_json .= ": ";
				}
				else
				{
					$new_json .= $char;
				}
				break;
			case '"':
				if($c > 0 && $json[$c-1] != '\\')
				{
					$in_string = !$in_string;
				}
			default:
				$new_json .= $char;
				break;
		}
	}

	return $new_json;
}

function json_enc( $data, $html = false )
{
	return json_pp( json_encode( $data, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE ), $html );
}

function json_enc_obj( $obj, $html = false )
{
	return json_pp( json_encode( object_to_array( $obj ) ), $html );
}

function now()
{
	return time_to_date();
}

function time_to_date( $time = null, $set_time_zone = false )
{
	if ( $set_time_zone )
		date_default_timezone_set( 'UTC' );
	
	if ( is_null( $time ) )
		return date( 'Y-m-d H:i:s', time() );
	
	return date( 'Y-m-d H:i:s', $time );
}

function get_var( $name, $is_post = FALSE )
{
	$ret = null;
	
	if ( TRUE == DEBUG )
	{
		if ( isset( $_REQUEST[ $name ] ) )
		{
			$ret = $_REQUEST[ $name ];
		}
		
	}
	
	if ( $is_post )
	{
		if ( isset( $_POST[ $name ] ) )
		{
			$ret = $_POST[ $name ];
		}
	}
	
	if ( isset( $_GET[ $name ] ) )
	{
		$ret = $_GET[ $name ];
	}
	
	/* We strip slashes if magic quotes is on to keep things consistent

	   NOTE: In PHP 5.4 get_magic_quotes_gpc() will always return 0 and
		 it will probably not exist in future versions at all.
	*/
	if ( ! is_php('5.4') && get_magic_quotes_gpc())
	{
		$ret = stripslashes($ret);
	}

	return $ret;
}

function get_post( $name )
{
	return get_var( $name, true );
}

function get_var_def( $name, $default, $is_post = FALSE )
{
	$res = get_var( $name, $is_post );
	
	return NULL != $res ? $res : $default;
}

function get_post_def( $name, $default )
{
	return get_var_def( $name, $default, TRUE );
}

function getlocale( $category = LC_ALL )
{
	return setlocale( $category, NULL );
}

function simple_mail( $from, $to, $subject, $msg, $reply_to = '' )
{
	if ( '' == $to ) { return; }

	CI()->load->library('email');
	CI()->email->from( $from );
	CI()->email->to($to); 
	CI()->email->subject($subject);
	CI()->email->message($msg);
	
	if ( '' != $reply_to )
	{
		CI()->email->reply_to( $reply_to );
	}
	
	CI()->email->send();
}

function rand_string( $length, $charset = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789' )
{
	$str	= '';
	$count	= strlen($charset);
	
	while ($length--)
	{
		$str .= $charset[ mt_rand( 0, $count - 1 ) ];
	}
	
	return $str;
}

function str_starts_with( $start, $str )
{
	$pos = -1;
	$start_size = strlen( $start );
	if ( strlen( $str ) >= $start_size )
	{
		for ( $i = 0; $i < $start_size; $i++ )
		{
			if ( $start[$i] == $str[$i] )
			{
				$pos = $i;
			} else {
				$pos = -1;
				break;
			}
		}
	}

	return $pos;
}

function str_ends_with( $haystack, $needle )
{
	return $needle === "" || ( ( $temp = strlen( $haystack ) - strlen( $needle ) ) >= 0 && strpos( $haystack, $needle, $temp ) !== false );
}

function object_to_array($Class)
{
	# Typecast to (array) automatically converts stdClass -> array.
	$Class = (array)$Class;
	
	# Iterate through the former properties looking for any stdClass properties.
	# Recursively apply (array).
	foreach($Class as $key => $value)
	{
		if(is_object($value)&&get_class($value)==='stdClass')
		{
			$Class[$key] = object_to_array($value);
		}
	}
	return $Class;
}

# Convert an Array to stdClass.
function array_to_object(array $array)
{
	# Iterate through our array looking for array values.
	# If found recurvisely call itself.
	foreach($array as $key => $value)
	{
		if(is_array($value))
		{
			$array[$key] = array_to_object($value);
		}
	}
	
	# Typecast to (object) will automatically convert array -> stdClass
	return (object)$array;
}

/**
* Handles multidimentional array sorting by a key (not recursive)
*
* @author Oliwier Ptak <aleczapka at gmx dot net>
*/
class array_sorter
{
	var $skey = false;
	var $sarray = false;
	var $sasc = true;

	/**
	* Constructor
	*
	* @access public
	* @param mixed $array array to sort
	* @param string $key array key to sort by
	* @param boolean $asc sort order (ascending or descending)
	*/
	function __construct(&$array, $key, $asc=true)
	{
		$this->sarray = $array;
		$this->skey = $key;
		$this->sasc = $asc;
	}

	/**
	* Sort method
	*
	* @access public
	* @param boolean $remap if true reindex the array to rewrite indexes
	*/
	function sortit($remap=true)
	{
		$array = &$this->sarray;
		uksort($array, array($this, "_as_cmp"));
		if ($remap)
		{
			$tmp = array();
			while (list($id, $data) = each($array))
				$tmp[] = $data;
			return $tmp;
		}
		return $array;
	}

	/**
	* Custom sort function
	*
	* @access private
	* @param mixed $a an array entry
	* @param mixed $b an array entry
	*/
	function _as_cmp($a, $b)
	{
		//since uksort will pass here only indexes get real values from our array
		if (!is_array($a) && !is_array($b))
		{
			$a = $this->sarray[$a][$this->skey];
			$b = $this->sarray[$b][$this->skey];
		}

		//if string - use string comparision
		if (!ctype_digit($a) && !ctype_digit($b))
		{
			if ($this->sasc)
				return strcasecmp($a, $b);
			else 
				return strcasecmp($b, $a);
		}
		else
		{
			if (intval($a) == intval($b)) 
				return 0;

			if ($this->sasc)
				return (intval($a) > intval($b)) ? -1 : 1;
			else
				return (intval($a) > intval($b)) ? 1 : -1;
		}
	}
}//end of class

function multi_sort(&$array, $key, $asc=true)
{
	$sorter = new array_sorter( $array, $key, $asc );
	return $sorter->sortit();
}

function format_date( $date )
{
	if ( !$date )	return null;

	$exp	= explode( ' ', $date );
	$dat	= explode( '/', $exp[0] );

	if ( count( $dat ) != 3 )
	{
		$dat = explode( '-', $exp[0] );
	}

	return $dat[2] . '-' . $dat[1] . '-' . $dat[0];
}

function unformat_date( $date )
{
	if ( !$date )	return null;

	$exp	= explode( ' ', $date );
	$dat	= explode( '-', $exp[0] );

	return $dat[2] . '/' . $dat[1] . '/' . $dat[0];
}

function format_date_time( $date )
{
	if ( !$date )	return null;

	
	$exp	= explode( ' ', $date );
	$dat	= explode( '/', $exp[0] );
	
	$rdat	= $dat[2] . '-' . $dat[1] . '-' . $dat[0];
	$rtim	= $exp[1] . ':00';
	
	return $rdat . ' ' . $rtim;
}

function is_mobile_browser()
{
	require_once(APPPATH.'third_party/Mobile_Detect.php');
	$detect = new Mobile_Detect;
	return $detect->isMobile();
}

function is_tablet_browser()
{
	require_once(APPPATH.'third_party/Mobile_Detect.php');
	$detect = new Mobile_Detect;
	return $detect->isTablet();
}

function price_to_float($s)
{
	// convert "," to "."
	$s = str_replace(',', '.', $s);

	// remove everything except numbers and dot "."
	$s = preg_replace("/[^0-9\.]/", "", $s);

	// remove all seperators from first part and keep the end
	$s = str_replace('.', '',substr($s, 0, -3)) . substr($s, -3);

	// return float
	return (float) $s;
}

function pp_date( $date )
{
	return strftime( '%Y-%m-%d %H:%M:%S', $date );
}

function pp_date_now()
{
	return pp_date( time() );
}

function add_date( $givendate, $day=0, $mth=0, $yr=0 )
{
	$cd = strtotime( $givendate );
	$newdate = date('Y-m-d H:i:s', mktime( date('H',$cd), date('i',$cd), date('s',$cd), date('m',$cd) + $mth, date('d',$cd) + $day, date('Y',$cd) + $yr ) );
	return $newdate;
}

function sub_date( $givendate, $day=0, $mth=0, $yr=0 )
{
	$cd = strtotime( $givendate );
	$newdate = date('Y-m-d H:i:s', mktime( date('H',$cd), date('i',$cd), date('s',$cd), date('m',$cd) - $mth, date('d',$cd) - $day, date('Y',$cd) - $yr ) );
	return $newdate;
}

function days_diff( $date_start, $date_end )
{
	return floor(($date_end - $date_start)/3600/24);
}

function uri_starts_with( $uri )
{
	return -1 != str_starts_with( $uri, $_SERVER['REQUEST_URI'] );
}

function trace_json( $arr )
{
	trace( json_enc( $arr ) );
}

function get_field_values_from_form( $fields, $form )
{
	$values = array();
	
	foreach ( $fields as $f )
	{
		array_push( $values, $form[ $f ] );
	}
	
	return $values;
}

function& CI()
{
	return get_instance();
}

function& db_get()
{
	return CI()->db;
}

function& load_model($model_name)
{
	$CI =& get_instance();
	$CI->load->model($model_name);
	return $CI->$model_name;
}

function load_helper($helper_name)
{
	$CI =& get_instance();
	$CI->load->helper($helper_name);
}

function& load_view( $view, $vars = array(), $return = FALSE )
{
	$CI =& get_instance();
	$CI->load->view( $view, $vars, $return );
	return $CI->$view;
}

function load_library($library = '', $params = NULL, $object_name = NULL)
{
	$CI =& get_instance();
	$CI->load->library( $library, $params, $object_name );
	return isset( $CI->$library ) ? $CI->$library : NULL;
}

function pipe_exec( $cmd, $async = FALSE, $input='' )
{
	$cmd  = $cmd . ( TRUE == $async ? ' > /dev/null 2>/dev/null &' : '' );
	$proc = proc_open($cmd, array(array('pipe', 'r'),
								  array('pipe', 'w'),
								  array('pipe', 'w')), $pipes);
	fwrite($pipes[0], $input);
	fclose($pipes[0]);

	$stdout = stream_get_contents($pipes[1]);
	fclose($pipes[1]);

	$stderr = stream_get_contents($pipes[2]);
	fclose($pipes[2]);

	$return_code = (int)proc_close($proc);

	return array($return_code, $stdout, $stderr);
}

function http_remove( $url )
{
	$disallowed = array('http://', 'https://');
	
	foreach( $disallowed as $d )
	{
		if( strpos($url, $d) === 0 )
		{
			return str_replace($d, '', $url);
		}
	}
	
	return $url;
}

function http_generate_get_post_string( $fields )
{
	$vars	= '';
	$sep	= '';
	
	if ( NULL != $fields && !empty( $fields ) )
	{
		foreach( $fields as $key=>$value )
		{
			if ( is_string( $key ) && is_string( $value ) )
			{
				$vars.= $sep . urlencode( $key ) . '=' . urlencode( $value );
				$sep  ='&';
			}
			else
			{
				trace( "key found as none-string: " );
				trace( json_enc( $key ) );
				trace( json_enc( $value ) );
			}
		}
	}
	
	return $vars;
}

function http_request_redirect( $to_host )
{
	$post 	= '';
	$host	= PAGE_PROTOCOL . http_remove( $to_host ) . $_SERVER['REQUEST_URI'];

	if ( isset( $_POST ) && !empty( $_POST ) )
	{
		$post	= http_generate_get_post_string( $_POST );
	}

	$cmd	= "curl --insecure --data \"$post\" $host";
	
	if ( '' != $cmd )
	{
		$res = pipe_exec( $cmd, TRUE );
	}
}

function http_request_redirect_cond( $to_host )
{
	if ( FALSE == DEBUG_SERVER )
	{
		http_request_redirect( $to_host );
	}
}

function csv_create_header( $filename )
{
	header('Pragma: public');
	header('Expires: Sat, 26 Jul 1997 05:00:00 GMT');
	header('Cache-Control: must-revalidate, post-check=0, pre-check=0, max-age=0');
	header('Content-Type: application/force-download');
	header('Content-Type: application/octet-stream', false);
	header('Content-Type: application/download', false);
	header('Content-Type: text/csv', false);
	header('Content-Disposition: attachment; filename="'.$filename.'.csv"');
	header('Content-Transfer-Encoding: binary');
}

function text_plain_create_header( $filename )
{
	header('Pragma: public');
	header('Expires: Sat, 26 Jul 1997 05:00:00 GMT');
	header('Cache-Control: must-revalidate, post-check=0, pre-check=0, max-age=0');
	header('Content-Type: application/force-download');
	header('Content-Type: application/octet-stream', false);
	header('Content-Type: application/download', false);
	header('Content-Type: text/plain', false);
	header('Content-Disposition: attachment; filename="'.$filename.'.txt"');
	header('Content-Transfer-Encoding: binary');
}

function pagination_config($extra_class="")
{
	$config							= array();
	$config['full_tag_open']		= '<div class="table_pager' . (""!=$extra_class?' '.$extra_class:'') . '">';
	$config['full_tag_close']		= '</div>';
	$config['num_links']			= 5;
	$config['per_page']				= defined('LIGHTWEIGHT_RESULTS') && TRUE == LIGHTWEIGHT_RESULTS ? 50 : 500;
	$config['use_page_numbers'] 	= TRUE;
	$config['anchor_class']			= 'class="ajax-link" ';
	$config['first_link']			= '&lt;&lt;';
	$config['first_tag_open']		= '<div class="first">';
	$config['first_tag_close']		= '</div>';
	$config['last_link']			= '&gt;&gt;';
	$config['last_tag_open']		= '<div class="last">';
	$config['last_tag_close']		= '</div>';
	$config['next_link']			= '&gt;';
	$config['next_tag_open']		= '<div class="next">';
	$config['next_tag_close']		= '</div>';
	$config['prev_link']			= '&lt;';
	$config['prev_tag_open']		= '<div class="prev">';
	$config['prev_tag_close']		= '</div>';
	$config['cur_tag_open']			= '<span>';
	$config['cur_tag_close']		= '</span>';
	$config['num_tag_open']			= '<div class="digit">';
	$config['num_tag_close']		= '</div>';
	$config['page_query_string']	= TRUE;
	$config['query_string_segment']	= 'page_num';
	return $config;
}

function http_build_query_merge( $query_strings )
{
	return http_build_query( array_merge( $_GET, $query_strings ) );
}

function http_build_query_current()
{
	return http_build_query( $_GET );
}

function http_build_query_pagination()
{
	$current = $_GET;
	
	if ( isset( $current['page_num'] ) )
	{
		unset( $current['page_num'] );
	}
	
	return http_build_query( $current );
}

function order_dir_invert()
{
	return array( 'order_dir' => ( strtoupper( get_var_def( 'order_dir', 'ASC' ) ) == 'ASC' ? 'DESC' : 'ASC' ) );
}

function http_build_query_merge_auto( $query_strings )
{
	return http_build_query_merge( array_merge( $query_strings, order_dir_invert() ) );
}

function root_path( $uri )
{
	return 'file://' . ROOTPATH . $uri;
}

function temp_files_delete_old( $interval = 3600 )
{
	if ( $handle = opendir( TMPPATH ) )
	{
		while ( false !== ( $file = readdir( $handle ) ) )
		{ 
			if ( 	!is_dir( $file ) && 
					( ( filemtime( TMPPATH . $file ) + $interval ) < time() ) && 
					( $file != '..' ) && 
					( $file != '.' ) && 
					( substr( $file, 0, 1 ) !== '.' ) && 
					( $file !='GIVE_RW_PERMISSIONS' )
			)
			{
				unlink( TMPPATH . $file ); 
			}
		}
		
		closedir( $handle );
	}
}

function pdf_create( $html, $filename='', $js_delay = 0 )
{
	temp_files_delete_old();
	
	$html_file	= TMPPATH . $filename . '.html';
	$pdf_file	= TMPPATH . $filename . '.pdf';
	$pdf_url	= '/tmp/' . $filename . '.pdf';
	
	if ( file_exists( $html_file ) )
	{
		unlink( $html_file );
	}
	
	if ( file_exists( $pdf_file ) )
	{
		unlink( $pdf_file );
	}
	
	$file		= fopen ( $html_file, 'w' );
	fputs( $file, $html );
	fclose( $file );
	
	pipe_exec( "wkhtmltopdf --javascript-delay $js_delay \"$html_file\" \"$pdf_file\"" );
	
	header('Location: ' . base_url( $pdf_url ) );
}

function http_header_json_no_cache()
{
	header('Cache-Control: no-cache, must-revalidate');
	header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
	header('Content-type: application/json; charset=utf-8');
}

function hex2rgb($hex)
{
	$hex = str_replace("#", "", $hex);

	if(strlen($hex) == 3)
	{
		$r = hexdec(substr($hex,0,1).substr($hex,0,1));
		$g = hexdec(substr($hex,1,1).substr($hex,1,1));
		$b = hexdec(substr($hex,2,1).substr($hex,2,1));
	}
	else
	{
		$r = hexdec(substr($hex,0,2));
		$g = hexdec(substr($hex,2,2));
		$b = hexdec(substr($hex,4,2));
	}
	
	return array($r, $g, $b);
}

function rgb2hex($rgb)
{
	$hex = "#";
	$hex .= str_pad(dechex($rgb[0]), 2, "0", STR_PAD_LEFT);
	$hex .= str_pad(dechex($rgb[1]), 2, "0", STR_PAD_LEFT);
	$hex .= str_pad(dechex($rgb[2]), 2, "0", STR_PAD_LEFT);

	return $hex;
}

function array_merge_recursive_distinct(array &$array1, array &$array2)
{
	$merged = $array1;

	foreach($array2 as $key => &$value)
	{
		if( is_array( $value ) && isset( $merged[$key] ) && is_array( $merged[$key] ) )
		{
			$merged[$key] = array_merge_recursive_distinct( $merged[$key], $value );
		}
		else
		{
			$merged[$key] = $value;
		}
	}

	return $merged;
}

function array_count_unique_subkey( array $array, $subkey )
{
	$count = array();
	
	if ( isset( $array ) && !empty( $array ) )
	{
		foreach ( $array as $subarray )
		{
			if ( array_key_exists( $subkey, $subarray ) )
			{
				$count[ $subarray[$subkey] ] = TRUE;
			}
		}
	}
	
	return count( $count );
}

function is_valid_domain_name($domain_name)
{
	return (preg_match("/^([a-z\d](-*[a-z\d])*)(\.([a-z\d](-*[a-z\d])*))*$/i", $domain_name) //valid chars check
			&& preg_match("/^.{1,253}$/", $domain_name) //overall length check
			&& preg_match("/^[^\.]{1,63}(\.[^\.]{1,63})*$/", $domain_name)   ); //length of each label
}

function unichr($u)
{
	return mb_convert_encoding('&#' . intval($u) . ';', 'UTF-8', 'HTML-ENTITIES');
}

function form_to_array( $form, $fields )
{
	$arr = array();
	
	$newlen = strlen( '_new' ); // 4, i know!
	
	foreach ( $form as $id=>$name )
	{
		$rid = 0;
		
		foreach( $fields as $af )
		{
			if ( 'id' != $af )
			{
				$tabbr = $af.'_id_';
				
				if ( -1 != str_starts_with( $tabbr, $id ) )
				{
					$val = substr( $id, strlen( $tabbr ) ); // Take the id of the field
					
					if ( FALSE != strpos( $id, 'new' ) )
					{
						// look if ends with new ( means that is not updating the data, is inserting it )
						$val = substr( $val, 0, strlen( $val ) - $newlen ); // take the temporal id of the field and remove the '_new' part
						
						$rid = -intval( $val ); // Assign as a negative number, this means that it will be inserted ( > 0 updated )
					}
					else
					{
						$rid = intval( $val );
					}
					
					$arr[$rid][$af] = $name;
				}
			}
		}
	}
	
	return $arr;
}

function array_remove_value( &$arr, $del_val )
{
	if ( ( $key = array_search( $del_val, $arr ) ) !== FALSE )
	{
		unset( $arr[$key] );
	}
}

function csv_output($data)
{
	if ( isset( $data ) )
	{
		$outputBuffer = fopen("php://output", 'w');
	
		foreach($data as $val)
		{
			fputcsv($outputBuffer, $val);
		}
		
		fclose($outputBuffer);
	}
}

function print_var_sel( $var_name, $var_val )
{
	return get_var($var_name)==$var_val?'selected':'';
}

function log_error( $message )
{
	log_message( 'error', $message );
}

function log_debug( $message )
{
	log_message( 'debug', $message );
}

function log_info( $message )
{
	log_message( 'info', $message );
}

function log_backtrace( $force = FALSE )
{
	if ( TRUE == config_item('log_error_print_backtrace') || $force )
	{
		log_message('error', 'Backtrace:' );
		
		$backtrace = debug_backtrace();
		
		if ( isset( $backtrace ) && !empty( $backtrace ) )
		{
			foreach ( $backtrace as $t )
			{
				if ( isset($t['file']) )
				{
					log_message('error', "file: " . $t['file'] . ":" . $t['line'] . " func: " . $t['function'] );
				}
				else
				{
					log_message('error', "file: ?:? func: " . $t['function'] );
				}
			}
		}
	}
}

function get_json_body()
{
	return json_decode( file_get_contents('php://input'), TRUE );
}

function get_real_post()
{
	$pairs = explode("&", file_get_contents("php://input"));
	$vars = array();
	
	foreach ($pairs as $pair)
	{
		$nv = explode("=", $pair);
		$name = urldecode($nv[0]);
		$value = urldecode($nv[1]);
		$vars[$name] = $value;
	}
	
	return $vars;
}

function is_get()
{
	return $_SERVER['REQUEST_METHOD'] == 'GET';
}

function is_post()
{
	return $_SERVER['REQUEST_METHOD'] == 'POST';
}

function is_put()
{
	return $_SERVER['REQUEST_METHOD'] == 'PUT';
}

function is_delete()
{
	return $_SERVER['REQUEST_METHOD'] == 'DELETE';
}

if (!function_exists('http_response_code')) {
	function http_response_code($code = NULL) {

		if ($code !== NULL) {

			switch ($code) {
				case 100: $text = 'Continue'; break;
				case 101: $text = 'Switching Protocols'; break;
				case 200: $text = 'OK'; break;
				case 201: $text = 'Created'; break;
				case 202: $text = 'Accepted'; break;
				case 203: $text = 'Non-Authoritative Information'; break;
				case 204: $text = 'No Content'; break;
				case 205: $text = 'Reset Content'; break;
				case 206: $text = 'Partial Content'; break;
				case 300: $text = 'Multiple Choices'; break;
				case 301: $text = 'Moved Permanently'; break;
				case 302: $text = 'Moved Temporarily'; break;
				case 303: $text = 'See Other'; break;
				case 304: $text = 'Not Modified'; break;
				case 305: $text = 'Use Proxy'; break;
				case 400: $text = 'Bad Request'; break;
				case 401: $text = 'Unauthorized'; break;
				case 402: $text = 'Payment Required'; break;
				case 403: $text = 'Forbidden'; break;
				case 404: $text = 'Not Found'; break;
				case 405: $text = 'Method Not Allowed'; break;
				case 406: $text = 'Not Acceptable'; break;
				case 407: $text = 'Proxy Authentication Required'; break;
				case 408: $text = 'Request Time-out'; break;
				case 409: $text = 'Conflict'; break;
				case 410: $text = 'Gone'; break;
				case 411: $text = 'Length Required'; break;
				case 412: $text = 'Precondition Failed'; break;
				case 413: $text = 'Request Entity Too Large'; break;
				case 414: $text = 'Request-URI Too Large'; break;
				case 415: $text = 'Unsupported Media Type'; break;
				case 500: $text = 'Internal Server Error'; break;
				case 501: $text = 'Not Implemented'; break;
				case 502: $text = 'Bad Gateway'; break;
				case 503: $text = 'Service Unavailable'; break;
				case 504: $text = 'Gateway Time-out'; break;
				case 505: $text = 'HTTP Version not supported'; break;
				default:
					exit('Unknown http status code "' . htmlentities($code) . '"');
				break;
			}

			$protocol = (isset($_SERVER['SERVER_PROTOCOL']) ? $_SERVER['SERVER_PROTOCOL'] : 'HTTP/1.0');

			header($protocol . ' ' . $code . ' ' . $text);

			$GLOBALS['http_response_code'] = $code;

		} else {

			$code = (isset($GLOBALS['http_response_code']) ? $GLOBALS['http_response_code'] : 200);

		}

		return $code;
	}
}

function uri_is_valid( $valid_uris )
{
	$cur_uri = uri_string();
	
	foreach ( $valid_uris as $uri=>$full_path )
	{
		if ( $full_path )
		{
			if ( $uri == $cur_uri )
			{
				return TRUE;
			}
		}
		else
		{
			if ( -1 != str_starts_with( $uri, $cur_uri ) )
			{
				return TRUE;
			}
		}
	}
	
	return FALSE;
}

function is_numeric_integer( $val )
{
    return ctype_digit( strval( $val ) );
}

function is_numeric_integer_array( $arr )
{
	if ( is_array( $arr ) )
	{
		foreach ( $arr as $val )
		{
			if ( !is_numeric_integer( $val ) )
			{
				return FALSE;
			}
		}
		
		return TRUE;
	}
	else
	{
		return is_numeric_integer( $arr );
	}
}

function is_numeric_integer_string_explode( $str, $delimiter = ',' )
{
	return is_numeric_integer_array( explode( $delimiter, $str ) );
}

function hexdec_bigint( $hex )
{
	$dec = 0;
	$len = strlen($hex);
	
	for ($i = 1; $i <= $len; $i++)
	{
		$dec = bcadd($dec, bcmul(strval(hexdec($hex[$i - 1])), bcpow('16', strval($len - $i))));
	}
	
	return $dec;
}

function dechex_bigint( $dec )
{
	return base_convert($dec, 10, 16);
}

function csv_string_sanitize( &$val )
{
	$val = str_replace( array("\r\n", "\n", '"'), '', $val );
}

function csv_array_sanitize( &$arr )
{
	if ( is_array( $arr ) )
	{
		foreach ( $arr as &$row )
		{
			csv_string_sanitize( $row );
		}
	}
}

function byte_array_to_hexa( $barray )
{
	$str = '';
	
	if ( is_array( $barray ) )
	{
		foreach ( $barray as $b )
		{
			$str .= str_pad( dechex( $b ), 2, '0', STR_PAD_LEFT );
		}
	}
	
	return $str;
}