<?php 
define('T_MAN',0);
define('T_TAR',1);
define('T_NOC',2);
define('T_INTERVAL_MIN',30);
define('T_DEF_FIRST',0);
define('T_DEF_LAST',1);

class HoursSlot
{
	public static $DAYS		= array('lun' => 'Lunes','mar' => 'Martes','mie' => 'Miércoles','jue' => 'Jueves','vie' => 'Viernes','sab' => 'Sábado','dom' => 'Domingo');
	public static $TURNS	= array('man'=>'Mañana','tar'=>'Tarde','noc'=>'Noche');
	
	public static function pad_time( $h, $m )
	{
		return str_pad($h,2,'0',STR_PAD_LEFT).":".str_pad($m,2,'0',STR_PAD_LEFT);
	}
	
	public static function make_select( $hours_data, $class, $name, $s,$e,$c,$default = T_DEF_FIRST )
	{
		$opt = '';
		$sel = false;
		
		for($i=0;$i<$c+1;$i++)
		{
			$h = ($i+$s)%24;
			for($j=0;$j<60;$j+=T_INTERVAL_MIN)
			{
				$m=$j;
				$timestr = self::pad_time($h,$m);
				$selected = '';

				if(!$sel)
				{
					if( isset($hours_data[$name]) )
					{
						if ( $timestr == $hours_data[$name] )//selected from db
						{
							$selected = 'selected="selected"';
							$sel = true;
						}
					}
				}

				$opt .= "\n\t\t\t\t".'<option '.$selected.'>'.$timestr.'</option>';

				if($i==$c)
				{
					break;
				}
			}
		}
		
		$opt = "\n\t\t\t\t<option " . ( $sel ? 'selected="selected"' : '' ) . '></option>' . $opt;
		
		return "\n\t\t\t".'<select name="'.$name.'" class="'.$class.'">'.$opt."\n\t\t\t".'</select>'."\n";
	}
	
	public static function turn2str( $turn_type )
	{
		switch($turn_type)
		{
			case T_MAN: return 'man';
			case T_TAR: return 'tar';
			case T_NOC: return 'noc';
		}
	}
	
	public static function cb( $turn_type, $day, $hours_table = null )
	{
		$s = 0;
		$e = 0;
		
		switch($turn_type)
		{
			case T_MAN: $s = 0; $e = 12; break;
			
			case T_TAR: $s = 12; $e = 18; break;
			
			case T_NOC: $s = 18; $e = 24; break;
			
			default:
				die('ERROR, unknown type');
		}
		
		$c = $e - $s;
		
		if($c<0)
		{
			$c += 24;
		}
		
		$classbase = 'cb_turn_'.self::turn2str($turn_type).' cb_day_'.$day;
		$class1 = $classbase.' cb_ini';
		$class2 = $classbase.' cb_fin' . ' separate_day';
		
		$name1 = 'hours_'.self::turn2str($turn_type).'_'.$day.'_ini';
		$name2 = 'hours_'.self::turn2str($turn_type).'_'.$day.'_fin';
		
		return	"\n\n<td>".self::make_select($hours_table, $class1, $name1, $s,$e,$c,T_DEF_FIRST).
				"</td>\n\t\t<td>".self::make_select($hours_table, $class2, $name2, $s,$e,$c,T_DEF_LAST)."</td>\n";
	}
	
	public static function turn_from_hour( $hour, $ini )
	{
		$h = intval( substr( $hour, 0, 2 ) );
		
		if ( $ini )
		{
			if ( $h >= 0 && $h < 12 )
			{
				return 'man';
			}
			else if( $h >= 12 && $h < 18 )
			{
				return 'tar';
			}
			else
			{
				return 'noc';
			}
		}
		else
		{
			if ( $h >= 0 && $h <= 12 )
			{
				return 'man';
			}
			else if ( $h > 12 && $h <= 18 )
			{
				return 'tar';
			}
			else
			{
				return 'noc';
			}
		}
	}
}
