<?php

function day2str($turn_type)
{
	switch($turn_type)
	{
		case 0: return 'dom';
		case 1: return 'lun';
		case 2: return 'mar';
		case 3: return 'mie';
		case 4: return 'jue';
		case 5: return 'vie';
		case 6: return 'sab';
	}
}

function mon2str($mon_num)
{
	switch($mon_num)
	{
		case 1: return 'Enero';
		case 2: return 'Febrero';
		case 3: return 'Marzo';
		case 4: return 'Abril';
		case 5: return 'Mayo';
		case 6: return 'Junio';
		case 7: return 'Julio';
		case 8: return 'Agosto';
		case 9: return 'Septiembre';
		case 10: return 'Octubre';
		case 11: return 'Noviembre';
		case 12: return 'Diciembre';
		default: return '';
	}
}

function get_icons_array()
{
	return array( 
		'Interior' => 'INTERIOR',
		'Exterior con filtro a más de 10m de alt.' => 'EXTERIOR_HIGH_FILTERED',
		'Exterior sin filtro a más de 10m de alt.' => 'EXTERIOR_HIGH',
		'Exterior a menos de 10m de alt.' => 'EXTERIOR_GROUND',
		'Potencial Instalación Tipo 1' => 'INST_TYPE_1',
		'Potencial Instalación Tipo 2' => 'INST_TYPE_2',
		'Central de Monitoreo' => 'MONITORING_CENTRAL'
	);
}

function get_vehicles_array()
{
	return array(
		'Auto' => 'CAR',
		'Camión' => 'TRUCK',
		'Moto' => 'BIKE',
		'Avión' => 'PLANE'
	);
}

function get_vehicle_name( $type )
{
	return array_search( $type, get_vehicles_array() );
}

function get_fake_hw_types()
{
	return array(
		'Azul' => '0',
		'Fucsia' => '1'
	);
}

function get_fake_hw_type_name( $type_num )
{
	switch ( $type_num )
	{
		case 1:		return 'FUCSIA';
		case 0:
		default:	return 'AZUL';
	}
}

function get_icon_name( $type )
{
	return array_search( $type, get_icons_array() );
}

function get_fleet_type( $type_num )
{
	switch ( $type_num )
	{
		case 0: return 'Corta Distancia';
		case 1: return 'Media Distancia';
		case 2: return 'Larga Distancia';
	}
}

function get_last_hour_times( &$start, &$end )
{
	$end		= time() - 3600;
	$start		= $end - 3600;	
}

function get_timestamp_from_date_time( $to_date_get )
{
	if ( $to_date_get )
	{
		if ( !defined( 'USE_POSTGRES') )
		{
			$db = db_get();
			
			//i use mysql to convert since php doesn't seem to have a function that do this properly to 5.3+
			
			$db->set_qd( array( $to_date_get ) );
			
			$to_date		= $db->get_var("SELECT UNIX_TIMESTAMP(STR_TO_DATE(?, '%d/%m/%Y %H:%i'))");
		}
		else
		{
			$to_date		= strtotime( format_date_time( $to_date_get ) );
		}
		
		return $to_date;
	}
	
	return null;
}

function get_timestamp_from_date( $to_date_get )
{
	if ( $to_date_get )
	{
		return strtotime( format_date( $to_date_get ) );
	}
	
	return null;
}

function User()
{
	return DomoUser::$instance;
}

function get_password_hash( $pass )
{
	return hash( 'sha256', $pass );
}

function gen_sec_code_from_data( $uid, $name, $type )
{
	return get_password_hash( 'domo_' . $uid . '.' . $name . '.' . $type . ':mudita^uppekha' );
}

function generate_debt_mail( $user, $receipt, $company )
{
	$startdate	= unformat_date( $receipt->re_date );
	$enddate	= unformat_date( add_date( $receipt->re_date, 30 ) );
	$freq		= $user->ui_payfreq == 1 ? 'un mes' : $user->ui_payfreq . ' meses';
	$debt		= abs( $user->ui_balance );
	$msg		="Estimado " . $user->ui_lastname . " " . $user->ui_name . ",

Este es un recordatorio de que su comprobante de servicio fue generado el $startdate se vencerá el $enddate

Método de pago: Cuota cada $freq por un importe total de $" . $user->ui_price . "


Monto adeudado: $" . $debt . "
Fecha de vencimiento: $enddate

Lo saluda cordialmente,

" . $company->com_name;

	return $msg;
}

function validate_icon( &$icon )
{
	static $v_icon = array( 'INTERIOR','EXTERIOR_HIGH_FILTERED','EXTERIOR_HIGH','EXTERIOR_GROUND','INST_TYPE_1','INST_TYPE_2','MONITORING_CENTRAL' );
	
	if ( isset( $icon ) && '' != $icon )
	{
		$icon = strtoupper( $icon );
		
		if ( in_array( $icon, $v_icon ) )
		{
			return ''; // return the same as validate fields
		}
		else
		{
			return "&Iacute;cono no reconocido, ingres&oacute: $icon pero debe ser uno de los siguientes: 'INTERIOR','EXTERIOR_HIGH_FILTERED','EXTERIOR_HIGH','EXTERIOR_GROUND','INST_TYPE_1','INST_TYPE_2','MONITORING_CENTRAL'";
		}
	}
	
	$icon = $v_icon[0];
	
	return '';
}

function get_geotrace_events()
{
	return array(
		1 => 'SOS Activa',
		9 => 'SOS Inactiva',
		17 => 'Batería Baja',
		18 => 'Alimentación Externa Baja',
		19 => 'Alerta de Velocidad',
		22 => 'Alimentación Externa ON',
		23 => 'Alimentación Externa OFF',
		24 => 'GPS Fix',
		25 => 'GPS No Fix',
		31 => 'Heartbeat',
		32 => 'Cambio de Rumbo',
		33 => 'Distancia',
		34 => 'Posición Actual',
		35 => 'Tiempo',
		144 => 'Encendido',
		145 => 'Apagado',
		146 => 'En Movimiento',
		147 => 'Detenido'
	);
}

function short_to_string( $short )
{
	$str = (string) ( unichr( ( $short >> 8 ) & 0xFF ) . unichr( ( $short >> 0 ) & 0xFF ) );
	
	if ( strlen( $str ) == 2 )
	{
		return $str;
	}
	
	return str_pad( dechex( $short ), 4, '0', STR_PAD_LEFT );
}

function string_to_short( $str )
{
	if ( strlen( $str ) == 1 )
	{
		return ( ord( $str[0] ) << 0 );
	}
	
	return ( ord( $str[0] ) << 8 ) | ( ord( $str[1] ) << 0 );
}

function console_time( $timestamp = null )
{
	return strftime( "%d/%m %H:%M:%S", null == $timestamp ? time() : $timestamp );
}

function airmesh_command_msg( $action, $mac, $timestamp, $state_type, $mode, $cmd, $data_count, $frame_data )
{
	$cmd =	str_pad( dechex( $timestamp ), 8, '0', STR_PAD_LEFT ) . ' ' . 
			str_pad( dechex( $mac ), 8, '0', STR_PAD_LEFT ) . ' ' . 
			str_pad( dechex( $state_type ), 2, '0', STR_PAD_LEFT ) . ' ' .
			str_pad( dechex( $mode ), 2, '0', STR_PAD_LEFT ) . ' ' . 
			$cmd . ' ' . 
			str_pad( dechex( $data_count ), 2, '0', STR_PAD_LEFT ) . ' ' . 
			$frame_data;
	
	$msg = $action . ': ' . $cmd . ' for MAC: ' . str_pad( dechex( $mac ), 8, '0', STR_PAD_LEFT );
	
	return $msg;
}

function citymesh_command_msg( $action, $mac, $timestamp, $code, $msg_type, $mode, $cmd, $val, $msg_type_val, $force, $checksum )
{
	$cmd =	str_pad( dechex( $timestamp ), 8, '0', STR_PAD_LEFT ) . ' ' . 
			str_pad( dechex( $mac ), 8, '0', STR_PAD_LEFT ) . ' ' . 
			str_pad( dechex( $code ), 4, '0', STR_PAD_LEFT ) . ' ' . 
			str_pad( dechex( $msg_type ), 2, '0', STR_PAD_LEFT ) . ' ' .
			dechex( $mode ) . ' ' . 
			str_pad( dechex( $cmd ), 3, '0', STR_PAD_LEFT ) . ' ' . 
			str_pad( dechex( $val ), 2, '0', STR_PAD_LEFT ) . ' ' . 
			str_pad( dechex( $msg_type_val ), 2, '0', STR_PAD_LEFT ) . ' ' . 
			dechex( $force ) . ' ' . 
			dechex( $checksum );
	
	$msg = $action . ': ' . $cmd . ' for MAC: ' . str_pad( dechex( $mac ), 8, '0', STR_PAD_LEFT );
	
	return $msg;
}

function http_request_redirect_all()
{
	if ( TRUE == MASTER_SERVER )
	{
		$api_key = get_var('api_key');
		
		// 101 || Santa Celina
		if ( 'cMLCdD0w' == $api_key || 'ziJW09cK' == $api_key )
		{
			//http_request_redirect( 'deitresargentina.no-ip.org' );
		}
	}
}

function is_dshield_path()
{
	return strstr( $_SERVER['REQUEST_URI'], 'dshield' );
}

function get_user()
{
	return DomoUser::$instance;
}

class CompanyUserType
{
	const NORMAL		= 0;
	const GUARD			= 1;
	const PROFESSIONAL	= 2;
	
	public static function get_types()
	{
		return array(
			0 => 'Normal',
			1 => 'Guardia',
			2 => 'Profesional a cargo de obra'
		);
	}
}

function report_prop( &$r, $prop1, $prop2 = NULL, $prop3 = NULL )
{
	if ( NULL != $prop3 && NULL != $prop2 )
	{
		if ( isset( $r->$prop1->$prop2->$prop3 ) )
		{
			return $r->$prop1->$prop2->$prop3;
		}
		else
		{
			return 'Sin datos';
		}
	}
	else if ( NULL != $prop2 )
	{
		if ( isset( $r->$prop1->$prop2 ) )
		{
			return $r->$prop1->$prop2;
		}
		else
		{
			return 'Sin datos';
		}
	}
	else
	{
		if ( isset( $r->$prop1 ) )
		{
			return $r->$prop1;
		}
		else
		{
			return 'Sin datos';
		}
	}
}
