<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

require_once( LIBSPATH . 'domouser.php' );

class PAGE_Controller extends MY_Controller
{
	protected $sess					= NULL;
	protected $user					= NULL;

	function __construct()
	{
		parent::__construct();

		$this->load->library('session');

		$this->session_recover();
	}
	
	protected function auto_add()
	{
		parent::auto_add();
	
		$this->add_scrollto();
		$this->add_graphs();
		$this->add_maps();
		$this->add_jqueryui();
		$this->add_alertify();
		$this->add_jqueryupload();
		$this->add_pace();
		$this->add_mcustomscrollbar();
		$this->add_contextmenu();
		$this->add_webcamjs();
		$this->add_imagesloaded();
		$this->add_chartsjs();
		$this->add_rwdimagemaps();
		$this->add_filesaver();
		$this->add_safeform();
	}

	protected function add_frame_view( $content_view, $data = array(), $show_header = TRUE, $show_footer = TRUE, $return = FALSE )
	{
		if ( $this->is_kajax_request() )
		{
			if ( !$return )
			{
				$this->load->view($content_view, $data);
			}
			else
			{
				return $this->load->view($content_view, $data, TRUE );
			}
		}
		else
		{
			$frame_data					= array();
			$frame_data['content']		= $this->load->view($content_view, $data, true);
			$frame_data['css']			= $this->render_ext_css() . $this->render_css();
			$frame_data['js']			= $this->render_ext_js() . $this->render_js(); //external js first, usuarlly local js depend on those
			$frame_data['og']			= $this->render_og();
			$hfdata['global_user_name'] = NULL != $this->user ? $this->user->get_fullname() : '';
			
			if ( $show_header )
			{
				$frame_data['header']	= $this->load->view('/frame/header', $hfdata, TRUE);
			}
			
			if ( $show_footer )
			{
				$frame_data['footer']	= $this->load->view('/frame/footer', $hfdata, TRUE);
			}
			
			$frame_data['data']			= $data;
			
			if ( !$return )
			{
				$this->load->view('/frame/frame', $frame_data );
			}
			else
			{
				return $this->load->view('/frame/frame', $frame_data, TRUE );
			}
		}
	}

	protected function session_create( $user_id, $username, $user_type, $remember_me = FALSE )
	{
		if ( !$remember_me )
		{
			$this->session->sess_expire_on_close = TRUE;
			$this->session->sess_update();
		}
		
		$username	= strtolower( $username );
		
		$data = array(
			'session_uid'		=> $user_id,
			'session_cuid'		=> $user_id,
			'session_name'		=> $username,
			'session_secu'		=> gen_sec_code_from_data( $user_id, $username, $user_type ),
			'session_remember'	=> $remember_me
		);
		
		$this->session->set_userdata( $data );
	}
	
	protected function session_exists()
	{
		return isset( $this->sess ) && isset( $this->sess['session_uid'] );
	}
	
	protected function session_restricted()
	{
		if ( $this->is_kajax_request() )
		{
			echo 'ACCESO RESTRINGIDO';
			exit;
		}
		else
		{
			redirect(base_url('/'));
		}
	}
	
	protected function session_restrict( $level )
	{
		$this->load->helper('url');
		
		if ( !$this->session_exists() )
		{
			redirect(base_url('/?referer=') . $_SERVER['REQUEST_URI'] );
		}
		else
		{
			if ( $this->user->get_real_type() < $level )
			{
				$this->session_restricted();
			}
			else if ( $this->user->is_professional() )
			{
				$valid_urls = array( 
					'person' => FALSE, 
					'dshield/person' => FALSE, 
					'dshield' => TRUE, 
					'user' => TRUE, 
					'user/logout' => TRUE, 
					'user/config' => TRUE, 
					'user/save' => TRUE, 
					'user/jobs' => TRUE,
					'rfid/pair' => FALSE,
					'rfid/jobs' => TRUE
				);
				
				$this->load->model('RfidUser_model');
				
				if ( !$this->RfidUser_model->exists_uid(  $this->user->get_user_id() ) )
				{
					echo "La cuenta profesional debe pertenecer a una persona registrada en el sistema.";
					exit;
				}
				
				if ( !uri_is_valid( $valid_urls ) )
				{
					$this->session_restricted();
				}
			}
		}
	}
	
	protected function session_recover()
	{
		$this->sess = $this->session->all_userdata();
		
		if ( $this->session_exists() && ( !isset( $this->sess['session_remember'] ) || !$this->sess['session_remember'] ) )
		{
			$this->session->sess_expire_on_close = TRUE;
			$this->session->sess_update();
		}
					
		if ( $this->user_id() > 0 )
		{
			$this->user_recover();
		}
	}
	
	protected function user_recover()
	{
		$this->load->library( 'DomoUser', array( 'uid' => $this->user_id(), 'session' => $this->sess ) );
		
		$this->user = DomoUser::$instance;
	}
	
	protected function session_destroy()
	{
		$this->session->sess_destroy();
	}

	protected function sess()
	{
		return $this->sess;
	}
	
	protected function user_id()
	{
		if ( $this->session_exists() )
		{
			return $this->sess['session_cuid'];
		}
		
		return 0;
	}
	
	protected function add_maps()
	{
		$this->add_js( 'assets/js/map.js', FALSE == DEBUG );
		
		if ( FALSE == OFFLINE_SERVER )
		{
			$this->add_ext_js('https://maps.googleapis.com/maps/api/js?libraries=drawing');
		}
	}
	
	protected function add_graphs()
	{
		if ( FALSE == OFFLINE_SERVER )
		{
			$this->add_ext_js('https://www.google.com/jsapi');
		}
	}
	
	protected function add_canvg()
	{
		$this->add_js( 'assets/libs/canvg/canvg-1.0.js' );
		$this->add_js( 'assets/libs/canvg/rgbcolor.js' );
	}
	
	protected function add_jqueryui()
	{
		$this->add_css( 'assets/libs/jquery-ui/jquery-ui.min.css' );
		$this->add_js( 'assets/libs/jquery-ui/jquery-ui.min.js' );
		$this->add_js( 'assets/libs/jquery-ui/jquery-ui-timepicker-addon.min.js' );
		$this->add_js( 'assets/libs/jquery-ui/jquery-ui-timepicker-es.js' );
	}
	
	protected function add_alertify()
	{
		$this->add_css( 'assets/libs/alertify.js/alertify.core.css' );
		$this->add_css( 'assets/libs/alertify.js/alertify.default.css' );
		$this->add_js( 'assets/libs/alertify.js/alertify.min.js' );
	}
	
	protected function add_scrollto()
	{
		$this->add_js( 'assets/libs/jquery-scrollTo/jquery.scrollTo.min.js' );
	}
	
	protected function add_jqueryupload()
	{
		$this->add_js('assets/libs/jquery-upload/jquery.fileupload.min.js');
		$this->add_css('assets/libs/jquery-upload/jquery.fileupload.css');
	}
	
	protected function add_pace()
	{
		$this->add_js('assets/libs/pace/pace.min.js');
		$this->add_css('assets/libs/pace/pace.css');
	}
	
	protected function add_mcustomscrollbar()
	{
		$this->add_js('assets/libs/mcustomscrollbar/jquery.mCustomScrollbar.concat.min.js');
		$this->add_css('assets/libs/mcustomscrollbar/jquery.mCustomScrollbar.css');
	}
	
	protected function add_contextmenu()
	{
		if ( FALSE == OFFLINE_SERVER )
		{
			$this->add_js('assets/libs/contextmenu/ContextMenu.js');
		}
	}
	
	protected function add_webcamjs()
	{
		$this->add_js('assets/libs/webcamjs/webcam.min.js');
	}
	
	protected function add_imagesloaded()
	{
		$this->add_js('assets/libs/imagesloaded/imagesloaded.pkgd.min.js');
	}
	
	protected function add_chartsjs()
	{
		$this->add_js('assets/libs/chartsjs/Chart.bundle.min.js');
	}
	
	protected function add_rwdimagemaps()
	{
		$this->add_js('assets/libs/jquery-rwdImageMaps/jquery.rwdImageMaps.min.js');
	}
	
	protected function add_filesaver()
	{
		$this->add_js('assets/libs/filesaver/FileSaver.min.js');
	}
	
	protected function add_safeform()
	{
		$this->add_js('assets/libs/jquery.safeform/jquery.safeform.js');
	}
	
	protected function build_event_filters( $from_ref = NULL, $to_ref = NULL, $rve_id = NULL, $urfid_id = NULL )
	{
		$filter				= array(
			array(
				'field_name'	=>	'name',
				'filter_val'	=>	get_var( 'name' ),
				'filter_type'	=>	SQLFilterType::ILIKE
			),
			array(
				'field_name'	=>	'rve_id',
				'filter_val'	=>	$rve_id
			),
			array(
				'field_name'	=>	'urfid_name',
				'filter_val'	=>	get_var( 'urfid_name' ),
				'filter_type'	=>	SQLFilterType::ILIKE
			),
			array(
				'field_name'	=>	'urfid_dni',
				'filter_val'	=>	get_var( 'urfid_dni' ),
				'field_type'	=> SQLFieldType::INT
			),
			array(
				'field_name'	=>	'parent_urfid_id',
				'filter_val'	=>	$urfid_id != NULL ? $urfid_id : get_var( 'urfid_id' ),
				'field_type'	=>	SQLFieldType::INT
			),
			array(
				'field_name'	=>	'time_end',
				'filter_val'	=>	NULL != $to_ref ? get_timestamp_from_date_time( $to_ref ) : time() + 3600,
				'filter_type'	=>	SQLFilterType::BIGGER_OR_EQ
			),
			array(
				'order_by'		=>	get_var_def( 'order_by', 'time_start' ),
				'order_fields'	=>	array( 'urfid_id', 'urfid_name', 'name', 'urfid_dni', 'urfid_plate', 'time_start', 'time_end', 'urfid_plot' ),
				'order_dir'		=>	get_var_def( 'order_dir', 'ASC' )
			)
		);
		
		return SQL::build_query_filter( $filter );
	}
	
	protected function build_family_filter( $urfid_id, $plots, $user_type = NULL )
	{
		$user_type			= NULL == $user_type ? array( RfIdUserType::NEIGHBOR, RfidUserType::OWNER ) : $user_type;
		
		$filter				= array(
			array(
				'field_name'	=>	'urfid_id',
				'filter_val'	=>	$urfid_id,
				'filter_type'	=>	SQLFilterType::UNEQUALS
			),
			array(
				'field_name'	=>	'rup_plot',
				'filter_val'	=>	$plots
			),
			array(
				'field_name'	=>	'urfid_user_type',
				'filter_val'	=>	$user_type
			),
			array(
				'order_by'		=>	get_var_def( 'order_by', 'urfid_name' ),
				'order_fields'	=>	array( 'urfid_name' ),
				'order_dir'		=>	get_var_def( 'order_dir', 'ASC' )
			),
			array(
				'join'			=>	'rfid_user_plot',
				'on'			=>	'urfid_id = rup_urfid_id',
				'type'			=>	'LEFT'
			)
		);
		
		return SQL::build_query_filter( $filter );
	}
	
	protected function user_index()
	{
		$this->load->model( 'Hardware_model' );		
		$this->load->model( 'GlobalEvent_model' );
		$this->load->model( 'Location_model' );
		
		$vehicles = $vehicles_data = $keys = null;
		$hws = $this->Hardware_model->get_from_user( $this->user->get_type_id() );
		
		if ( is_dshield_path() )
		{
			$this->load->model( 'Keychain_model' );
			$this->load->model( 'AvlHardware_model' );
			
			$keys = $this->Keychain_model->get_from_user( $this->user->get_id() );
			
			if ( $this->user->is_logged_as_user() )
			{
				$uid			= $this->user_id();
			}
			
			$filter_company		= $this->user->get_company() > 0 ? $this->user->get_company() : NULL;
			$vehicles			= $this->AvlHardware_model->get_all_for_map( $filter_company, $this->build_vehicles_filter(), NULL, $uid, 'af_name, ' );
			$vehicles_data		= json_encode( $vehicles );
		}
		
		$hards = array();

		if ( isset( $hws ) )
		{
			$i = 0;
			
			foreach( $hws as $hw )
			{
				$hards[$i]["hw"]		= $hw;
				$hards[$i]["actions"]	= Actions::get_last_states( $hw['hw_id'] );
				$signal					= HW_Stats::createtestdata_hw( $hw['hw_id'] );
				$rsignal				= "dead";
				$rsignal_txt			= "Sin Señal";
				
				if		( 1 == $signal["low"] )			{	$rsignal	= "low";		$rsignal_txt = "Señal Baja";		}
				else if	( 1 == $signal["good"] )		{	$rsignal	= "good";		$rsignal_txt = "Señal Buena";		}
				else if	( 1 == $signal["excellent"] )	{	$rsignal	= "excellent";	$rsignal_txt = "Señal Excelente";	}
				
				$hards[$i]["signal"]	= $rsignal;
				$hards[$i]["signal_txt"]= $rsignal_txt;
				$hards[$i]['city']		= $this->Location_model->get_fullname( $hw['hw_city'] );
				$hards[$i]["events"]	= $this->GlobalEvent_model->get_lastest_events( $hw['hw_id'] );
				
				$i++;
			}
		}
		
		$data = array( 'fullname' => $this->user->get_fullname(), 'hws' => $hards, 'keys' => $keys, 'vehicles' => $vehicles, 'vehicles_data' => $vehicles_data );
		
		if ( $this->user->is_dshield_user() )
		{
			$this->load->library('pagination');
			$this->load->model('RfidUser_model');
			$this->load->model('RfidVisit_model');
			$this->load->model('RfidUserPlot_model');
			
			if ( -1 == str_starts_with( 'Filtrar', get_var('from') ) )
			{
				$data['from'] = $from_ref	= NULL != get_var('from') ? substr( get_var('from'), strlen( 'Desde el ' ) ) : NULL;
			}
			else
			{
				$data['from'] = $from_ref	= NULL;
			}
			
			if ( -1 == str_starts_with( 'Filtrar', get_var('to') ) )
			{
				$data['to']	= $to_ref		= NULL != get_var('to') ? substr( get_var('to'), strlen( 'Hasta el ' ) ) : NULL;
			}
			else
			{
				$data['to']	= $to_ref		= NULL;
			}
			
			if ( $data['to'] < $data['from'] )
			{
				$new_from		= $data['to'];
				$data['to']		= $data['from'];
				$data['from']	= $new_from;
			}
			
			$data['urfid_name']			= get_var( 'urfid_name' );
			$data['urfid_dni']			= get_var( 'urfid_dni' );
			$data['urfid_plot']			= get_var( 'urfid_plot' );
			
			$page						= get_var_def( 'page_num', 1 );
			$config						= pagination_config();
			$urfid_id					= NULL;
			
			$data['user'] = $person		= $this->RfidUser_model->get_by_uid( $this->user->get_id() );
			
			$plots = $this->RfidUserPlot_model->get_arr( $person['urfid_id'] );
			
			$is_owner_view = NULL != $plots && NULL != $person && ( $person['urfid_user_type'] == RfIdUserType::OWNER || $person['urfid_user_type'] == RfIdUserType::NEIGHBOR );
			
			if ( $is_owner_view )
			{
				$this->load->model('RfidGallery_model');
				
				$urfid_id		= $person['urfid_id'];
				$data['family'] = $this->RfidUser_model->get_all( $this->user->get_company_ids(), $this->build_family_filter( $person['urfid_id'], $plots ) );
				$data['workers'] = $this->RfidUser_model->get_all( $this->user->get_company_ids(), $this->build_family_filter( $person['urfid_id'], $plots, array( RfIdUserType::SERVICE, RfidUserType::PROFESSIONAL, RfidUserType::WORKER ) ) );
				$data['general_photos'] = $this->RfidGallery_model->get_gallery_photos( $urfid_id, RfidGalleryType::GENERAL );
			}
			
			$query_filter				= $this->build_event_filters( $from_ref, $to_ref, NULL, $urfid_id );
			$config['total_rows']		= $data['total_events']	= $this->RfidVisit_model->count( $this->user->get_company_ids(), $query_filter );
			$data['events']				= $events = $this->RfidVisit_model->get_all( $this->user->get_company_ids(), $query_filter, $config['per_page'], $page );
			$config['base_url']			= base_url( '/dshield/?' . http_build_query_pagination() );
			
			$data['is_owner_view']		= $is_owner_view;
			
			$this->pagination->initialize($config);
			
			$data['pagination']		= $this->pagination->create_links();
		}
		
		$this->add_frame_view( 'user_home', $data );
	}
}
