<?php

class MY_Input extends CI_Input
{
	/**
	 * Clean Keys
	 *
	 * This is a helper function. To prevent malicious users
	 * from trying to exploit keys we make sure that keys are
	 * only named with alpha-numeric text and a few other items.
	 * 
	 * Extended to allow: 
	 *      - '.' (dot), 
	 *      - '[' (open bracket),
	 *      - ']' (close bracket)
	 * 
	 * @access  private
	 * @param   string
	 * @return  string
	 */
	function _clean_input_keys($str)
	{
		if ( !preg_match( "/^[a-z0-9:_\/\(\)\,\.\[\]-]+$/i", $str ) )
		{/*
			$base_url = isset($_SERVER['HTTPS']) && strtolower($_SERVER['HTTPS']) !== 'off' ? 'https' : 'http';
			$base_url .= '://'. $_SERVER['HTTP_HOST'];
			$base_url .= $_SERVER['REQUEST_URI'];
			
			log_message('error', "_clean_input_keys failed to clean:\n$str");
			
			log_message('error', "request data from URL: " . $base_url );
			
			log_message('error', "POST DATA: " );
			
			if ( isset( $_POST ) && !empty( $_POST ) )
			{
				foreach ( $_POST as $d )
				{
					log_message('error', $d );
				}
			}
			
			log_message('error', "GET DATA: " );
			
			if ( isset( $_GET ) && !empty( $_GET ) )
			{
				foreach ( $_GET as $d )
				{
					log_message('error', $d );
				}
			}
			*/
			exit('Disallowed Key Characters.');
		}

		// Clean UTF-8 if supported
		if (UTF8_ENABLED === TRUE)
		{
			$str = $this->uni->clean_string($str);
		}

		return $str;
	}
}
