<?php  if (!defined('BASEPATH')) exit('No direct script access allowed');

require_once(APPPATH.'third_party/cacheable.php');
require_once(APPPATH.'third_party/jsmin.php');

class MY_Controller extends BASE_Controller
{
	public static $JS_CACHE			= FALSE; // TRUE = compact in one file and minify
	public static $JS_CACHE_LIBS	= FALSE; // Only cache files on the libs path
	public static $JS_USE_CACHED	= FALSE; // Loads the already cached site/libs
	public static $JS_PATH			= './';

	function __construct()
	{
		parent::__construct();
		
		ini_set( 'upload_max_filesize', '1024M' );
		ini_set( 'post_max_size', '1024M' );
		
		$this->load->library('kajax');
		
		// The release server should use only the cached libs
		if ( DEBUG_SERVER == FALSE )
		{
			self::$JS_CACHE			= FALSE;
			self::$JS_CACHE_LIBS	= TRUE;
			self::$JS_USE_CACHED	= TRUE;
		}
		
		// This should be loaded every time the repo is updated in the server
		$js_cache = get_var( 'build_js_cache' );
		
		if ( NULL != $js_cache && $js_cache == 'bodhisattva' )
		{
			self::$JS_CACHE			= TRUE;
			self::$JS_CACHE_LIBS	= TRUE;
			self::$JS_USE_CACHED	= FALSE;
		}
		
		$this->auto_add();
	}

	protected $a_css		= array();
	protected $a_ext_css	= array();
	protected $a_js			= array();
	protected $a_ext_js		= array();
	protected $a_og			= array();
	
	protected function clear_all()
	{
		$this->a_css		= array();
		$this->a_ext_css	= array();
		$this->a_js			= array();
		$this->a_ext_js		= array();
		$this->a_og			= array();
	}

	//override to avoid auto_add, or to add more files
	protected function auto_add()
	{
		$this->add_less('assets/css/style.less');
		
		$this->add_css('assets/sprites/img.css');
		
		$this->add_css('assets/css/global.css', FALSE == DEBUG );
		
		if ( is_tablet_browser() )
		{
			$this->add_css('assets/css/mobile.tablet.css', FALSE == DEBUG );
		}
		
		$this->add_js('assets/libs/jquery/jquery-1.10.2.min.js');
		
		if ( self::$JS_USE_CACHED )
		{
			$this->add_js('assets/cache/' . ( self::$JS_CACHE_LIBS ? 'libs' : 'site' ) . '.js');
		}
		
		$this->add_js('assets/js/modal_dialog.js', FALSE == DEBUG );
		
		$this->add_js('assets/js/local_storage.js', FALSE == DEBUG );
		
		$this->add_js('assets/js/kajax.js', FALSE == DEBUG );
		
		$this->add_js('assets/js/site.js', FALSE == DEBUG );
		
		$this->add_js('assets/js/dshield.js', FALSE == DEBUG );
		
		$this->add_js('assets/js/hw_config.js', FALSE == DEBUG );
	}

	protected static function get_file_hash($file)
	{
		$time_in = filemtime($file);
		return hash('md5',$time_in);
	}

	protected static function css_tag($curr_css, $file)
	{
		return $curr_css."\t".'<link rel="stylesheet" type="text/css" href="'.base_url($file).'" />'."\n";
	}

	protected static function ext_css_tag($curr_css, $file)
	{
		return $curr_css."\t".'<link rel="stylesheet" type="text/css" href="'.$file.'" />'."\n";
	}

	protected static function js_tag($curr_js, $file)
	{
		if ( self::$JS_CACHE_LIBS && strstr( $file, 'libs/' ) )
		{
			return $curr_js;
		}
		
		return $curr_js.'<script type="text/javascript" src="'.base_url($file).'"></script>'."\n";
	}

	protected static function ext_js_tag($curr_js, $file)
	{
		return $curr_js.'<script type="text/javascript" src="'.$file.'"></script>'."\n";
	}

	protected static function og_tag($curr_og, $metadata)
	{
		return $curr_og."\t".'<meta property="' . $metadata['property'] . '" content="' . $metadata['content']. '" />'."\n";
	}

	public function add_ext_js( $file )
	{
		$this->a_ext_js[] = $file;
	}

	public function add_ext_css( $file )
	{
		$this->a_ext_css[] = $file;
	}

	public function add_og( $property, $content )
	{
		$this->a_og[] = array( 'property' => $property, 'content' => $content );
	}

	public function add_less($file)
	{
		$this->load->library('less');
		$this->add_css($this->less->parse($file), false);
	}

	protected static function js_combine($curr_js, $file)
	{
		if ( !self::$JS_CACHE_LIBS || ( self::$JS_CACHE_LIBS && strstr( $file, 'libs/' ) ) )
		{
			$buf = file_get_contents( self::$JS_PATH . $file );
		
			if( !strstr( $file, 'min' ) )//not minified already
			{
				$buf = JSMin::minify( $buf );
			}
		
			return $curr_js . ' { '.$buf.' } ';
		}
		else
		{
			return $curr_js;
		}
	}

	protected function render_css()
	{
		return array_reduce($this->a_css,'MY_Controller::css_tag');	
	}

	protected function render_ext_css()
	{
		return array_reduce($this->a_ext_css,'MY_Controller::ext_css_tag');	
	}

	protected function render_js()
	{
		if(!self::$JS_CACHE||self::$JS_USE_CACHED)
		{
			return array_reduce($this->a_js,'MY_Controller::js_tag');
		}
		else
		{
			$all_js =  array_reduce($this->a_js,'MY_Controller::js_combine');
			$filepath = 'assets/cache/' . ( self::$JS_CACHE_LIBS ? 'libs' : 'site' ) . '.js';
			file_put_contents(self::$JS_PATH.$filepath, $all_js);
			$js_final = self::js_tag('', $filepath);
			return $js_final . array_reduce($this->a_js,'MY_Controller::js_tag');
		}
	}

	protected function render_ext_js()
	{
		return array_reduce($this->a_ext_js,'MY_Controller::ext_js_tag');
	}

	protected function render_og()
	{
		return array_reduce($this->a_og,'MY_Controller::og_tag');	
	}

	public function add_css($file, $add_version = true)
	{
		if ( !in_array( $file, $this->a_css ) )
		{
			if($add_version)
			{
				$file = Cacheable::addversion($file);
			}
			$this->a_css[] = $file;
		}
	}

	public function add_js($file, $add_version = true)
	{
		if ( self::$JS_USE_CACHED && !strstr( $file, 'cache/' ) )
		{
			if ( !self::$JS_CACHE_LIBS || ( self::$JS_CACHE_LIBS && strstr( $file, 'libs/' ) ) )
			{
				return;
			}
		}
		
		if ( !in_array( $file, $this->a_js ) )
		{
			if($add_version && !self::$JS_CACHE)
			{
				$file = Cacheable::addversion($file);
			}
			
			$this->a_js[] = $file;
		}
	}

	public function is_kajax_request()
	{
		return $this->input->is_ajax_request() && $this->input->post('kajax') == true;
	}
	
	public function redirect( $uri )
	{
		if ( $this->is_kajax_request() )
		{
			$this->kajax->redirect( $uri );
			$this->kajax->out(TRUE);
		}
		else
		{
			redirect( $uri );
		}
	}
	
	// Usage: callback_fval[type-req]
	protected function fval( $str, $type = 'any' )
	{
		$this->load->helper( array( 'form_validation' ) );
		
		$typeex	= explode( '-', $type );
		$req	= count( $typeex ) > 1 ? TRUE : FALSE;
		$vf		= validate_field( $str, $type, $req );
		
		return $vf;
	}
	
	protected function do_validation( $str, $function_name )
	{
		$vf	= $this->fval( $str, substr( $function_name, 4 ) );
		$this->form_validation->set_message( $function_name, '%s: ' . $vf );
		return '' == $vf;
	}
	
	public function val_any( $str )		{ return $this->do_validation( $str, __FUNCTION__ ); }
	public function val_min( $str )		{ return $this->do_validation( $str, __FUNCTION__ ); }
	public function val_num( $str )		{ return $this->do_validation( $str, __FUNCTION__ ); }
	public function val_alpha( $str )	{ return $this->do_validation( $str, __FUNCTION__ ); }
	public function val_address( $str )	{ return $this->do_validation( $str, __FUNCTION__ ); }
	public function val_alnum( $str )	{ return $this->do_validation( $str, __FUNCTION__ ); }
	public function val_alphanum( $str ){ return $this->do_validation( $str, __FUNCTION__ ); }
	public function val_email( $str )	{ return $this->do_validation( $str, __FUNCTION__ ); }
	public function val_web( $str )		{ return $this->do_validation( $str, __FUNCTION__ ); }
	public function val_url( $str )		{ return $this->do_validation( $str, __FUNCTION__ ); }
	public function val_date( $str )	{ return $this->do_validation( $str, __FUNCTION__ ); }
	public function val_phone( $str )	{ return $this->do_validation( $str, __FUNCTION__ ); }
	public function val_float( $str )	{ return $this->do_validation( $str, __FUNCTION__ ); }
	public function val_dni( $str )		{ return $this->do_validation( $str, __FUNCTION__ ); }
	public function val_select( $str )	{ return $this->do_validation( $str, __FUNCTION__ ); }
	public function val_textarea( $str ){ return $this->do_validation( $str, __FUNCTION__ ); }
	public function val_hour( $str )	{ return $this->do_validation( $str, __FUNCTION__ ); }
	public function val_hexa( $str )	{ return $this->do_validation( $str, __FUNCTION__ ); }
	public function val_hexa1( $str )	{ return $this->do_validation( $str, __FUNCTION__ ); }
	public function val_hexa2( $str )	{ return $this->do_validation( $str, __FUNCTION__ ); }
	public function val_hexa3( $str )	{ return $this->do_validation( $str, __FUNCTION__ ); }
	public function val_hexa4( $str )	{ return $this->do_validation( $str, __FUNCTION__ ); }
	
	public function val_ip( $str )
	{
		if ( isset( $str ) && !empty( $str ) )
		{
			if( filter_var( $ipdom[0], FILTER_VALIDATE_IP ) )
			{
				return TRUE;
			}
		}
		else
		{
			return TRUE;
		}
		
		$this->form_validation->set_message( __FUNCTION__, '%s: IP inválido.' );
		
		return FALSE;
	}
	
	public function val_version( $str )
	{
		if ( isset( $str ) && !empty( $str ) )
		{
			$vers = explode( '.', $str );
			
			if ( count( $vers ) == 2 )
			{
				if ( (string)intval($vers[0]) == $vers[0] && (string)intval($vers[1]) == $vers[1] )
				{
					return TRUE;
				}
			}
		}
		else
		{
			return TRUE;
		}
		
		$this->form_validation->set_message( __FUNCTION__, '%s: versión inválida.' );
		
		return FALSE;
	}

	public function val_analog_input( $str )
	{
		if ( isset( $str ) && !empty( $str ) )
		{
			$input = explode( ':', $str );
			
			if ( count( $input ) == 2 )
			{
				if ( (string)intval($input[0]) == $input[0] && (string)intval($input[1]) == $input[1] )
				{
					return TRUE;
				}
			}
		}
		else
		{
			return TRUE;
		}
		
		$this->form_validation->set_message( __FUNCTION__, '%s: entrada inválida.' );
		
		return FALSE;
	}

	public function val_ipdomport( $str )
	{
		if ( isset( $str ) && !empty( $str ) )
		{
			if ( $str == ':' || $str == ':0' )
			{
				return TRUE;
			}
			
			$ipdom = explode( ':', $str );
			
			if ( count( $ipdom ) == 2 )
			{
				if ( (string)intval($ipdom[1]) == $ipdom[1] )
				{
					if( filter_var( $ipdom[0], FILTER_VALIDATE_IP ) || is_valid_domain_name( $ipdom[0] ) )
					{
						return TRUE;
					}
				}
			}
		}
		else
		{
			return TRUE;
		}
		
		$this->form_validation->set_message( __FUNCTION__, '%s: IP o Dominio más Puerto inválidos.<br/>Formatos esperados:<br/>"ip:puerto" o<br/>"dominio.com:puerto"' );
		
		return FALSE;
	}
	
	public function val_gsm( $str )
	{
		$msg = '';
		$ok = TRUE;
		
		//internet.ctimovil.com.ar:gprs::reddomo.com.ar:4550:0
		
		if ( isset( $str ) && !empty( $str ) )
		{
			$d = explode( ':', $str );
			
			if ( count( $d ) == 6 )
			{
				if( !( filter_var( $d[0], FILTER_VALIDATE_IP ) || is_valid_domain_name( $d[0] ) ) )
				{
					$msg .= 'Dominio o IP ( ' . $d[0] . ' ) de APN inválido.<br/>'; $ok = FALSE;
				}
				
				if( !( filter_var( $d[3], FILTER_VALIDATE_IP ) || is_valid_domain_name( $d[3] ) ) )
				{
					$msg .= 'Dominio o IP ( ' . $d[3] . ' )  del servidor inválido.<br/>'; $ok = FALSE;
				}
				
				if ( (string)intval($d[4]) != $d[4] )
				{
					$msg .= 'Puerto del servidor debe ser un número entero.<br/>'; $ok = FALSE;
				}
				
				if ( intval( $d[5] ) != 0 && intval( $d[5] ) != 1 )
				{
					$msg .= 'es_tcp debe ser 0 o 1. ( indica si el equipo conecta por TCP )<br/>'; $ok = FALSE;
				}
			}
			else
			{
				$msg .= 'Número de argumentos inválido.<br/>'; $ok = FALSE;
			}
		}
		
		if ( FALSE == $ok )
		{
			$msg = '<br/>' . $msg . 'Formato esperado:<br/>apn_dominio_o_ip:apn_usuario:apn_clave:servidor_dominio_o_ip:servidor_puerto:es_tcp';
		}
		
		$this->form_validation->set_message( __FUNCTION__, '%s: ' . $msg );
		
		return $ok;
	}
	
	public function val_emails_or_phones( $str )
	{
		$this->form_validation->set_message( __FUNCTION__, '%s: ' . 'EMail/s o Teléfono/s inválido/s' );
		
		if ( '' != $str )
		{
			$data = explode( ',', $str );
			
			if ( isset( $data ) && !empty( $data ) )
			{
				foreach ( $data as $mop )
				{
					$phone		= str_replace( '+', '', $mop );
					$is_phone	= is_numeric($phone);
					
					if ( !( '' == $this->fval( $mop, 'email' ) || $is_phone ) )
					{
						return FALSE;
					}
				}
			}
		}
		
		return TRUE;
	}
	
	public function val_hexa1_list( $str )
	{
		$this->form_validation->set_message( __FUNCTION__, '%s: ' . 'EMail/s o Teléfono/s inválido/s' );
		
		if ( '' != $str )
		{
			$data = explode( ',', $str );
			
			if ( isset( $data ) && !empty( $data ) )
			{
				foreach ( $data as $mop )
				{
					$phone		= str_replace( '+', '', $mop );
					$is_phone	= is_numeric($phone);
					
					if ( !( '' == $this->fval( $mop, 'email' ) || $is_phone ) )
					{
						return FALSE;
					}
				}
			}
		}
		
		return TRUE;
	}
	
	public function val_channels_list( $str )
	{
		$this->form_validation->set_message( __FUNCTION__, '%s: ' . 'Lista de canales inválida' );
		
		if ( '' != $str )
		{
			$data = explode( ',', $str );
			
			if ( isset( $data ) && !empty( $data ) )
			{
				foreach ( $data as $hexa1 )
				{
					if ( '' != $this->fval( $hexa1, 'hexa1' ) )
					{
						return FALSE;
					}
				}
			}
		}
		
		return TRUE;
	}
	
	public function val_plot_list( $str )
	{
		$this->form_validation->set_message( __FUNCTION__, '%s: ' . 'Lote/s inválido/s' );
		
		if ( '' != $str )
		{
			$str = str_replace( ' ', '', $str );
			$data = explode( ',', $str );
			
			if ( isset( $data ) && !empty( $data ) )
			{
				foreach ( $data as $plot )
				{
					if ( '' != $this->fval( $plot, 'num' ) )
					{
						return FALSE;
					}
				}
			}
		}
		
		return TRUE;
	}
		
	protected function is_plate( $str )
	{
		// Argentina - Paraguay
		if (	strlen( $str ) == 6 && 
				ctype_alpha( substr( $str, 0, 3 ) ) &&
				ctype_digit( substr( $str, 3 ) )
		)
		{
			return TRUE;
		}
		
		// Mercosur - Chile
		if (	strlen( $str ) == 7 && 
				ctype_alpha( substr( $str, 0, 2 ) ) && 
				ctype_digit( substr( $str, 2, 3 ) ) &&
				ctype_alpha( substr( $str, 5, 2 ) )
		)
		{
			return TRUE;
		}
		
		// Brasil - Uruguay
		if (	strlen( $str ) == 7 && 
				ctype_alpha( substr( $str, 0, 3 ) ) && 
				ctype_digit( substr( $str, 3 ) )
		)
		{
			return TRUE;
		}
		
		// Moto Argentina - Brasil - Venezuela
		if (	strlen( $str ) == 7 && 
				ctype_alpha( substr( $str, 0, 1 ) ) && 
				ctype_digit( substr( $str, 1, 3 ) ) && 
				ctype_alpha( substr( $str, 4, 3 ) )
		)
		{
			return TRUE;
		}
		
		// Moto Paraguay
		if (	strlen( $str ) == 7 && 
				ctype_digit( substr( $str, 0, 3 ) ) && 
				ctype_alpha( substr( $str, 4 ) )
		)
		{
			return TRUE;
		}
		
		// Moto Uruguay
		if (	strlen( $str ) == 7 && 
				ctype_alpha( substr( $str, 0, 3 ) ) && 
				ctype_digit( substr( $str, 4 ) )
		)
		{
			return TRUE;
		}
		
		// 123ABC
		if (	strlen( $str ) == 6 && 
				ctype_digit( substr( $str, 0, 3 ) ) &&
				ctype_alpha( substr( $str, 3 ) )
		)
		{
			return TRUE;
		}
		
		// A12ABC
		if (	strlen( $str ) == 6 && 
				ctype_alpha( substr( $str, 0, 1 ) ) &&
				ctype_digit( substr( $str, 1, 2 ) ) &&
				ctype_alpha( substr( $str, 3 ) )
		)
		{
			return TRUE;
		}
		
		return FALSE;
	}
	
	public function val_plate( $str )
	{
		$this->form_validation->set_message( __FUNCTION__, '%s: ' . 'Inválida' );
		
		if ( '' != $str )
		{
			$str = str_replace( ' ', '', $str );
			
			if ( !$this->is_plate( $str ) )
			{
				return FALSE;
			}
		}
		
		return TRUE;
	}
	
	public function val_plate_list( $str )
	{
		$this->form_validation->set_message( __FUNCTION__, '%s: ' . 'Patente/s inválida/s' );
		
		if ( '' != $str )
		{
			$str = str_replace( ' ', '', $str );
			$data = explode( ',', $str );
			
			if ( isset( $data ) && !empty( $data ) )
			{
				foreach ( $data as $plate )
				{
					if ( !$this->is_plate( $plate ) )
					{
						return FALSE;
					}
				}
			}
		}
		
		return TRUE;
	}
	
	protected function kajax_validation_set_input_states( $rules, $id, $rows_extra = NULL, $row_name = '#row_' )
	{
		if ( !empty( $rules ) )
		{
			$rows = array( $row_name . ( intval( $id ) == 0 ? 'new' : $id ) );
			
			if ( NULL != $rows_extra )
			{
				if ( is_array( $rows_extra ) && !empty( $rows_extra ) )
				{
					foreach ( $rows_extra as $re )
					{
						array_push( $rows, $re . ( intval( $id ) == 0 ? 'new' : $id ) );
					}
				}
				else if ( is_string( $rows_extra ) )
				{
					array_push( $rows, $rows_extra . ( intval( $id ) == 0 ? 'new' : $id ) );
				}
			}
			
			foreach ( $rows as $row_id )
			{
				$this->kajax_validate_inputs( $rules, $row_id );
			}
		}
	}
	
	protected function kajax_validate_inputs( $rules, $id = '' )
	{
		if ( !empty( $rules ) )
		{
			foreach ( $rules as $r )
			{
				$field	= $r['field'];
				
				if ( isset( $r['type'] ) && 'textarea' == $r['type'] )
				{
					$target	= ( '' != $id ? $id . ' ' : '' ) . 'textarea[name="' . $field . '"]';
				}
				else
				{
					$target	= ( '' != $id ? $id . ' ' : '' ) . 'input[name="' . $field . '"]';
				}
				
				if ( '' != form_error( $field ) )
				{
					$this->kajax->addClass( $target, 'error' );
				}
				else
				{
					$this->kajax->removeClass( $target, 'error' );
				}
			}
		}
	}
	
	/**
	 * @param $id Is the new id of the elements
	 * @param $elements_base_name is an array of elements base names, this means: if element is called 'row_new', the base name is 'row_'
	 * */
	protected function kajax_replace_new_ids( $id, $elements_base_name )
	{
		foreach( $elements_base_name as $el )
		{
			$this->kajax->attr( '#' . $el . 'new', 'id', $el . $id );
		}
	}
	
	protected function json_output_error( $error_msg, $response_code = 500 )
	{
		$this->json_output( array( 'error' => $error_msg ), $response_code );
	}
	
	protected function json_output( $output, $response_code = 200 )
	{
		http_response_code( $response_code );
		http_header_json_no_cache();
		
		$ret = json_encode( $output );
		
		if ( FALSE !== $ret )
		{
			echo $ret;
		}
		else
		{
			$error = json_last_error_msg();
			
			log_error("json_print: json_encode failed:\n" . $error );
			
			http_response_code(500);
			echo json_encode( array( 'error' => $error ) ); 
		}
		
		exit;
	}
}
