<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

require_once( LIBSPATH . 'maps/maps.php' );
require_once( LIBSPATH . 'frames/actions.php' );

class Airmesh_Controller extends PAGE_Controller
{
	protected function set_map_to_tpl( &$data, $map_res, $show_count = TRUE )
	{
		$data['map_html'] = $map_res['html'];
		$data['citymesh_data'] = $map_res['data'];
		
		$this->set_map_to_tpl_airmesh($data, $map_res, $show_count);
		$this->set_map_to_tpl_gprs($data, $map_res, $show_count);
	}

	protected function set_map_to_tpl_airmesh( &$data, $map_res, $show_count = TRUE )
	{
		if( $show_count )
		{
			$data['airmesh_dead_count'] 		= intval( $map_res['states'][TestState::DEAD] );
			$data['airmesh_low_count']			= intval( $map_res['states'][TestState::LOW] );
			$data['airmesh_good_count']			= intval( $map_res['states'][TestState::GOOD] );
			$data['airmesh_excellent_count']	= intval( $map_res['states'][TestState::EXCELLENT] );
			$data['airmesh_hw_count']			= $data['airmesh_dead_count'] + $data['airmesh_low_count'] + $data['airmesh_good_count'] + $data['airmesh_excellent_count'];
			
			if ( $data['airmesh_hw_count'] > 0 )
			{
				$data['airmesh_dead_percent']		= intval( floor( floatval( $data['airmesh_dead_count'] ) / floatval( $data['airmesh_hw_count'] ) * 100 ) );
				$data['airmesh_low_percent']		= intval( floor( floatval( $data['airmesh_low_count'] ) / floatval( $data['airmesh_hw_count'] )  * 100 ) );
				$data['airmesh_good_percent']		= intval( floor( floatval( $data['airmesh_good_count'] ) / floatval( $data['airmesh_hw_count'] ) * 100 ) );
				$data['airmesh_excellent_percent']	= intval( floor( floatval( $data['airmesh_excellent_count'] ) / floatval( $data['airmesh_hw_count'] ) * 100 ) );
				$total_percent						= $data['airmesh_dead_percent'] + $data['airmesh_low_percent'] + $data['airmesh_good_percent'] + $data['airmesh_excellent_percent'];
			}
			else
			{
				$data['airmesh_dead_percent']		= 0;
				$data['airmesh_low_percent']		= 0;
				$data['airmesh_good_percent']		= 0;
				$data['airmesh_excellent_percent']	= 0;
				$total_percent						= 100;
			}
			
			if ( $total_percent < 100 )
			{
				$rest = 100 - $total_percent;
				
				if ( $data['airmesh_dead_percent'] > 0 )
				{
					$data['airmesh_dead_percent'] += $rest;
				}
				else if ( $data['airmesh_low_percent'] > 0 )
				{
					$data['airmesh_low_percent'] += $rest;
				}
				else if ( $data['airmesh_good_percent'] > 0 )
				{
					$data['airmesh_good_percent'] += $rest;
				}
				else if ( $data['airmesh_excellent_percent'] > 0 )
				{
					$data['airmesh_excellent_percent'] += $rest;
				}
			}
		}
	}

	protected function set_map_to_tpl_gprs( &$data, $map_res, $show_count = TRUE )
	{
		if( $show_count )
		{
			$data['gprs_dead_count'] 		= intval( $map_res['states_gprs'][TestState::DEAD] );
			$data['gprs_low_count']			= intval( $map_res['states_gprs'][TestState::LOW] );
			$data['gprs_good_count']		= intval( $map_res['states_gprs'][TestState::GOOD] );
			$data['gprs_excellent_count']	= intval( $map_res['states_gprs'][TestState::EXCELLENT] );
			$data['gprs_hw_count']			= $data['gprs_dead_count'] + $data['gprs_low_count'] + $data['gprs_good_count'] + $data['gprs_excellent_count'];
			
			if ( $data['gprs_hw_count'] > 0 )
			{
				$data['gprs_dead_percent']		= intval( floor( floatval( $data['gprs_dead_count'] ) / floatval( $data['gprs_hw_count'] ) * 100 ) );
				$data['gprs_low_percent']		= intval( floor( floatval( $data['gprs_low_count'] ) / floatval( $data['gprs_hw_count'] )  * 100 ) );
				$data['gprs_good_percent']		= intval( floor( floatval( $data['gprs_good_count'] ) / floatval( $data['gprs_hw_count'] ) * 100 ) );
				$data['gprs_excellent_percent']	= intval( floor( floatval( $data['gprs_excellent_count'] ) / floatval( $data['gprs_hw_count'] ) * 100 ) );
				$total_percent						= $data['gprs_dead_percent'] + $data['gprs_low_percent'] + $data['gprs_good_percent'] + $data['gprs_excellent_percent'];
			}
			else
			{
				$data['gprs_dead_percent']		= 0;
				$data['gprs_low_percent']		= 0;
				$data['gprs_good_percent']		= 0;
				$data['gprs_excellent_percent']	= 0;
				$total_percent						= 100;
			}
			
			if ( $total_percent < 100 )
			{
				$rest = 100 - $total_percent;
				
				if ( $data['gprs_dead_percent'] > 0 )
				{
					$data['gprs_dead_percent'] += $rest;
				}
				else if ( $data['gprs_low_percent'] > 0 )
				{
					$data['gprs_low_percent'] += $rest;
				}
				else if ( $data['gprs_good_percent'] > 0 )
				{
					$data['gprs_good_percent'] += $rest;
				}
				else if ( $data['gprs_excellent_percent'] > 0 )
				{
					$data['gprs_excellent_percent'] += $rest;
				}
			}
		}
	}

	protected function show_common_user( &$data )
	{
		$data['signal_hw_state_low']	= $this->user->get_hw_state_low();
		$data['signal_hw_state_good']	= $this->user->get_hw_state_good();
		$this->set_map_to_tpl( $data, HardwareMap::createmap_user() );
	}

	protected function show_company( &$data, $god = FALSE, $metacpy = FALSE )
	{
		$data['company_id']		= $this->user->get_type_id();

		if ( !$god )
		{
			if( $metacpy )
			{
				$this->set_map_to_tpl( $data, HardwareMap::createmap_company_meta() );
			}
			else
			{
				$this->set_map_to_tpl( $data, HardwareMap::createmap_company() );
			}
			
			$data['signal_hw_state_low']	= $this->user->get_hw_state_low();
			$data['signal_hw_state_good']	= $this->user->get_hw_state_good();
		}
		else
		{
			$data['signal_hw_state_low']	= 7;
			$data['signal_hw_state_good']	= 10;
			
			$this->set_map_to_tpl( $data, HardwareMap::createmap_god() );
		}
	}

	protected function show_god( &$data )
	{
		$this->show_company( $data, TRUE );
	}

	protected function show_company_meta( &$data )
	{
		$this->show_company( $data, FALSE, TRUE );
	}
	
	protected function set_map_data( &$data, $unlocked = FALSE, $hide_checkbox = FALSE )
	{
		if ( $unlocked )
		{
			$data['panel_state_unlocked'] = TRUE;
		}
		
		if ( $hide_checkbox )
		{
			$data['panel_state_checkbox_hide'] = TRUE;
		}
		
		switch ( $this->user->get_type() )
		{
			case USER_TYPE_USER:		$this->show_common_user( $data );	break;
			case USER_TYPE_CPNY_RO:
			case USER_TYPE_CPNY_RW:
			case USER_TYPE_CPNY:		$this->show_company( $data );		break;
			case USER_TYPE_CPNY_META:	$this->show_company_meta( $data );	break;
			case USER_TYPE_GOD:			$this->show_god( $data );			break;
		}
	}
}
