<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Users extends PAGE_Controller
{ 
	protected function build_user_filters( $ignore_real_type = FALSE )
	{
		$filter = array(
			array(
				'field_name'	=>	'ui_name',
				'filter_val'	=>	get_var( 'ui_name' ),
				'filter_type'	=>	SQLFilterType::ILIKE
			),
			array(
				'field_name'	=>	'ui_lastname',
				'filter_val'	=>	get_var( 'ui_lastname' ),
				'filter_type'	=>	SQLFilterType::ILIKE
			),
			array(
				'field_name'	=>	'uname',
				'filter_val'	=>	get_var( 'uname' ),
				'filter_type'	=>	SQLFilterType::ILIKE
			),
			array(
				'field_name'	=>	'umail',
				'filter_val'	=>	get_var( 'umail' ),
				'filter_type'	=>	SQLFilterType::ILIKE
			),
			array(
				'order_by'		=> get_var_def( 'order_by', 'ui_lastname' ),
				'order_fields'	=> array( 'ui_lastname', 'ui_name', 'umail', 'uname', 'hw_code' ),
				'order_dir'		=> get_var_def( 'order_dir', 'ASC' )
			)
		);
		
		if ( $this->user->is_logged_as_user() && !$ignore_real_type )
		{
			$filter[] = array(
				'field_name'	=>	'uid',
				'filter_val'	=>	$this->user_id()
			);
		}
		
		$query_filter		= SQL::build_query_filter( $filter );
		
		return $query_filter;
	}
	
	public function search()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->library('pagination');
		
		$data['js_cb']			= get_var( 'cb' );
		$data['row_id']			= get_var_def( 'row_id', 0 );
		$data['unselect_but']	= get_var( 'unselect_but' );
		
		$page					= get_var_def( 'page_num', 1 );
		$config					= pagination_config();
		$config['per_page']		= 12;
		$query_filter			= $this->build_user_filters( 'user_profile_jump' == $data['js_cb'] );
		$data['ui_name']		= get_var( 'ui_name' );
		$data['ui_lastname']	= get_var( 'ui_lastname' );
		$data['umail']			= get_var( 'umail' );
		
		$config['total_rows']	= $data['total_users']	= $this->User_model->count( $this->user->get_company_ids(), $this->user->get_df_code(), $query_filter );
		$data['users']			= $this->User_model->get_all( $this->user->get_company_ids(), $this->user->get_df_code(), $query_filter, $config['per_page'], $page );
		$config['base_url']		= base_url( '/users/search/?' . http_build_query_pagination() );
		$config['anchor_class']	= 'class="ajax-paging-link ajax-clean" ';
		$data['base_url']		= $config['base_url'];
		$data['select_uid']		= get_var( 'uid' ) == 1;
		
		$this->pagination->initialize($config);
		
		$data['pagination']		= $this->pagination->create_links();
		
		$this->load->view( 'users_search_list', $data );
	}
	
	public function all()
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->load->library('pagination');
		
		$page					= get_var_def( 'page_num', 1 );
		$config					= pagination_config();
		$query_filter			= $this->build_user_filters();
		$data['ui_name']		= get_var( 'ui_name' );
		$data['ui_lastname']	= get_var( 'ui_lastname' );
		$data['uname']			= get_var( 'uname' );
		$data['umail']			= get_var( 'umail' );
		$config['total_rows']	= $data['total_users']	= $this->User_model->count( $this->user->get_company_ids(), $this->user->get_df_code(), $query_filter );
		$data['users']			= $this->User_model->get_all( $this->user->get_company_ids(), $this->user->get_df_code(), $query_filter, $config['per_page'], $page );
		$config['base_url']		= base_url( '/users/all/?' . http_build_query_pagination() );
		$config['anchor_class']	= 'class="ajax-link" ';
		$data['base_url']		= $config['base_url'];
		
		if ( $this->user->is_logged_as_god() )
		{
			$this->load->model('Company_model');
			$data['all_com']	= $this->Company_model->get_all_names();
		}
		
		$this->pagination->initialize($config);
		
		$data['pagination']		= $this->pagination->create_links();
		
		$this->add_frame_view( 'users_list', $data );
	}
	
	public function get_new_row()
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$data = array();
		
		if ( $this->user->is_logged_as_god_or_meta_company() )
		{
			$this->load->model('Company_model');
			$data['all_com']	= $this->Company_model->get_all_names( $this->user->get_company_ids() );
		}
		
		$this->kajax->prepend( '#users_list_table', $this->load->view( 'new_row_user', $data, TRUE ) );
		$this->kajax->out();
	}
	
	protected function user_id_replace( $id )
	{
		$this->kajax_replace_new_ids( 
			$id,
			array(	'row_', 
					'row_hidden_',
					'row_extra_'
			)
		);
	}	
	
	public function update()
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$post = $this->input->post();
		
		$edit = intval( $post['uid'] ) != 0;
		
		$this->load->library('form_validation');

		$rules	= array(
			array(
				'field'   => 'uname', 
				'label'   => 'Usuario', 
				'rules'   => 'required|trim|max_length[40]'
			),
			array(
				'field'   => 'name', 
				'label'   => 'Nombre', 
				'rules'   => 'required|trim|max_length[64]'
			),   
			array(
				'field'   => 'lastname', 
				'label'   => 'Apellido', 
				'rules'   => 'required|trim|max_length[64]'
			),
			array(
				'field'   => 'umail', 
				'label'   => 'EMail', 
				'rules'   => 'required|trim|max_length[128]|valid_email'
			),
			array(
				'field'   => 'upass', 
				'label'   => 'Contraseña', 
				'rules'   => ( $edit ? '' : 'required|' ) . 'matches[upass_rep]'
			),
			array(
				'field'   => 'upass_rep', 
				'label'   => 'Repetir Contraseña', 
				'rules'   => ''
			),
			array(
				'field'   => 'phone', 
				'label'   => 'Celular', 
				'rules'   => 'trim|max_length[64]'
			),
			array(
				'field'   => 'address', 
				'label'   => 'Dirección', 
				'rules'   => 'required|trim|max_length[64]'
			),
			array(
				'field'   => 'support', 
				'label'   => 'Soporte', 
				'rules'   => 'trim|max_length[64]|valid_emails'
			),
			array(
				'field'   => 'observations', 
				'label'   => 'Observaciones', 
				'rules'   => 'trim|max_length[128]'
			)
		);
		
		$this->form_validation->set_rules( $rules );
		
		if ( $this->form_validation->run() != FALSE )
		{
			if ( $edit )
			{
				if ( $this->user->owns_user( $post['uid'] ) )
				{
					if ( isset( $post['uname'] ) && $this->User_model->user_name_exists_off_uid( $post['uid'], $post['uname'] ) > 0 ) 
					{
						$this->kajax->fancy_log_error( 'El nombre de usuario ' . $post['uname'] . ' ya está registrado' );
					}
					else
					{
						if ( $this->user->is_logged_as_god() )
						{
							$this->load->model('Company_model');
							
							$this->User_model->update( $post, $post['com_id'], $this->Company_model->get_city( $post['com_id'] )  );
						}
						else
						{
							$this->User_model->update( $post );
						}
						
						$this->kajax->fancy_log_success( 'Usuario: ' . $post['uname'] . ' editado con éxito.' );
					}
				}
				else
				{
					$this->kajax->fancy_log_error('No puedes modificar este usuario, no tienes suficientes permisos.');
				}
			}
			else
			{
				if ( $this->user->is_logged_as_god() )
				{
					$this->load->model('Company_model');
					
					$id = $this->User_model->create( $post, $post['com_id'], $this->Company_model->get_city( $post['com_id'] )  );
				}
				else
				{
					$id = $this->User_model->create( $post, $this->user->get_company(), $this->user->get_city() );
				}
				
				$this->kajax->fancy_log_success( 'Usuario: ' . $post['uname'] . ' añadido con éxito.' );
				$this->user_id_replace( $id );
				$this->kajax->prepend( '#row_hidden_' . $id . ' td', '&nbsp;<button data-href="'. base_url('/users/suspend/'.$id) . '" class="submit_btn_table suspend_btn" value="¿Seguro que quiere suspender el usuario ' . $post['uname'] . '?"><span>Suspender</span></button>' );
				$this->kajax->call( 'table_row_new_convert_to_id( ' . $id . ', "uid", "' . base_url('/users/delete/'.$id) . '", "¿Seguro que quiere eliminar el usuario ' . $post['uname'] . '?" )' );
				
				$post['uid'] = $id;
			}
		}
		else
		{
			$this->kajax->fancy_log_error( validation_errors() );
		}
		
		$this->kajax_validation_set_input_states( $rules, $post['uid'], '#row_extra_' );
		
		$this->kajax->out();
	}
	
	public function delete( $id )
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		if ( $this->user->owns_user( $id ) )
		{
			$user = $this->User_model->get( $id );
			
			if ( NULL != $user )
			{		
				$this->User_model->delete( intval( $id ) );
				
				$this->kajax->fancy_log_success( "Usuario " . $user->uname . " eliminado con éxito." );
				
				$this->kajax->remove( '#row_hidden_' . $id );
				$this->kajax->remove( '#row_extra_' . $id );
				$this->kajax->remove( '#row_' . $id );
			}
			else
			{
				$this->kajax->fancy_log_error( 'No se encontró el usuario a eliminar' );
			}
		}
		else
		{
			$this->kajax->fancy_log_error( 'No tienes suficientes permisos para eliminar usuarios.' );
		}
		
		$this->kajax->out();
	}
	
	public function suspend( $uid, $uname )
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		if ( $this->user->owns_user( $uid ) )
		{
			$this->User_model->suspend( $uid, TRUE );
			
			$rid = '#row_hidden_' . $uid;
			$sel = $rid . ' button.submit_btn_table.suspend_btn ';
			
			$this->kajax->text( $rid . ' td div.state', 'Usuario Suspendido' );
			
			$this->kajax->text( $sel . ' span', 'Activar' );
			
			$this->kajax->data( $sel, 'text', '¿Seguro que quiere activar el usuario ' . $uname . '?' );
			
			$this->kajax->data( $sel, 'href', base_url('/users/activate/'.$uid.'/'.$uname ) );
			
			$this->kajax->out();
		}
		else
		{
			$this->kajax->fancy_log_error( 'No tienes suficientes permisos para suspender usuarios.' );
		}
	}
	
	public function activate( $uid, $uname )
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->User_model->suspend( $uid, FALSE );
		
		$rid = '#row_hidden_' . $uid;
		$sel = $rid . ' button.submit_btn_table.suspend_btn ';
		
		$this->kajax->text( $rid . ' td div.state', '' );
		
		$this->kajax->text( $sel . ' span', 'Suspender' );
		
		$this->kajax->data( $sel, 'text', '¿Seguro que quiere suspender el usuario ' . $uname . '?' );
		
		$this->kajax->data( $sel, 'href', base_url('/users/suspend/'.$uid.'/'.$uname ) );
		
		$this->kajax->out();
	}
}
