<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class User extends Airmesh_Controller
{
	protected function build_vehicles_filter()
	{
		$fields = array(
			array(
				'field_name'	=>	'ae_id',
				'filter_val'	=>	'( SELECT MAX(ae_id) FROM avl_event WHERE ae_imei = ahw_imei )',
				'field_type'	=>	SQLFieldType::ANY
			),
			array(
				'field_name'	=>	'ae_gpsstatus',
				'filter_val'	=>	'V',
				'filter_type'	=>	SQLFilterType::UNEQUALS
			),
			array(
				'order_by'		=>	'af_name',
				'order_dir'		=>	'ASC',
				'null_order'	=>	'LAST'
			),
			array(
				'order_by'		=>	'state',
				'order_dir'		=>	'ASC'
			)
		);
		
		return SQL::build_query_filter( $fields );
	}
	
	public function index()
	{
		if ( isset( $this->user ) )
		{
			if ( $this->user->is_logged_as_user() )
			{
				if ( $this->user->is_dshield_user() )
				{
					$this->redirect( base_url('/dshield/') );
				}
				else
				{
					$this->user_index();
				}
			}
			else if ( $this->user->is_professional() )
			{
				$this->redirect( base_url('/dshield/person/all') );
			}
			else if ( $this->user->is_guard() || $this->user->is_dshield_user() )
			{
				$this->redirect( base_url('/dshield/') );
			}
			else
			{
				$this->map();
			}
		}
		else
		{
			$this->logout();
		}
	}
	
	public function login_json()
	{
		$form			= get_json_body();
		$user_id		= 0;
		$user_type		= 0;
		$row			= $this->User_model->get_with_password( $form['user'], $form['pass'] );
		$user_suspended	= TRUE;
		
		if ( isset( $row ) )
		{
			$user_id		= $row->uid;
			$user_name		= $row->uname;
			$user_type		= $row->utype;
			$user_suspended	= ( 'SUSPENDED' == $row->ustate ) ? TRUE : FALSE;
		}
		
		if ( isset( $row ) && $user_id > 0 )
		{
			if ( !$user_suspended )
			{
				$this->session_create( $user_id, $user_name, $user_type, isset( $form['session_remember'] ) );
				
				$this->load->model( 'SiteLog_model' );
				
				$this->SiteLog_model->register_log( $user_id );
				
				http_response_code(200); // OK
				
				echo json_encode( array( "resp" => "success" ) );
			}
			else
			{
				http_response_code(403); // FORBIDDEN_403
				
				echo json_encode( array( "resp" => "user_suspended" ) );
			}
		}
		else
		{
			if ( $this->User_model->exists_name( $form['user'] ) )
			{
				http_response_code(401); // UNAUTHORIZED_401
				
				echo json_encode( array( "resp" => "wrong_password" ) );
			}
			else
			{
				http_response_code(404); // NOT_FOUND_404
				
				echo json_encode( array( "resp" => "wrong_user" ) );
			}
		}
	}
	
	public function login( $how = null )
	{
		if ( $how == 'json' )
		{
			return $this->login_json();
		}
		
		$form			= $this->input->post();
		$user_id		= 0;
		$user_type		= 0;
		$row			= $this->User_model->get_with_password( $form['user'], $form['pass'] );
		$user_suspended	= TRUE;
		
		if ( isset( $row ) )
		{
			$user_id		= $row->uid;
			$user_name		= $row->uname;
			$user_type		= $row->utype;
			$user_suspended	= ( 'SUSPENDED' == $row->ustate ) ? TRUE : FALSE;
		}
		
		if ( isset( $row ) && $user_id > 0 )
		{
			if ( !$user_suspended )
			{
				$this->session_create( $user_id, $user_name, $user_type, isset( $form['session_remember'] ) );
				
				$this->load->model( 'SiteLog_model' );
				
				$this->SiteLog_model->register_log( $user_id );
				
				$referer = isset( $form['referer'] ) && '' != $form['referer'] ? $form['referer'] : '/user';
				$this->kajax->redirect( base_url( $referer ) );
			}
			else
			{

			}
		}
		else
		{
			$this->kajax->attr('#username', 'placeholder', 'Nombre de Usuario');
			$this->kajax->attr('#password', 'placeholder', 'Contraseña');
			$this->kajax->removeClass('#username', 'error');
			$this->kajax->removeClass('#password', 'error');
			$this->kajax->removeClass('.login_input', 'login_input_error');
			$this->kajax->addClass('.login_username_state', 'sprite-img-icon-user');
			$this->kajax->removeClass('.login_username_state', 'sprite-img-icon-user-error');
			$this->kajax->addClass('.login_password_state', 'sprite-img-icon-password');
			$this->kajax->removeClass('.login_password_state', 'sprite-img-icon-password-error');
			
			if ( $this->User_model->exists_name( $form['user'] ) )
			{
				$this->kajax->val('#password', '');
				$this->kajax->attr('#password', 'placeholder', 'Contraseña Incorrecta');
				$this->kajax->addClass('#password', 'error');
				$this->kajax->removeClass('.login_password_state', 'sprite-img-icon-password');
				$this->kajax->addClass('.login_password_state', 'sprite-img-icon-password-error');
				$this->kajax->addClass('#login_password_input', 'login_input_error');
			}
			else
			{
				$this->kajax->val('#username', '');
				$this->kajax->attr('#username', 'placeholder', 'Usuario Incorrecto');
				$this->kajax->addClass('#username', 'error');
				$this->kajax->removeClass('.login_username_state', 'sprite-img-icon-user');
				$this->kajax->addClass('.login_username_state', 'sprite-img-icon-user-error');
				$this->kajax->addClass('#login_user_input', 'login_input_error');
			}
		}
		
		$this->kajax->out();
	}
	
	public function logout( $how = null )
	{
		$this->session_destroy();
		
		if ( $how == 'json' )
		{
			echo json_encode( array( 'resp' => 'success' ) );
		}
		else
		{
			redirect( base_url('/') );
		}
	}
	
	public function map()
	{
		ini_set("memory_limit","1024M");
		
		$this->session_restrict( USER_TYPE_USER );
		
		$data	= array();
		
		$this->set_map_data( $data );
		
		$data['hours']		= get_var_def( 'ghours', 1 );
		$data['date_str']	= HardwareMap::$final_datetime_str;
		$data['map']		= $this->load->view( 'map', $data, TRUE );
		
		if ( $this->user->is_logged_as_company() && !$this->user->is_logged_as_company_meta() )
		{
			$data['healthy']	= $this->user->is_company_healthy();
			
			$this->load->model('Radar_model');
			
			$data['has_radar']	= $this->Radar_model->has_radar( $this->user->get_company_ids() );
		}
		
		$this->load->model('HardwareGroup_model');
		$data['groups']		= $this->HardwareGroup_model->get_all( $this->user->get_company_ids() );
		
		$this->add_frame_view( 'main', $data );
	}
	
	public function map_export()
	{
		ini_set("memory_limit","1024M");
		
		$this->session_restrict( USER_TYPE_USER );
		
		$data = null;
		
		switch ( $this->user->get_type() )
		{
			case USER_TYPE_USER:
			{
				$data = HardwareMap::createmap_user();
				break;
			}
			case USER_TYPE_CPNY_RO:
			case USER_TYPE_CPNY:
			{
				$data = HardwareMap::createmap_company();
				break;
			}
			case USER_TYPE_CPNY_META:
			{
				$data = HardwareMap::createmap_company_meta();
				break;
			}
			case USER_TYPE_GOD:
			{
				$data = HardwareMap::createmap_god();
				break;
			}
		}
		
		if ( null != $data && isset( $data['data'] ) )
		{
			$res		= $data['data'];
			$hours		= get_var_def( 'ghours', 1 );
			$date_str	= HardwareMap::$final_datetime_str;
			
			csv_create_header( 'map_data_' . $hours . '_' . $date_str );
			csv_array_sanitize( $res );
			
			$w = '"nombre","apellido","nombre abonado","latitud","longitud","número de abonado","mac","horas","estado","reportes"' . "\r\n";
			
			foreach ( $res as $r )
			{
				$w.=	'"' . $r['ui_name'] . '",' . 
						'"' . $r['ui_lastname'] . '",' . 
						'"' . $r['hw_name'] . '",' . 
						'"' . $r['hw_lat'] . '",' . 
						'"' . $r['hw_long'] . '",' . 
						'"' . dechex( $r['hw_code'] ) . '",' . 
						'"' . dechex( $r['hw_serial'] ) . '",' . 
						'"' . $r['thours'] . '",' . 
						'"' . $r['tests_state']['state'] . '",' . 
						'"' . $r['tests_state']['count'] . '"' . "\r\n";
			}
			
			echo $w;
		}
	}
	
	public function log_as( $uid )
	{
		if ( NULL != DomoUser::$instance )
		{
			if ( DomoUser::$instance->log_as( $uid, $this->session ) )
			{
				redirect( base_url('/') );
			}
			else
			{
				$this->logout();
			}
		}
		else
		{
			echo "User not logged.";
		}
	}
	
	public function hw( $uid )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		if ( $this->user->owns_user( $uid ) )
		{
			$this->load->model('User_model');
			$this->load->model('Hardware_model');
			$this->load->model('AvlHardware_model');
			$this->load->model('Keychain_model');
			
			$data['user']			= $this->User_model->get_full( $uid, ARRAY_A );
			$data['airmesh_hw']		= $this->Hardware_model->get_all( NULL, SQL::build_query_filter( array( array( 'field_name'	=>	'hw_user', 'filter_val'	=>	$data['user']['ui_id'] ) ) ) );
			$data['geotrace_hw']	= $this->AvlHardware_model->get_all( NULL, SQL::build_query_filter( array( array( 'field_name'	=>	'ahw_uid', 'filter_val'	=>	$uid ) ) ) );
			$data['dkeep_hw']		= $this->Keychain_model->get_all( NULL, SQL::build_query_filter( array( array( 'field_name'	=>	'key_user', 'filter_val'	=>	$uid ) ) ) );
			
			$this->add_frame_view( 'user_hw', $data );
		}
	}
	
	public function hws_pre_links( $user_id )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->load->model('User_model');
		
		$user = $this->User_model->get_info_from_id( $user_id );
		
		if ( $this->user->owns_user( $user->ui_uid ) )
		{
			$this->load->model('HardwarePreLink_model');
			
			$data['user_id']	= $user_id;
			$data['prelinks']	= $this->HardwarePreLink_model->get_from_user( $user_id );
			
			$this->load->view( 'hws_pre_link', $data );
		}
	}
	
	public function add_pre_links()
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->load->model('User_model');
		
		$user_id = get_post('user');
		
		$user = $this->User_model->get_info_from_id( $user_id );
		
		if ( $this->user->owns_user( $user->ui_uid ) )
		{
			$this->load->model('HardwarePreLink_model');
			
			$macs = get_post('macs');
			
			$this->HardwarePreLink_model->clear( $user_id );
			
			if ( isset( $macs ) && !empty( $macs ) )
			{
				$macs = str_replace( "\r", "", $macs );
				$macs = explode( "\n", $macs );
				
				foreach ( $macs as $mac )
				{
					if ( ctype_xdigit( $mac ) )
					{
						$decmac = hexdec( $mac );
						
						$this->HardwarePreLink_model->add( $decmac, $user_id );
					}
				}
				
				$this->kajax->fancy_log_success( 'Enlace a equipos pendientes de instalación guardados.' );
			}
		}
		else
		{
			$this->kajax->fancy_log_error( 'No tienes permisos para enlazar.' );
		}
		
		$this->kajax->call('modal_dialog_close()');
		
		$this->kajax->out();
	}
	
	public function jobs()
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$jobs = array();
		
		if ( $this->user->is_god() && $this->user->is_logged_as_company() && !$this->user->is_logged_as_company_meta() && !$this->user->is_professional() )
		{
			$this->load->model('AirmeshConfigLog_model');
			$this->load->model('CityMeshConfigLog_model');
			$this->load->model('HardwareConfigCommand_model');
			$this->load->model('HardwareCityMeshCommand_model');
			
			$com_id							= $this->user->get_type_id();
			
			$airmesh_job['is_running']		= $this->HardwareConfigCommand_model->is_running_commands( $com_id );
			$airmesh_job['state']			= $this->HardwareConfigCommand_model->get_state( $com_id );
			
			$citymesh_job['is_running']		= $this->HardwareCityMeshCommand_model->is_running_commands( $com_id );
			$citymesh_job['state']			= $this->HardwareCityMeshCommand_model->get_state( $com_id );
			
			$jobs['airmesh'] 				= $airmesh_job;
			$jobs['citymesh']				= $citymesh_job;
		}
		
		echo json_encode( $jobs );
	}
	
	public function techsupport()
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->load->helper('form_validation_helper');
		
		$mails = get_mails_from_string( $this->user->get_support() );
		
		$subject = $this->user->get_fullname() . ': Solicitud de soporte técnico.';
		
		$this->load->view( 'mail_popup', array(	'callback_url' => base_url( '/user/mailtechsupport' ), 
												'default_subject' => $subject, 
												'default_reply_to' => $this->user->get_mail(), 
												'hide_from' => TRUE, 
												'no_to' => ( '' == $mails )
										)
		);
	}
	
	public function admsupport()
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->load->model('Company_model');
		
		$this->load->helper('form_validation_helper');
		
		$mails = get_mails_from_string( $this->Company_model->get( $this->user->get_company() )->com_support );
		
		$subject = $this->user->get_fullname() . ': Solicitud de soporte administrativo.';
		
		$this->load->view( 'mail_popup', array( 'callback_url' => base_url( '/user/mailadmsupport' ), 
												'default_subject' => $subject, 
												'default_reply_to' => $this->user->get_mail(), 
												'hide_from' => TRUE,
												'no_to' => ( '' == $mails )
										)
		);
	}
	
	protected function send_mail( $data, $to )
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->library('form_validation');

		$rules	= array(
			array(
				'field'   => 'subject', 
				'label'   => 'Asunto', 
				'rules'   => 'required|trim|max_length[200]'
			),
			array(
				'field'   => 'from', 
				'label'   => 'Responde a', 
				'rules'   => 'required|trim|max_length[128]|valid_email'
			),
			array(
				'field'   => 'message', 
				'label'   => 'Mensaje', 
				'rules'   => 'required|trim|min_length[10]',
				'type'    => 'textarea'
			)
		);
		
		$this->form_validation->set_rules( $rules );
		
		if ( $this->form_validation->run() != FALSE )
		{
			simple_mail( 'mailer@reddomo.com.ar', $to, $data['subject'], $data['message'], $data['from'] );
			
			$this->kajax->html('.mail_response_div', '<p>Gracias por contactarse.</p><p>El administrador se pondrá en contacto con usted a la brevedad.</p>');
			$this->kajax->hide('.mail_popup_div');
			$this->kajax->show('.mail_response_div');
			$this->kajax->call('modal_dialog_close_timeout(5000)');
		}
		else
		{
			$this->kajax->fancy_log_error( validation_errors() );
		}
		
		$this->kajax_validate_inputs( $rules, '.mail_popup_div' );
		
		$this->kajax->out();
	}
	
	public function mailtechsupport()
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->load->helper('form_validation_helper');
		
		$this->send_mail( $this->input->post(), get_mails_from_string( $this->user->get_support() ) );
	}
	
	public function mailadmsupport()
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->load->model('Company_model');
		
		$this->load->helper('form_validation_helper');
		
		$this->send_mail( $this->input->post(), get_mails_from_string( $this->Company_model->get( $this->user->get_company() )->com_support ) );
	}
	
	public function config()
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->load->model('User_model');
		
		$data['u'] = $this->User_model->get_full( $this->user->get_id(), ARRAY_A );
		
		$this->add_frame_view( 'user_config', $data );
	}
	
	public function save()
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$post = $this->input->post();
			
		if ( $this->user->owns_user( $post['uid'] ) )
		{
			$this->load->library('form_validation');
			
			$rules	= array(
				array(
					'field'   => 'umail', 
					'label'   => 'EMail', 
					'rules'   => 'required|trim|max_length[128]|valid_email'
				),
				array(
					'field'   => 'name', 
					'label'   => 'Nombre', 
					'rules'   => 'required|trim|min_length[2]'
				),
				array(
					'field'   => 'lastname', 
					'label'   => 'Apellido', 
					'rules'   => 'required|trim|min_length[2]'
				),
				array(
					'field'   => 'phone', 
					'label'   => 'Celular', 
					'rules'   => 'trim|min_length[4]'
				),
				array(
					'field'   => 'address', 
					'label'   => 'Domicilio del Titular', 
					'rules'   => 'trim|min_length[4]'
				),
				array(
					'field'   => 'upass', 
					'label'   => 'Contraseña', 
					'rules'   => 'matches[upass_rep]'
				),
				array(
					'field'   => 'upass_rep', 
					'label'   => 'Repetir Contraseña', 
					'rules'   => ''
				)
			);
			
			$this->form_validation->set_rules( $rules );
			
			if ( $this->form_validation->run() != FALSE )
			{
				$user = $this->User_model->get_full( $this->user->get_id(), ARRAY_A );
				
				if (	( !isset( $post['passkey_old'] ) || '' == $post['passkey_old'] ) || 
						( '' != $post['passkey_old'] && $post['passkey_old'] == $user['ui_passkey']  )
				)
				{		
					$this->load->model('User_model');
					
					$post['observations'] = $user['ui_observations'];
					$post['support'] = $user['ui_support'];
					
					if ( !isset( $post['passkey'] ) || '' == $post['passkey'] )
					{
						$post['passkey'] = $user['ui_passkey'];
					}
					
					$this->User_model->update( $post );
					
					$this->kajax->fancy_log_success( 'Usuario ' . $post['uname'] . ' modificado exitosamente.' );
				}
				else
				{
					$this->kajax->fancy_log_error( 'Palabra clave incorrecta' );
				}
			}
			else
			{
				$this->kajax->fancy_log_error( validation_errors() );
			}
			
			$this->kajax_validate_inputs( $rules );
		}
		
		$this->kajax->out();
	}
	
	public function recover_mail()
	{
		$posts = $this->input->post();
		
		$this->load->model('User_model');
		
		$email = isset( $posts['email'] ) ? strtolower( $posts['email'] ) : NULL;
		
		if ( isset( $email ) && ( $user = $this->User_model->from_mail( $email ) ) )
		{
			$token = rand_string(64);
			
			$this->User_model->set_pass_recover( $email, $token );
			
			$link = base_url('/recover/'.$user['uname'].'/'.$token);
			
			$msg = "Alguien recientemente solicitó restablecer la contraseña para la cuenta de usuario {$user['uname']}.

Para asignar una nueva contraseña siga el siguiente link:

$link

Si este email ha sido un error o no lo ha pedido usted mismo, por favor ignórelo, su contraseña no será modificada.";
			
			simple_mail( 'no-responder@reddomo.com.ar', $email, 'DOMO: Recuperar contraseña.', $msg );
			
			$this->kajax->text( '.recover_msg', 'Se ha enviado un email con las instrucciones de cómo recuperar su contraseña.' );
			$this->kajax->hide('.recover_btn');
			$this->kajax->attr('#email', 'disabled', 'disabled');
		}
		else
		{
			$this->kajax->text( '.recover_msg', 'E-mail no registrado.' );
		}
		
		$this->kajax->out();
	}
	
	public function reset_password( $uname, $token )
	{
		$post = $this->input->post();
			
		$this->load->library('form_validation');
		
		$rules	= array(
			array(
				'field'   => 'pass', 
				'label'   => 'Contraseña', 
				'rules'   => 'required|trim|min_length[4]|matches[pass_rep]'
			),
			array(
				'field'   => 'pass_rep', 
				'label'   => 'Repetir Contraseña', 
				'rules'   => ''
			)
		);
		
		$this->form_validation->set_rules( $rules );
		
		if ( $this->form_validation->run() != FALSE )
		{
			$this->load->model('User_model');
			
			$user = $this->User_model->from_user_and_token( $uname, $token );
			
			if ( isset( $user ) )
			{
				$this->User_model->edit_password( $user['uid'], $post['pass'] );
				$this->User_model->reset_pass_recover( $user['uid'] );
				
				$this->kajax->html('.recover_msg', 'Nueva constraseña establecida. Vuelva a ingresar al sitio.' );
				
				$this->kajax->timeout_start();
				$this->kajax->redirect(base_url());
				$this->kajax->timeout_stop( 3000 );
			}
			else
			{
				$this->kajax->html('.recover_msg', 'Los datos proveídos son incorrectos. Error inesperado.' );
			}
		}
		else
		{
			$this->kajax->html('.recover_msg', validation_errors() );
		}
		
		$this->kajax->out();
	}
}
