<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Templates extends PAGE_Controller
{
	public function actions( $hw_id = NULL )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$_GET['hw_id'] = $hw_id;
		
		if ( isset( $hw_id ) && !$this->user->owns_hw( $hw_id ) )
		{
			echo "ACCESO RESTRINGIDO";
			exit;
		}
		else
		{
			$this->session_restrict( USER_TYPE_CPNY );
		}
		
		$this->load->model('ActionsTemplate_model');
		
		$data['actions'] = $this->ActionsTemplate_model->get_data();
		$data['hw'] = array( 'hw_id' => get_var('hw_id') );
		
		$this->add_frame_view( 'template_actions', $data );	
	}
	
	public function events( $hw_id = NULL )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$_GET['hw_id'] = $hw_id;
		
		if ( isset( $hw_id ) && !$this->user->owns_hw( $hw_id ) )
		{
			echo "ACCESO RESTRINGIDO";
			exit;
		}
		else
		{
			$this->session_restrict( USER_TYPE_CPNY );
		}
		
		$this->load->model('EventsTemplate_model');
		
		$data['events'] = $this->EventsTemplate_model->get_data();
		$data['hw'] = array( 'hw_id' => get_var('hw_id') );
		
		$this->add_frame_view( 'template_events', $data );
	}
	
	public function get_new_event_row( $id )
	{
		$this->session_restrict( USER_TYPE_USER );
		$this->kajax->append( '#template_events_table tbody', $this->load->view( 'new_row_events_tpl', array( 'new_id' => $id, 'hw_id' => get_var('hw_id') ), TRUE ) );
		$this->kajax->href('#add_new_but', base_url('/templates/get_new_event_row/'.($id+1) . '?hw_id=' . get_var('hw_id')) );
		$this->kajax->data('#add_new_but', 'number', ($id+1));
		$this->kajax->out();
	}
	
	protected function validate_tpl_field( $id, $row, $type, &$err, $allow_asterisc = FALSE )
	{
		if ( '' != validate_field( $row, $type, TRUE ) && !( $allow_asterisc && '*' == $row ) )
		{
			$this->kajax->addClass( '#'.$id, 'error' );
			
			$err = TRUE;
		}
		else
		{
			$this->kajax->removeClass( '#'.$id, 'error' );
		}
	}
	
	protected function validate_form( $form )
	{
		$err = FALSE;
		
		$this->load->helper( array( 'form_validation' ) );
		
		foreach ( $form as $id=>$row )
		{
			if ( -1 != str_starts_with( 'code', $id ) )
			{
				$this->validate_tpl_field( $id, $row, 'hexa3', $err );
			}
			else if ( -1 != str_starts_with( 'partition', $id ) )
			{
				$this->validate_tpl_field( $id, $row, 'hexa2', $err, TRUE );
			}
			else if ( -1 != str_starts_with( 'zone', $id ) )
			{
				$this->validate_tpl_field( $id, $row, 'hexa3', $err, TRUE );
			}
			else if ( -1 != str_starts_with( 'qualifier', $id ) )
			{
				$this->validate_tpl_field( $id, $row, 'hexa1', $err );
			}
			else if ( -1 != str_starts_with( 'type', $id ) )
			{
				$this->validate_tpl_field( $id, $row, 'hexa2', $err );
			}
			else if ( -1 != str_starts_with( 'mail', $id ) )
			{
				$mails = explode( ",", $row );
				$was_err = FALSE;
				$ferr = FALSE;
				
				foreach ( $mails as $mail )
				{
					$mail = trim( $mail );
					
					if ( strlen( $mail ) && !is_numeric( $mail ) )
					{
						$this->validate_tpl_field( $id, $mail, 'email', $ferr );
						
						if ( $ferr )
						{
							$was_err = $err = TRUE;
						
							break;
						}
					}
					else
					{
						$this->kajax->removeClass( '#'.$id, 'error' );
					}
				}
			}
			else if ( -1 != str_starts_with( 'var', $id ) )
			{
				$this->validate_tpl_field( $id, $row, 'any', $err );
			}
		}
		
		return !$err;
	}
	
	public function event_delete( $id )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$hw_id = get_var('hw_id');
		
		if ( !isset( $hw_id ) )
		{
			$this->session_restrict( USER_TYPE_CPNY );
		}
		
		if ( !isset( $hw_id ) || $this->user->owns_hw( $hw_id ) )
		{
			$this->load->model('EventsTemplate_model');
				
			$this->EventsTemplate_model->delete_id( $id );
				
			$this->kajax->fancy_log_success('Fila eliminada');
			
			$this->kajax->remove( '#row_' . $id );
			$this->kajax->remove( '#row_hidden_' . $id );
		}
		else
		{
			$this->kajax->fancy_log_error('No tienes permisos para borrar filas en la plantilla.');
		}
		
		$this->kajax->out();
	}
	
	protected function kajax_replace_old_new_ids_and_name( $tid, $nid, $elements_base_name )
	{
		foreach( $elements_base_name as $el )
		{
			$this->kajax->attr( '#' . $el . $tid . '_new', 'id', $el . $nid );
			
			$this->kajax->attr( '#' . $el . $nid, 'name', $el . $nid );
			
			$this->kajax->attr( 'label[for="' . $el . $tid . '_new' . '"]', 'for', $el . $nid );
		}
	}
	
	public function events_save()
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$hw_id = get_var('hw_id');
		
		if ( !isset( $hw_id ) )
		{
			$this->session_restrict( USER_TYPE_CPNY );
		}
		
		if ( !isset( $hw_id ) || $this->user->owns_hw( $hw_id ) )
		{
			$post = get_real_post();
			
			if ( $this->validate_form( $post ) )
			{
				$this->load->model('EventsTemplate_model');
				
				$new_ids = $this->EventsTemplate_model->update_all( $post );
				
				if ( isset( $new_ids ) && !empty( $new_ids ) )
				{
					$wi_hw = ( isset( $hw_id ) ? '/?hw_id=' . $hw_id : '' );
					
					foreach ( $new_ids as $tid => $nid )
					{
						$this->kajax_replace_old_new_ids_and_name( $tid, $nid, array( 'row_', 'row_hidden_', 'type_id_', 'qualifier_id_', 'code_id_', 'partition_id_', 'zone_id_', 'var_id_', 'emergency_id_', 'notifications_id_', 'filter_act_id_', 'mail_id_' ) );
						
						$this->kajax->call( 'table_row_new_convert_to_id( ' . $nid . ', "id", "' . base_url('/templates/event_delete/' . $nid . $wi_hw) . '", "¿Seguro que quiere eliminar esta fila?" )' );
						
						$this->kajax->remove("#row_hidden_{$nid} button.cancel_btn");
					}
				}
				
				$this->kajax->fancy_log_success('Plantilla de Eventos Guardada');
			}
			else
			{
				$this->kajax->fancy_log_error('La plantilla contiene errores.');
			}
		}
		else
		{
			$this->kajax->fancy_log_error('No tienes permisos para editar esta plantilla.');
		}
		
		$this->kajax->out();
	}
	
	public function actions_save()
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$hw_id = get_var('hw_id');
		
		if ( !isset( $hw_id ) )
		{
			$this->session_restrict( USER_TYPE_CPNY );
		}
		
		$post = get_real_post();
		
		if ( !isset( $hw_id ) || $this->user->owns_hw( $hw_id ) )
		{
			if ( $this->validate_form( $post ) )
			{
				$this->load->model('ActionsTemplate_model');
				
				$this->ActionsTemplate_model->update_all( $post );
				
				$this->kajax->fancy_log_success('Plantilla de Acciones Guardada');
			}
			else
			{
				$this->kajax->fancy_log_error('La plantilla contiene errores.');
			}
		}
		else
		{
			$this->kajax->fancy_log_error('No tienes permisos para editar esta plantilla.');
		}
		
		$this->kajax->out();
	}
	
	public function help()
	{
		$this->load->view('templates_help');
	}
}
