<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Software extends PAGE_Controller
{
	public static $CONF_RECEIVER = 1;
	public static $CONF_HW = 2;
	public static $CONF_JSON = 3;
	
	protected $files_expected		= array();
	protected $files_zip			= array();
	protected $file_path			= TMPPATH;
	protected $file_cfg_name		= 'config.ini';
	protected $file_name			= 'update.zip';
	protected $script_file_name		= 'script.zip';
	protected $json_config_name		= 'domo_config.json';
	
	public function config_json_soft()
	{
		$this->session_restrict( USER_TYPE_GOD );
		
		$this->load->model('Company_model');
		
		$data['type']			= 'json_config';
		$data['companies']		= $this->Company_model->get_all_names();
		$data['url']			= base_url('/software/upload_conf_json');
		
		$this->load->view( 'soft_config', $data );
	}
	
	public function config_hw()
	{
		$this->session_restrict( USER_TYPE_GOD );
		
		$this->load->model('Company_model');
		
		$data['type']			= 'hw';
		$data['companies']		= $this->Company_model->get_all_names();
		$data['url']			= base_url('/software/upload_conf_hw');
		
		$this->load->view( 'soft_config', $data );
	}
	
	public function config_receiver()
	{
		$this->session_restrict( USER_TYPE_GOD );
		
		$this->load->model('Company_model');
		
		$data['type']			= 'receiver';
		$data['companies']		= $this->Company_model->get_all_names();
		$data['url']			= base_url('/software/upload_conf_receiver');
		
		$this->load->view( 'soft_config', $data );
	}
	
	public function receiver()
	{
		$this->session_restrict( USER_TYPE_GOD );
		
		$this->load->model('Software_model');
		
		$data['companies'] = $this->Software_model->get_receivers_by_company();
		
		$this->add_frame_view( 'soft_receiver_companies', $data );
	}
	
	public function index()
	{
		$this->receiver();
	}
	
	protected function check_files_existence()
	{
		$c = count( $this->files_expected );
		
		for ( $i = 0; $i < $c; $i++ )
		{
			if ( !isset( $this->files_zip[ $this->files_expected[$i] ] ) )
			{
				return false;
			}
		}
		
		return true;
	}
	
	protected function file_update_validate( $path, &$ok )
	{
		$this->load->model('Software_model');
		
		$zip = new ZipArchive();
		
		if ( $zip->open( $path ) )
		{
			for( $i = 0; $i < $zip->numFiles; $i++ )
			{
				$stat = $zip->statIndex( $i );
				
				$this->files_zip[ $stat['name'] ] = $stat;
			}
			
			$zip->close();
			
			if ( $this->check_files_existence() )
			{
				$newpath = $this->file_path . $this->file_name;
				
				rename( $path, $newpath );
				
				// All required files are inside the zipfile
				$file_hash = hash_file( 'md5', $newpath );
				$file_size = filesize( $newpath );
				
				$last_insert = $this->Software_model->soft_update_get_last( get_post('com_id') );
				
				if ( isset( $last_insert ) )
				{
					if ( $last_insert->sr_hash == $file_hash )
					{
						$ok = FALSE;
						return ( 'La versi&oacute;n actual es la misma que la subida.' );
						
						unlink( $newpath );
						
						return;
					}
				}
				
				$id = $this->Software_model->soft_update_add( $file_hash, $file_size, get_post('com_id') );
				
				$finalpath = ROOTPATH . '/soft/downloads/';
				$finalfile = $finalpath . $this->file_name . '.' . $file_hash;
				
				copy( $newpath, $finalfile );
				
				unlink( $newpath );
				
				$ok = TRUE;
				return ( 'Nueva versi&oacute;n subida al servidor, en unos minutos se distribuir&aacute; en la receptora de la empresa indicada.' );
			}
			else
			{
				// We are frakked
				unlink( $path );
				
				// fatal error
				$ok = FALSE;
				return ( 'Faltan archivos base dentro del archivo zip.' );
			}
		}
		else
		{
			// We are frakked
			unlink( $path );
			
			// fatal error
			$ok = FALSE;
			return ( 'No se pudo abrir el archivo, probablemente no sea un zip v&aacute;lido.' );
		}
	}
	
	public function upload_soft()
	{
		$this->session_restrict( USER_TYPE_GOD );
		
		$this->load->library( 'UploadHandler', array( 
			'script_url' => base_url('/software/upload_soft/'),
			'accept_file_types' => '/\.(zip)$/i'
		) );
		
		$resp = $this->uploadhandler->post(false);
		$ok = FALSE;
		
		if ( isset( $resp['files'][0] ) && file_exists( TMPPATH . $resp['files'][0]->name ) )
		{
			$full_path	= TMPPATH . $resp['files'][0]->name;
			
			$result = $this->file_update_validate( $full_path, $ok );
		}
		else
		{
			$result = "Fallo al subir el archivo.";
		}
		
		if ( $ok )
		{
			$this->kajax->fancy_log_success( $result );
		}
		else
		{
			$this->kajax->fancy_log_error( $result );
		}
		
		$this->kajax->reload_target();
		
		$this->kajax->out();
	}
	
	protected function file_validate( $path, $com_id, $type )
	{
		$this->load->model('Company_model');
		$this->load->model('Software_model');
		
		if ( isset( $com_id ) && intval( $com_id ) && ( $company = $this->Company_model->get( $com_id ) ) )
		{
			$file_hash = hash_file( 'md5', $path );
			$file_size = filesize( $path );
			
			if ( $type == self::$CONF_RECEIVER )
			{
				$last_insert = $this->Software_model->soft_config_get_last( $com_id );
				
				if ( isset( $last_insert ) )
				{
					if ( $last_insert->sc_hash == $file_hash )
					{
						unlink( $path );
						
						return 'La versi&oacute;n actual es la misma que la subida.';
					}
				}
				
				$id			= $this->Software_model->soft_config_add( $file_hash, $file_size, $com_id );
				$finalpath	= ROOTPATH . '/soft/config/';
				$finalfile	= $finalpath . $this->file_cfg_name . '.' . $file_hash;
			}
			else if ( $type == self::$CONF_HW )
			{
				$last_insert = $this->Software_model->soft_script_get_last( $com_id );
				
				if ( isset( $last_insert ) )
				{
					if ( $last_insert->ss_hash == $file_hash )
					{
						unlink( $path );
						
						return 'La versi&oacute;n actual es la misma que la subida.';
					}
				}
				
				$id			= $this->Software_model->soft_script_add( $file_hash, $file_size, $com_id );
				$finalpath	= ROOTPATH . '/soft/script/';
				$finalfile	= $finalpath . $this->script_file_name . '.' . $file_hash;
			}
			else if ( $type == self::$CONF_JSON )
			{
				$last_insert = $this->Software_model->soft_json_config_get_last( $com_id );
				
				if ( isset( $last_insert ) )
				{
					if ( $last_insert->sjc_hash == $file_hash )
					{
						unlink( $path );
						
						return 'La versi&oacute;n actual es la misma que la subida.';
					}
				}
				
				$id			= $this->Software_model->soft_json_config_add( $file_hash, $file_size, $com_id );
				$finalpath	= ROOTPATH . '/soft/json_config/';
				$finalfile	= $finalpath . $this->json_config_name . '.' . $file_hash;
			}
			
			copy( $path, $finalfile );
			
			unlink( $path );
			
			return 'Nueva configuraci&oacute;n subida. La receptora estar&aacute; recibiendo la actualizaci&oacute;n en los pr&oacute;ximos minutos.';
		}
		else
		{
			return 'Selecciona una empresa';
		}
	}
	
	public function upload_conf_receiver()
	{
		$this->session_restrict( USER_TYPE_GOD );
		
		$this->load->library( 'UploadHandler', array( 
			'script_url' => base_url('/software/upload_conf_receiver/'),
			'accept_file_types' => '/\.(zip)$/i'
		) );
		
		$resp = $this->uploadhandler->post(false);
		
		if ( isset( $resp['files'][0] ) && file_exists( TMPPATH . $resp['files'][0]->name ) )
		{
			$full_path	= TMPPATH . $resp['files'][0]->name;
			
			$resp['files'][0]->result = $this->file_validate( $full_path, get_post( 'company' ), self::$CONF_RECEIVER );
		}
		
		echo json_encode( $resp );
	}
	
	public function upload_conf_hw()
	{
		$this->session_restrict( USER_TYPE_GOD );
		
		$this->load->library( 'UploadHandler', array( 
			'script_url' => base_url('/software/upload_conf_hw/'),
			'accept_file_types' => '/\.(ini)$/i'
		) );
		
		$resp = $this->uploadhandler->post(false);
		
		if ( isset( $resp['files'][0] ) && file_exists( TMPPATH . $resp['files'][0]->name ) )
		{
			$full_path	= TMPPATH . $resp['files'][0]->name;
			
			$resp['files'][0]->result = $this->file_validate( $full_path, get_post( 'company' ), self::$CONF_HW );
		}
		
		echo json_encode( $resp );
	}
	
	public function upload_conf_json()
	{
		$this->session_restrict( USER_TYPE_GOD );
		
		$this->load->library( 'UploadHandler', array( 
			'script_url' => base_url('/software/upload_conf_json/'),
			'accept_file_types' => '/\.(json)$/i'
		) );
		
		$resp = $this->uploadhandler->post(false);
		
		if ( isset( $resp['files'][0] ) && file_exists( TMPPATH . $resp['files'][0]->name ) )
		{
			$full_path	= TMPPATH . $resp['files'][0]->name;
			
			$resp['files'][0]->result = $this->file_validate( $full_path, get_post( 'company' ), self::$CONF_JSON );
		}
		
		echo json_encode( $resp );
	}
	
	public function receiver_help()
	{
		$this->load->view('receiver_help');
	}
}
