<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Scripts extends PAGE_Controller
{
	public function get_date()
	{
		echo strftime( "%m%d%H%M%Y.%S" );
	}
	
	public function template_migrate_events_from_company( $com_id = NULL )
	{
		$this->session_restrict( USER_TYPE_GOD );
		
		$this->load->model('Company_model');
		
		if ( isset( $com_id ) && $this->Company_model->exists( $com_id ) )
		{
			$this->load->model('EventsTemplate_model');
			
			$this->EventsTemplate_model->migrate_events_from_company( $com_id );
		}
	}
	
	public function template_migrate_events_from_hw( $hw_id = NULL, $com_id = NULL )
	{
		$this->session_restrict( USER_TYPE_GOD );
		
		$this->load->model('Company_model');
		$this->load->model('Hardware_model');
		
		if ( isset( $com_id ) && isset( $hw_id ) && $this->Company_model->exists( $com_id ) && $this->Hardware_model->exists( $hw_id ) )
		{
			$this->load->model('EventsTemplate_model');
		
			$this->EventsTemplate_model->copy_events_from_hw_to_company( $hw_id, $com_id );
		}
	}
	
	public function build_js_cache()
	{
		$this->render_js();
		
		echo get_var('build_js_cache') . "\n";
	}
	
	function fix_com_id( $com_df_id, $com_rec_id )
	{
		if ( !isset( $com_df_id ) || !isset( $com_rec_id ) )
			return;
		
		
		$this->load->model('Company_model');
		$this->load->model('Hardware_model');
		
		$com = $this->Company_model->get_company_from_df_anc_rec( $com_df_id, $com_rec_id );
		
		if ( isset( $com ) )
		{
			$this->Hardware_model->fix_broken_com_id( $com['com_id'], $com_df_id, $com_rec_id );
		}
	}
	
	public function recache( $sec )
	{
		if ( 'bodhisattva' == $sec )
		{
			opcache_reset();
		}
	}
	
	public function import_rfid_users( $com_id )
	{
		if ( 'QAXZoF7vyNaVgS2ut6ixOwuMuw7TxmMt7JOs0fnly8blfgzi0LlhjKb4mSLtaIO2' == get_var( 'code' ) )
		{
			$this->load->model('RfidUser_model');
			$this->load->model('RfidUserPlot_model');
			
			$file	= get_var( 'file' );
			$file	= ROOTPATH . $file;
			
			if ( file_exists( $file ) )
			{
				$string = file_get_contents( $file );
				
				$buffers	= explode( "\n", $string );
				$len		= count( $buffers );
				$guesssep	= '' != get_var( 'guesssep', TRUE );
				$separator	= ',';
				$type		= RfIdUserType::OWNER;
			
				for ( $c = 0; $c < $len; $c++ )
				{
					$buffer	= $buffers[ $c ];
					$err	= false;
					$edit	= false;
					$buflen	= strlen( $buffer );
					$buffer	= ( $buflen >= 1 && $buffer[ $buflen - 1 ] == "\n" ) ? substr( $buffer, 0, $buflen - 1 ) : $buffer;
					$buffer = str_replace( '"', '', $buffer );
					
					if ( $guesssep )
					{
						$guesssep	= false;
						$c2			= substr_count( $buffer, ';' );
						
						if ( $c2 > 0 )
						{
							$separator = ';';
						}
					}
					
					$data	= explode( $separator, $buffer );
					$msg	= '';
					$cdata	= count( $data );
					
					if ( $cdata >= 2 )
					{
						$name = ucwords( strtolower( preg_replace('/\s+/', ' ', $data[0] ) ) );
						$plot = intval(trim($data[1]));
						$phone = '';
						
						if ( $cdata >= 3 )
						{
							$phone = preg_replace('/\s+/', ' ', $data[2] );
						}
						
						$person = $this->RfidUser_model->get_by_name( $name, $com_id );
						
						if ( !isset( $person ) )
						{
							$urfid_id = $this->RfidUser_model->add( $type, $com_id, $name, $plot, '', $phone, '' );
							echo "Added person $name" . ( '' != $phone ? " $phone" : '' ) . "\n<br/>";
						}
						else
						{
							$urfid_id = $person['urfid_id'];
							echo "Person $name already existed\n<br/>";
						}
						
						if ( !$this->RfidUserPlot_model->has_plot( $urfid_id, $plot ) )
						{
							$this->RfidUserPlot_model->add( $urfid_id, $plot );
							echo "Added plot $plot\n<br/>";
						}
					}
				}
				
				echo "OK";
			}
			else
			{
				echo "Wrong file";
			}
		}
		else
		{
			echo "Wrong code";
		}
	}
	
	public function create_dshield_users()
	{
		if ( 'QAXZoF7vyNaVgS2ut6ixOwuMuw7TxmMt7JOs0fnly8blfgzi0LlhjKb4mSLtaIO2' == get_var( 'code' ) )
		{
			$this->load->model('Company_model');
			$this->load->model('RfidUser_model');
			$this->load->model('User_model');
			
			$fields = array(
				array( 
					'field_name'	=> 'urfid_user_type',
					'filter_val'	=> RfIdUserType::OWNER
				)
			);
			
			$query_filter = SQL::build_query_filter( $fields );
			
			$this->db->trans_start();
			
			$rusers = $this->RfidUser_model->get_all( NULL, $query_filter );
			
			if ( isset( $rusers ) )
			{
				foreach ( $rusers as $ruser )
				{
					$data['uname'] = DSHIELD_BASE_USER_NAME . $ruser['urfid_plot'];
					$data['upass'] = $ruser['urfid_dni'];
					$data['umail'] = '';
					$data['name'] = '';
					$data['lastname'] = $ruser['urfid_name'];
					$data['phone'] = $ruser['urfid_phone'];
					$data['address'] = '';
					$data['support'] = '';
					$data['passkey'] = '';
					$data['observations'] = '';
					$data['ui_type'] = UserInfoType::USER_INFO_TYPE_DSHIELD;
					
					$uid = $this->User_model->create( $data, $ruser['urfid_com_id'], $this->Company_model->get_city( $ruser['urfid_com_id'] ) );
					
					$this->RfidUser_model->update_uid( $ruser['urfid_id'], $uid );
					
					echo "Created:\n" . json_enc( $data, TRUE ) . "\n\n";
				}
			}
			
			$this->db->trans_complete();
		}
	}
	
	public function gen_rfid_events()
	{
		$this->load->model('RfidEvent_model');
		
		for ( $i = 43680; $i < 43682; $i++ )
		{
			$this->RfidEvent_model->add( 844295169, $i, RfidType::RFID, RfidCommandType::ADD, time(), 2, 'PENDING_SEND', NULL );
			$this->RfidEvent_model->add( 844295169, $i, RfidType::OPEN, RfidEventType::ENTRY, time(), 2, 'PENDING_SEND', NULL );
		}
	}
	
	public function delete_faulty_hwgl()
	{
		if ( 'QAXZoF7vyNaVgS2ut6ixOwuMuw7TxmMt7JOs0fnly8blfgzi0LlhjKb4mSLtaIO2' == get_var( 'code' ) )
		{
			$sql = "SELECT hardware_group_link.* FROM hardware_group_link INNER JOIN hardware ON hw_id = hwgl_hw_id INNER JOIN hardware_group ON hwgl_group = hwg_id WHERE hw_company != hwg_company ORDER BY hwgl_group ASC, hwgl_hw_id ASC";
			
			$res = $this->db->get_results( $sql, ARRAY_A );
			
			if ( isset( $res ) )
			{
				$this->db->trans_start();
				
				foreach ( $res as $hwgl )
				{
					echo "DELETED hwgl_group " . $hwgl['hwgl_group'] . " hwgl_hw_id " . $hwgl['hwgl_hw_id'] . "\n<br/>";
					
					$this->db->query( 'DELETE FROM hardware_group_link WHERE hwgl_group = ? AND hwgl_hw_id = ?', array( $hwgl['hwgl_group'], $hwgl['hwgl_hw_id'] ) );
				}
				
				$this->db->trans_complete();
			}
		}
	}
	
	public function upgrade_rfid_events()
	{
		if ( 'QAXZoF7vyNaVgS2ut6ixOwuMuw7TxmMt7JOs0fnly8blfgzi0LlhjKb4mSLtaIO2' == get_var( 'code' ) )
		{
			set_time_limit(0);
			
			$this->load->model('RfidEvent_model');
			
			$filter				= array(
				array(
					'field_name'	=> 're_user',
					'filter_val'	=> NULL,
					'accept_null'	=> TRUE,
					'filter_type'	=> SQLFilterType::UNEQUALS
				),
				array(
					'field_name'	=> 're_user_data',
					'filter_val'	=> NULL,
					'accept_null'	=> TRUE,
					'filter_type'	=> SQLFilterType::EQUALS
				),
				array(
					'order_by'		=> get_var_def( 'order_by', 're_timestamp' ),
					'order_fields'	=> array( 're_user', 're_user_name', 're_user_dni', 're_user_plate', 're_timestamp', 'urfid_plot' ),
					'order_dir'		=> get_var_def( 'order_dir', 'DESC' )
				)
			);
			
			$builded_filter = SQL::build_query_filter( $filter );
			
			$event_count = $this->RfidEvent_model->count( NULL, $builded_filter );
			
			echo "Event count: $event_count<br/>\n";
			
			$page_size = 100;
			
			if ( $event_count > 0 )
			{
				$event_parts = intval( $event_count / $page_size ) + 1;
				
				for ( $i = 0; $i < $event_parts; $i++ )
				{
					$this->db->trans_start();
					
					$events = $this->RfidEvent_model->get_all( NULL, $builded_filter, $page_size, $i+1, 're_id, re_user' );
					
					if ( isset( $events ) )
					{
						foreach ( $events as $event )
						{
							if ( NULL != $event['re_user'] )
							{
								$this->RfidEvent_model->update_user_data( $event['re_id'], $event['re_user'] );
							}
						}
					}
					
					$this->db->trans_complete();
				}
			}
		}
	}
	
	public function send_mail()
	{
		if ( 'QAXZoF7vyNaVgS2ut6ixOwuMuw7TxmMt7JOs0fnly8blfgzi0LlhjKb4mSLtaIO2' == get_var( 'code' ) )
		{
			$mails = get_post('recipient');
			$from = get_post('from') != NULL ? get_post('from') : "no-responder@reddomo.com.ar";
			$subj = get_post('subject');
			$msg = get_post('message');
			
			if ( !empty($mails) && !empty($subj) && !empty($msg) )
			{
				simple_mail( $from, $mails, $subj, $msg );
				
				echo "Mail sent";
			}
			else
			{
				echo "Missing parameters";
			}
		}
		else
		{
			echo "Wrong validation code";
		}
	}
	
	public function dbstats()
	{
		$this->load->library('table');
		
		$res = $this->db->get_results('SELECT * FROM pg_stat_activity ORDER BY state ASC, query_start ASC', ARRAY_A);
		
		if ( isset( $res ) )
		{
			echo "<h4>Current Queries</h4>";
			$this->table->set_heading(array_keys($res[0]));
			echo $this->table->generate($res);
		}
	}
	
	public function requeststats()
	{
		$this->load->library('table');
		
		$res = load_model('RequestTracker_model')->get_all();
		
		if ( isset( $res ) )
		{
			echo "<h4>Number of requests by company in the last 5 minutes.</h4>";
			$this->table->set_heading(array_keys($res[0]));
			echo $this->table->generate($res);
		}
	}
	
	public function recover_hardware_backup()
	{
		if ( 'QAXZoF7vyNaVgS2ut6ixOwuMuwasxmMt7JOs0fnly8blfgzi0LlhjKb4mSLtaIO2' == get_var( 'code' ) )
		{
			
			$sql = "
			UPDATE hardware 
			SET 
				hw_lat = hb.hw_lat,
				hw_long = hb.hw_long,
				hw_address = hb.hw_address,
				hw_icon = hb.hw_icon,
				hw_setup_signal = hb.hw_setup_signal,
				hw_inst_time = hb.hw_inst_time,
				hw_setup_signal_filtered = hb.hw_setup_signal_filtered,
				hw_info = hb.hw_info,
				hw_imei = hb.hw_imei,
				hw_create_time = hb.hw_create_time,
				hw_core = hb.hw_core,
				hw_last_message = hb.hw_last_message,
				hw_is_kpanel = hb.hw_is_kpanel,
				hw_inst_time_3g = hb.hw_inst_time_3g,
				hw_setup_signal_3g = hb.hw_setup_signal_3g,
				hw_setup_signal_total_3g = hb.hw_setup_signal_total_3g,
				hw_setup_signal_total_xbee = hb.hw_setup_signal_total_xbee,
				hw_is_city7 = hb.hw_is_city7
			FROM
				(  SELECT * FROM hardware_bck ) AS hb
			WHERE 
				hardware.hw_serial = hb.hw_serial
			";
			
			$com_id = get_var( 'com_id' );
			
			if ( isset( $com_id ) )
			{
				$sql .= ' AND hb.hw_company = ' . intval( $com_id );
			}
			
			$this->db->query( $sql );
		}
		else
		{
			echo "Wrong validation code";
		}
	}
	
	public function delete_duplicate_radar_events()
	{
		if ( 'QAXZoF7vyNaVgS2ut6ixOwuMuwasxmMtsJOs0fnly8blfgzi0LlhjKb4mSLtaIO2' == get_var( 'code' ) )
		{
			$sql = "SELECT re_rd_serial, re_timestamp, COUNT(re_timestamp) FROM radar_event
					WHERE re_timestamp >  (extract(epoch from now()) - 3600*24*30)
					GROUP BY re_rd_serial, re_timestamp
					HAVING COUNT(re_timestamp) > 1 
					ORDER BY re_rd_serial ASC, re_timestamp ASC";
			
			$res = $this->db->get_results( $sql, ARRAY_A );
			
			if ( isset( $res ) )
			{
				foreach ( $res as $r )
				{
					$rsql = "SELECT re_id, re_image FROM radar_event WHERE re_rd_serial = ? AND re_timestamp = ? ORDER BY re_id DESC";
					
					$events = $this->db->get_results( $rsql, ARRAY_A, array( $r['re_rd_serial'], $r['re_timestamp'] ) );
					
					foreach ( $events as $re )
					{
						if ( file_exists( FINESPATH . $re['re_image'] ) )
						{
							echo "Deleted image for radar_event " . $re['re_id'] . "<br/>";
							
							unlink( FINESPATH . $re['re_image'] );
						}
						else
						{
							echo "Tried to delete image: " . FINESPATH . $re['re_image'] . " but does not exists.<br/>";
						}
						
						echo "Deleted duplicate radar events for serial: " . $r['re_rd_serial'] . " and timestamp " . $r['re_timestamp'];
						
						$dsql = "DELETE FROM radar_event WHERE re_rd_serial = ? AND re_timestamp = ? AND re_id != ( SELECT re_id FROM radar_event WHERE re_rd_serial = ? AND re_timestamp = ? ORDER BY re_id ASC LIMIT 1 )";
						
						$this->db->query( $dsql, array( $r['re_rd_serial'], $r['re_timestamp'], $r['re_rd_serial'], $r['re_timestamp'] ) );
						
						flush();
						
						ob_flush();
						
						if ( null != get_var_def( 'test', null ) )
						{
							exit(0);
						}
					}
				}
			}
		}
	}
}
