<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Rfid extends DSHIELD_Controller
{
	public function citymesh_show()
	{
		$this->session_restrict( USER_TYPE_CPNY_RO );
		
		$this->load->model('RfidCitymesh_model');
		
		$data['citymesh'] = $this->RfidCitymesh_model->get_all( $this->user->get_company_ids() );
		
		$this->load->view( 'dshield/citymesh_select', $data );
	}
	
	public function citymesh_set()
	{
		$this->session_restrict( USER_TYPE_CPNY_RO );
		
		$selected = get_post( 'selected' );
		
		$this->load->model('RfidUserCitymesh_model');
		
		if ( isset( $selected ) )
		{
			$sel = explode( ',', $selected );
			
			if ( isset( $sel ) && count( $sel ) > 0 && '' != $sel[0] )
			{
				$this->RfidUserCitymesh_model->clean_and_add( $this->user->get_user_id(), $sel );
			}
			else
			{
				$this->RfidUserCitymesh_model->delete( $this->user->get_user_id() );
			}
		}
		else
		{
			$this->RfidUserCitymesh_model->delete( $this->user->get_user_id() );
		}
	}
	
	public function jobs()
	{
		$this->session_restrict( USER_TYPE_CPNY_RO );
		
		$this->load->model('RfidEvent_model');
		
		$data['events'] = !$this->user->is_professional() ? $this->RfidEvent_model->get_pending_events( $this->user->get_user_id(), $this->user->get_company() ) : null;
		
		echo json_enc( $data );
	}
	
	public function pair( $urfid_id )
	{
		if ( isset( $this->user ) && ( $this->user->is_guard() || $this->user->is_professional() ) && $this->input->is_ajax_request() )
		{
			$this->kajax->call('modal_dialog_close()');
			$this->kajax->reload_target();
			$this->kajax->out(TRUE);
			exit;
		}
		
		$this->session_restrict( USER_TYPE_CPNY_RO );
		
		$this->load->model('RfidUser_model');
		$this->load->model('RfidEvent_model');
		
		if ( $this->user->owns_person( $urfid_id ) )
		{
			$data['person'] = $this->RfidUser_model->get( $urfid_id );
			
			$data['re_id'] = $this->RfidEvent_model->get_last_id();
			
			if ( null != get_var('adding_person' ) )
			{
				$data['adding_person'] = TRUE;
			}
			
			$this->load->view('dshield/person_rfid_pairing', $data );
		}
	}
	
	protected function build_pairing_filters()
	{
		$this->load->model('RfidCitymesh_model');
		
		$filter				= array(
			array(
				'field_name'	=>	're_timestamp',
				'filter_val'	=>	get_post( 'time' ),
				'filter_type'	=>	SQLFilterType::BIGGER_OR_EQ
			),
			array(
				'field_name'	=>	're_id',
				'filter_val'	=>	get_post( 're_id' ),
				'filter_type'	=>	SQLFilterType::BIGGER
			),
			array(
				'field_name'	=>	'rc_type',
				'filter_val'	=>	RfidCitymeshType::UNKNOWN
			),
			array(
				'order_by'		=> get_var_def( 'order_by', 're_timestamp' ),
				'order_fields'	=> array( 're_timestamp' ),
				'order_dir'		=> get_var_def( 'order_dir', 'DESC' )
			)
		);
		
		return SQL::build_query_filter( $filter );
	}
	
	public function unpair( $urfid_id = null )
	{
		$this->session_restrict( USER_TYPE_CPNY_RO );
		
		$this->load->model('RfidUser_model');
		
		$resp['result'] = 'error';
		
		if ( isset( $urfid_id ) && $this->user->owns_person( $urfid_id ) )
		{
			$this->load->model('Rfid_model');
			$this->load->model('RfidEvent_model');

			$event = $this->RfidEvent_model->get_last_urfid_event( $urfid_id );
			
			if ( isset( $event ) )
			{
				$this->Rfid_model->unassign_person_by_urfid_id( $urfid_id );
				
				$this->RfidUser_model->allow( $urfid_id );
				
				$this->RfidEvent_model->set_serial_accept_on_pending_validation( $event['re_serial'] );
				
				$this->RfidEvent_model->add_all( $event['re_serial'], RfidType::RFID, RfidCommandType::ERASE, time(), $event['re_com_id'], 'PENDING_SEND', $urfid_id );
				
				$resp['result'] = 'ok';
			}
		}
		
		echo json_encode( $resp );
	}
	
	public function pairing()
	{
		$this->session_restrict( USER_TYPE_CPNY_RO );
		
		$urfid_id = get_post('urfid_id');
		
		if ( $this->user->owns_person( $urfid_id ) )
		{
			$this->load->model('RfidEvent_model');
			
			$events = $this->RfidEvent_model->get_rejected_events( $this->user->get_company(), $this->build_pairing_filters() );
			
			$resp['result'] = 'waiting';
			
			if ( isset( $events ) && !empty( $events ) )
			{
				$event = $events[0];
				
				$this->load->model('Rfid_model');
				
				if ( NULL == ( $urfid_id_other = $this->Rfid_model->is_assigned_to_other_person( $event['re_serial'], $urfid_id ) ) )
				{
					if ( !$this->Rfid_model->is_assigned_to_me( $event['re_serial'], $urfid_id ) )
					{
						$person = $this->RfidUser_model->get( $urfid_id );
						
						$this->Rfid_model->update_person( $event['re_serial'], $urfid_id );
						
						$this->RfidEvent_model->set_serial_accept_on_pending_validation( $event['re_serial'] );
						
						$add_type = $person['urfid_user_type'] == RfIdUserType::GUARD ? RfidCommandType::ADD_VIP : RfidCommandType::ADD;
						
						// Register the RFID in Citymesh
						$this->RfidEvent_model->add_all( $event['re_serial'], RfidType::RFID, $add_type, time(), $event['re_com_id'], 'PENDING_SEND', $urfid_id );
						
						$resp['result'] = 'ok';
					}
					else
					{
						$resp['result'] = 'assigned';
					}
				}
				else
				{
					$resp['result'] = 'exists';
					$resp['person'] = $this->RfidUser_model->get( $urfid_id_other );
				}
			}
		}
		
		echo json_encode( $resp );
	}
	
	protected function build_family_filter( $urfid_id, $plots, $user_type = NULL )
	{
		$filter				= array(
			array(
				'field_name'	=>	'urfid_id',
				'filter_val'	=>	$urfid_id,
				'filter_type'	=>	SQLFilterType::UNEQUALS
			),
			array(
				'field_name'	=>	'rup_plot',
				'filter_val'	=>	$plots
			),
			array(
				'field_name'	=>	'urfid_user_type',
				'filter_val'	=>	array( RfIdUserType::NEIGHBOR, RfidUserType::OWNER )
			),
			array(
				'order_by'		=>	get_var_def( 'order_by', 'urfid_name' ),
				'order_fields'	=>	array( 'urfid_name' ),
				'order_dir'		=>	get_var_def( 'order_dir', 'ASC' )
			),
			array(
				'join'			=>	'rfid_user_plot',
				'on'			=>	'urfid_id = rup_urfid_id',
				'type'			=>	'LEFT'
			)
		);
		
		return SQL::build_query_filter( $filter );
	}
	
	protected function get_event_data( $urfid_id, $rc_type, $person = NULL )
	{
		$this->load->model('RfidUser_model');
		$this->load->model('RfidUserPlot_model');
		$this->load->model('RfidEvent_model');
		$this->load->model('RfidGallery_model');
		
		$event = $person;
		$data['person'] = $person = $this->RfidUser_model->get( $urfid_id );
		$data['user_data'] = $user_data = json_decode( $data['person']['urfid_user_data'], TRUE );
		
		$plots = $this->RfidUserPlot_model->get_arr( $person['urfid_id'] );
		
		if ( NULL != $plots && NULL != $person && ( $person['urfid_user_type'] == RfIdUserType::OWNER || $person['urfid_user_type'] == RfIdUserType::NEIGHBOR ) )
		{
			$data['family'] = $this->RfidUser_model->get_all( $this->user->get_company_ids(), $this->build_family_filter( $urfid_id, $plots ) );
		}
		
		$rc_id = NULL;
		
		if ( isset( $event['rc_id'] ) )
		{
			$rc_id = $event['rc_id'];
		}
		else
		{
			$this->load->model('RfidUserCitymesh_model');
			$rcitymesh = $this->RfidUserCitymesh_model->get_citymesh_type_from_user( $this->user->get_user_id(), $rc_type );
			
			if ( isset( $rcitymesh ) )
			{
				$rc_id = $rcitymesh['rc_id'];
			}
		}
		
		$data['tools_photos'] = $this->RfidGallery_model->get_gallery_photos( $urfid_id, RfidGalleryType::TOOLS );
		$data['general_photos'] = $this->RfidGallery_model->get_gallery_photos( $urfid_id, RfidGalleryType::GENERAL );
		$data['insurance_photos'] = $this->RfidGallery_model->get_gallery_photos( $urfid_id, RfidGalleryType::INSURANCE );
		
		return array_merge( $data, $this->RfidEvent_model->get_event_result( $urfid_id, $rc_id, $person ) );
	}
	
	protected function get_event_result( $urfid_id, $rc_id )
	{
		$this->load->model('RfidEvent_model');
		
		$data = $this->RfidEvent_model->get_event_result( $urfid_id, $rc_id );
		
		return $data['re_result'];
	}
	
	public function event_show( $re_id, $serial )
	{
		$this->session_restrict( USER_TYPE_CPNY_RO );
		
		if ( $this->user->owns_rfid( $serial ) )
		{
			$this->load->model('RfidCitymesh_model');
			$this->load->model('RfidEvent_model');
			
			$event = $this->RfidEvent_model->get_event( $re_id );
			
			if ( isset( $event ) )
			{
				$data = $this->get_event_data( $event['urfid_id'], $event['rc_type'], $event );
				
				$data['event'] = $event;
				$data['citymesh'] = $this->RfidCitymesh_model->get( $event['re_code'], $this->user->get_company() );
				
				if ( isset( $data['citymesh'] ) )
				{
					$data['rc_type'] = $data['citymesh']['rc_type'];
				}
				
				$this->load->view('dshield/rfid_event_show', $data );
			}
		}
	}
	
	public function event_show_dni( $dni, $rc_type )
	{
		$this->session_restrict( USER_TYPE_CPNY_RO );
		
		$this->load->model('RfidUser_model');
		
		$person = $this->RfidUser_model->get_by_dni( $dni, $this->user->get_company_ids() );
		
		if ( isset( $person ) )
		{
			if ( $this->user->owns_person( $person['urfid_id'] ) )
			{
				$data = $this->get_event_data( $person['urfid_id'], $rc_type, $person );
				
				$data['citymesh']['rc_type'] = $data['rc_type'] = $rc_type;
				
				$this->load->view('dshield/rfid_event_show', $data );
			}
			else
			{
				$this->load->view('dshield/rfid_event_show_dni_denied');
			}
		}
		else
		{
			$this->load->view('dshield/rfid_event_show_dni_add');
		}
	}
	
	public function event_show_id( $urfid_id, $rc_type )
	{
		$this->session_restrict( USER_TYPE_CPNY_RO );
		
		$this->load->model('RfidUser_model');
		
		$person = $this->RfidUser_model->get( $urfid_id, $this->user->get_company_ids() );
		
		if ( isset( $person ) )
		{
			if ( $this->user->owns_person( $person['urfid_id'] ) )
			{
				$data = $this->get_event_data( $person['urfid_id'], $rc_type, $person );
				
				$data['citymesh']['rc_type'] = $data['rc_type'] = $rc_type;
				
				$this->load->view('dshield/rfid_event_show', $data );
			}
			else
			{
				$this->load->view('dshield/rfid_event_show_dni_denied');
			}
		}
		else
		{
			$this->load->view('dshield/rfid_event_show_dni_add');
		}
	}
	
	protected function event_add_global_event( $re_id, $serial, $user_id, $accepted )
	{
		$this->load->model('RfidUser_model');
		$this->load->model('RfidEvent_model');
		$this->load->model('GlobalEvent_model');
		
		$timestamp = time();
		
		$by = '';
		
		if ( isset( $this->user ) )
		{
			$by = ' por ' . $this->user->get_fullname();
		}
		
		if ( NULL != $re_id )
		{
			$event = $this->RfidEvent_model->get_event( $re_id );
			
			$event_desc = $this->RfidEvent_model->get_event_desc( $event['re_event_type'], $serial, $event['re_code'], $timestamp, $event['re_packet_type'], $event['re_state'] );
			
			$event_desc.= $accepted ? '. Acceso ACEPTADO' : '. Acceso RECHAZADO';
			
			$event_desc.= $by;
			
			$ge_id = $this->GlobalEvent_model->add( GlobalEventType::RFID, $re_id, $user_id, $serial, $serial, $event['re_code'], $event['re_com_id'], $timestamp, $event_desc, $accepted ? 0 : 1 );
		}
		else
		{
			$this->load->model('RfidUserCitymesh_model');
			
			$re_code = NULL;
			
			$rucs = $this->RfidUserCitymesh_model->get( $this->user->get_user_id() );
			
			if ( isset( $rucs ) && !empty( $rucs ) )
			{
				$re_code = $rucs[0]['rc_code'];
			}
			
			$event_desc = 'Acceso ACEPTADO';
			
			$event_desc.= $by;
			
			$ge_id = $this->GlobalEvent_model->add( GlobalEventType::RFID, NULL, $user_id, NULL, NULL, $re_code, $this->user->get_company(), $timestamp, $event_desc, 1 );
		}
		
		return $ge_id;
	}
	
	public function event_is_set( $re_id, $serial )
	{
		$this->session_restrict( USER_TYPE_CPNY_RO );
		
		$res['result'] = 'error';
		
		if ( $this->user->owns_rfid( $serial ) )
		{
			$this->load->model('RfidUser_model');
			$this->load->model('RfidEvent_model');
			$this->load->model('RfidCitymesh_model');
			
			$event = $this->RfidEvent_model->get_event( $re_id );
			
			$res['result'] = ( ( isset( $event ) && $event['re_state'] != 'PENDING_VALIDATE' ) ) ? 'true' : 'false';
		}
		
		echo json_encode( $res );
	}
	
	public function event_set( $re_id, $serial )
	{
		$this->session_restrict( USER_TYPE_CPNY_RO );
		
		$res['result'] = 'error';
		
		if ( $this->user->owns_rfid( $serial ) )
		{
			$this->load->model('RfidUser_model');
			$this->load->model('RfidEvent_model');
			$this->load->model('RfidCitymesh_model');
			
			$validated = get_var('validated');
			
			if ( isset( $validated ) )
			{
				$accepted = 1 == intval( $validated );
				
				$event = $this->RfidEvent_model->get_event( $re_id );
				
				if ( isset( $event ) && $event['re_state'] == 'PENDING_VALIDATE' )
				{
					$urfid_id = $this->RfidUser_model->get_id_from_serial( $event['re_serial'] );
					$citymesh = $this->RfidCitymesh_model->get( $event['re_code'], $event['re_com_id'] );
					$is_entry = RfidCitymeshType::is_entry( $citymesh['rc_type'] );
					
					if ( $accepted )
					{
						$walking	= get_var( 'walking' );
						$result		= $this->get_event_result( $urfid_id, $citymesh['rc_id'] );
						
						if ( !isset( $walking ) )
						{
							$this->RfidEvent_model->add( $event['re_serial'], $event['re_code'], RfidType::OPEN, RfidCommandType::ADD, time(), $event['re_com_id'], 'PENDING_SEND', $urfid_id );
						}
						else
						{
							$result |=  RfidEventResultType::ACCESS_WALKING;
						}
						
						$this->RfidEvent_model->set_serial_accept_on_pending_validation( $serial, $result );
						
						$this->RfidUser_model->update_entry_leave_status( $urfid_id, $is_entry );
						
						$members = get_var( 'members' );
						
						if ( isset( $members ) && '' != $members )
						{
							$members = explode( ',', $members );
							
							foreach ( $members as $member )
							{
								$this->event_add_global_event( $re_id, $serial, $member, TRUE );
								
								$this->RfidUser_model->update_entry_leave_status( $member, $is_entry );
							}
						}
						
						$note = get_var('note');
						
						if ( isset( $note ) && NULL != $note && !empty( $note ) )
						{
							$this->RfidEvent_model->update_note( $re_id, $note );
						}
						
						if ( isset( $this->user ) )
						{
							$this->RfidEvent_model->update_validator( $re_id, $this->user->get_fullname() );
						}
					}
					else
					{
						$this->RfidEvent_model->set_serial_reject_on_pending_validation( $serial, $this->get_event_result( $urfid_id, $citymesh['rc_id'] ) );
					}
					
					$this->event_add_global_event( $re_id, $serial, $urfid_id, $accepted );
					
					$res['result'] = 'ok';
				}
			}
		}
		
		echo json_encode( $res );
	}
	
	public function event_is_created( $dni, $rc_type, $time )
	{
		$this->session_restrict( USER_TYPE_CPNY_RO );
		
		$this->load->model('RfidUser_model');
		$this->load->model('RfidEvent_model');
		$this->load->model('RfidCitymesh_model');
		
		$res['result'] = 'error';
		
		$person = $this->RfidUser_model->get_by_dni( $dni, $this->user->get_company_ids() );
			
		if ( isset( $person ) && $this->user->owns_person( $person['urfid_id'] ) )
		{
			$event = $this->RfidEvent_model->get_last_dni_entry_event( $dni, RfidCitymeshType::to_event_type( $rc_type ), $time );
			
			$res['result'] = isset( $event ) ? 'true' : 'false';
		}
		
		echo json_encode( $res );
	}
	
	public function event_is_created_id( $urfid_id, $rc_type, $time )
	{
		$this->session_restrict( USER_TYPE_CPNY_RO );
		
		$this->load->model('RfidUser_model');
		$this->load->model('RfidEvent_model');
		$this->load->model('RfidCitymesh_model');
		
		$res['result'] = 'error';
		
		$person = $this->RfidUser_model->get( $urfid_id );
			
		if ( isset( $person ) && $this->user->owns_person( $person['urfid_id'] ) )
		{
			$event = $this->RfidEvent_model->get_last_id_entry_event( $urfid_id, RfidCitymeshType::to_event_type( $rc_type ), $time );
			
			$res['result'] = isset( $event ) ? 'true' : 'false';
		}
		
		echo json_encode( $res );
	}
	
	public function event_create_id( $urfid_id, $rc_type, $citymesh_select = NULL )
	{
		$this->event_create( $urfid_id, $rc_type, $citymesh_select, TRUE );
	}
	
	public function event_create( $dni, $rc_type, $citymesh_select = NULL, $dni_is_id = FALSE )
	{
		$this->session_restrict( USER_TYPE_CPNY_RO );
		
		$res['result'] = 'error';
		
		$this->load->model('RfidUser_model');
		$this->load->model('RfidEvent_model');
		$this->load->model('RfidCitymesh_model');
		$this->load->model('RfidUserCitymesh_model');
		
		$validated = get_var('validated');
		
		if ( isset( $validated ) )
		{
			$accepted = 1 == intval( $validated );
			$accepted_str = $accepted ? 'ACCEPTED' : 'REJECTED';
			$rc_type = isset( $rc_type ) ? $rc_type : 0;
			
			$person = $dni_is_id ? 
						$this->RfidUser_model->get( $dni ) :
						$this->RfidUser_model->get_by_dni( $dni, $this->user->get_company_ids() );
			
			if ( isset( $person ) && $this->user->owns_person( $person['urfid_id'] ) )
			{
				if ( NULL != $citymesh_select ) {
					$rcitymesh = $this->RfidUserCitymesh_model->get_citymesh_from_id_and_user( $this->user->get_user_id(), $citymesh_select );
				} else {
					$rcitymesh = $this->RfidUserCitymesh_model->get_citymesh_type_from_user( $this->user->get_user_id(), $rc_type );
				}
				
				if ( isset( $rcitymesh ) )
				{
					$is_entry = RfidCitymeshType::is_entry( $rc_type );
					
					$re_code = $rcitymesh['rc_code'];
					
					$access_type = RfidCitymeshType::to_event_type( $rc_type );
					
					$members = get_var( 'members' );
					
					if ( isset( $members ) && '' != $members )
					{
						$members = explode( ',', $members );
						
						foreach ( $members as $member )
						{
							$this->RfidEvent_model->add( $dni, 0, RfidType::RFID, $access_type, time(), $this->user->get_company(), $accepted_str, $member, RfidEventResultType::LOGGED_WITH_DNI );
							
							$this->event_add_global_event( NULL, NULL, $member, $accepted );
							
							if ( $accepted )
							{
								$this->RfidUser_model->update_entry_leave_status( $member, $is_entry );
							}
						}
					}
					
					$user_id = $person['urfid_id'];
					
					$this->event_add_global_event( NULL, NULL, $user_id, $accepted );
					
					$this->load->model('RfidUserCitymesh_model');
					
					$walking	= get_var( 'walking' );
					$result		= $this->get_event_result( $user_id, $rcitymesh['rc_id'] ) | RfidEventResultType::LOGGED_WITH_DNI;
					
					if ( $accepted )
					{
						if ( !isset( $walking ) )
						{
							$res['re_id_1'] = $this->RfidEvent_model->add( $dni, $re_code, RfidType::OPEN, RfidCommandType::ADD, time(), $this->user->get_company(), 'PENDING_SEND', $user_id, RfidEventResultType::LOGGED_WITH_DNI );
						}
						else
						{
							$result |=  RfidEventResultType::ACCESS_WALKING;
						}
						
						$this->RfidUser_model->update_entry_leave_status( $user_id, $is_entry );
					}
					
					$res['re_id_2'] = $this->RfidEvent_model->add( $dni, $re_code, RfidType::RFID, $access_type, time(), $this->user->get_company(), $accepted_str, $user_id, $result );
					
					$note = get_var('note');
					
					if ( isset( $note ) && NULL != $note && !empty( $note ) )
					{
						$this->RfidEvent_model->update_note( $res['re_id_2'], $note );
					}
					
					if ( isset( $this->user ) )
					{
						$this->RfidEvent_model->update_validator( $res['re_id_2'], $this->user->get_fullname() );
					}
					
					$new_rc_type = $rc_type == RfidCitymeshType::ENTRY ? RfidCitymeshType::LEAVE : RfidCitymeshType::ENTRY;
					$res['new_id'] = '.td_urfid_id_'.$person['urfid_id'];
					$res['new_url'] = base_url('/rfid/event_show_id/'.$person['urfid_id'].'/'.$new_rc_type);
					$res['new_state'] = $new_rc_type == RfidCitymeshType::ENTRY ? 'Ingreso' : 'Egreso';
					
					$res['result'] = 'ok';
				}
				else
				{
					$res['type'] = 'city_not_found';
				}
			}
			else
			{
				$res['type'] = 'permissions';
			}
		}
		
		echo json_encode( $res );
	}
	
	protected function build_rfid_filters( $from_ref, $to_ref )
	{
		$filter				= array(
			array(
				'field_name'	=>	're_user_name',
				'filter_val'	=>	get_var( 'urfid_name' ),
				'filter_type'	=>	SQLFilterType::ILIKE
			),
			array(
				'field_name'	=>	're_user_dni',
				'filter_val'	=>	get_var( 'urfid_dni' )
			),
			array(
				'field_name'	=>	're_user_plate',
				'filter_val'	=>	get_var( 'urfid_plate' ),
				'filter_type'	=>	SQLFilterType::ILIKE
			),
			array(
				'field_name'	=>	're_timestamp',
				'filter_val'	=>	NULL != $to_ref ? get_timestamp_from_date_time( $to_ref ) : NULL,
				'filter_type'	=>	SQLFilterType::SMALLER_OR_EQ
			),
			array(
				'field_name'	=>	're_timestamp',
				'filter_val'	=>	NULL != $from_ref ? get_timestamp_from_date_time( $from_ref ) : NULL,
				'filter_type'	=>	SQLFilterType::BIGGER_OR_EQ
			),
			array(
				'field_name'	=>	're_user_type',
				'filter_val'	=>	get_var( 'types' )
			),
			array(
				'field_name'	=> 're_packet_type',
				'filter_val'	=> 0x7F,
				'filter_type'	=> SQLFilterType::SMALLER_OR_EQ
			),
			array(
				'field_name'	=> 're_user_plot',
				'filter_val'	=> get_var( 're_user_plot' ) != NULL ? explode( ',', get_var( 're_user_plot' ) ) : NULL,
				'filter_type'	=> SQLFilterType::EQUALS_ANY,
				'field_type'	=> SQLFieldType::INT
			),
			array(
				'order_by'		=> get_var_def( 'order_by', 're_timestamp' ),
				'order_fields'	=> array( 're_user', 're_user_name', 're_user_dni', 're_user_plate', 're_user_plot', 're_timestamp', 'urfid_plot' ),
				'order_dir'		=> get_var_def( 'order_dir', 'DESC' )
			)
		);
		
		if ( $this->user->is_dshield_user() )
		{
			$person = $this->RfidUser_model->get_by_uid( $this->user->get_id() );
			
			if ( isset( $person ) )
			{
				$filter_plot = explode( ',', $person['urfid_plot'] );
			}
			else
			{
				$filter_plot = array( 0 );
			}
		}
		
		if ( isset( $filter_plot ) && NULL != $filter_plot && !empty( $filter_plot ) && '' != $filter_plot[0] )
		{
			$filter[] = array(
				'join'			=>	'rfid_user_plot',
				'on'			=>	'urfid_id = rup_urfid_id AND ' . SQL::get_or_filter( $filter_plot, 'rup_plot' )
			);
		}
		
		return SQL::build_query_filter( $filter );
	}
	
	public function all( $type = null )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		if ( !( $this->user->is_logged_as_god() || $this->user->is_normal_dshield_admin() || $this->user->is_dshield_user() ) )
		{
			return;
		}
		
		$this->load->library('pagination');
		$this->load->model('RfidUser_model');
		$this->load->model('RfidEvent_model');
		
		$now					= strftime( '%d/%m/%Y %H:%M', time() + 60 );
		$hour_ago				= strftime( '%d/%m/%Y %H:%M', time() + 60 - 3600 );
		$from_ref				= NULL != get_var('from') ? substr( get_var('from'), strlen( 'Desde el ' ) ) : $hour_ago;
		$to_ref					= NULL != get_var('to') ? substr( get_var('to'), strlen( 'Hasta el ' ) ) : $now;
		$page					= get_var_def( 'page_num', 1 );
		$config					= pagination_config();
		
		$fields_get				= 'DISTINCT rfid_event.re_id, rfid_event.re_serial, rfid_event.re_code, rfid_event.re_packet_type, rfid_event.re_event_type, 
								   rfid_event.re_timestamp, rfid_event.re_state, rfid_event.re_com_id, rfid_event.re_user, rfid_event.re_result,
								   rfid_event.re_user_name, rfid_event.re_user_dni, rfid_event.re_user_plate, rfid_event.re_user_plot, rfid_event.re_user_type, rfid_event.re_note, urfid_plot, rfid_event.re_validator';
								   
		$query_filter			= $this->build_rfid_filters( $from_ref, $to_ref );
		$data['urfid_name']		= get_var( 'urfid_name' );
		$data['urfid_dni']		= get_var( 'urfid_dni' );
		$data['urfid_plate']	= get_var( 'urfid_plate' );
		$data['urfid_plot']		= get_var( 'urfid_plot' );
		$data['re_user_plot']	= get_var( 're_user_plot' );
		$data['from']			= NULL != $from_ref ? $from_ref : $hour_ago;
		$data['to']				= NULL != $to_ref ? $to_ref : $now;
		$config['total_rows']	= $data['total_events']	= $this->RfidEvent_model->count( $this->user->get_company_ids(), $query_filter );
		$data['events']			= $events = $this->RfidEvent_model->get_all( $this->user->get_company_ids(), $query_filter, $config['per_page'], $page, $fields_get );
		$config['base_url']		= base_url( '/dshield/rfid/all/?' . http_build_query_pagination() );
		$data['evmod']			= $this->RfidEvent_model;
		
		$this->pagination->initialize($config);
		
		$data['pagination']		= $this->pagination->create_links();
		
		if ( null == $type )
		{
			$this->add_frame_view( 'dshield/rfid_events', $data );
		}
		else if ( 'csv' == $type )
		{
			$filename	= $this->user->get_name() . ' - Historial de accesos - ' . $type;
			$sep		= CSV_SEPARATOR;
			csv_create_header( $filename );
			
			$data = '"Fecha"' . $sep . '"Nombre"' . $sep . '"DNI"' . $sep . '"Patente"' . $sep . '"Lote"' . $sep . '"Tipo de Usuario"' . $sep . '"Descripción"' . $sep . '"Nota"' . "\n";
			
			if ( isset( $events ) )
			{
				csv_array_sanitize( $events );
				
				foreach ( $events as $person )
				{
					$date = strftime('%a %d/%b/%y - %H:%M:%S', $person['re_timestamp'] );
					
					$data.= '"' . $date . '"' . $sep . 
							'"' . $person['re_user_name'] . '"' . $sep . 
							'"' . $person['re_user_dni'] . '"' . $sep . 
							'"' . $person['re_user_plate'] . '"' . $sep . 
							'"' . SQL::arr_to_str( $person['re_user_plot'] ) . '"' . $sep . 
							'"' . RfIdUserType::to_string($person['re_user_type']) . '"' . $sep .
							'"' . $this->RfidEvent_model->get_event_desc_full(	$person['re_event_type'], 
																				$person['re_serial'], 
																				$person['re_code'], 
																				$person['re_timestamp'], 
																				$person['re_packet_type'], 
																				$person['re_state'],
																				$person['re_result'],
																				$person['re_validator'] ). '"' . $sep .
							'"' . ( isset( $person['re_note'] ) ? $person['re_note'] : '' ) . '"' . "\r\n";
				}
			}
			
			echo @iconv( 'utf-8', 'iso-8859-1', $data );
		}
	}
	
	public function export( $type )
	{
		$this->all( $type );
	}
	
	public function access_graph()
	{
		$this->session_restrict( USER_TYPE_CPNY_RO );
		
		$this->load->model('RfidEvent_model');
		
		$to_date_get	= get_var('gtodate');
		$hours_get		= get_var_def('ghours', 24);
		$to_date		= isset( $to_date_get ) ? get_timestamp_from_date_time( $to_date_get ) : time();
		$from_date		= $to_date - 3600 * $hours_get;
		$data 			= $this->RfidEvent_model->get_graph_full_data( $this->user->get_company(), $from_date, $to_date );
		
		$this->add_frame_view( 'dshield/rfid_graph', $data );
	}
}
