<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

require_once( FRAMES_PATH . 'framecfg.php' );
require_once( FRAMES_PATH . 'actions.php' );

class Receiver extends Airmesh_Controller
{
	protected function get_all_macs( $com_id, $macs_arr, $macs_comma, $groups_arr )
	{
		$this->load->model('HardwareGroup_model');
		
		$macs = array();
		
		if ( isset( $macs_arr ) && !empty( $macs_arr ) )
		{
			foreach( $macs_arr as $m )
			{
				array_push( $macs, intval( $m ) );
			}
		}
		
		if ( isset( $groups_arr ) )
		{
			foreach ( $groups_arr as $g )
			{
				if ( $this->HardwareGroup_model->company_owns_group( $com_id, $g ) )
				{
					$ghws = $this->HardwareGroup_model->get_group_links( intval( $g ) );
					
					if ( isset( $ghws ) && !empty( $ghws ) )
					{
						foreach ( $ghws as $hw )
						{
							if ( !in_array( $hw['hw_serial'], $macs ) )
							{
								array_push( $macs, intval( $hw['hw_serial'] ) );
							}
						}
					}
				}
			}
		}
		
		if ( isset( $macs_comma ) && '' != $macs_comma )
		{
			$macc = explode( ',', $macs_comma );
			
			if ( isset( $macc ) && !empty( $macc ) )
			{
				foreach( $macc as $c )
				{
					$rc = hexdec( trim( $c ) );
					
					if ( !in_array( $rc, $macs ) )
					{
						array_push( $macs, $rc );
					}
				}
			}
		}
				
		return !empty( $macs ) ? $macs : null;
	}
	
	public function index()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		if ( $this->user->is_logged_as_god() )
		{
			echo "Sólo se puede acceder como usuario empresa. Ingresa primero como un usuario empresa para poder ver la receptora de la misma.";
			return;
		}
		
		$this->load->model('HardwareGroup_model');
		$this->load->model('HardwareConfigCommand_model');
		$this->load->model('HardwareCityMeshCommand_model');
		$this->load->model('Hardware_model');
		$this->load->model('CompanyAirmeshConfig_model');
		$this->load->model('CompanyCityMeshConfig_model');
		$this->load->model('HardwareNoiseConfig_model');
		
		$com_id						= $this->user->get_company();
		$data['groups']				= $this->HardwareGroup_model->get_all( $com_id );
		$data['macs']				= $this->Hardware_model->get_company_macs( $com_id );
		$data['airmesh_config']		= $this->CompanyAirmeshConfig_model->get( $com_id );
		$data['airmesh_is_running']	= $this->HardwareConfigCommand_model->is_running_commands( $com_id );
		$data['citymesh_config']	= $this->CompanyCityMeshConfig_model->get( $com_id );
		$data['citymesh_is_running']= $this->HardwareCityMeshCommand_model->is_running_commands( $com_id );
		$data['hwncs']				= $this->HardwareNoiseConfig_model->get_all( $this->user->get_company() );
		$data['noise_pending']		= $this->HardwareNoiseConfig_model->pending_send(  $this->user->get_company() );
		
		$this->add_frame_view( 'receiver', $data );
	}
	
	public function get_messages()
	{	
		$this->session_restrict( USER_TYPE_CPNY );
		
		if ( $this->user->is_logged_as_god() )
		{
			echo '{}'; exit(0);
		}

		$this->load->model('ReceiverTicks_model');
		$this->load->model('ReceiverConsoleLog_model');
		
		$com_id				= $this->user->get_type_id();
		$msgs				= $this->ReceiverConsoleLog_model->get( $com_id, get_post('last_id' ) );
		$tick				= $this->ReceiverTicks_model->get_last( $com_id );
		$tick['tick_health']= $this->ReceiverTicks_model->get_health_percent( $com_id );
		$res['tick']		= $tick;
		$res['ok']			= true;
		$res['data']		= $msgs;
		
		echo json_encode( $res );
	}
	
	public function download_log()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->model('ReceiverConsoleLog_model');
		
		$com_id		= $this->user->get_type_id();
		$from		= format_date_time( get_var('from') );
		$to			= format_date_time( get_var('to') );
		
		if ( $from > $to )
		{
			$f = $from; $from = $to; $to = $f;
		}
		
		$msgs		= $this->ReceiverConsoleLog_model->get_from( $com_id, $from, $to );
		$filename	= $this->user->get_name() . ' - log';
		
		csv_create_header( $filename );
		
		$str = '';
		
		if ( isset( $msgs ) )
		{
			csv_array_sanitize( $msgs );
			
			foreach ( $msgs as $msg )
			{
				$str .= '"' . datetime_noms( $msg['time'] ) . '",';
				
				$msgs = explode( ' ', $msg['msg'] );
				
				foreach ( $msgs as $msg )
				{
					$str .= "\"$msg\";";
				}
				
				$str = substr($str, 0, strlen($str)-1);
				$str .= "\n";
			}
		}
		
		echo $str;
	}

	public function download_citymesh_log()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->model('CityMeshConfigLog_model');
		
		$com_id		= $this->user->get_type_id();
		$msgs		= $this->CityMeshConfigLog_model->get_from( $com_id, strtotime( format_date_time( get_var('from') ) ) );
		$filename	= $this->user->get_name() . ' - CityMesh log';
		
		csv_create_header( $filename );
		
		$str = '';
		
		if ( isset( $msgs ) )
		{
			csv_array_sanitize( $msgs );
			
			foreach ( $msgs as $msg )
			{
				$str .= '"' . datetime_noms( $msg['time'] ) . '",';
				
				$msgs = explode( ' ', $msg['msg'] );
				
				foreach ( $msgs as $msg )
				{
					$str .= "\"$msg\";";
				}
				
				$str = substr($str, 0, strlen($str)-1);
				$str .= "\n";
			}
		}
		
		echo $str;
	}
	
	public function send_citymesh_config()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$post = $this->input->post();
		
		$this->load->model('HardwareCityMeshCommand_model');
		$this->load->model('CompanyCityMeshConfig_model');
		$this->load->model('CityMeshConfigLog_model');
		
		$com_id		= $this->user->get_type_id();
		
		$this->load->library('form_validation');

		$rules	= array(
			array(
				'field'   => 'send_ok_interval', 
				'label'   => 'Espera con respuesta', 
				'rules'   => 'required|trim|integer'
			),
			array(
				'field'   => 'send_err_interval', 
				'label'   => 'Espera sin respuesta', 
				'rules'   => 'required|trim|integer'
			),
			array(
				'field'   => 'send_max_per_mac', 
				'label'   => 'Reintentos por MAC', 
				'rules'   => 'required|trim|integer'
			),
			array(
				'field'   => 'send_max_resp_time_per_mac', 
				'label'   => 'Tiempo de espera resp/cmd', 
				'rules'   => 'required|trim|integer'
			),
			array(
				'field'   => 'retry_count',
				'label'   => 'Intentos por comando',
				'rules'   => 'required|trim|integer'
			),
			array(
				'field'   => 'no[]',
				'label'   => 'NO',
				'rules'   => 'required|trim|callback_val_hexa2'
			),
			array(
				'field'   => 'p[]',
				'label'   => 'P',
				'rules'   => 'required|trim|callback_val_hexa1'
			),
			array(
				'field'   => 'qrs[]',
				'label'   => 'QRS',
				'rules'   => 'required|trim|callback_val_hexa3'
			),
			array(
				'field'   => 'tu[]',
				'label'   => 'TU',
				'rules'   => 'required|trim|callback_val_hexa2'
			),
			array(
				'field'   => 'vw[]',
				'label'   => 'VW',
				'rules'   => 'required|trim|callback_val_hexa2'
			)
		);
		
		$this->form_validation->set_rules( $rules );
		
		if ( $this->form_validation->run() != FALSE )
		{
			if ( !$this->HardwareCityMeshCommand_model->is_running_commands( $com_id ) )
			{
				$this->CompanyCityMeshConfig_model->add_update( $com_id, $post['send_ok_interval'], $post['send_err_interval'], $post['send_max_per_mac'], $post['send_max_resp_time_per_mac'], isset( $post['add_to_group'] ) ? $post['add_to_group'] : NULL, isset( $post['force_send'] ) ? 1 : 0 );
				
				$macs = $this->get_all_macs( 	$com_id,
												isset( $post['macs'] ) ? $post['macs'] : null, 
												isset( $post['macscomma'] ) ? $post['macscomma'] : null, 
												isset( $post['groups'] ) ? $post['groups'] : null 
				);
				
				if ( isset( $macs ) && !empty( $macs ) )
				{
					$no = &$post['no'];
					$p = &$post['p'];
					$qrs = &$post['qrs'];
					$tu = &$post['tu'];
					$vw = &$post['vw'];
					
					$cno = count( $no );
					$cp = count( $p );
					
					if ( $cno == $cp && $cno > 0 )
					{
						$this->load->model('Hardware_model');
						
						$timestamp = time();
						
						$batch_id = $this->HardwareCityMeshCommand_model->get_next_batch_id();
						
						$this->db->trans_start();
						
						$this->CityMeshConfigLog_model->add( $com_id, $timestamp, "Created Commands Batch: $batch_id" );
						
						if ( isset( $post['send_reset'] ) )
						{	// attach a reset command
							$no[]	= 0x47;
							$p[]	= 0x01;
							$qrs[]	= 0x111;
							$tu[]	= 0x00;
							$vw[]	= 0x00;
							$cno++;
						}
						
						foreach ( $macs as $mac )
						{
							for ( $i = 0; $i < $cno; $i++ )
							{
								$code = $this->Hardware_model->get_code_from_mac( $mac );
								
								if ( !isset( $code ) )
								{
									$code = 0;
								}
								
								$force = isset( $post['force_send'] ) ? 1 : 0;
								
								$this->HardwareCityMeshCommand_model->add(	$mac, $timestamp, $code,
																			hexdec( $no[$i] ), hexdec( $p[$i] ), hexdec( $qrs[$i] ), hexdec( $tu[$i] ), hexdec( $vw[$i] ),
																			$force, 0, 'PENDING_SEND', $batch_id, $post['retry_count'] );
								
								$msg = citymesh_command_msg( 'Queued Command', $mac, $timestamp, $code, hexdec( $no[$i] ), hexdec( $p[$i] ), hexdec( $qrs[$i] ), hexdec( $tu[$i] ), hexdec( $vw[$i] ), $force, 0 );
								
								$this->CityMeshConfigLog_model->add( $com_id, $timestamp, $msg );
							}
						}
						
						$this->CompanyCityMeshConfig_model->update_batch_id( $com_id, $batch_id );
						
						$this->db->trans_complete();
						
						$this->kajax->addClass('#citymesh_send_but', 'red_but');
						
						$this->kajax->fancy_log_success( 'Commands Queued' );
					}
				}
				else
				{
					$this->kajax->fancy_log( 'Se guardó la configuración.<br/>No se encontraron comandos y/o equipos para encolar.' );
				}
			}
			else
			{
				$this->kajax->fancy_log_error( 'Actualmente ya se encuentran comandos en ejecución.<br/>Debe esperar a que estos terminen de ejecutarse.' );
			}
		}
		else
		{
			$this->kajax->fancy_log_error( validation_errors() );
		}
		
		$this->kajax->out();
	}
	
	public function send_generic_msg()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$post = $this->input->post();
		
		$this->load->model('HardwareGenericMessage_model');
		
		$com_id		= $this->user->get_type_id();
		
		$this->load->library('form_validation');

		$rules	= array(
			array(
				'field'   => 'cmd[]',
				'label'   => 'Comando',
				'rules'   => 'required|trim'
			)
		);
		
		$this->form_validation->set_rules( $rules );
		
		if ( $this->form_validation->run() != FALSE )
		{
			$macs = $this->get_all_macs( 	$com_id,
											isset( $post['macs'] ) ? $post['macs'] : null, 
											isset( $post['macscomma'] ) ? $post['macscomma'] : null, 
											isset( $post['groups'] ) ? $post['groups'] : null 
			);
			
			if ( isset( $macs ) && !empty( $macs ) )
			{
				$cmd = &$post['cmd'];
				$ccmd = count( $cmd );
				
				if ( $ccmd > 0 )
				{
					$timestamp = time();
					
					$this->db->trans_start();
					
					foreach ( $macs as $mac )
					{
						for ( $i = 0; $i < $ccmd; $i++ )
						{
							$c = &$cmd[$i];
							
							if ( !empty( $c ) )
							{
								$this->HardwareGenericMessage_model->add( $com_id, $mac, $c );
							}
						}
					}
					
					$this->db->trans_complete();
					
					$this->kajax->fancy_log_success( 'Mensajes encolados para ser enviados.' );
				}
			}
		}
		else
		{
			$this->kajax->fancy_log_error( validation_errors() );
		}
		
		$this->kajax->out();
	}
	
	public function cancel_citymesh_config()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$com_id		= $this->user->get_type_id();
		
		$this->load->model('CompanyCityMeshConfig_model');
		$this->load->model('HardwareCityMeshCommand_model');
		$this->load->model('CityMeshConfigLog_model');
		
		$batch_id = $this->HardwareCityMeshCommand_model->get_last_company_batch_id( $com_id );
		
		$this->HardwareCityMeshCommand_model->cancel_last_batch( $com_id );
		
		$this->CompanyCityMeshConfig_model->set_batch_cancellation( $com_id );
		
		Actions::set_config_cancelled( $com_id );
		
		Actions::set_actions_cancelled( $com_id );
		
		$msg = "Cancelled batch id: $batch_id";
		
		$this->CityMeshConfigLog_model->add( $com_id, time(), $msg );
		
		$this->kajax->fancy_log_success( $msg );
		
		$this->kajax->removeClass('#citymesh_send_but', 'red_but');
		
		$this->kajax->out();
	}
	
	
	public function get_citymesh_log()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		if ( $this->user->is_logged_as_god() )
		{
			echo '{}'; exit(0);
		}
		
		$this->load->model('CityMeshConfigLog_model');
		$this->load->model('HardwareCityMeshCommand_model');
		
		$com_id					= $this->user->get_type_id();
		$msgs					= $this->CityMeshConfigLog_model->get( $com_id, get_post('last_id' ) );
		$res['tick']			= $this->CityMeshConfigLog_model->get_last( $com_id );
		$res['tick']['state']	= $this->HardwareCityMeshCommand_model->get_state( $com_id );
		$res['is_running']		= $this->HardwareCityMeshCommand_model->is_running_commands( $com_id );
		$res['tick']['active']	= $res['is_running'];
		$res['ok']				= true;
		$res['data']			= $msgs;
		
		echo json_encode( $res );
	}
	
	public function download_citymesh_conf_macs()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->model('HardwareCityMeshCommand_model');
		
		$filename	= $this->user->get_name() . ' - citymesh configured macs - log';
		
		text_plain_create_header( $filename );
		
		$macs = $this->HardwareCityMeshCommand_model->get_configured_commands_macs( $this->user->get_type_id() );
		
		foreach ( $macs as $mac )
		{
			echo $mac['mac'] . "\n";
		}
	}
	
	public function download_citymesh_no_conf_macs()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->model('HardwareCityMeshCommand_model');
		
		$filename	= $this->user->get_name() . ' - citymesh not configured macs - log';
		
		text_plain_create_header( $filename );
		
		$macs = $this->HardwareCityMeshCommand_model->get_not_configured_commands_macs( $this->user->get_type_id() );
		
		foreach ( $macs as $mac )
		{
			echo $mac['mac'] . "\n";
		}
	}
	
	public function get_airmesh_log()
	{	
		$this->session_restrict( USER_TYPE_CPNY );
		
		if ( $this->user->is_logged_as_god() )
		{
			echo '{}'; exit(0);
		}
		
		$this->load->model('AirmeshConfigLog_model');
		$this->load->model('HardwareConfigCommand_model');
		
		$com_id					= $this->user->get_type_id();
		$msgs					= $this->AirmeshConfigLog_model->get( $com_id, get_post('last_id') );
		$res['tick']			= $this->AirmeshConfigLog_model->get_last( $com_id );
		$res['tick']['state']	= $this->HardwareConfigCommand_model->get_state( $com_id );
		$res['is_running']		= $this->HardwareConfigCommand_model->is_running_commands( $com_id );
		$res['tick']['active']	= $res['is_running'];
		$res['ok']				= true;
		$res['data']			= $msgs;
		
		echo json_encode( $res );
	}
	
	public function download_airmesh_log()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->model('AirmeshConfigLog_model');
		
		$com_id		= $this->user->get_type_id();
		$msgs		= $this->AirmeshConfigLog_model->get_from( $com_id, strtotime( format_date_time( get_var('from') ) ) );
		$filename	= $this->user->get_name() . ' - Airmesh log';
		
		csv_create_header( $filename );
		
		$str = '';
		
		if ( isset( $msgs ) )
		{
			csv_array_sanitize( $msgs );
			
			foreach ( $msgs as $msg )
			{
				$str .= '"' . datetime_noms( $msg['time'] ) . '",';
				
				$msgs = explode( ' ', $msg['msg'] );
				
				foreach ( $msgs as $msg )
				{
					$str .= "\"$msg\";";
				}
				
				$str = substr($str, 0, strlen($str)-1);
				$str .= "\n";
			}
		}
		
		echo $str;
	}
	
	public function send_airmesh_config()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$post = $this->input->post();
		
		$this->load->model('HardwareConfigCommand_model');
		$this->load->model('CompanyAirmeshConfig_model');
		$this->load->model('AirmeshConfigLog_model');
		
		$com_id		= $this->user->get_type_id();
		
		$this->load->library('form_validation');

		$rules	= array(
			array(
				'field'   => 'send_ok_interval', 
				'label'   => 'Espera con respuesta', 
				'rules'   => 'required|trim|integer'
			),
			array(
				'field'   => 'send_err_interval', 
				'label'   => 'Espera sin respuesta', 
				'rules'   => 'required|trim|integer'
			),
			array(
				'field'   => 'send_max_per_mac', 
				'label'   => 'Reintentos por MAC', 
				'rules'   => 'required|trim|integer'
			),
			array(
				'field'   => 'send_max_resp_time_per_mac', 
				'label'   => 'Tiempo de espera resp/cmd', 
				'rules'   => 'required|trim|integer'
			),
			array(
				'field'   => 'retry_count',
				'label'   => 'Intentos por comando',
				'rules'   => 'required|trim|integer'
			),
			array(
				'field'   => 'cmd[]',
				'label'   => 'Comando',
				'rules'   => 'required|trim'
			),
			array(
				'field'   => 'val[]',
				'label'   => 'Valor',
				'rules'   => 'trim|callback_val_hexa'
			)
		);
		
		$this->form_validation->set_rules( $rules );
		
		if ( $this->form_validation->run() != FALSE )
		{
			if ( !$this->HardwareConfigCommand_model->is_running_commands( $com_id ) )
			{
				$this->CompanyAirmeshConfig_model->add_update( $com_id, $post['send_ok_interval'], $post['send_err_interval'], $post['send_max_per_mac'], $post['send_max_resp_time_per_mac'], isset( $post['add_to_group'] ) ? $post['add_to_group'] : NULL, isset( $post['force_send'] ) ? 1 : 0 );
				
				$state_type = isset( $post['force_send'] ) ? EVT_CFG_STATE_TYPE::SEND_FORCED : EVT_CFG_STATE_TYPE::SEND;
				$force = isset( $post['force_send'] ) ? 1 : 0;
				
				$macs = $this->get_all_macs( 	$com_id,
												isset( $post['macs'] ) ? $post['macs'] : null, 
												isset( $post['macscomma'] ) ? $post['macscomma'] : null, 
												isset( $post['groups'] ) ? $post['groups'] : null 
				);
				
				if ( isset( $macs ) && !empty( $macs ) )
				{
					$cmd = &$post['cmd'];
					$val = &$post['val'];
					$ccmd = count( $cmd );
					$cval = count( $val );
					
					if ( $ccmd == $cval && $ccmd > 0 )
					{
						$timestamp = time();
						
						$batch_id = $this->HardwareConfigCommand_model->get_next_batch_id();
						
						$this->db->trans_start();
						
						$this->AirmeshConfigLog_model->add( $com_id, $timestamp, "Created Commands Batch: $batch_id" );
						
						foreach ( $macs as $mac )
						{
							for ( $i = 0; $i < $ccmd; $i++ )
							{
								$c = &$cmd[$i];
								$v = &$val[$i];
								
								if ( !empty( $c ) )
								{
									// Value is empty? So it must be a query, otherwise it must be a write
									$mode = empty( $v ) ?
												EVT_CFG_MODE::SEND_QUERY :
												( isset( $post['apply'] ) ? EVT_CFG_MODE::SEND_WRITE_APPLY : EVT_CFG_MODE::SEND_WRITE );
									
									if ( strlen( $v ) == 1 )
									{
										$v = '0' . $v;
									}
									
									if ( strlen( $v ) % 2 == 0 )
									{
										$this->HardwareConfigCommand_model->add( $mac, $timestamp, $state_type, $mode, string_to_short( $c ), strlen( $v ) / 2, $v, 'PENDING_SEND', $batch_id, $post['retry_count'], $force );
										
										$msg = airmesh_command_msg( 'Queued Command', $mac, $timestamp, $state_type, $mode, $c, strlen( $v ) / 2, $v );
										
										$this->AirmeshConfigLog_model->add( $com_id, $timestamp, $msg );
									}
								}
							}
							
							if ( isset( $post['write_permanently'] ) )
							{
								$this->HardwareConfigCommand_model->add( $mac, $timestamp, $state_type, $mode, string_to_short( 'WR' ), 0, '', 'PENDING_SEND', $batch_id, $post['retry_count'], $force );
								
								$msg = airmesh_command_msg( 'Queued Command', $mac, $timestamp, $state_type, $mode, 'WR', 0, '' );
								
								$this->AirmeshConfigLog_model->add( $com_id, $timestamp, $msg );
							}
						}
						
						$this->CompanyAirmeshConfig_model->update_batch_id( $com_id, $batch_id );
						
						$this->db->trans_complete();
						
						$this->kajax->addClass('#airmesh_send_but', 'red_but');
						
						$this->kajax->fancy_log_success( 'Commands Queued' );
					}
				}
				else
				{
					$this->kajax->fancy_log( 'Se guardó la configuración.<br/>No se encontraron comandos y/o equipos para encolar.' );
				}
			}
			else
			{
				$this->kajax->fancy_log_error( 'Actualmente ya se encuentran comandos en ejecución.<br/>Debe esperar a que estos terminen de ejecutarse.' );
			}
		}
		else
		{
			$this->kajax->fancy_log_error( validation_errors() );
		}
		
		$this->kajax->out();
	}
	
	public function cancel_airmesh_config()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$com_id		= $this->user->get_type_id();
		
		$this->load->model('CompanyAirmeshConfig_model');
		$this->load->model('HardwareConfigCommand_model');
		$this->load->model('AirmeshConfigLog_model');
		
		$batch_id = $this->HardwareConfigCommand_model->get_last_company_batch_id( $com_id );
		
		$this->HardwareConfigCommand_model->cancel_last_batch( $com_id );
		
		$this->CompanyAirmeshConfig_model->set_batch_cancellation( $com_id );
		
		$msg = "Cancelled batch id: $batch_id";
		
		$this->AirmeshConfigLog_model->add( $com_id, time(), $msg );
		
		$this->kajax->fancy_log_success( $msg );
		
		$this->kajax->removeClass('#airmesh_send_but', 'red_but');
		
		$this->kajax->out();
	}
	
	public function download_airmesh_conf_macs()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->model('HardwareConfigCommand_model');
		
		$filename	= $this->user->get_name() . ' - airmesh configured macs - log';
		
		text_plain_create_header( $filename );
		
		$macs = $this->HardwareConfigCommand_model->get_configured_commands( $this->user->get_type_id() );
		
		if ( isset( $macs ) )
		{
			foreach ( $macs as $mac )
			{
				echo $mac['mac'] . "\n";
			}
		}
	}
	
	public function download_airmesh_no_conf_macs()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->model('HardwareConfigCommand_model');
		
		$filename	= $this->user->get_name() . ' - airmesh not configured macs - log';
		
		text_plain_create_header( $filename );
		
		$macs = $this->HardwareConfigCommand_model->get_not_configured_commands( $this->user->get_type_id() );
		
		if ( isset( $macs ) )
		{
			foreach ( $macs as $mac )
			{
				echo $mac['mac'] . "\n";
			}
		}
	}
	
	public function report()
	{
		$this->load->model('Company_model');
		
		$report_str = NULL;
		$report		= NULL;
		
		if ( 0 != $this->user->get_company() )
		{
			$report_str	= $this->Company_model->get_report( $this->user->get_company() );
		}
		
		if ( isset( $report_str ) )
		{
			$report = json_decode( $report_str );
		}
		
		$this->add_frame_view( 'report', array( 'r' => $report, 'com_id' => $this->user->get_company(), 'com' => $this->Company_model->get( $this->user->get_company(), ARRAY_A ) ) );
	}
	
	public function send_noise_config()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$post = $this->input->post();
		
		$this->load->model('HardwareNoiseConfig_model');
		$this->load->model('CompanyNoiseConfig_model');
		
		$com_id		= $this->user->get_type_id();
		
		$this->load->library('form_validation');

		$rules	= array(
			array(
				'field'   => 'send_ok_interval', 
				'label'   => 'Espera con respuesta', 
				'rules'   => 'required|trim|integer'
			),
			array(
				'field'   => 'send_err_interval', 
				'label'   => 'Espera sin respuesta', 
				'rules'   => 'required|trim|integer'
			),
			array(
				'field'   => 'send_max_per_mac', 
				'label'   => 'Reintentos por MAC', 
				'rules'   => 'required|trim|integer'
			),
			array(
				'field'   => 'send_max_resp_time_per_mac', 
				'label'   => 'Tiempo de espera resp/cmd', 
				'rules'   => 'required|trim|integer'
			),
			array(
				'field'   => 'noise_test_time',
				'label'   => 'Período de medición de ruido', 
				'rules'   => 'required|trim|integer'
			),
			array(
				'field'   => 'noise_repeat_times',
				'label'   => 'Cantidad de veces que se mide en cada canal en cada período', 
				'rules'   => 'required|trim|integer'
			),
			array(
				'field'   => 'noise_channels_list',
				'label'   => 'Canales a Medir', 
				'rules'   => 'required|trim|callback_val_channels_list'
			),
			array(
				'field'   => 'noise_strength_test',
				'label'   => 'Cantidad de veces que se mide potencia de recepción en cada período', 
				'rules'   => 'required|trim|integer'
			)
		);
		
		$this->form_validation->set_rules( $rules );
		
		if ( $this->form_validation->run() != FALSE )
		{
			$this->CompanyNoiseConfig_model->add_update( $com_id, $post['send_ok_interval'], $post['send_err_interval'], $post['send_max_per_mac'], $post['send_max_resp_time_per_mac'] );
			
			$macs = $this->get_all_macs( 	$com_id,
											isset( $post['macs'] ) ? $post['macs'] : null, 
											isset( $post['macscomma'] ) ? $post['macscomma'] : null, 
											isset( $post['groups'] ) ? $post['groups'] : null 
			);
			
			if ( isset( $macs ) && !empty( $macs ) )
			{
				$timestamp = time();
				
				$state = isset( $post['state'] ) && 'paused' == $post['state'] ? 'PAUSED' : ( 'erased' == $post['state'] ? 'ERASED' : 'ACTIVE' );
				
				$post['noise_channels_list'] = str_replace( ' ', '', $post['noise_channels_list'] );  // remove spaces
				
				$batch_id = $this->HardwareNoiseConfig_model->get_next_batch_id();
				
				$this->db->trans_start();
				
				foreach( $macs as $mac )
				{
					$this->HardwareNoiseConfig_model->add_update(	$this->user->get_company(), $mac, $post['retry_count'], $post['noise_test_time'], 
																	$post['noise_repeat_times'], $post['noise_strength_test'], $post['noise_channels_list'], $batch_id, $timestamp, $state );
				}
				
				$this->db->trans_complete();
				
				$this->kajax->fancy_log_success( 'Configuración de Medición de Ruido Guardada.' );
				
				$this->kajax->call('noise_table_update()');
			}
			else
			{
				$this->kajax->fancy_log( 'Se guardó la configuración.<br/>No se han seleccionado equipos.' );
			}
		}
		else
		{
			$this->kajax->fancy_log_error( validation_errors() );
		}
		
		$this->kajax->out();
	}
	
	public function noise_table()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->model('HardwareNoiseConfig_model');
		
		$data['hwncs'] = $this->HardwareNoiseConfig_model->get_all( $this->user->get_company() );
		
		$this->load->view( 'hw_noise_state_table', $data );
	}
	
	public function noise_pending()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->model('HardwareNoiseConfig_model');
		
		$data['pending'] = $this->HardwareNoiseConfig_model->pending_send(  $this->user->get_company() );
		
		echo json_enc( $data );
	}
	
	public function send_hw_action()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->model('HardwareCityMeshCommand_model');
		
		$com_id			= $this->user->get_company();
		$hw_id			= get_var( 'hw_id' );
		$index			= get_var( 'index' );
		$state			= get_var( 'state' );
		$force_send		= null != get_post('force_send') ? 1 : 0;
		
		$res = array();
		
		if ( $this->user->owns_hw( $hw_id ) )
		{
			$hw = $this->db->get_row( "SELECT hw_id, hw_code, hw_serial FROM hardware WHERE hw_id = ? LIMIT 1", ARRAY_A, array( $hw_id ) );
			$id = Actions::send_action( $hw_id, $index, $state, $com_id, $hw['hw_serial'], $hw['hw_code'], $force_send );
			
			$res['ok'] = true;
			$res['msg'] = "";
			$res['action_id'] = $id;
		}
		else
		{
			$res['ok'] = false;
			$res['msg'] = "Permisos insuficientes para realizar esta acción.";
		}
		
		echo json_encode( $res );
	}
	
	public function send_hw_config()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->model('HardwareCityMeshCommand_model');
		
		$com_id		= $this->user->get_company();
		$error		= false;
		$msg		= "";
		$hw_id		= get_post('hw_id');
		$action_str	= get_post('action');		//'SEND', 'QUERY'  -> se convierte a ac_evt_qualifier
		
		switch( $action_str )
		{
			case 'SET': $qualifier = EVT_QUALIFIER::CONFIG;		break;
			case 'GET': $qualifier = EVT_QUALIFIER::INTERROGAR;	break;
			default:
			{
				$error = true;
				$msg = "Tipo de mensaje inválido: $type_str - debe ser SEND/QUERY";
			}
		}
		
		if ( !$this->user->owns_hw( $hw_id ) )
		{
			$error = true;
			$msg = "Permisos insuficientes para realizar esta acción.";
		}
		
		if( !$error )
		{
			$hw = $this->db->get_row( "SELECT hw_id, hw_code, hw_serial FROM hardware WHERE hw_id = ? LIMIT 1", ARRAY_A, array( $hw_id ) );
			
			if ( !isset( $hw ) )
			{
				$error = true;
				$msg = "No se encuentra el equipo a configurar.";
			}
			else
			{
				$hw_id			= $hw['hw_id'];
				$hw_serial		= $hw['hw_serial'];
				$hw_code		= $hw['hw_code'];
				$evt_code_name	= get_post('config_a_evt_code');
				$force_send		= null != get_post('force_send') ? 1 : 0;
				$action_id		= null;
				
				switch( $evt_code_name )
				{
					case 'RESET':
					{
						$action_id = Actions::send_reset( $hw_id, $com_id, $hw_code, $hw_serial );
						break;
					}
					default:
					{
						$value =  get_post('config_a_value');
						
						if( $evt_code_name == "BUSQUEDA_MODEM_ENCENDER" || $evt_code_name == "REPORTE_LINEA_TEL" )
						{
							$value = $value == "00" ? "00" : "FF";
						}
						
						$evt_code = EVT_CODE_CONFIG_A::getConst( $evt_code_name );
						
						if( $evt_code == null )
						{
							$error = true;
							$msg = "Debe elegir una acción válida.";
						}
						else if( $action_str == 'SET' && ( !isset($value) || trim($value) == "" ) )
						{
							$error = true;
							$msg = "Debe ingresar un valor.";
						}
						else
						{
							$frame_type = FrameType::CONFIG_A;
							$action_id = Actions::send_config_action( $hw_id, $frame_type, $qualifier, $evt_code, hexdec($value), $com_id, $hw_code, $hw_serial, $force_send );
						}
					}
				}
				
				if( $action_id != null )
				{
					$res['cfg_action_id'] = $action_id;
				}
			}
		}
		
		$res['ok'] = !$error;
		$res['msg'] = $msg;
		
		echo json_encode( $res );
	}
	
	public function get_config_state()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$action_id		= get_var('cfg_action_id');
		$res			= array();
		$res['ok'] 		= true;
		$res['state']	= Actions::get_config_status($action_id);

		echo json_encode( $res );
	}
	
	public function get_action_state()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$action_id		= get_var('action_id');
		$res			= array();
		$res['ok'] 		= true;
		$res['state']	= Actions::get_action_status($action_id);

		echo json_encode( $res );
	}
	
	public function graph()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		require_once( LIBSPATH . 'graphs/graphview.php' );
		
		$data = GraphView::gen_receiver_ticks_graph();
		
		$this->set_map_data( $data, TRUE, TRUE );
		
		$data['no_sel'] = TRUE;
		
		$this->add_frame_view( 'graph_tests_by_company', $data );
	}
	
	public function hard_reset()
	{
		$this->session_restrict( USER_TYPE_GOD );
		
		if ( $this->user->is_logged_as_company() )
		{
			$com_id = $this->user->get_company();
			
			$this->load->model('ReceiverCommand_model');
			
			$this->ReceiverCommand_model->add( $com_id, "hard_reset", '' );
			
			$this->kajax->fancy_log_success( 'Se intentará reiniciar el sistema operativo de la receptora a la brevedad.' );
		}
		else
		{
			$this->kajax->fancy_log_error( 'Algo anda mal!' );
		}
		
		$this->kajax->out();
	}
}
