<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Radars extends PAGE_Controller
{
	function __construct()
	{
		parent::__construct();
		
		$this->load->model('Radar_model');
	}
	
	public function index()
	{
		$this->all();
	}
	
	protected function build_filters()
	{
		$filter = array(
			array(
				'field_name'	=>	'rd_name',
				'filter_val'	=>	get_var( 'rd_name' ),
				'filter_type'	=>	SQLFilterType::ILIKE
			),
			array(
				'field_name'	=>	'rd_serial',
				'filter_val'	=>	get_var( 'rd_serial' ),
				'val_convert'	=>	SQLConvertType::HEXDEC
			),
			array(
				'order_by'		=> get_var_def( 'order_by', 'rd_name' ),
				'order_fields'	=> array( 'rd_name', 'rd_serial' ),
				'order_dir'		=> get_var_def( 'order_dir', 'ASC' )
			)
		);
		
		return SQL::build_query_filter( $filter );
	}
	
	public function all()
	{
		$this->session_restrict( USER_TYPE_GOD );
		
		$this->load->model('Company_model');
		$this->load->library('pagination');
		
		$page					= get_var_def( 'page_num', 1 );
		$config					= pagination_config();
		$query_filter			= $this->build_filters();
		$data['rd_name']		= get_var( 'rd_name' );
		$data['rd_serial']		= get_var( 'rd_serial' );
		$config['total_rows']	= $data['total_radars']	= $this->Radar_model->count( $this->user->get_company_ids(), $query_filter );
		$data['radars']			= $this->Radar_model->get_all( $this->user->get_company_ids(), $query_filter );
		$config['base_url']		= base_url( '/radars/all/?' . http_build_query_pagination() );
		$data['companies']		= $this->Company_model->get_all_names();
		
		$this->pagination->initialize($config);
		
		$data['pagination']		= $this->pagination->create_links();
		
		$this->add_frame_view( 'radars_list', $data );
	}
	
	protected function process_upload_logo( $id )
	{
		$key = 'urbanization_logo';
		
		$this->load->library( 'UploadHandler', array( 
			'script_url' => base_url('/radars/update/'),
			'upload_dir' => RADARSLOGOSPATH,
			'upload_url' => base_url('/assets/radars_logos') . '/',
			'accept_file_types' => '/\.(gif|jpe?g|png)$/i',
			'param_name' => $key,
			'image_versions' => array(
				'' => array(
					'auto_orient' => true
				)
			)
		) );
		
		$resp = $this->uploadhandler->post(false);
		
		if ( isset( $resp[$key][0] ) && file_exists( RADARSLOGOSPATH . $resp[$key][0]->name ) )
		{
			$retry		= FALSE;
			$newname	= '';
			$filename	= '';
			$ext		= '.jpg';
			
			do
			{
				$retry		= FALSE;
				$newname	= rand_string(64);
				$filename	= $newname . $ext;
				$oldfile	= RADARSLOGOSPATH . $resp[$key][0]->name;
				$newfile	= RADARSLOGOSPATH . $filename;
				
				$type		= $resp[$key][0]->type;
				
				if ( !file_exists( $newfile ) )
				{
					rename( $oldfile, $newfile );
					
					$resp[$key][0]->name	= $filename;
					$resp[$key][0]->url		= rawurldecode( base_url( '/assets/radars_logos/' ) . '/' . $filename );
				}
				else
				{
					$retry = TRUE;
				}
			}
			while ( $retry );
			
			$this->Radar_model->update_logo( $id, $newname );
		}
		
		$ret = $resp[$key][0];
		
		if ( isset( $ret->error ) )
		{
			$this->kajax->fancy_log_error( $ret->error );
		}
		else if ( isset( $ret->url ) )
		{
			$this->kajax->src( '#row_extra_' . $id . ' .logo_link', $ret->url );
			$this->kajax->src( '#row_extra_' . $id . ' .logo_img', $ret->url );
		}
		
		return $ret;
	}
	
	public function update()
	{
		$this->session_restrict( USER_TYPE_GOD );
		
		$post = $this->input->post();
		
		$this->load->library('form_validation');
		
		$id = isset( $post['id'] ) ? intval( $post['id'] ) : 0;
		
		$rules	= array(
			array(
				'field'   => 'serial', 
				'label'   => 'MAC', 
				'rules'   => 'trim|required|callback_val_hexa'
			),
			array(
				'field'   => 'name', 
				'label'   => 'Nombre', 
				'rules'   => 'trim|required|max_length[64]'
			),
			array(
				'field'   => 'company', 
				'label'   => 'Empresa', 
				'rules'   => 'trim|required'
			),
			array(
				'field'   => 'urbanization_name', 
				'label'   => 'Nombre de Urbanización', 
				'rules'   => 'trim'
			),
			array(
				'field'   => 'urbanization_address', 
				'label'   => 'Domicilio de Urbanización', 
				'rules'   => 'trim'
			),
			array(
				'field'   => 'lat', 
				'label'   => 'Latitud', 
				'rules'   => 'trim|required|decimal'
			),
			array(
				'field'   => 'long', 
				'label'   => 'Longitud', 
				'rules'   => 'trim|required|decimal'
			),
			array(
				'field'   => 'trigger_speed', 
				'label'   => 'Velocidad Máxima', 
				'rules'   => 'trim|required|integer'
			)
		);
		
		if ( $this->user->is_logged_as_god() )
		{
			$rules[] = array(
				'field'   => 'speed_ignore', 
				'label'   => 'Velocidad de Error', 
				'rules'   => 'trim|required|integer'
			);
			
			$rules[] = array(
				'field'   => 'country_id', 
				'label'   => 'Código de País', 
				'rules'   => 'trim|required|integer'
			);
			
			$rules[] = array(
				'field'   => 'photo_timeout_ms', 
				'label'   => 'Intervalo de Captura', 
				'rules'   => 'trim|required|integer'
			);
			
			$rules[] = array(
				'field'   => 'photo_count', 
				'label'   => 'Cantidad de Imágenes', 
				'rules'   => 'trim|required|integer'
			);
			
			$rules[] = array(
				'field'   => 'photo_index', 
				'label'   => 'Índice de Foto', 
				'rules'   => 'trim|required|integer'
			);
			
			$rules[] = array(
				'field'   => 'host_address', 
				'label'   => 'Dirección de Host', 
				'rules'   => 'trim|required'
			);
			
			if ( 0 != $id )
			{
				$rules[] = array(
					'field'   => 'api_key', 
					'label'   => 'API Key', 
					'rules'   => 'trim|required'
				);
			}
		}
		
		$this->form_validation->set_rules( $rules );
		
		if ( $this->form_validation->run() != FALSE )
		{
			if ( $id == 0 )
			{
				$id = $this->Radar_model->add( $post['name'], $post['lat'], $post['long'], $post['company'], hexdec_bigint( $post['serial'] ), $post['trigger_speed'], $post['urbanization_name'], $post['urbanization_address'], $post['host_address'] );
				
				if ( isset( $post['api_key'] ) && !empty( $post['api_key'] ) )
				{
					$this->Radar_model->update_api_key( $id, $post['api_key'] );
				}
				
				$this->id_replace( $id );
				
				$this->kajax->call( 'table_row_new_convert_to_id( ' . $id . ', "id" )' );
				
				$this->process_upload_logo( $id );
				
				$this->kajax->fancy_log_success( "Radar: " . $post['name'] . " añadido con éxito." );
			}
			else
			{
				if ( $this->Radar_model->exists( $id )  )
				{
					$this->Radar_model->update( $id, $post['name'], $post['lat'], $post['long'], $post['company'], hexdec_bigint( $post['serial'] ), $post['trigger_speed'], $post['urbanization_name'], $post['urbanization_address'] );
					
					$this->process_upload_logo( $id );
					
					$this->kajax->fancy_log_success( "Radar: " . $post['name'] . " guardado con éxito." );
				}
				else
				{
					$this->kajax->fancy_log_error(  "Radar: " . $post['name'] . " no existe." );
				}
			}
			
			if (  $this->user->is_logged_as_god() )
			{
				$this->Radar_model->update_config( $id, $post['country_id'], $post['speed_ignore'], $post['photo_timeout_ms'], $post['photo_count'], $post['photo_index'], $post['host_address'], $post['api_key'] );
			}
		}
		else
		{
			$this->kajax->fancy_log_error( validation_errors() );
		}
		
		$this->kajax_validation_set_input_states( $rules, $id );
		
		$this->kajax->out();
	}
	
	public function update_plate()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->library('form_validation');
		
		$post = $this->input->post();
		
		$rules	= array(
			array(
				'field'   => 'plate', 
				'label'   => 'Patente', 
				'rules'   => 'trim|required|callback_val_plate'
			)
		);
		
		$this->load->model('RadarEvent_model');
		
		$re = $this->RadarEvent_model->get( $post['re_id'] );
		
		if ( isset( $re ) && $this->user->owns_radar( $re['rd_id'] ) )
		{
			$this->form_validation->set_rules( $rules );
			
			if ( $this->form_validation->run() != FALSE )
			{
				$this->load->model('RadarEvent_model');
				
				$this->RadarEvent_model->update_plate( $post['re_id'], $post['plate'] );
				
				$this->kajax->text( '#re_id_' . $post['re_id'] . '_plate', $post['plate'] );
				$this->kajax->attr( '#re_id_' . $post['re_id'] . '_plate', 'onclick', '' );
				$this->kajax->unbind( '#re_id_' . $post['re_id'] . '_plate', 'click' );
				$this->kajax->bind( '#re_id_' . $post['re_id'] . '_plate', 'click', "function() { radar_change_plate( " . $post['re_id'] . ", '" . $post['plate'] . "' ); }" );
				$this->kajax->fancy_log_success( 'Dominio modificado' );
			}
			else
			{
				$this->kajax->fancy_log_error( validation_errors() );
			}
		}
		else
		{
			$this->kajax->fancy_log_error( "No posees permisos para modificar el dominio." );
		}
		
		$this->kajax->out();
	}
	
	protected function id_replace( $id )
	{
		$this->kajax_replace_new_ids( $id, array( 'row_', 'row_extra_', 'row_extra_2_', 'row_hidden_' ) );
	}
	
	public function delete( $id )
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		if ( $this->user->owns_radar( $id ) )
		{
			$radar = $this->Radar_model->get( $id );
			
			if ( NULL != $radar )
			{
				$this->Radar_model->delete( $id );
				
				$this->kajax->fancy_log_success( "Radar " . $radar['rd_name'] . " eliminado con éxito." );
				
				$this->kajax->remove( '#row_hidden_' . $id );
				$this->kajax->remove( '#row_extra_' . $id );
				$this->kajax->remove( '#row_extra_2_' . $id );
				$this->kajax->remove( '#row_' . $id );
			}
			else
			{
				$this->kajax->fancy_log_error( 'No se encontró el radar a eliminar.' );
			}
		}
		else
		{
			$this->kajax->fancy_log_error( 'No tienes suficientes permisos para eliminar radares.' );
		}
		
		$this->kajax->out();
	}
	
	public function get_new_row()
	{
		$this->session_restrict( USER_TYPE_GOD );
		$this->load->model('Company_model');
		$data['companies']		= $this->Company_model->get_all_names();
		$this->kajax->prepend( '#radars_list_table', $this->load->view( 'new_row_radar', $data, TRUE ) );
		$this->kajax->out();
	}
	
	public function show()
	{
		$this->load->model('Radar_model');
		$this->load->model('RadarEvent_model');
		
		$query_filter			= $this->build_filters();
		$data['radars']			= $this->Radar_model->get_all( $this->user->get_company_ids(), $query_filter );
		
		if ( isset( $data['radars'] ) )
		{
			foreach( $data['radars'] as &$radar )
			{
				$radar['events']	= $this->RadarEvent_model->get_from_radar( $radar['rd_id'], 5 );
			}
		}
		
		$this->add_frame_view( 'radars_view', $data );
	}
	
	protected function build_radars_filters( $from = NUll, $to = NULL, $valid = 1, $type = NULL )
	{
		$filter = array(
			array(
				'field_name'	=>	'rd_id',
				'filter_val'	=>	get_var( 'rd_id' )
			),
			array(
				'field_name'	=>	'rd_name',
				'filter_val'	=>	get_var( 'rd_name' ),
				'filter_type'	=>	SQLFilterType::ILIKE
			),
			array(
				'field_name'	=>	'rd_serial',
				'filter_val'	=>	get_var( 'rd_serial' ),
				'val_convert'	=>	SQLConvertType::HEXDEC
			),
			array(
				'field_name'	=>	're_speed',
				'filter_val'	=>	get_var( 'min_speed' ),
				'filter_type'	=>	SQLFilterType::BIGGER_OR_EQ,
				'val_convert'	=>	SQLConvertType::INT
			),
			array(
				'field_name'	=>	're_speed',
				'filter_val'	=>	get_var( 'max_speed' ),
				'filter_type'	=>	SQLFilterType::SMALLER_OR_EQ,
				'val_convert'	=>	SQLConvertType::INT
			),
			array(
				'field_name'	=>	're_valid',
				'filter_val'	=>	$valid,
				'field_type'	=>	SQLFieldType::INT
			),
			array(
				'field_name'	=>	're_type',
				'filter_val'	=>	$type,
				'field_type'	=>	SQLFieldType::INT
			),
			array(
				'order_by'		=> get_var_def( 'order_by', 're_timestamp' ),
				'order_fields'	=> array( 'rd_name', 'rd_serial', 'rd_id', 're_timestamp' ),
				'order_dir'		=> get_var_def( 'order_dir', 'DESC' )
			)
		);
		
		if ( NULL != $from && NULL != $to )
		{
			$filter[] = array(
				'field_name'	=>	're_timestamp',
				'filter_val'	=>	get_timestamp_from_date_time( $from ),
				'filter_type'	=>	SQLFilterType::BIGGER_OR_EQ
			);
			
			$filter[] = array(
				'field_name'	=>	're_timestamp',
				'filter_val'	=>	get_timestamp_from_date_time( $to ),
				'filter_type'	=>	SQLFilterType::SMALLER_OR_EQ
			);
		}
		
		return SQL::build_query_filter( $filter );
	}
	
	public function events( $type = 0 /*RadarEventType::INFRACTION*/ )
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->model('RadarEvent_model');
		
		$now					= strftime( '%d/%m/%Y %H:%M', time() );
		$hour_ago				= strftime( '%d/%m/%Y %H:%M', time() - 3600 * 6 );
		
		$from_ref				= NULL != get_var('from') ? substr( get_var('from'), strlen( 'Desde el ' ) ) : $hour_ago;
		$to_ref					= NULL != get_var('to') ? substr( get_var('to'), strlen( 'Hasta el ' ) ) : $now;
		$valid					= RadarEventStatus::VALID;
		
		if ( $this->user->is_logged_as_god() || $this->user->is_radar_validator() )
		{
			$valid				= array( RadarEventStatus::NOT_VALIDATED, RadarEventStatus::VALID );
		}
		
		$data['events']			= $this->RadarEvent_model->get_all( $this->user->get_company_ids(), $this->build_radars_filters( $from_ref, $to_ref, $valid, $type ), NULL, 1, 'radar_event.*, rd_name' );
		$data['from']			= NULL != $from_ref ? $from_ref : $hour_ago;
		$data['to']				= NULL != $to_ref ? $to_ref : $now;
		$data['min_speed']		= get_var('min_speed');
		$data['max_speed']		= get_var('max_speed');
		
		$data['rd_id']			= get_var( 'rd_id' );
		$data['rd_serial']		= NULL != get_var( 'rd_serial' ) ? get_var( 'rd_serial' ) : ( NULL != get_var( 'rd_id' ) ? dechex( load_model('Radar_model')->get_serial( get_var('rd_id') ) ) : NULL );
		$data['was_filtering']	= NULL != get_var('from') && NULL != get_var('to');
		$data['management']		= RadarEventType::INFRACTION == $type;
		
		$this->add_frame_view( 'radars_events', $data );
	}
	
	public function events_tests()
	{
		$this->load->model('RadarEvent_model');
		
		$this->events( RadarEventType::TEST );
	}
	
	public function autocomplete( $type = 'code' )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$res		= array();
		$rd_serial	= get_var('search');
		
		$this->load->model('Radar_model');
		
		if ( 'serial' == $type )
		{
			$data	= $this->Radar_model->get_all_serials( $this->user->get_company_ids(), $rd_serial, $this->user->is_logged_as_user() ? $this->user->get_type_id() : NULL );
			
			if ( NULL != $data )
			{
				foreach ( $data as $r )
				{
					array_push( $res, array( 'id' => $r['rd_id'], 'name' => $r['rd_serial'] ) );
				}
			}
		}
		
		echo json_enc( $res );
	}
	
	public function ticket( $re_id )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->load->model('RadarEvent_model');
		$this->load->model('RfidUser_model');
		
		$data['ticket'] = $ticket = $this->RadarEvent_model->get( $re_id );
		$data['person'] = $this->RfidUser_model->get_by_plate( $ticket['re_plate'], $this->user->get_company_ids(), TRUE );
		
		$html = $this->load->view( 'radar_ticket', $data, TRUE );
		
		$timestamp	= str_replace( ' ', '_' , str_replace( '/', '-', str_replace( ':', '-', timestamp_to_str( $ticket['re_timestamp'] ) ) ) );
		$rd_name	= urlencode( str_replace( ' ', '_', $ticket['rd_name'] ) );
		
		$filename = $rd_name . '_ticket_nro_' . $ticket['re_id'] . '_' . $timestamp . '_' . $ticket['re_speed'];
		
		pdf_create( $html, $filename );
	}
	
	public function ticket_preview( $re_id )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->load->model('RadarEvent_model');
		$this->load->model('RfidUser_model');
		
		$data['ticket'] = $ticket = $this->RadarEvent_model->get( $re_id );
		$data['person'] = $this->RfidUser_model->get_by_plate( $ticket['re_plate'], $this->user->get_company_ids(), TRUE );
		$data['preview']= TRUE;
		
		$this->load->view( 'radar_ticket', $data );
	}
	
	public function export( $re_id )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->load->model('RadarEvent_model');
		
		$re = $this->RadarEvent_model->get( $re_id );
		
		$filename = $re['re_rd_serial'] . '_' . $re['re_country_id'] . '_' . $re['re_timestamp'] . '_' . $re['re_max_speed'] . '_' . $re['re_speed'] . '_' . $re['re_type'] . '.jpg';
		
		$filepath = FINESPATH . $re['re_image'];
		
		header('Content-Type: image/jpeg');
		
		header('Content-Length: ' . filesize($filepath));
		
		header('Content-Disposition: attachment; filename="'.$filename.'"');
		
		$fp = fopen($filepath, 'rb');
		
		fpassthru($fp);
	}
	
	public function validation()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->model('RadarEvent_model');
		
		$data['events']	= $this->RadarEvent_model->get_all( $this->user->get_company_ids(), $this->build_radars_filters( NULL, NULL, RadarEventStatus::NOT_VALIDATED ), NULL, 1, 'radar_event.*, rd_name' );
		
		$this->add_frame_view('radars_validation', $data);
	}
	
	public function valid()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		if ( $this->user->is_logged_as_god() || $this->user->is_radar_validator() )
		{
			$this->load->library('form_validation');
			$this->load->library('openkey');
			
			$post = $this->input->post();
			
			$rules	= array(
				array(
					'field'   => 'plate', 
					'label'   => 'Patente', 
					'rules'   => 'trim|required|callback_val_plate'
				)
			);
			
			$this->form_validation->set_rules( $rules );
			
			if ( $this->form_validation->run() != FALSE )
			{
				$this->load->model('RadarEvent_model');
				
				$this->RadarEvent_model->update_state( $post['re_id'], RadarEventStatus::VALID );
				$this->RadarEvent_model->update_plate( $post['re_id'], $post['plate'] );
				
				$re_id_el = '#re_id_' . $post['re_id'];
				
				$this->kajax->remove( $re_id_el . ' .validate' );
				$this->kajax->remove( $re_id_el . ' .invalidate' );
				$this->kajax->removeClass( $re_id_el, 'alert' );
				
				$this->kajax->call( 'radar_event_remove( ' . $post['re_index'] . ' )' );
				
				if ( !$this->openkey->send_openkey_image( $post['re_id'] ) )
				{
					$this->kajax->fancy_log_error( 'No se pudo subir la FotoMulta a OpenKey.' );
				}
			}
			else
			{
				$this->kajax->fancy_log_error( validation_errors() );
			}
		}
		else
		{
			$this->kajax->fancy_log_error( "No posee permisos para realizar esta acción." );
		}
		
		$this->kajax->out();
	}
	
	public function invalid()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		if ( $this->user->is_logged_as_god() || $this->user->is_radar_validator() )
		{
			$post = $this->input->post();
			
			$this->load->model('RadarEvent_model');
			
			$this->RadarEvent_model->update_state( $post['re_id'], RadarEventStatus::INVALID );
			
			$this->kajax->call( 'radar_event_remove( ' . $post['re_index'] . ' )' );
		}
		else
		{
			$this->kajax->fancy_log_error( "No posee permisos para realizar esta acción." );
		}
		
		$this->kajax->out();
	}
	
	public function validate()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		if ( $this->user->is_logged_as_god() || $this->user->is_radar_validator() )
		{
			$this->load->library('form_validation');
			
			$post = $this->input->post();
			
			$rules	= array(
				array(
					'field'   => 'plate', 
					'label'   => 'Patente', 
					'rules'   => 'trim|required|callback_val_plate'
				)
			);
			
			$this->form_validation->set_rules( $rules );
			
			if ( $this->form_validation->run() != FALSE )
			{
				$this->load->library('openkey');
				$this->load->model('RadarEvent_model');
				
				$this->RadarEvent_model->update_state( $post['re_id'], RadarEventStatus::VALID );
				$this->RadarEvent_model->update_plate( $post['re_id'], $post['plate'] );
				
				$re_id_el = '#re_id_' . $post['re_id'];
			
				$this->kajax->remove( $re_id_el . ' .validate' );
				$this->kajax->remove( $re_id_el . ' .invalidate' );
				$this->kajax->removeClass( $re_id_el, 'alert' );
				$this->kajax->removeClass( $re_id_el . ' .revalidate', 'hidden' );
				$this->kajax->call( "$('$re_id_el .revalidate').prev().remove()" );
				$this->kajax->call( "$('$re_id_el .revalidate').prev().remove()" );
				
				if ( $this->openkey->send_openkey_image( $post['re_id'] ) )
				{
					$this->kajax->fancy_log_success( 'FotoMulta validada.' );
				}
				else
				{
					$this->kajax->fancy_log_error( 'No se pudo subir la FotoMulta a OpenKey.' );
				}
			}
			else
			{
				$this->kajax->fancy_log_error( validation_errors() );
			}
		}
		else
		{
			$this->kajax->fancy_log_error( "No posee permisos para realizar esta acción." );
		}
		
		$this->kajax->out();
	}
	
	public function invalidate( $re_id )
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		if ( $this->user->is_logged_as_god() || $this->user->is_radar_validator() )
		{
			$this->load->model('RadarEvent_model');
			
			$this->RadarEvent_model->update_state( $re_id, RadarEventStatus::INVALID );
			
			$this->kajax->remove( '#re_id_' . $re_id );
			
			$this->kajax->fancy_log( 'FotoMulta invalidada' );
		}
		else
		{
			$this->kajax->fancy_log_error( "No posee permisos para realizar esta acción." );
		}
	
		$this->kajax->out();
	}
	
	public function tickets_upload()
	{
		$this->session_restrict( USER_TYPE_GOD );
		
		$this->load->model('Company_model');
		
		$data['type']			= 'hw';
		$data['companies']		= $this->Company_model->get_all_names( User()->get_company_ids() );
		$data['url']			= base_url('/radars/upload_tickets');
		
		$this->load->view( 'tickets_upload', $data );
	}
	
	protected function file_validate( &$file )
	{
		if ( isset( $file ) && file_exists( FINESPATH . $file->name ) )
		{
			$retry		= FALSE;
			$filename	= '';
			$ext		= '.jpg';
			$real_name	= $file->name;
			$file_info	= explode( "_", $file->name );
			
			if ( isset( $file_info ) && !empty( $file_info ) && count( $file_info ) == 6 )
			{
				$this->load->model( 'RadarEvent_model' );
				
				$post['serial'] = $file_info[0];
				$post['country_id'] = $file_info[1];
				$post['timestamp'] = $file_info[2];
				$post['max_speed'] = $file_info[3];
				$post['speed'] = $file_info[4];
				$post['type'] = substr( $file_info[5], 0, strpos( $file_info[5], '.' ) );
				
				if ( !$this->RadarEvent_model->exists( $post['serial'], $post['timestamp'] ) )
				{
					do
					{
						$retry		= FALSE;
						$newname	= rand_string(64);
						$filename	= $newname . $ext;
						$oldfile	= FINESPATH . $file->name;
						$newfile	= FINESPATH . $filename;
						
						$type		= $file->type;
						
						if ( !file_exists( $newfile ) )
						{
							rename( $oldfile, $newfile );
							
							$oldmedfile	= FINESPATH . 'medium/' . $file->name;
							$oldthumbfile	= FINESPATH . 'thumbnail/' . $file->name;
							
							$file->name	= $filename;
							$file->url	= rawurldecode( base_url( '/assets/tickets/' ) . '/' . $filename );
							
							$newmedfile	= FINESPATH . 'medium/' . $filename;
							@rename( $oldmedfile, $newmedfile );
							$file->mediumUrl	= rawurldecode( base_url( '/assets/tickets/medium/' ) . '/' . $filename );
							
							$newthumbfile	= FINESPATH . 'thumbnail/' . $filename;
							@rename( $oldthumbfile, $newthumbfile );
							$file->thumbnailUrl	= rawurldecode( base_url( '/assets/tickets/thumbnail/' ) . '/' . $filename );
						}
						else
						{
							$retry = TRUE;
						}
					}
					while ( $retry );
					
					$id = $this->RadarEvent_model->add( $post['serial'], $post['country_id'], $filename, $post['timestamp'], $post['max_speed'], $post['speed'], $post['type'] );
					
					if ( intval( $post['type'] ) == RadarEventType::INFRACTION )
					{
						$this->load->model('GlobalEvent_model');
						$this->load->model('Radar_model');
						
						$radar = $this->Radar_model->get_from_serial( $post['serial'] );
						
						if ( isset( $radar ) )
						{
							$this->GlobalEvent_model->add( GlobalEventType::INFRACTION, $id, 0, $radar['rd_id'], $radar['rd_serial'], 0, $radar['rd_company'], $post['timestamp'], 'Exceso de Velocidad: ' . $post['speed'] . ' km/h', 0 );
						}
					}
					
					$file->result = '<b>FotoMulta "' . $real_name . '" subida con éxito.</b>';
				}
				else
				{
					$file->error = '<b>FotoMulta "' . $real_name . '" ya se encontraba en el sistema.</b>';
				}
			}
			else
			{
				$file->error = '<b>El archivo "' . $real_name . '" no tiene el formato de una FotoMulta.</b>';
			}
		}
		else
		{
			$file->error = "<b>Fallo al subir el archivo.</b>";
		}
	}
	
	public function upload_tickets()
	{
		$this->session_restrict( USER_TYPE_CPNY_META );
		
		$this->load->library( 'UploadHandler', array( 
				'script_url' => base_url('/radars/upload_tickets/'),
				'upload_dir' => FINESPATH,
				'upload_url' => base_url('/assets/tickets') . '/',
				'accept_file_types' => '/\.(jpg)$/i',
				'image_versions' => array( '' => array(),
					'medium' => array(
						'max_width' => 400,
						'max_height' => 200
					),
					'thumbnail' => array(
						'max_width' => 200,
						'max_height' => 100
					)
				)
			)
		);
		
		$resp = $this->uploadhandler->post(false);
		
		foreach ( $resp['files'] as &$file )
		{
			$this->file_validate( $file );
		}
		
		echo json_encode( $resp );
	}
	
	public function download_log()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->model('RadarLog_model');
		
		$com_id		= $this->user->get_type_id();
		$msgs		= $this->RadarLog_model->get_from( $this->user->get_company_ids(), format_date_time( get_var('from') ), format_date_time( get_var('to') ) );
		$filename	= 'radar - log';
		
		csv_create_header( $filename );
		
		$str = '';
		
		if ( isset( $msgs ) )
		{
			csv_array_sanitize( $msgs );
			
			$sep = CSV_SEPARATOR;
			
			foreach ( $msgs as $msg )
			{
				$str .= '"' . datetime_noms( $msg['time'] ) . '"' . $sep;
				
				$str .= '"' . dechex_bigint( $msg['serial'] ) . '"' . $sep;
				
				$msgs = explode( ' ', $msg['msg'] );
				
				foreach ( $msgs as $msg )
				{
					$str .= "\"$msg\"" . $sep;
				}
				
				$str = substr($str, 0, strlen($str)-1);
				$str .= "\n";
			}
		}
		
		echo $str;
	}
	
	public function log()
	{
		$this->session_restrict( USER_TYPE_GOD );
		
		$this->add_frame_view( 'radar_log' );
	}
	
	public function get_log()
	{	
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->model('RadarLog_model');
		
		$msgs					= $this->RadarLog_model->get( $this->user->get_company_ids(), get_post('last_id') );
		$res['ok']				= true;
		$res['data']			= $msgs;
		$res['tick']			= $this->RadarLog_model->get_last( $this->user->get_company_ids() );
		
		echo json_encode( $res );
	}
}
