<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Person extends DSHIELD_Controller
{
	public function index()
	{
		$this->all();
	}
	
	public function add( $auto_select_type = NULL )
	{
		$this->session_restrict( USER_TYPE_CPNY_RO );
		
		$this->load->model('RfidUser_model');
		
		$this->load->helper('hours');
		$data['upload_photo_url']	= base_url('/person/upload_person_photo?adding_person=true');
		$data['input_status'] = !$this->user->can_write() ? 'disabled' : '';
		
		if ( $this->user->is_professional() )
		{
			$data['autoselect_type'] = RfIdUserType::WORKER;
		}
		else if ( isset( $auto_select_type ) && RfIdUserType::is_valid( $auto_select_type ) )
		{
			$data['autoselect_type'] = $auto_select_type;
		}
		
		$this->load->view('dshield/person_add', $data);
	}
	
	public function edit( $id )
	{
		if ( $this->owns_person( $id ) )
		{
			$this->load->model('RfidUser_model');
			
			$data['person'] = $this->RfidUser_model->get( $id );
			$data['input_status'] = !$this->user->can_write() || $this->user->is_guard() ? 'disabled' : '';
			$data['is_edit'] = TRUE;
			$data['is_guard'] = $this->user->is_guard();
			
			$this->load->view('dshield/person_basic_data', $data);
		}
	}
	
	public function suspend( $id )
	{
		$resp['result'] = 'error';
		
		if ( $this->user->owns_person( $id ) )
		{
			$this->load->model('RfidUser_model');
			
			$this->RfidUser_model->suspend( $id );
			
			$resp['result'] = 'ok';
		}
		
		echo json_encode( $resp );
	}
	
	public function allow( $id )
	{
		$resp['result'] = 'error';
		
		if ( $this->owns_person( $id ) )
		{
			$this->load->model('RfidUser_model');
			
			$this->RfidUser_model->allow( $id );
			
			$person = $this->RfidUser_model->get( $id );
			
			if ( isset( $person ) && $person['urfid_user_type'] == RfIdUserType::VISITOR )
			{
				$this->RfidUser_model->update_expiration( $id, time() + RfidUser_model::$visitor_expiration_time );
			}
			
			$resp['result'] = 'ok';
		}
		
		echo json_encode( $resp );
	}
	
	public function edit_photo( $id )
	{
		if ( $this->owns_person( $id ) )
		{
			$this->load->model('RfidUser_model');
			
			$data['person']				= $this->RfidUser_model->get( $id );
			$data['upload_photo_url']	= base_url('/person/upload_person_photo');
			$data['dialog_header']		= TRUE;
			
			$this->load->view('dshield/person_photo', $data);
		}
	}
	
	public function edit_hours( $id )
	{
		if ( $this->owns_person( $id ) )
		{
			$this->load->helper('hours');
			$this->load->model('RfidUser_model');
			$this->load->model('RfidUserHours_model');
			
			$data['person'] = $this->RfidUser_model->get( $id );
			
			$data['hours'] = $this->RfidUserHours_model->build_hour_table( $id );
			
			if ( null != get_var('adding_person') )
			{
				$data['adding_person'] = TRUE;
			}
			
			$this->load->view('dshield/person_hours_base', $data);
		}
	}
	
	protected function edit_gallery_type( $id, $type )
	{
		if ( $this->owns_person( $id ) )
		{
			$this->load->model('RfidUser_model');
			$this->load->model('RfidGallery_model');
			$this->load->model('RfidPhoto_model');
			
			$gallery_id					= $this->RfidGallery_model->get_id( $id, $type );
			$data['person']				= $this->RfidUser_model->get( $id );
			$data['gallery_id']			= $gallery_id;
			$data['gallery_type']		= $type;
			$data['photos']				= $this->RfidPhoto_model->get_gallery_photos( $gallery_id );
			$data['upload_photo_url']	= base_url('/person/upload_gallery_photo/'. $type . '?');
			$data['user_data']			= json_decode( $data['person']['urfid_user_data'], TRUE );
			
			if ( NULL != get_var('adding_person') && 'true' == get_var('adding_person') )
			{
				$data['adding_person']		= TRUE;
				$data['next_step']			= get_var_def( 'next_step', 'dshield_person_set_type_data_3' );
				$data['upload_photo_url']	.= 'adding_person=true&next_step=' . $data['next_step'];
			}
			
			$this->load->view('dshield/person_gallery', $data );
		}
	}
	
	public function edit_tools( $id )
	{
		$this->load->model('RfidGallery_model');
		$this->edit_gallery_type( $id, RfidGalleryType::TOOLS );
	}
	
	public function edit_gallery( $id )
	{
		$this->load->model('RfidGallery_model');
		$this->edit_gallery_type( $id, RfidGalleryType::GENERAL );
	}
	
	public function edit_insurance( $id )
	{
		$this->load->model('RfidGallery_model');
		$this->edit_gallery_type( $id, RfidGalleryType::INSURANCE );
	}
	
	public function edit_entrance( $id )
	{
		if ( $this->owns_person( $id ) )
		{
			$this->load->model('RfidUser_model');
			
			$data['person']				= $this->RfidUser_model->get( $id );
			
			$this->load->view('dshield/person_entrance', $data );
		}
	}
	
	protected function process_upload_gallery_photo( $id, $param_name, $newname, $resp, $gallery_type )
	{
		$this->load->model('RfidGallery_model');
		$this->load->model('RfidPhoto_model');
		$this->load->model('RfidUser_model');
		
		$gallery_id = $this->RfidGallery_model->get_id( $id, $gallery_type );
		
		$state = InsurancePhotoState::NOT_VALIDATED;
		
		if ( $gallery_type == RfidGalleryType::INSURANCE )
		{
			$this->RfidPhoto_model->delete_gallery( $gallery_id );
			
			if ( $this->user->is_logged_as_company() && !$this->user->is_professional() )
			{
				$state = InsurancePhotoState::VALID;
			}
		}
		
		$rp_id = $this->RfidPhoto_model->add( $newname, $gallery_id, $state );
		
		if ( $gallery_type == RfidGalleryType::TOOLS )
		{
			$this->load->model('RfidEvent_model');
			
			$this->RfidEvent_model->add( $rp_id, $id, RfidType::TOOL_PHOTO, RfidCommandType::ADD, time(), $this->RfidUser_model->get_company( $id ), 'ACCEPTED', $id );
		}
		
		$sec = ( $gallery_type == RfidGalleryType::GENERAL ? 'edit_gallery' : ( $gallery_type == RfidGalleryType::TOOLS ? 'edit_tools' : 'edit_insurance' ) );
		
		$resp['upload_type']	= 'gallery_photo';
		$resp['href']			= base_url('/person/' . $sec . '/' . $id );
		$resp['adding_person']	= get_var( 'adding_person' ) ? true : false;
		
		if ( get_var( 'next_step' ) != NULL )
		{ 
			$resp['next_step']	= get_var( 'next_step' );
		}
		
		return $resp;
	}
	
	public function upload_gallery_photo( $gallery_type )
	{
		$this->upload_photo( 'process_upload_gallery_photo', $gallery_type );
	}
	
	protected function build_person_filters( $filter_users = NULL )
	{
		$filter				= array(
			array(
				'field_name'	=>	'urfid_name',
				'filter_val'	=>	get_var( 'urfid_name' ),
				'filter_type'	=>	SQLFilterType::ILIKE
			),
			array(
				'field_name'	=>	'urfid_dni',
				'filter_val'	=>	get_var( 'urfid_dni' ),
				'field_type'	=>	SQLFieldType::INT
			),
			array(
				'field_name'	=>	'urfid_plate',
				'filter_val'	=>	get_var( 'urfid_plate' ),
				'filter_type'	=>	SQLFilterType::ILIKE
			),
			array(
				'field_name'	=>	'urfid_user_type',
				'filter_val'	=>	get_var( 'types' )
			),
			array(
				'field_name'	=>	'urfid_inside',
				'filter_val'	=>	get_var( 'urfid_inside' )
			),
			array(
				'order_by'		=> array( get_var_def( 'order_by', 'urfid_name' ), 'urfid_id' ),
				'order_fields'	=> array( 'urfid_id', 'urfid_name', 'urfid_dni', 'urfid_user_type', 'urfid_creation_time' ),
				'order_dir'		=> array( get_var_def( 'order_dir', 'ASC' ), NULL )
			)
		);
		
		
		$urfid_dni = get_var( 'urfid_dni' );
		
		if ( isset( $urfid_dni ) && '' != $urfid_dni && !is_numeric_integer( $urfid_dni ) )
		{
			$this->kajax->fancy_log_error( 'El número de DNI debe ser un valor entero.' );
		}
		
		$order_by = get_var( 'order_by' );
		
		if ( 'urfid_creation_time' == $order_by )
		{
			$filter[] = array(
				'field_name'	=>	'urfid_creation_time',
				'filter_val'	=>	time() - 432000,
				'filter_type'	=>	SQLFilterType::BIGGER_OR_EQ
			);
		}
		
		if ( get_var('with_photo') )
		{
			$filter[] = array(
				'field_name'	=>	'urfid_photo',
				'filter_val'	=>	'',
				'filter_type'	=>	SQLFilterType::UNEQUALS,
				'accept_null'	=>	TRUE,
				'compare_string'=>	TRUE
			);
		}
		
		$filter_plot = NULL;
		
		if ( $this->user->is_professional() )
		{
			$this->load->model('RfidUserPlot_model');
			
			$filter[] = array(
				'field_name'	=>	'urfid_user_type',
				'filter_val'	=>	RfIdUserType::WORKER
			);
			
			$person			= $this->RfidUser_model->get_by_uid( $this->user->get_user_id() );
			$filter_plot_t	= $this->RfidUserPlot_model->get_arr( $person['urfid_id'] );
			$filter_plots	= get_var('urfid_plot');
			
			if ( isset( $filter_plots ) )
			{
				$filter_plot_f	= explode( ',', $filter_plots );
				$filter_plot	= array();
				
				if ( isset( $filter_plot_f ) && !empty( $filter_plot_f ) )
				{
					foreach ( $filter_plot_f as $p )
					{
						if ( in_array( $p, $filter_plot_t ) )
						{
							$filter_plot[] = $p;
						}
					}
					
					if ( empty( $filter_plot ) )
					{
						$filter_plot = $filter_plot_t;
					}
				}
			}
			else
			{
				$filter_plot = $filter_plot_t;
			}
		}
		else if ( NULL != get_var('urfid_plot') )
		{
			$filter_plot = explode( ',', get_var('urfid_plot') );
		}
		
		if ( NULL != $filter_plot && !empty( $filter_plot ) && '' != $filter_plot[0] )
		{
			if ( !is_numeric_integer_array( $filter_plot ) )
			{
				$this->kajax->fancy_log_error( 'El número de lote debe ser un valor entero.' );
			}
			else
			{
				$filter[] = array(
					'join'			=>	'rfid_user_plot',
					'on'			=>	'urfid_id = rup_urfid_id'
				);
				
				$filter[] = array(
					'field_name'	=>	'rup_plot',
					'filter_val'	=>	$filter_plot,
					'field_type'	=>	SQLFieldType::INT
				);
			}
		}
		
		if ( NULL != $filter_users )
		{
			$filter[] = array(
				'field_name'	=>	'urfid_id',
				'filter_val'	=>	$filter_users
			);
		}
		
		$query_filter		= SQL::build_query_filter( $filter );
		
		return $query_filter;
	}
	
	public function all()
	{
		$this->session_restrict( USER_TYPE_CPNY_RO );
		
		$this->load->library('pagination');
		$this->load->model('RfidUser_model');
		
		$page					= get_var_def( 'page_num', 1 );
		$config					= pagination_config();
		$config['per_page']		= 50;
		$query_filter			= $this->build_person_filters();
		$data['urfid_name']		= get_var( 'urfid_name' );
		$data['urfid_dni']		= get_var( 'urfid_dni' );
		$data['urfid_plate']	= get_var( 'urfid_plate' );
		$data['urfid_plot']		= get_var( 'urfid_plot' );
		$data['urfid_inside']	= get_var( 'urfid_inside' );
		$fields_get				= str_replace( '?', get_var_def( 'order_by', 'urfid_name' ), 'DISTINCT ON (?, rfid_user.urfid_id) rfid_user.*,rfid.*' );
		$config['total_rows']	= $data['total_persons']	= $this->RfidUser_model->count( $this->user->get_company_ids(), $query_filter );
		$data['persons']		= $this->RfidUser_model->get_all( $this->user->get_company_ids(), $query_filter, $config['per_page'], $page, $fields_get );
		$config['base_url']		= base_url( '/dshield/person/all/?' . http_build_query_pagination() );
		$data['new_person']		= $this->user->is_professional() ? 'Nuevo Empleado de Obra' : 'Nueva Persona';
		$data['is_guard']		= $this->user->is_guard();
		$data['script']			= $this->kajax->out(TRUE,TRUE);
		
		$this->pagination->initialize($config);
		
		$data['pagination']		= $this->pagination->create_links();
		
		$this->add_frame_view( 'dshield/person_list', $data );
	}
	
	public function update_observations()
	{
		$this->session_restrict( USER_TYPE_CPNY_RO );
		
		$post = $this->input->post();

		if ( $this->user->owns_person( $post['id'] ) )
		{
			$this->load->model('RfidUser_model');
			
			$this->RfidUser_model->update_observations( $post['id'], $post['observations'] );
			
			$this->kajax->fancy_log_success( "Observaciones actualizadas." );
			$this->kajax->call('modal_dialog_close();');
		}
		else
		{
			$this->kajax->fancy_log_error( "No tienes permisos para realizar esta acción." );
		}
		
		$this->kajax->out();
	}
	
	public function insert_plot()
	{
		$this->session_restrict( USER_TYPE_CPNY_RO );
		
		$this->load->model('RfidUserPlot_model');
		
		$post = $this->input->post();
		
		if ( $this->user->is_professional() )
		{
			if ( isset( $post['id'] ) && isset( $post['plot'] ) && !empty( $post['plot'] ) )
			{
				if ( !$this->RfidUserPlot_model->in_plot_user( $post['plot'], $this->user->get_user_id() ) )
				{
					$this->kajax->fancy_log_error( "El lote a asignar debe ser un lote donde el profesional a cargo de obra posea acceso." );
				}
				else
				{
					$this->RfidUserPlot_model->add_opt( $post['id'], $post['plot'] );
					
					$this->kajax->fancy_log_success("Lotes agregados con éxito.");
					$this->kajax->call('modal_dialog_close()');
					$this->kajax->reload_target();
				}
			}
			else
			{
				$this->kajax->fancy_log_error("Faltan datos.");
			}
		}
		else
		{
			$this->kajax->fancy_log_error("No posees permisos para realizar esta acción.");
		}
		
		$this->kajax->out();
	}
	
	public function insert()
	{
		$this->session_restrict( USER_TYPE_CPNY_RO );
		
		$this->load->model('RfidUser_model');
		$this->load->model('RfidUserPlot_model');
		
		$this->load->library('form_validation');
		
		if ( !$this->user->can_write() )
		{
			$this->kajax->fancy_log_error("No posees permisos para editar personas");
			$this->kajax->out();
			return;
		}
		
		$post = $this->input->post();
		
		$is_editing = !( !isset( $post['id'] ) || empty( $post['id'] ) || 0 == intval( $post['id'] ) );
		
		if ( $this->user->is_guard() )
		{
			if ( $is_editing )
			{
				$this->update_observations();
				return;
			}
			else
			{
				if ( $post['type'] != RfIdUserType::GUEST && $post['type'] != RfIdUserType::PROVIDER && $post['type'] != RfIdUserType::VISITOR && $post['type'] != RfIdUserType::WORKER )
				{
					$this->kajax->fancy_log_error( "No tienes permisos para cargar el tipo de usuario definido" );
					$this->kajax->out();
					return;
				}
			}
		}
		
		if ( isset( $post['id'] ) && '' != $post['id'] )
		{
			$me = $this->RfidUser_model->get( $post['id'] );
			
			$plot_rules = ( $me['urfid_user_type'] != RfIdUserType::NEIGHBOR_EMPLOYEE && $me['urfid_user_type'] != RfIdUserType::GUARD ) ? '|required' : '';
		}
		else
		{
			$plot_rules = $post['type'] != RfIdUserType::NEIGHBOR_EMPLOYEE && $post['type'] != RfIdUserType::GUARD ? '|required' : '';
		}
		
		$rules	= array(
			array(
				'field'   => 'name', 
				'label'   => 'Nombre Completo', 
				'rules'   => 'trim|required|max_length[64]'
			),
			array(
				'field'   => 'dni', 
				'label'   => 'DNI', 
				'rules'   => 'trim|required|integer'
			),
			array(
				'field'   => 'plate', 
				'label'   => 'Patente', 
				'rules'   => 'trim|callback_val_plate_list'
			),
			array(
				'field'   => 'plot', 
				'label'   => 'Lote', 
				'rules'   => 'trim|callback_val_plot_list' . $plot_rules
			),
			array(
				'field'   => 'phone',
				'label'   => 'Teléfono',
				'rules'   => 'trim|max_length[64]'
			),
			array(
				'field'   => 'observations',
				'label'   => 'Observaciones',
				'rules'   => 'trim|max_length[8192]'
			)
		);
		
		if ( RfIdUserType::PROVIDER == $post['type'] )
		{
			$rules[] = array(
				'field'   => 'company_name',
				'label'   => 'Empresa',
				'rules'   => 'trim|max_length[64]' 
			);
		}
		
		$this->form_validation->set_rules( $rules );
		
		$form_inputs = '.form-table input, .form-table textarea, .form-table select';
		$this->kajax->removeClass( $form_inputs, 'error' );
		$this->kajax->resetAnim( $form_inputs );
		
		if ( $this->form_validation->run() != FALSE )
		{
			if ( !$is_editing )
			{
				if ( !$this->RfidUser_model->exists_dni( $post['dni'], $this->user->get_company_ids() ) )
				{
					$plot_ok = trim( $post['plot'] ) == '' || !$this->RfidUserPlot_model->has_owner( $post['plot'], $this->user->get_company_ids() );
					
					if ( $this->user->is_professional() && !$this->RfidUserPlot_model->in_plot_user( $post['plot'], $this->user->get_user_id() ) )
					{
						$this->kajax->fancy_log_error( "El lote a asignar debe ser un lote donde el profesional a cargo de obra posea acceso." );
					}
					else
					{
						if ( RfIdUserType::OWNER != $post['type'] || $plot_ok )
						{
							if ( $this->user->is_professional() )
							{
								$post['type'] = RfIdUserType::WORKER;
							}
							
							$urfid_id = $this->RfidUser_model->add( $post['type'], $this->user->get_company(), $post['name'], $post['dni'], $post['plate'], $post['phone'], $post['observations'], RfIdUserType::OWNER != $post['type'] ? NULL : $post['plot'] );
							
							if ( isset( $post['plot'] ) && !empty( $post['plot'] ) )
							{
								$this->load->model('RfidUserPlot_model');
								
								$this->RfidUserPlot_model->clean_and_add( $urfid_id, explode( ',', $post['plot'] ) );
							}
							
							if ( RfIdUserType::WORKER == $post['type'] )
							{
								$this->load->model('RfidUserHours_model');
								
								$default_hours = json_decode( '{"hours_man_lun_ini": "08:00","hours_man_lun_fin": "12:00","hours_man_mar_ini": "08:00","hours_man_mar_fin": "12:00","hours_man_mie_ini": "08:00","hours_man_mie_fin": "12:00","hours_man_jue_ini": "08:00","hours_man_jue_fin": "12:00","hours_man_vie_ini": "08:00","hours_man_vie_fin": "12:00","hours_man_sab_ini": "","hours_man_sab_fin": "","hours_man_dom_ini": "","hours_man_dom_fin": "","hours_tar_lun_ini": "12:00","hours_tar_lun_fin": "18:00","hours_tar_mar_ini": "12:00","hours_tar_mar_fin": "18:00","hours_tar_mie_ini": "12:00","hours_tar_mie_fin": "18:00","hours_tar_jue_ini": "12:00","hours_tar_jue_fin": "18:00","hours_tar_vie_ini": "12:00","hours_tar_vie_fin": "18:00","hours_tar_sab_ini": "","hours_tar_sab_fin": "","hours_tar_dom_ini": "","hours_tar_dom_fin": "","hours_noc_lun_ini": "","hours_noc_lun_fin": "","hours_noc_mar_ini": "","hours_noc_mar_fin": "","hours_noc_mie_ini": "","hours_noc_mie_fin": "","hours_noc_jue_ini": "","hours_noc_jue_fin": "","hours_noc_vie_ini": "","hours_noc_vie_fin": "","hours_noc_sab_ini": "","hours_noc_sab_fin": "","hours_noc_dom_ini": "","hours_noc_dom_fin": ""}', TRUE );
								
								if ( SERVER_NAME == 'bsvr' )
									$default_hours = json_decode( '{"hours_man_lun_ini": "08:00","hours_man_lun_fin": "12:00","hours_man_mar_ini": "08:00","hours_man_mar_fin": "12:00","hours_man_mie_ini": "08:00","hours_man_mie_fin": "12:00","hours_man_jue_ini": "08:00","hours_man_jue_fin": "12:00","hours_man_vie_ini": "08:00","hours_man_vie_fin": "12:00","hours_man_sab_ini": "","hours_man_sab_fin": "","hours_man_dom_ini": "","hours_man_dom_fin": "","hours_tar_lun_ini": "12:00","hours_tar_lun_fin": "17:00","hours_tar_mar_ini": "12:00","hours_tar_mar_fin": "17:00","hours_tar_mie_ini": "12:00","hours_tar_mie_fin": "17:00","hours_tar_jue_ini": "12:00","hours_tar_jue_fin": "17:00","hours_tar_vie_ini": "12:00","hours_tar_vie_fin": "17:00","hours_tar_sab_ini": "","hours_tar_sab_fin": "","hours_tar_dom_ini": "","hours_tar_dom_fin": "","hours_noc_lun_ini": "","hours_noc_lun_fin": "","hours_noc_mar_ini": "","hours_noc_mar_fin": "","hours_noc_mie_ini": "","hours_noc_mie_fin": "","hours_noc_jue_ini": "","hours_noc_jue_fin": "","hours_noc_vie_ini": "","hours_noc_vie_fin": "","hours_noc_sab_ini": "","hours_noc_sab_fin": "","hours_noc_dom_ini": "","hours_noc_dom_fin": ""}', TRUE ); 
								
								$this->RfidUserHours_model->save( $urfid_id, $default_hours );
							}
							
							if ( RfIdUserType::VISITOR == $post['type'] )
							{
								$this->RfidUser_model->update_expiration( $urfid_id, time() + RfidUser_model::$visitor_expiration_time );
							}
							else if ( RfIdUserType::PROVIDER == $post['type'] )
							{
								$this->RfidUser_model->update_company_name( $urfid_id, $post['company_name'] );
							}
							
							$this->kajax->fancy_log_success( $post['name'] . " añadido." );
							
							$this->kajax->call( 'person_insert_form_storage_remove()' );
							
							$this->kajax->call( 'dshield_photo_set_person( ' . $urfid_id . ' )' );
						}
						else
						{
							$this->kajax->fancy_log_error( "El lote ya posee un propietario cargado en el sistema." );
						}
					}
				}
				else
				{
					if ( $this->user->is_professional() )
					{
						$urfid = $this->RfidUser_model->get_by_dni( $post['dni'], $this->user->get_company_ids() );
						
						if ( isset( $urfid ) )
						{
							if ( $urfid['urfid_user_type'] != RfIdUserType::WORKER )
							{
								$this->kajax->fancy_alert( 'La persona que usted quiere cargar ya se encuentra en sistema como "' . RfIdUserType::to_string( $urfid['urfid_user_type'] ) . '". Por favor solicite al administrador que reclasifique a la persona como "Empleado de obra".' );
							}
							else
							{
								$this->kajax->call( 'dshield_already_exists( ' . $urfid['urfid_id'] . ', "' . $urfid['urfid_name'] . '", "' . $post['plot'] . '" )' );
							}
						}
						else
						{
							$this->kajax->fancy_log_error( "La persona con el DNI ingresado ya existe en el sistema." );
						}
					}
					else
					{
						$this->kajax->fancy_log_error( "La persona con el DNI ingresado ya existe en el sistema." );
					}
				}
			}
			else
			{
				if ( $this->user->owns_person( $post['id'] ) )
				{
					if ( !$this->RfidUser_model->exists_dni_not_me( $post['dni'], $post['id'], $this->user->get_company_ids() ) )
					{
						$me = $this->RfidUser_model->get( $post['id'] );
						
						$plot_ok = trim( $post['plot'] ) == '' || !$this->RfidUserPlot_model->has_owner_not_me( $post['plot'], $post['id'], $this->user->get_company_ids() );
						
						if ( RfIdUserType::OWNER != $me['urfid_user_type'] || $plot_ok )
						{
							$this->RfidUser_model->update( $post['id'], $post['name'], $post['dni'], $post['plate'], $post['phone'], $post['observations'] );
							
							if ( RfIdUserType::OWNER == $me['urfid_user_type'] && isset( $me['urfid_uid'] ) && intval( $me['urfid_uid'] ) != 0 )
							{
								$this->load->model('User_model');
								
								$this->User_model->update_name_and_phone( $me['urfid_uid'], $post['name'], $post['phone'] );
							}
							
							if ( isset( $post['plot'] ) && !empty( $post['plot'] ) )
							{
								if ( $this->user->is_professional() && !$this->RfidUserPlot_model->in_plot_user( $post['plot'], $this->user->get_user_id() ) )
								{
									$this->kajax->fancy_log_error( "El lote a asignar debe ser un lote donde el profesional a cargo de obra posea acceso." );
								}
								else
								{
									$this->load->model('RfidUserPlot_model');
								
									$this->RfidUserPlot_model->clean_and_add( $post['id'], explode( ',', $post['plot'] ) );
								}
							}
							
							if ( RfIdUserType::PROVIDER == $me['urfid_user_type'] )
							{
								$this->RfidUser_model->update_company_name( $post['id'], $post['company_name'] );
							}
							
							$this->kajax->fancy_log_success( $post['name'] . " editado." );
							$this->kajax->reload_target();
						}
						else
						{
							$this->kajax->fancy_log_error( "El lote ya posee un propietario cargado en el sistema." );
						}
					}
					else
					{
						$this->kajax->fancy_log_error( "La persona con el DNI ingresado ya existe en el sistema." );
					}
				}
				else
				{
					$this->kajax->fancy_log_error( "No tienes permisos para realizar esta acción." );
				}
			}
		}
		else
		{
			$this->kajax->fancy_log_error( validation_errors() );
		}
		
		$this->kajax_validate_inputs( $rules );
		
		$this->kajax->out();
	}
	
	public function delete( $urfid_id )
	{
		if ( $this->owns_person( $urfid_id ) && $this->user->can_write() && !$this->user->is_guard() )
		{
			$this->load->model('User_model');
			$this->load->model('Rfid_model');
			$this->load->model('RfidUser_model');
			$this->load->model('RfidUserPlot_model');
			$this->load->model('RfidUserHours_model');
			
			$person = $this->RfidUser_model->get( $urfid_id );
			
			$this->Rfid_model->unassign_person_by_urfid_id( $urfid_id );
			$this->RfidUser_model->delete( $urfid_id );
			$this->RfidUserPlot_model->delete( $urfid_id );
			$this->RfidUserHours_model->delete( $urfid_id );
			
			if ( isset( $person ) && isset( $person['urfid_uid'] ) && RfIdUserType::OWNER == $person['urfid_user_type'] )
			{
				$this->User_model->delete( $person['urfid_uid'] );
			}
			
			$this->kajax->reload_target();
			$this->kajax->call('modal_dialog_close()');
			$this->kajax->fancy_log_success( 'Perfil de persona borrado' );
		}
		else
		{
			$this->kajax->fancy_log_error( 'No posees permisos para modificar esta persona.' );
		}
		
		$this->kajax->out();
	}
	
	public function entrance()
	{
		$this->session_restrict( USER_TYPE_CPNY_RO );
		
		$post = $this->input->post();
		
		if ( !$this->user->is_guard() && $this->user->owns_person( $post['id'] ) )
		{
			$entrance_type	= RfidUserEntranceType::SIMPLE == intval( $post['entrance'] ) ? RfidUserEntranceType::SIMPLE : RfidUserEntranceType::DOUBLE;
			$exit_type		= RfidUserEntranceType::SIMPLE == intval( $post['exit'] ) ? RfidUserEntranceType::SIMPLE : RfidUserEntranceType::DOUBLE;
			
			$this->RfidUser_model->update_entrance_exit_type( $post['id'], $entrance_type, $exit_type );
			
			$this->kajax->fancy_log_success( "Tipo de entrada y salida guardadas con éxito." );
		}
		else
		{
			$this->kajax->fancy_log_error( 'No tienes permisos para modificar esta persona.' );
		}
		
		$this->kajax->call('modal_dialog_close()');
		
		$this->kajax->out();
	}
	
	protected function upload_photo( $saved_callback, $gallery_type = null )
	{
		$this->load->model('RfidGallery_model');
		
		$id = get_post( 'urfid_id' ) ? get_post( 'urfid_id' ) : get_var( 'urfid_id' );
		
		if ( !$this->owns_person( $id ) )
		{
			echo json_enc( array( 'error' => 'unauthorized' ) );
			return;
		}
		
		$is_webcam = get_var('webcam');
		
		$param_name = $is_webcam ? 'webcam' : 'files';
		
		$accept_types = $is_webcam ? '' : '/\.(gif|jpe?g|png)$/i';
		
		if ( $gallery_type == RfidGalleryType::INSURANCE )
		{
			$accept_types = $is_webcam ? '' : '/\.(gif|jpe?g|png|pdf)$/i';
		}
		
		$this->load->library( 'UploadHandler', array( 
			'script_url' => base_url('/person/upload_person_photo/'),
			'param_name' => $param_name,
			'accept_file_types' => $accept_types,
			'image_versions' => array(
				'thumbnail' => array(
					'max_width' => 240,
					'max_height' => 240
				)
			)
		) );
		
		$resp = $this->uploadhandler->post(false);
		
		if ( isset( $resp[$param_name][0] ) && file_exists( TMPPATH . $resp[$param_name][0]->name ) )
		{
			$retry		= FALSE;
			$newname	= '';
			$filename	= '';
			$ext		= '.jpg';
			$is_pdf		= FALSE;
			
			if ( stristr( $resp[$param_name][0]->name, '.pdf' ) )
			{
				$is_pdf = TRUE;
				$ext = '.pdf';
			}
			
			do
			{
				$retry		= FALSE;
				$newname	= rand_string(64);
				$filename	= $newname . $ext;
				$oldfile	= TMPPATH . $resp[$param_name][0]->name;
				$newfile	= PHOTOSPATH . $filename;
				
				if ( $is_pdf )
				{
					$newname .= $ext;
				}
				
				if ( !file_exists( $newfile ) )
				{
					copy( $oldfile, $newfile );
					unlink( $oldfile );
					
					$oldthumbfile	= TMPPATH . 'thumbnail/' . $resp[$param_name][0]->name;
					
					$resp[$param_name][0]->name	= $filename;
					$resp[$param_name][0]->url	= rawurldecode( base_url( '/assets/photos/' ) . '/' . $filename );
					
					if ( !$is_pdf )
					{
						$newthumbfile	= PHOTOSPATH . 'thumbnail/' . $filename;
						copy( $oldthumbfile, $newthumbfile );
						unlink( $oldthumbfile );
						$resp[$param_name][0]->thumbnailUrl	= rawurldecode( base_url( '/assets/photos/thumbnail/' ) . '/' . $filename );
					}
				}
				else
				{
					$retry = TRUE;
				}
			}
			while ( $retry );
			
			$resp = call_user_func( array( $this, $saved_callback ), $id, $param_name, $newname, $resp, $gallery_type );
		}
		
		if ( isset( $resp['webcam'] ) )
		{
			$resp['files'] = $resp['webcam'];
			
			unset( $resp['webcam'] );
		}
		
		echo json_encode( $resp );
	}
	
	protected function process_upload_person_photo( $id, $param_name, $newname, $resp, $data )
	{
		$this->load->model('RfidUser_model');
		
		$this->RfidUser_model->update_profile_photo( $id, $newname );
		
		$resp['upload_type']			= 'profile_photo';
		$resp['was_editing']			= !get_var( 'adding_person' ) ? true : false;
		$resp[$param_name][0]->result	= 'Foto de perfil actualizada';
		
		return $resp;
	}
	
	public function upload_person_photo()
	{
		$this->upload_photo( 'process_upload_person_photo' );
	}
	
	public function hours_save()
	{
		$urfid_id = get_post('urfid_id');
		
		if ( isset( $urfid_id ) && $this->owns_person( $urfid_id ) )
		{
			$this->load->model( 'RfidUserHours_model' );
			
			$this->RfidUserHours_model->save( $urfid_id, $this->input->post() );
			
			$this->kajax->fancy_log_success( 'Franja Horaria Guardada Exitosamente' );
			
			$this->kajax->val( '#person_hours_save_finish', 'Finalizar' );
		}
		else
		{
			$this->kajax->fancy_log_error( "No puedes modificar la franja horaria de esta persona" );
		}
		
		$this->kajax->out();
	}
	
	public function insurance_set()
	{
		$urfid_id = get_post('urfid_id');
		$date = get_post('expiration');
		$resp['result'] = 'error';
		
		if (	isset( $urfid_id ) && 
				$this->owns_person( $urfid_id ) && 
				isset( $date ) && 
				'' != $date && 
				( $timestamp = get_timestamp_from_date( $date ) ) 
		)
		{
			$this->load->model('RfidUser_model');
			$this->load->model('RfidUserHours_model');
			$this->load->model('RfidPhoto_model');
			$this->load->model('RfidGallery_model');
			
			$gallery_id = $this->RfidGallery_model->get_id( $urfid_id, RfidGalleryType::INSURANCE );
			
			$state = InsurancePhotoState::NOT_VALIDATED;
			
			if ( $this->user->is_logged_as_company() && !$this->user->is_professional() )
			{
				$state = InsurancePhotoState::VALID;
			}
			
			if ( $this->RfidPhoto_model->get_gallery_photos_count( $gallery_id ) == 0 )
			{
				$this->RfidPhoto_model->add( '', $gallery_id, $state );
			}
			else
			{
				$insurance = $this->RfidPhoto_model->get_insurance_from( $urfid_id );
				
				if ( isset( $insurance ) )
				{
					$this->RfidPhoto_model->update_state( $insurance['rp_id'], $state );
				}
			}
			
			$person = $this->RfidUser_model->get( $urfid_id );
			
			$user_data = json_decode( $person['urfid_user_data'], TRUE );
			
			$user_data['insurance_expiration'] = $timestamp;
			
			$this->RfidUser_model->update_data( $urfid_id, $user_data );
			
			$resp['result'] = 'ok';
		}
		
		echo json_encode( $resp );
	}
	
	public function pair()
	{
		$post = $this->input->post();
		
		if ( $this->owns_person( $post['urfid_id'] ) )
		{
			$this->load->model('RfidUser_model');
			$this->load->model('User_model');
			
			$person = $this->RfidUser_model->get( $post['urfid_id'] );
			$user = $this->User_model->get( $post['uid'], ARRAY_A );
			
			if ( isset( $person ) && isset( $user ) )
			{
				if ( !( $person_other = $this->RfidUser_model->exists_uid_not_me( $post['uid'], $post['urfid_id'] ) ) )
				{
					$this->RfidUser_model->update_uid( $post['urfid_id'], $post['uid'] );
					
					$this->User_model->flag_as_dshield_user( $post['uid'] );
					
					$this->kajax->fancy_log_success( $person['urfid_name'] . " se ha enlazado al usuario '" . $user['uname'] . "''" );
					
					$this->kajax->reload_target();
				}
				else
				{
					$this->kajax->fancy_log_error( 'El usuario ya se encuentra asignado a: ' . $person_other['urfid_name'] . ' ( DNI: ' . $person_other['urfid_dni'] . ' )' );
				}
			}
			else
			{
				$this->kajax->fancy_log_error( 'Usuario no encontrado.' );
			}
		}
		else
		{
			$this->kajax->fancy_log_error( 'No tienes permisos para modificar esta persona.' );
		}
		
		$this->kajax->out();
	}
	
	public function unpair( $urfid_id )
	{
		if ( $this->owns_person( $urfid_id ) )
		{
			$this->load->model('RfidUser_model');
			$this->load->model('CompanyUser_model');
			
			$person = $this->RfidUser_model->get( $urfid_id );
			$user = $this->User_model->get( $person['urfid_uid'], ARRAY_A );
			
			if ( isset( $person ) && isset( $user ) )
			{
				$this->RfidUser_model->update_uid( $urfid_id, null );
				
				$this->kajax->fancy_log_success( $person['urfid_name'] . " se ha desenlazado del usuario '" . $user['uname'] . "''" );
				
				$this->kajax->reload_target();
			}
			else if ( isset( $person ) )
			{
				$this->RfidUser_model->update_uid( $urfid_id, null );
				
				$this->kajax->fancy_log_success( "Se ha desenlazado del usuario" );
				
				$this->kajax->reload_target();
			}
			else
			{
				$this->kajax->fancy_log_error( 'Usuario no encontrado.' );
			}
		}
		else
		{
			$this->kajax->fancy_log_error( 'No tienes permisos para modificar esta persona.' );
		}
		
		$this->kajax->out();
	}
	
	public function delete_photo( $id )
	{
		$this->load->model('RfidPhoto_model');
		$this->load->model('RfidGallery_model');
		$this->load->model('RfidEvent_model');
		
		$photo = $this->RfidPhoto_model->get( $id );
		
		if ( $this->owns_photo( $id ) && isset( $photo ) )
		{
			$msg = "Imagen removida de la galería";
			
			switch ( $photo['rg_type'] )
			{
				case RfidGalleryType::TOOLS:
				{
					$msg = "Herramienta removida.";
					
					$this->RfidEvent_model->add( $id, $photo['urfid_id'], RfidType::TOOL_PHOTO, RfidCommandType::ERASE, time(), $photo['urfid_com_id'], 'ACCEPTED', $photo['urfid_id'] );
					
					break;
				}
				case RfidGalleryType::INSURANCE:
				{
					$msg = "Seguro removido.";
					
					break;
				}
			}
			
			$this->RfidPhoto_model->unlink( $id );
			$this->kajax->remove( '.photo_' . $id );
			$this->kajax->fancy_log_success( $msg );
		}
		else
		{
			$this->kajax->fancy_log_error( 'No tienes permisos para modificar esta persona.' );
		}
		
		$this->kajax->out();
	}
	
	public function offside()
	{
		$this->session_restrict( USER_TYPE_CPNY_RO );
		
		$this->load->library('pagination');
		$this->load->model('RfidUser_model');
		$this->load->model('RfidUserHours_model');
		
		$users					= $this->RfidUserHours_model->get_users_inside( $this->user->get_company_ids() );
		$not_allowed_users		= array();
		
		if ( isset( $users ) && !empty( $users ) )
		{
			foreach ( $users as $user )
			{
				if ( !$this->RfidUserHours_model->access_allowed( $user['urfid_id'] ) )
				{
					$not_allowed_users[] = $user['urfid_id'];
				}
			}
			
			if ( empty( $not_allowed_users ) )
			{
				$not_allowed_users[] = -1;
			}
		}
		else
		{
			$not_allowed_users[] = -1;
		}
		
		$page					= get_var_def( 'page_num', 1 );
		$config					= pagination_config();
		$config['per_page']		= 50;
		$query_filter			= $this->build_person_filters( $not_allowed_users );
		$data['urfid_name']		= get_var( 'urfid_name' );
		$data['urfid_dni']		= get_var( 'urfid_dni' );
		$data['urfid_plate']	= get_var( 'urfid_plate' );
		$data['urfid_plot']		= get_var( 'urfid_plot' );
		$data['urfid_inside']	= get_var( 'urfid_inside' );
		$fields_get				= str_replace( '?', get_var_def( 'order_by', 'urfid_name' ), 'DISTINCT ON (?, rfid_user.urfid_id) rfid_user.*,rfid.*' );
		$config['total_rows']	= $data['total_persons']	= $this->RfidUser_model->count( $this->user->get_company_ids(), $query_filter );
		$data['persons']		= $this->RfidUser_model->get_all( $this->user->get_company_ids(), $query_filter, $config['per_page'], $page, $fields_get );
		$config['base_url']		= base_url( '/dshield/offside/all/?' . http_build_query_pagination() );
		$data['new_person']		= $this->user->is_professional() ? 'Nuevo Empleado de Obra' : 'Nueva Persona';
		$data['is_guard']		= $this->user->is_guard();
		$data['hide_new_person']= TRUE;
		$data['is_offside']		= TRUE;
		
		$this->pagination->initialize($config);
		
		$data['pagination']		= $this->pagination->create_links();
		
		$this->add_frame_view( 'dshield/person_list', $data );
	}
}
