<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Main extends PAGE_Controller
{
	public function index()
	{
		$redirect	= get_var('noredirect');

		if ( defined( 'FORCE_HTTPS' ) )
		{
			if ( !isset($_SERVER['HTTPS']) && isset( $_SERVER['HTTP_HOST'] ) )
			{
				redirect( 'https://'.$_SERVER['HTTP_HOST'] );
			}
		}

		if ( !$this->session_exists() )
		{
			$this->add_frame_view( 'login', array( 'referer' => get_var('referer' ) ), FALSE, FALSE );
		}
		else
		{
			redirect( base_url('/user') );
		}
	}
	
	protected function auto_add()
	{
		$this->add_js('assets/libs/jquery/jquery-1.10.2.min.js');
		
		if ( self::$JS_USE_CACHED )
		{
			$this->add_js('assets/cache/' . ( self::$JS_CACHE_LIBS ? 'libs' : 'site' ) . '.js');
		}
		
		$this->add_less('assets/css/style.less');
		
		$this->add_css('assets/sprites/img.css');
		
		$this->add_css('assets/css/global.css', FALSE == DEBUG );
		
		$this->add_css( 'assets/css/login.css', FALSE == DEBUG );
		
		if ( is_tablet_browser() )
		{
			$this->add_css( 'assets/css/login.tablet.css', FALSE == DEBUG );
		}
		
		$this->add_js('assets/js/kajax.js', FALSE == DEBUG );
	}
	
	public function recover( $email = NULL, $token = NULL )
	{
		$this->load->model('User_model');
		
		$data['email'] = $email;
		$data['token'] = $token;
		
		if ( isset( $email ) && isset( $token ) )
		{
			$user = $this->User_model->from_user_and_token( $email, $token );
			
			if ( isset( $user ) )
			{
				$data['error'] = FALSE;
				
				$expiration = strtotime( $user['upass_recover_expiration'] );
				
				if ( time() > $expiration )
				{
					$data['error'] = TRUE;
					$data['error_msg'] = 'Tu código de recuperación de contraseña ha expirado. Vuelve a solicitar uno nuevo.';
				}
			}
			else
			{
				$data['error'] = TRUE;
				$data['error_msg'] = 'No se ha encontrado el usuario con la cuenta de mail con este código de recuperación.';
			}
		}
		else
		{
			$data['error'] = TRUE;
			$data['error_msg'] = 'URL incompleta.';
		}
		
		$this->add_frame_view( 'recover', $data, FALSE, FALSE );
	}
	
	public function who()
	{
		echo json_encode( array( 'client' => 'domo' ) );
	}
	
	public function version()
	{
		$rev = 0;
		$version = @file_get_contents( ROOTPATH . 'domo.version' );
		
		if ( FALSE != $version )
		{
			$rev = intval( $version );
		}
		
		$data['version'] = $rev;
		
		echo json_encode( $data );
	}
}
