<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Macs extends PAGE_Controller
{
	protected function build_mac_filters()
	{
		$filter = array(
			array(
				'field_name'	=>	'mac_serial',
				'filter_val'	=>	get_var( 'mac_serial' ),
				'filter_type'	=>	SQLFilterType::ILIKE
			),
			array(
				'field_name'	=>	'mac_icon',
				'filter_val'	=>	get_var( 'mac_icon' )
			),
			array(
				'order_by'		=> get_var_def( 'order_by', 'mac_serial' ),
				'order_fields'	=> array( 'mac_serial', 'mac_icon' ),
				'order_dir'		=> get_var_def( 'order_dir', 'ASC' )
			)
		);
		
		$query_filter		= SQL::build_query_filter( $filter );
		
		return $query_filter;
	}
	
	public function index()
	{
		$this->all();
	}
	
	public function all()
	{
		$this->session_restrict( USER_TYPE_GOD );
		
		$this->load->library('pagination');
		$this->load->model('MacsIcons_model');
		
		$page					= get_var_def( 'page_num', 1 );
		$config					= pagination_config();
		$query_filter			= $this->build_mac_filters();
		$data['mac_serial']		= get_var( 'mac_serial' );
		$data['mac_icon']		= get_var( 'mac_icon' );
		$config['total_rows']	= $data['total_hw']	= $this->MacsIcons_model->count( $query_filter );
		$data['hws']			= $this->MacsIcons_model->get_all( $query_filter, $config['per_page'], $page );
		$config['base_url']		= base_url( '/macs/all/?' . http_build_query_pagination() );
		
		$this->pagination->initialize($config);
		
		$data['pagination']		= $this->pagination->create_links();
		
		$this->add_frame_view( 'macsicons_list', $data );
	}
	
	protected function mac_id_replace( $id )
	{
		$this->kajax_replace_new_ids( 
			$id,
			array(	'row_', 
					'mac_pin_select_', 
					'mac_icon_', 
					'mac_icon_img_', 
					'row_hidden_'
			)
		);
	}
	
	public function get_new_row()
	{
		$this->session_restrict( USER_TYPE_GOD );
		
		$this->kajax->prepend( '#macsicons_list_table', $this->load->view( 'new_row_macs', NULL, TRUE ) );
		$this->kajax->out();
	}
	
	public function update()
	{
		$this->session_restrict( USER_TYPE_GOD );
		
		$post = $this->input->post();
		
		$this->load->library('form_validation');
		
		$rules	= array(
			array(
				'field'   => 'serial', 
				'label'   => 'MAC', 
				'rules'   => 'trim|required|max_length[64]|callback_val_hexa'
			),
			array(
				'field'   => 'icon', 
				'label'   => 'Ícono', 
				'rules'   => 'trim|required'
			)
		);
		
		$this->form_validation->set_rules( $rules );
		
		$serial = hexdec( $post['serial'] );
		
		if ( $this->form_validation->run() != FALSE )
		{
			$this->load->model('MacsIcons_model');
			
			if ( isset( $post['is_new'] ) && intval( $post['is_new'] ) == 1 )
			{
				if ( !$this->MacsIcons_model->exists( $serial ) )
				{
					$this->MacsIcons_model->add( $serial, $post['icon'] );
					
					$this->mac_id_replace( $serial );
					
					$this->kajax->val( '#row_' . $serial . ' input[name="is_new"]', '0' );
					
					$this->kajax->call( 'table_row_new_convert_to_id( ' . $serial . ', "mac_id", "' . base_url('/macs/delete/'.$serial) . '", "¿Seguro que quiere eliminar este ícono para esta MAC?" )' );
					
					$this->kajax->removeAttr('#mac_icon_img_' . $serial, 'onclick');
					
					$this->kajax->unbind( '#mac_icon_img_' . $serial, 'click' );
					
					$this->kajax->unbind( '#mac_pin_select_' . $serial . ' div', 'click' );
					
					$this->kajax->bind( '#mac_icon_img_' . $serial, 'click', "function(){ return pin_open_select( '$serial', { onClosed: function() { pin_select_close(); } } ) }" );
					
					$this->kajax->bind( '#mac_pin_select_' . $serial . ' div', 'click', "function(){ return pin_select_for( '" . $serial. "' ) }" );
					
					$this->kajax->fancy_log_success( "Ícono de MAC: " . $post['serial'] . " añadido con éxito." );
				}
				else
				{
					$this->kajax->fancy_log_error(  "Ícono de MAC: " . $post['serial'] . " ya existe." );
				}
			}
			else
			{
				if ( $this->MacsIcons_model->exists( $serial )  )
				{
					$this->MacsIcons_model->edit( $serial, $post['icon'] );
					
					$this->kajax->fancy_log_success( "Ícono de MAC: " . $post['serial'] . " guardado con éxito." );
				}
				else
				{
					$this->kajax->fancy_log_error(  "Ícono de MAC: " . $post['serial'] . " no existe." );
				}
			}
		}
		else
		{
			$this->kajax->fancy_log_error( validation_errors() );
		}
		
		$this->kajax_validation_set_input_states( $rules, $serial );
		
		$this->kajax->out();
	}
	
	public function delete( $id )
	{
		$this->session_restrict( USER_TYPE_GOD );
		
		$this->load->model('MacsIcons_model');
		
		$this->MacsIcons_model->delete( $id );
		
		$this->kajax->fancy_log_success( "Ícono de MAC " . dechex( $id ) . " eliminado con éxito." );
		
		$this->kajax->remove( '#row_hidden_' . $id );
		$this->kajax->remove( '#row_' . $id );
		
		$this->kajax->out();
	}
	
	protected function file_validate( $path, $div )
	{
		$this->load->model('MacsIcons_model');
		$this->load->model('Hardware_model');
		
		$res	= '';
		$handle	= @fopen( $path, "r" );
		
		if ( $handle ) {
			$string		= file_get_contents( $path );
			$string		= str_replace("\r\n", "\n", $string); // normalize line endings
			$row		= 1;
			$success	= true;
			$hwadded	= array();
			$separator	= ',';
			$guesssep	= true;
			
			if ( !( @iconv( 'utf-8', 'utf-8//IGNORE', $string ) == $string ) ) {
				$string = @iconv( 'iso-8859-1', 'utf-8', $string );
			}
			
			$buffers	= explode( "\n", $string );
			$len		= count( $buffers );
			
			for ( $c = 0; $c < $len; $c++ )
			{
				$buffer	= $buffers[ $c ];
				$err	= false;
				$edit	= false;
				$buflen	= strlen( $buffer );
				$buffer	= ( $buflen >= 1 && $buffer[ $buflen - 1 ] == "\n" ) ? substr( $buffer, 0, $buflen - 1 ) : $buffer;
				$buffer = str_replace( '"', '', $buffer );
				
				if ( $guesssep )
				{
					$guesssep	= false;
					$c2			= substr_count( $buffer, ';' );
					
					if ( $c2 == 1 )
					{
						$separator = ';';
					}
				}
				
				$data	= explode( $separator, $buffer );
				$msg	= '';
				$cdata	= count( $data );
				
				if ( $cdata < 2 )
				{
					$err	= true;
					$msg	.= 'No hay suficientes datos en la fila: ' . $buffer . '.<br/>';
				}
				else
				{
					$data[1]	= strtoupper( $data[1] );
					$err_1		= validatefield( $data[0], 'hexa'	, true );	// mac_serial
					$err_2		= validateicon( $data[1] );						// mac_icon
					
					if ( '' == $err_1 && '' == $err_2 )
					{
						if ( null != $this->MacsIcons_model->exists( hexdec( $data[0] ) ) )
						{
							$edit = true;
						}
					}
					else
					{
						$err_1 = $err_1 == '' ? 'OK' : $err_1;
						$err_2 = $err_2 == '' ? 'OK' : $err_2;
						
						$msg .= 'MAC: '				. $err_1 . '<br/>';
						$msg .= '&Iacute;cono: '	. $err_2 . '<br/>';
						
						$err = true;
					}
				}
				
				if ( $err )
				{
					$res .= "<h4>Error en la fila $row<br/>$msg</h4>";
				}
				else
				{
					if ( !$edit )
					{
						$this->MacsIcons_model->add( hexdec( $data[0] ), $data[1] );
					}
					else
					{
						$this->MacsIcons_model->edit( hexdec( $data[0] ), $data[1] );
					}
					
					$update_hw = FALSE;
					
					// Check if the hardware already exists and update the icon to it
					$hw = HardwareModel::get_from_serial( hexdec( $data[0] ) );
					
					if ( null != $hw )
					{
						$this->Hardware_model->update_icon( $hw->hw_id, $data[1] );
						
						$update_hw = TRUE;
					}
					
					$res .= "<h4>Fila $row " . ( !$edit ? 'a&ntilde;adida' : 'editada' ) . ' correctamente. Datos: MAC serial: ' . $data[0] . ', &iacutecono: ' . $data[1] . '.' . ( $update_hw ? ' The hardware already exists, so the icon was updated.' : '' ) . "</h4>";
				}
				
				$row++;
			}
			
			fclose( $handle );
			
			unlink( $path );
		}
	}

	public function upload()
	{
		$this->session_restrict( USER_TYPE_GOD );
		
		$this->load->library( 'UploadHandler', array( 'script_url' => base_url('/macs/upload/') ) );
		
		$resp = $this->uploadhandler->post(false);
		
		if ( isset( $resp['files'][0] ) && file_exists( TMPPATH . $resp['files'][0]->name ) )
		{
			$full_path	= TMPPATH . $resp['files'][0]->name;
			
			$resp['files'][0]->result = $this->file_validate( $full_path );
		}
		
		echo json_encode( $resp );
	}
}
