<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class KPanel extends PAGE_Controller
{
	function __construct()
	{
		parent::__construct();
		
		$this->load->model('Hardware_model');
		$this->load->model('KPanelMsgReceived_model');
		$this->load->model('KPanelMsgSend_model');
	}
	
	protected function check_hw_id( $hw_id )
	{
		if ( NULL == $hw_id || intval( $hw_id ) == 0 || intval( $hw_id ) != $hw_id || !$this->Hardware_model->exists( $hw_id ) )
		{
			$this->json_output_error('Not found', 404);
		}
		
		if ( !$this->user->owns_hw( $hw_id ) )
		{
			$this->json_output_error('No posees permisos para trabajar con este equipo.', 401);
		}
	}
	
	public function get_new_messages_from( $hw_id = NULL )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->check_hw_id( $hw_id );
		
		$timestamp = intval( get_var_def('timestamp', time() ) );
		
		if ( $timestamp == 0 ) $timestamp = time();
		
		$messages = $this->KPanelMsgReceived_model->get_new_messages_timestamp( $hw_id, $timestamp );
		
		$resp['last_message'] = $this->Hardware_model->get_last_message( $hw_id );
		$resp['timestamp'] = $timestamp;
		$resp['count'] = count( $messages );
		$resp['messages'] = $messages;
		
		$this->json_output( $resp );
	}
	
	public function send_initialization( $hw_id = NULL )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->check_hw_id( $hw_id );
		
		$hw = $this->Hardware_model->get_from_id( $hw_id );
		
		$kms_id = $this->KPanelMsgSend_model->send_initialization( $hw['hw_company'], $hw['hw_serial'] );
		
		$this->json_output( array( 'message' => $this->KPanelMsgSend_model->get( $kms_id ) ) );
	}
	
	public function get_message_sent( $kms_id )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$msg = $this->KPanelMsgSend_model->get( $kms_id );
		
		$this->check_hw_id( $msg['hw_id'] );
		
		$msg_rec = NULL;
		
		if ( $msg['kms_state'] == 'EXECUTED' )
		{
			$msg_rec = $this->KPanelMsgReceived_model->get_message_response( $msg['hw_id'], $msg['kms_msg_id'] );
		}
		
		$last_msg = $this->KPanelMsgReceived_model->get_last_message( $msg['hw_id'] );
		
		$timestamp = isset( $last_msg ) ? $last_msg['timestamp'] : 0;
		
		$this->json_output( array( 'message' => $msg, 'received' => $msg_rec, 'timestamp' => $timestamp ) );
	}
	
	public function send_message( $hw_id = NULL )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->check_hw_id( $hw_id );
		
		$hw = $this->Hardware_model->get_from_id( $hw_id );
		$partition = get_post('partition');
		$reports_num = 60;
		$msg = get_post('msg');
		
		if ( intval( $partition ) == $partition && intval( $partition ) != 0 )
		{
			$msglen = strlen( $msg );
			
			if ( $msglen > 0 && $msglen < 32 && ctype_xdigit($msg) )
			{
				$kms_id = $this->KPanelMsgSend_model->send_message( $hw['hw_company'], $hw['hw_serial'], $partition, $reports_num, $msg );
				
				$this->json_output( array( 'message' => $this->KPanelMsgSend_model->get( $kms_id ) ) );
			}
			else
			{
				$this->json_output( array( 'error' => 'message_not_valid' ) );
			}
		}
		else
		{
			$this->json_output( array( 'error' => 'invalid_partition' ) );
		}
	}
	
	public function view( $hw_id = NULL )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->check_hw_id( $hw_id );
		
		$data['hw'] = $this->Hardware_model->get_from_id( $hw_id );
		
		$this->add_frame_view( 'kpanel_view', $data );
	}
}
