<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Keychain extends PAGE_Controller
{
	function __construct()
	{
		parent::__construct();
		
		$this->load->model('Keychain_model');
	}
	
	public function index()
	{
		$this->all();
	}
	
	protected function build_keychain_filters()
	{
		$filter				= array(
			array(
				'field_name'	=>	'key_id',
				'filter_val'	=>	get_var( 'key_id' ),
				'val_convert'	=>	SQLConvertType::HEXDEC
			),
			array(
				'field_name'	=>	'key_owner_name',
				'filter_val'	=>	get_var( 'key_owner_name' ),
				'filter_type'	=>	SQLFilterType::ILIKE
			),
			array(
				'field_name'	=>	'key_owner_lastname',
				'filter_val'	=>	get_var( 'key_owner_lastname' ),
				'filter_type'	=>	SQLFilterType::ILIKE
			),
			array(
				'field_name'	=>	'key_owner_dni',
				'filter_val'	=>	get_var( 'key_owner_dni' ),
				'filter_type'	=>	SQLFilterType::ILIKE
			),
			array(
				'field_name'	=>	'key_group',
				'filter_val'	=>	get_var( 'key_group' ),
				'filter_type'	=>	SQLFilterType::ILIKE
			),
			array(
				'order_by'		=> get_var_def( 'order_by', 'key_id' ),
				'order_fields'	=> array( 'key_id', 'key_owner_lastname', 'key_owner_name', 'key_owner_dni', 'key_owner_phone', 'key_owner_cellphone', 'key_owner_mail' ),
				'order_dir'		=> get_var_def( 'order_dir', 'ASC' )
			)
		);
		
		if ( $this->user->is_logged_as_user() )
		{
			$filter[] = 			array(
				'field_name'	=>	'key_user',
				'filter_val'	=>	$this->user->get_id()
			);
		}
		
		$query_filter		= SQL::build_query_filter( $filter );
		
		return $query_filter;
	}
	
	public function all()
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->load->library('pagination');
		
		$page						= get_var_def( 'page_num', 1 );
		$config						= pagination_config();
		$query_filter				= $this->build_keychain_filters();
		$data['key_id']				= get_var( 'key_id' );
		$data['key_owner_lastname']	= get_var( 'key_owner_lastname' );
		$data['key_group']			= get_var( 'key_group' );
		$config['total_rows']		= $data['total_hw']	= $this->Keychain_model->count( $this->user->get_company_ids(), $query_filter );
		$data['keys']				= $this->Keychain_model->get_all( $this->user->get_company_ids(), $query_filter, $config['per_page'], $page );
		$config['base_url']			= base_url( '/keychain/all/?' . http_build_query_pagination() );
		$data['focus']				= get_var( 'focus' );

		if ( $this->user->is_logged_as_god() )
		{
			$this->load->model('Company_model');
			$data['all_com']	= $this->Company_model->get_all_names();
		}
		
		$this->pagination->initialize($config);
		
		$data['pagination']		= $this->pagination->create_links();
		
		$this->add_frame_view( 'keychain_list', $data );
	}
	
	protected function keychain_uid_replace( $uid )
	{
		$this->kajax_replace_new_ids( 
			$uid,
			array(	'row_', 
					'row_hidden_',
					'row_extra_'
			)
		);
	}	
	
	public function update()
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$post = $this->input->post();
		
		$this->load->library('form_validation');
		
		$rules	= array(
			array(
				'field'   => 'owner_lastname', 
				'label'   => 'Apellido', 
				'rules'   => 'trim|max_length[64]'
			),   
			array(
				'field'   => 'owner_name', 
				'label'   => 'Nombre', 
				'rules'   => 'trim|max_length[64]'
			),
			array(
				'field'   => 'owner_dni', 
				'label'   => 'DNI', 
				'rules'   => 'trim|integer|max_length[128]'
			),
			array(
				'field'   => 'owner_phone', 
				'label'   => 'Teléfono', 
				'rules'   => 'trim'
			),
			array(
				'field'   => 'owner_cellphone', 
				'label'   => 'Celular', 
				'rules'   => 'trim'
			),
			array(
				'field'   => 'owner_mail', 
				'label'   => 'EMail', 
				'rules'   => 'trim'
			),
			array(
				'field'   => 'group', 
				'label'   => 'Grupo', 
				'rules'   => 'trim'
			)
		);
		
		$this->form_validation->set_rules( $rules );
		
		if ( $this->form_validation->run() != FALSE )
		{
			$post['company']	= User()->is_logged_as_god() ? $post['com_id'] : User()->get_type_id();
			$post['owner_dni']	= isset( $post['owner_dni'] ) && '' != $post['owner_dni'] ? $post['owner_dni'] : NULL;
			
			if ( 0 != intval( $post['uid'] ) )
			{
				if ( $this->user->owns_keychain( $post['uid'] ) )
				{
					$this->Keychain_model->edit( $post );
					
					$this->kajax->fancy_log_success( "Llavero ID: " . dechex( $post['key_id'] ) . " guardado con éxito." );
				}
				else
				{
					$this->kajax->fancy_log_error('No puedes modificar este llavero, no tienes suficientes permisos.');
				}
			}
			else
			{
				$this->session_restrict( USER_TYPE_CPNY );
				
				$uid = $this->Keychain_model->add( $post );
				
				$this->keychain_uid_replace( $uid );
				
				$post['uid'] = $uid;
				
				$this->kajax->fancy_log_success( "Llavero ID: " . dechex( $post['key_id'] ) . " añadido con éxito." );
				$this->kajax->prepend( '#row_hidden_' . $uid . ' td', '&nbsp;<button onclick="keychain_template_modal_dialog('.$uid.')" class="submit_btn_table template_btn"><span>Plantilla</span></button>' );
				$this->kajax->call( 'table_row_new_convert_to_id( ' . $uid . ', "uid", "' . base_url('/keychain/delete/'.$uid) . '", "¿Seguro que quiere eliminar el llavero ' . dechex( $post['key_id'] ) . '?" )' );
			}
		}
		else
		{
			$this->kajax->fancy_log_error( validation_errors() );
		}
		
		$this->kajax_validation_set_input_states( $rules, $post['uid'] );
		
		$this->kajax->out();
	}
	
	public function get_active_not_registered()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		return json_encode( $this->Keychain_model->get_active_not_registered( User()->get_company() ) );
	}
	
	public function get_active_not_registered_table()
	{
		$results = $this->Keychain_model->get_active_not_registered( User()->get_company() );
		
		$this->load->view( 'keychain_new_table', array( 'results' => $results ) );
	}
	
	public function select()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->view( 'keychain_select' );
	}
	
	public function add( $key_id )
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$data = array();
		
		$data['key_id'] = $key_id;
		
		if ( $this->user->is_logged_as_god() )
		{
			$this->load->model('Company_model');
			$data['all_com']	= $this->Company_model->get_all_names();
		}
		
		$this->kajax->prepend( '#keychain_list_table', $this->load->view( 'new_row_keychain', $data, TRUE ) );
		$this->kajax->out();
	}
	
	public function delete( $key_uid )
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		if ( $this->user->owns_keychain( $key_uid ) )
		{
			$keychain = $this->Keychain_model->get( $key_uid );
			
			if ( NULL != $keychain )
			{
				$this->Keychain_model->delete( $key_uid );
			
				$this->kajax->fancy_log_success( "Llavero " . $keychain['key_id'] . " eliminado con éxito." );
				
				$this->kajax->remove( '#row_hidden_' . $key_uid );
				$this->kajax->remove( '#row_extra_' . $key_uid );
				$this->kajax->remove( '#row_' . $key_uid );
			}
			else
			{
				$this->kajax->fancy_log_error( 'No se encontró el llavero a eliminar.' );
			}
		}
		else
		{
			$this->kajax->fancy_log_error( 'No tienes suficientes permisos para eliminar llaveros.' );
		}
		
		$this->kajax->out();
	}
	
	public function template( $key_uid )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		if ( $this->user->owns_keychain( $key_uid ) )
		{
			$keychains_tpl = $this->Keychain_model->get_key_tpl( $key_uid );
			
			$this->load->view( 'keychain_template', array( 'key_uid' => $key_uid, 'keychains_tpl' => $keychains_tpl ) );
		}
		else
		{
			$this->kajax->fancy_log_error( 'No tienes suficientes permisos para crear/editar la plantilla del llavero.' );
		}
	}
	
	public function template_save()
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$key_uid = $this->input->post('key_uid');
		
		if ( $this->user->owns_keychain( $key_uid ) )
		{
			$this->load->library('form_validation');
			
			$rules	= array();
			
			for ( $i = 1; $i <= 4; $i++ )
			{
				$rules[] = array(
					'field'   => 'description_' . $i, 
					'label'   => 'Descripción botón ' . $i, 
					'rules'   => 'trim|max_length[64]'
				);
				
				$rules[] = array(
					'field'   => 'sms_' . $i, 
					'label'   => 'Mensaje Botón ' . $i, 
					'rules'   => 'trim|max_length[140]'
				);
				
				$rules[] = array(
					'field'   => 'contact_' . $i, 
					'label'   => 'EMail/Teléfono', 
					'rules'   => 'trim|min_length[6]|callback_val_emails_or_phones'
				);
			}
			
			$this->form_validation->set_rules( $rules );
			
			if ( $this->form_validation->run() != FALSE )
			{
				$keychain = $this->Keychain_model->get( $key_uid );
				
				if ( NULL != $keychain )
				{
					$form = $this->input->post();
				
					$this->Keychain_model->update_tpl( $form );
					
					$this->kajax->fancy_log_success( "Plantilla de llavero ID: " . dechex( $keychain['key_id'] ) . " guardada con éxito." );
					
					$this->kajax->call('modal_dialog_close()');
				}
				else
				{
					$this->kajax->fancy_log_error( 'No se encontró el llavero a crear/editar plantilla.' );
				}
			}
			else
			{
				$this->kajax->fancy_log_error( validation_errors() );
			}
			
			$this->kajax_validation_set_input_states( $rules, $key_uid, null, '#ktrow_' );
		}
		else
		{
			$this->kajax->fancy_log_error( 'No tienes suficientes permisos para crear/editar la plantilla del llavero.' );
		}
		
		$this->kajax->out();
	}
	
	public function test()
	{
		require_once( FRAMES_PATH . 'frame.php' );
		
		if ( $this->user->is_god() )
		{
			$this->load->model('Keychain_model');
			
			$key_id = 2565552;
			$time = time();
			$event_id = $this->Keychain_model->add_event( $key_id, 2, 1, $time, 1080511391 );
			$frame = new Frame();
			$frame->add_global_event_dkeep( $key_id, array( 'button' => 1 ), $event_id, $time, 2, 1080511391 );
			
			echo 'OK';
		}
	}
	
	public function search()
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->load->library('pagination');
		
		$data['js_cb']				= get_var( 'cb' );
		$data['row_id']				= get_var_def( 'row_id', 0 );
		$page						= get_var_def( 'page_num', 1 );
		$config						= pagination_config();
		$config['per_page']			= 12;
		$query_filter				= $this->build_keychain_filters();
		$data['key_id']				= get_var( 'key_id' );
		$data['key_owner_name']		= get_var( 'key_owner_name' );
		$data['key_owner_lastname']	= get_var( 'key_owner_lastname' );
		$data['key_owner_dni']		= get_var( 'key_owner_dni' );
		$config['total_rows']		= $data['total_hws']	= $this->Keychain_model->count( $this->user->get_company_ids(), $query_filter );
		$data['keys']				= $this->Keychain_model->get_all( $this->user->get_company_ids(), $query_filter, $config['per_page'], $page );
		$config['base_url']			= base_url( '/keychain/search/?' . http_build_query_pagination() );
		$config['anchor_class']		= 'class="ajax-paging-link ajax-clean" ';
		$data['base_url']			= $config['base_url'];
		
		$this->pagination->initialize($config);
		
		$data['pagination']			= $this->pagination->create_links();
		
		$this->load->view( 'keychain_search_list', $data );
	}
	
	public function link( $uid, $key_uid )
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		if ( $this->user->owns_keychain( $key_uid ) && !$this->Keychain_model->owns_keychain( $uid, $key_uid ) )
		{
			$this->Keychain_model->link( $key_uid, $uid );
			
			$data['key']	= $this->Keychain_model->get( $key_uid );
			
			$this->kajax->append( '#dkeep_box', $this->load->view( 'new_user_keychain', $data, TRUE ) );
			$this->kajax->init_el('#dkeep_box');
		}
		
		$this->kajax->out();
	}
	
	public function unlink( $key_uid )
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		if ( $this->user->owns_keychain( $key_uid ) )
		{
			$this->Keychain_model->unlink( $key_uid );
			
			$this->kajax->remove("#key_$key_uid");
		}
		
		$this->kajax->out();
	}
	
	public function export( $type = 'csv' )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$query_filter	= $this->build_keychain_filters();
		$data			= '';
		$res			= $this->Keychain_model->get_all( $this->user->get_company_ids(), $query_filter );
		$filename		= $this->user->get_name() . ' - llaveros - ' . $type;
		
		if ( 'csv' == $type )
		{
			if ( isset( $res ) )
			{
				$sep		= CSV_SEPARATOR;
				
				csv_create_header( $filename );
				csv_array_sanitize( $res );
				
				$data.= '"ID"'.$sep.'"Cliente"'.$sep.'"Nombre"'.$sep.'"Apellido"'.$sep.'"DNI"'.$sep.'"Teléfono"'.$sep.'"Celular"'.$sep.'"EMail"'.$sep.'"Grupo"'.$sep.'"Teléfono Alt."'.$sep.'"Observaciones"' . "\n";
				
				foreach ( $res as $row )
				{
					$client = isset( $row['ui_name'] ) || isset( $row['ui_lastname'] ) ? $row['ui_lastname'] . ' ' . $row['ui_name'] : '';
					
					$data.= '"' . dechex( $row['key_id'] ) . '"'.$sep.'"' . $client . '"'.$sep.'"' . $row['key_owner_name'] . '"'.$sep.'"' . $row['key_owner_lastname'] . '"'.$sep.'"' . $row['key_owner_dni'] . '"'.$sep.'"' . $row['key_owner_phone'] . '"'.$sep.'"' . $row['key_owner_cellphone'] . '"'.$sep.'"' . $row['key_owner_mail'] . '"'.$sep.'"' . $row['key_group'] . '"'.$sep.'"' . $row['key_owner_phone_alt'] . '"'.$sep.'"' . $row['key_observations']  . "\"\n";
				}
			}
			
			echo $data;
		}
	}
}
