<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Insurance extends PAGE_Controller
{
	public function index()
	{
		$this->all();
	}
	
	public function build_insurance_filter()
	{
		$filter				= array(
			array(
				'field_name'	=>	'urfid_name',
				'filter_val'	=>	get_var( 'urfid_name' ),
				'filter_type'	=>	SQLFilterType::ILIKE
			),
			array(
				'field_name'	=>	'urfid_dni',
				'filter_val'	=>	get_var( 'urfid_dni' )
			),
			array(
				'field_name'	=>	'urfid_user_type',
				'filter_val'	=>	get_var( 'types' )
			),
			array(
				'order_by'		=> array( get_var_def( 'order_by', 'rp_id' ) ),
				'order_fields'	=> array( 'rp_id', 'urfid_id', 'urfid_dni', 'urfid_user_type', 'urfid_name', 'urfid_plot', 'urfid_professional_name' ),
				'order_dir'		=> array( get_var_def( 'order_dir', 'ASC' ) )
			)
		);
		
		$filter_plot = NULL;
		
		if ( NULL != get_var('urfid_plot') )
		{
			$filter_plot = explode( ',', get_var('urfid_plot') );
		}
		
		if ( NULL != $filter_plot && !empty( $filter_plot ) && '' != $filter_plot[0] )
		{
			$filter[] = array(
				'join'			=>	'rfid_user_plot',
				'on'			=>	'urfid_id = rup_urfid_id AND ' . SQL::get_or_filter( $filter_plot, 'rup_plot' )
			);
		}
		else
		{
			$filter[] = array(
				'join'			=>	'rfid_user_plot',
				'on'			=>	'urfid_id = rup_urfid_id'
			);
		}
		
		$filter[] = array(
			'type'				=> 'LEFT',
			'lateral'			=> TRUE,
			'join'				=> "( SELECT string_agg(urfid_name, ',') AS urfid_professional_name 
										FROM rfid_user_plot AS rup_lat 
										INNER JOIN rfid_user AS urfid_prof ON urfid_prof.urfid_id = rup_lat.rup_urfid_id 
										WHERE rup_lat.rup_plot = rfid_user_plot.rup_plot AND urfid_prof.urfid_user_type = " . RfIdUserType::PROFESSIONAL . " ) AS professional",
			'on'				=> 'TRUE'
		);
		
		return $filter;
	}
	
	public function all()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		if ( $this->user->is_guard() )
		{
			http_response_code(403);
			return;
		}
		
		$this->load->library('pagination');
		$this->load->model('RfidUser_model');
		$this->load->model('RfidGallery_model');
		$this->load->model('RfidPhoto_model');
		
		$page					= get_var_def( 'page_num', 1 );
		$config					= pagination_config('insurances_list_table_pager');
		$config['per_page']		= 50;
		$query_filter			= $this->build_insurance_filter();
		$data['urfid_name']		= get_var( 'urfid_name' );
		$data['urfid_dni']		= get_var( 'urfid_dni' );
		$data['urfid_plot']		= get_var( 'urfid_plot' );
		$fields_get				= str_replace( '?', get_var_def( 'order_by', 'urfid_name' ), 'DISTINCT ON (?, rfid_user.urfid_id, rp_id) rfid_user.*, rfid_photo.*, urfid_professional_name' );
		$config['total_rows']	= $data['total_insurances']	= $this->RfidUser_model->get_not_validated_insurances_count( $this->user->get_company_ids(), $query_filter );
		$data['insurances']		= $this->RfidUser_model->get_not_validated_insurances( $this->user->get_company_ids(), $query_filter, $config['per_page'], $page, $fields_get );
		$config['base_url']		= base_url( '/dshield/insurance/all/?' . http_build_query_pagination() );
		
		$this->pagination->initialize($config);
		
		$data['pagination']		= $this->pagination->create_links();
		
		$this->add_frame_view( 'dshield/insurance_list', $data );
	}
	
	public function validate( $rp_id )
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		if ( $this->user->is_guard() || !$this->user->owns_photo( $rp_id ) )
		{
			http_response_code(403);
			return;
		}
		
		$this->load->model('RfidPhoto_model');
		
		$this->RfidPhoto_model->update_state( $rp_id, InsurancePhotoState::VALID );
		
		$this->kajax->fancy_log_success( 'Seguro validado' );
		
		$this->kajax->remove('#row_'.$rp_id);
		
		$this->kajax->out();
	}
	
	public function is_expiring_soon()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->model('RfidUser_model');
		
		$count = $this->RfidUser_model->get_near_to_expire_workers_insurance_count( $this->user->get_company_ids() );
		
		if ( $count > 0 )
		{
			$this->kajax->fancy_alert( "Se encuentran seguros expirados o prontos a expirar.<br/>Recuerde informarlo a los profesionales a cargo de obra desde:<br/><a href='" . base_url('/dshield/insurance/expiring_soon') . "'>Expiración de Seguros</a>" );
		}
		
		$this->kajax->out();
	}
	
	public function expiring_soon()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->model('RfidUser_model');
		
		$expiring = $this->RfidUser_model->get_near_to_expire_workers_insurance( $this->user->get_company_ids() );
		
		$data = array();
		$professionals = array();
		
		if ( isset( $expiring ) )
		{
			foreach ( $expiring as $e )
			{
				if ( isset( $e['urfid_professional_id'] ) && NULL != $e['urfid_professional_id'] )
				{
					$professional_arr		= explode( ',', $e['urfid_professional_id'] );
					$professional_name_arr	= explode( ',', $e['urfid_professional_name'] );
					
					for ( $i = 0; $i < count($professional_arr); $i++ )
					{
						$prof = $professional_arr[$i];
						
						if ( !isset( $professionals[ $prof ] ) )
						{
							$professionals[ $prof ] = array();
							$professionals[ $prof ]['id'] = $prof;
							$professionals[ $prof ]['name'] = $professional_name_arr[$i];
							$professionals[ $prof ]['workers'] = array();
							$professionals[ $prof ]['user'] = $this->RfidUser_model->get_full( $prof );
						}
						
						$professionals[ $prof ]['workers'][ $e['urfid_id'] ] = $e;
					}
				}
			}
		
			$data['professionals'] = $professionals;
		}
		
		$this->add_frame_view( 'dshield/insurance_expiring_soon', $data );
	}
}
