<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class HwFake extends PAGE_Controller
{
	protected function build_hw_filters()
	{
		$filter = array(
			array(
				'field_name'	=>	'hwf_name',
				'filter_val'	=>	get_var( 'hwf_name' ),
				'filter_type'	=>	SQLFilterType::ILIKE
			),
			array(
				'field_name'	=>	'hwf_code',
				'filter_val'	=>	get_var( 'hwf_code' ),
				'val_convert'	=>	SQLConvertType::HEXDEC
			),
			array(
				'field_name'	=>	'hwf_address',
				'filter_val'	=>	get_var( 'hwf_address' ),
				'filter_type'	=>	SQLFilterType::ILIKE
			),
			array(
				'order_by'		=> get_var_def( 'order_by', 'hwf_id' ),
				'order_fields'	=> array( 'hwf_id', 'hwf_name', 'hwf_code' ),
				'order_dir'		=> get_var_def( 'order_dir', 'ASC' )
			)
		);
		
		$query_filter		= SQL::build_query_filter( $filter );
		
		return $query_filter;
	}
	
	public function all()
	{
		$this->session_restrict( USER_TYPE_CPNY_RO );
		
		$this->load->library('pagination');
		$this->load->model('HardwareFake_model');
		
		$page					= get_var_def( 'page_num', 1 );
		$config					= pagination_config();
		$query_filter			= $this->build_hw_filters();
		$data['hwf_code']		= get_var( 'hwf_code' );
		$data['hwf_name']		= get_var( 'hwf_name' );
		$data['hwf_address']	= get_var( 'hwf_address' );
		$config['total_rows']	= $data['total_hw']	= $this->HardwareFake_model->count( $this->user->get_company_ids(), $query_filter );
		$data['hws']			= $this->HardwareFake_model->get_all( $this->user->get_company_ids(), $query_filter, $config['per_page'], $page );
		$config['base_url']		= base_url( '/hwfake/all/?' . http_build_query_pagination() );
		
		$this->pagination->initialize($config);
		
		$data['pagination']		= $this->pagination->create_links();
		
		$this->add_frame_view( 'hwfake_list', $data );
	}
	
	protected function hwf_id_replace( $id )
	{
		$this->kajax_replace_new_ids( 
			$id,
			array(	'row_', 
					'hwf_pin_select_', 
					'hwf_icon_', 
					'hwf_icon_img_', 
					'row_color_type_', 
					'fake_hw_color_selector_', 
					'row_hidden_'
			)
		);
	}
	
	public function add()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$post = $this->input->post();
		
		$this->load->library('form_validation');
		
		$post['name']		= '';
		$post['address']	= '';
		$post['icon']		= 'INTERIOR';
		$post['type']		= 0;
		
		$rules	= array(
			array(
				'field'   => 'code', 
				'label'   => 'Número', 
				'rules'   => 'required|callback_val_hexa4'
			),
			array(
				'field'   => 'lat', 
				'label'   => 'Latitud', 
				'rules'   => 'trim|decimal'
			),   
			array(
				'field'   => 'long', 
				'label'   => 'Longitud', 
				'rules'   => 'trim|decimal'
			)
		);
		
		$this->form_validation->set_rules( $rules );
		
		$this->load->model('HardwareFake_model');
		
		if ( $this->form_validation->run() != FALSE )
		{
			$post['company']	= $this->user->get_company();
			$post['city']		= $this->user->get_city();
			
			$id = $this->HardwareFake_model->add( $post );
				
			$this->kajax->fancy_log_success( "Instalación potencial número: " . $post['code'] . " añadida con éxito." );
			$this->kajax->call( 'on_fake_hw_add( ' . $id . ', "' . $post['code'] . '", ' . $post['lat'] . ', ' . $post['long'] . ' )' );
		}
		else
		{
			$this->kajax->fancy_log_error( validation_errors() );
		}
		
		$this->kajax->out();
	}
	
	public function update()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$post = $this->input->post();
		
		$this->load->library('form_validation');
		
		$rules	= array(
			array(
				'field'   => 'code', 
				'label'   => 'Número', 
				'rules'   => 'required|callback_val_hexa4'
			),
			array(
				'field'   => 'name', 
				'label'   => 'Nombre', 
				'rules'   => 'trim|required|max_length[64]'
			),
			array(
				'field'   => 'lat', 
				'label'   => 'Latitud', 
				'rules'   => 'trim|decimal'
			),   
			array(
				'field'   => 'long', 
				'label'   => 'Longitud', 
				'rules'   => 'trim|decimal'
			),
			array(
				'field'   => 'address', 
				'label'   => 'Dirección', 
				'rules'   => 'trim|max_length[128]'
			),
			array(
				'field'   => 'icon', 
				'label'   => 'Ícono', 
				'rules'   => 'trim|required'
			),
			array(
				'field'   => 'type', 
				'label'   => 'Tipo de Instalación', 
				'rules'   => 'integer|required'
			)
		);
		
		$this->form_validation->set_rules( $rules );
		
		$this->load->model('HardwareFake_model');
		
		$id = isset( $post['hwf_id'] ) ? intval( $post['hwf_id'] ) : 0;
		
		if ( $this->form_validation->run() != FALSE )
		{
			if ( 0 != $id )
			{
				if ( $this->user->owns_hw_fake( $id ) )
				{
					$this->HardwareFake_model->update( $post );
					
					$this->kajax->fancy_log_success( "Instalación potencial número: " . $post['code'] . " guardada con éxito." );
				}
				else
				{
					$this->kajax->fancy_log_error('No puedes modificar esta instalación potencial, no tienes suficientes permisos.');
				}
			}
			else
			{
				$post['company']	= User()->get_company();
				$post['city']		= User()->get_city();
				
				$id = $this->HardwareFake_model->add( $post );
				
				$this->kajax->fancy_log_success( "Instalación potencial número: " . $post['code'] . " añadida con éxito." );
				
				$this->hwf_id_replace( $id );
				
				$this->kajax->call( 'table_row_new_convert_to_id( ' . $id . ', "hwf_id", "' . base_url('/hwfake/delete/'.$id.'/'.$post['code']) . '", "¿Seguro que quiere eliminar esta instalación potencial?" )' );

				$this->kajax->removeAttr('#hwf_icon_img_' . $id, 'onclick');
				
				$this->kajax->unbind( '#hwf_icon_img_' . $id, 'click' );
				
				$this->kajax->unbind( '#hwf_pin_select_' . $id . ' div', 'click' );
				
				$this->kajax->bind( '#hwf_icon_img_' . $id, 'click', "function(){ return pin_open_select( '$id', { onClosed: function() { pin_select_close(); } } ) }" );
				
				$this->kajax->bind( '#hwf_pin_select_' . $id . ' div', 'click', "function(){ return pin_select_for( '" . $id. "' ) }" );
			}
		}
		else
		{
			$this->kajax->fancy_log_error( validation_errors() );
		}
		
		$this->kajax_validation_set_input_states( $rules, $id );
		
		$this->kajax->out();
	}
	
	public function export( $type = 'csv' )
	{
		$this->session_restrict( USER_TYPE_CPNY_RO );
		
		$this->load->model('HardwareFake_model');
		
		$query_filter	= $this->build_hw_filters();
		$data			= '';
		$res			= $this->HardwareFake_model->get_all( $this->user->get_company_ids(), $query_filter );
		
		if ( 'csv' == $type )
		{
			if ( isset( $res ) )
			{
				$sep		= CSV_SEPARATOR;
				$filename	= $this->user->get_name() . ' - abonados potenciales - ' . $type;
				
				csv_create_header( $filename );
				csv_array_sanitize( $res );
				
				foreach ( $res as $row )
				{
					$line = dechex( $row['hwf_code'] ) . '"'.$sep.'"' . $row['hwf_name'] . '"'.$sep.'"' . $row['hwf_address'] . '"'.$sep.'"' . $row['hwf_lat'] . '"'.$sep.'"' . $row['hwf_long'] . '"'.$sep.'"' . $row['hwf_icon'] . '"'.$sep.'"' . $row['hwf_type'] . '"';
					$data.=  $line . "\n";
				}
			}
			
			echo $data;
		}
	}
	
	public function get_new_row()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->kajax->prepend( '#hwf_list_table', $this->load->view( 'new_row_hwfake', NULL, TRUE ) );
		$this->kajax->out();
	}
	
	public function delete( $id, $code = 0 )
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->model('HardwareFake_model');
		
		$this->HardwareFake_model->delete( intval($id ) );
		
		$this->kajax->fancy_log_success( "Instalación potencial " . ( 0 != $code ? "número: " . $code : '' ) . " eliminada con éxito." );
		
		$this->kajax->remove( '#row_hidden_' . $id );
		$this->kajax->remove( '#row_' . $id );
		
		$this->kajax->out();
	}
	
	protected function file_validate( $path )
	{
		$this->load->model('Hardware_model');
		$this->load->model('HardwareFake_model');
		$this->load->helper('form_validation');
		
		$handle = @fopen( $path, "r" );
		
		$res = '';
		
		if ( $handle )
		{
			$string		= file_get_contents( $path );
			$string		= str_replace("\r\n", "\n", $string); // normalize line endings
			$row		= 1;
			$success	= true;
			$hwadded	= array();
			$separator	= ',';
			$guesssep	= true;
			
			if ( !( @iconv( 'utf-8', 'utf-8//IGNORE', $string ) == $string ) )
			{
				$string = @iconv( 'iso-8859-1', 'utf-8', $string );
			}
			
			$buffers	= explode( "\n", $string );
			$len		= count( $buffers );
			
			for ( $c = 0; $c < $len; $c++ )
			{
				$buffer	= $buffers[ $c ];
				$err	= false;
				$edit	= false;
				$buflen	= strlen( $buffer );
				$buffer	= ( $buflen >= 1 && $buffer[ $buflen - 1 ] == "\n" ) ? substr( $buffer, 0, $buflen - 1 ) : $buffer;
				$buffer = str_replace( '"', '', $buffer );
				
				if ( $guesssep )
				{
					$guesssep	= false;
					$c2			= substr_count( $buffer, ';' );
					
					if ( $c2 == 2 || $c2 == 4 || $c2 == 5 || $c2 == 6 || $c2 == 7 )
					{
						$separator = ';';
					}
					
					$c2			= substr_count( $buffer, '	' );
					
					if ( $c2 == 2 || $c2 == 4 || $c2 == 5 || $c2 == 6 || $c2 == 7 )
					{
						$separator = '	';
					}
				}
				
				$data	= explode( $separator, $buffer );
				$msg	= '';
				$cdata	= count( $data );
				
				if ( $cdata < 3 )
				{
					$err	= true;
					$msg	.= 'No hay suficientes datos en la fila: ' . $buffer . '.<br/>';
				} else {
					$err_1		= validate_field( $data[0], 'hexa4'	, true ); // hwf code
					$err_2		= validate_field( $data[1], 'any'	, true ); // hwf name
					$err_3		= validate_field( $data[2], 'any', false ); // hwf address
					
					$err_4		= '';
					$err_5		= '';
					$err_6		= '';
					
					if ( $cdata >= 5 )
					{
						if ( $data[3] == '' ) $data[3] = 0;
						if ( $data[4] == '' ) $data[4] = 0;
						
						$err_4		= validate_field( $data[3], 'float', true ); // hwf lat
						$err_5		= validate_field( $data[4], 'float', true ); // hwf long
						
						if ( $err_4 != '' )
						{
							$err_4 .= ' ' . $data[3];
						}
						
						if ( $err_5 != '' )
						{
							$err_5 .= ' ' . $data[4];
						}
						
						if ( $cdata >= 6 )
						{
							$err_6		= validate_icon( $data[5] );	// hwf icon
						}
					}
					
					if ( '' == $err_1 && '' == $err_2 && '' == $err_3 && '' == $err_4 && '' == $err_5 && '' == $err_6 )
					{
						if ( $this->HardwareFake_model->code_count( $data[0] , $this->user->get_type_id() ) > 0 )
						{
							$edit = true;
						}

						if ( $this->Hardware_model->code_count( $data[0], $this->user->get_df_code(), $this->user->get_df_rec() ) > 0 )
						{
							$msg .= 'Ya existe una instalaci&oacute;n con ese código.<br/>';
							$err = true;
						}
						
						if ( isset( $hwadded[ $data[0] ] ) )
						{
							$msg .= 'Ya se a&ntilde;adi&oacute; una instalaci&oacute;n con ese código.<br/>';
							$err = true;
						}
					}
					else
					{
						$err_1 = $err_1 == '' ? 'OK' : $err_1;
						$err_2 = $err_2 == '' ? 'OK' : $err_2;
						$err_3 = $err_3 == '' ? 'OK' : $err_3;
						$err_4 = $err_4 == '' ? 'OK' : $err_4;
						$err_5 = $err_5 == '' ? 'OK' : $err_5;
						$err_6 = $err_6 == '' ? 'OK' : $err_6;
						
						$msg .= 'C&oacute;digo: '		. $err_1 . '<br/>';
						$msg .= 'Nombre: '				. $err_2 . '<br/>';
						$msg .= 'Direcci&oacute;n: '	. $err_3 . '<br/>';
						$msg .= 'Latitud: '				. $err_4 . '<br/>';
						$msg .= 'Longitud: '			. $err_5 . '<br/>';
						$msg .= '&Iacute;cono: '		. $err_6 . '<br/>';
						
						$err = true;
					}
				}
				
				if ( $err )
				{
					$res .= "<h4>Error en la fila $row <br/>$msg</h4>";
				}
				else
				{
					$form['lat']		= ( $cdata >= 5 ) ? $data[3] : 0;
					$form['long']		= ( $cdata >= 5 ) ? $data[4] : 0;
					$form['code']		= $data[0];
					$form['name'] 		= $data[1];
					$form['address']	= $data[2];
					$form['city']		= $this->user->get_city();
					$form['company']	= $this->user->get_company();
					$form['icon']		= ( $cdata >= 6 ) ? $data[5] : 'INTERIOR';
					$form['type']		= ( isset( $data[6] ) && $data[6] != '0' && $data[6] != '' && strtoupper( $data[6] ) != 'AZUL' ) ? 1 : 0;
					
					if ( isset( $hwadded[ $form['code'] ] ) )
					{
						$hwadded[ $form['code'] ]++;
					}
					else
					{
						$hwadded[ $form['code'] ] = 1;
					}
					
					if ( strlen( $form['address'] ) )
					{
						$loc	= $form['address'];
					}
					else
					{
						$loc	= 'Latitud: ' . $form['lat'] . ' - Longitud: ' . $form['long'];
					}
					
					if ( isset( $form['name'] ) && isset( $form['icon'] ) )
					{
						if ( !$edit )
						{
							$id = $this->HardwareFake_model->add( $form );
							
							$res .= '<h4>Fila ' . $row . ' a&ntilde;adida correctamente. Datos: C&oacute;digo:' . $form['code'] . ', Nombre: ' . $form['name'] . ', Direcci&oacute;n/Locaci&oacute;n: ' . $loc . ', &Iacute;cono: ' . $form['icon'] . '</h4>';
						}
						else
						{
							$form['hwf_id']	= $this->HardwareFake_model->get_id_from_code( $form['code'],  $this->user->get_type_id() );
							
							$id = $this->HardwareFake_model->update( $form );
							
							$res .= '<h4>Fila ' . $row . ' editada correctamente. Datos: C&oacute;digo:' . $form['code'] . ', Nombre: ' . $form['name'] . ', Direcci&oacute;n/Locaci&oacute;n: ' . $loc . ', &Iacute;cono: ' . $form['icon'] . '</h4>';
						}
					}
					else
					{
						$res .= "<h4>Error fatal en fila $row, datos: " . json_enc( $form, TRUE ) . "</h4>";
					}
				}
				
				$row++;
			}
			
			fclose( $handle );
			
			unlink( $path );
		}
		
		return $res;
	}
	
	public function upload()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->library( 'UploadHandler', array( 'script_url' => base_url('/hwfake/upload/') ) );
		
		$resp = $this->uploadhandler->post(false);
		
		if ( isset( $resp['files'][0] ) && file_exists( TMPPATH . $resp['files'][0]->name ) )
		{
			$full_path	= TMPPATH . $resp['files'][0]->name;
			
			$resp['files'][0]->result = $this->file_validate( $full_path );
		}
		
		echo json_encode( $resp );
	}
}
