<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Hw extends Airmesh_Controller
{
	public function stats( $hw_id = NULL )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		require_once( LIBSPATH . 'graphs/graphs.php' );
		
		$data = HardwareGraph::creategraph( $hw_id );
		
		$this->set_map_data( $data, TRUE, TRUE );
		
		$this->add_frame_view( 'graph_hw', $data );
	}
	
	public function stats_export( $hw_id = NULL )
	{
		$sep = CSV_SEPARATOR;
		
		$this->session_restrict( USER_TYPE_USER );
		
		require_once( LIBSPATH . 'graphs/graphs.php' );
		
		$data = HardwareGraph::creategraph( $hw_id );
		
		$packets = $data['data'];
		
		csv_create_header( 'Test por Abonado - data' );
		csv_array_sanitize( $packets );
		
		foreach ( $packets as $name=>$packet )
		{
			for ( $i = 0; $i < $data['hours']; $i++ )
			{
				$initial_date	= ( floor( $data['final_datetime'] / 3600 ) * 3600 ) - 3600 * $i;
				$date			= date( "Y-m-d H:i:s", $initial_date );
				
				echo '"' . $name . '"' . $sep . '"' . $packet[$i]  . '"' . $sep . '"' . $date . '"' . "\n";
			}
		}
	}
	
	public function tests()
	{
		$this->session_restrict( USER_TYPE_USER );
		
		require_once( LIBSPATH . 'graphs/graphview.php' );
		
		$data = GraphView::gen_company_test_graph();
		
		$this->set_map_data( $data, TRUE, TRUE );
		
		$this->add_frame_view( 'graph_tests_by_company', $data );
	}
	
	public function tests_export()
	{
		$sep = CSV_SEPARATOR;
		
		$this->session_restrict( USER_TYPE_USER );
		
		require_once( LIBSPATH . 'graphs/graphview.php' );
		
		$data = GraphView::gen_company_test_graph();
		
		csv_create_header( 'Comportamiento de la Red - data' );
		
		$v = $data['data'];
		
		csv_array_sanitize( $v );
		
		foreach ( $v as $packet )
		{
			$date			= date( "Y-m-d H:i:s",  $packet['tlc_from_time'] );
			
			echo '"' . $packet['name'] . '"' . $sep . '"' . $packet['tlc_tests_count']  . '"' . $sep . '"' . $date . '"' . "\n";
		}
	}
	
	public function percents()
	{
		$this->session_restrict( USER_TYPE_USER );
		
		require_once( LIBSPATH . 'graphs/graphview.php' );
		
		$data = GraphView::gen_company_percent_graph();
		
		$this->set_map_data( $data, TRUE, TRUE );
		
		$this->add_frame_view( 'graph_tests_barchart', $data );
	}
	
	public function repeated()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		require_once( LIBSPATH . 'graphs/graphview.php' );
		
		$data = GraphView::gen_company_repeated_messages_by_mac();
		
		$this->set_map_data( $data, TRUE, TRUE );
		
		$this->add_frame_view( 'graph_hw_repeated', $data );
	}
	
	public function repeated_export()
	{
		$sep = CSV_SEPARATOR;
		
		$this->session_restrict( USER_TYPE_CPNY );
		
		require_once( LIBSPATH . 'graphs/graphview.php' );
		
		$data = GraphView::gen_company_repeated_messages_by_mac();
		
		csv_create_header( 'Mensajes Repetidos por Abonado - data' );
		
		$v = $data['data'];
		csv_array_sanitize( $v );
		
		foreach ( $v as $packet )
		{
			$date			= date( "Y-m-d H:i:s",  $packet['timestamp'] );
			
			echo '"' . $packet['serial'] . '"' . $sep . '"' . $packet['repeated']  . '"' . $sep . '"' . $date . '"' . "\n";
		}
	}
	
	public function repeated_status()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		require_once( LIBSPATH . 'graphs/graphview.php' );
		
		$data				= GraphView::gen_company_repeated_messages();
		$data['repeated']	= TRUE;
		
		$this->set_map_data( $data, TRUE, TRUE );
		
		$this->add_frame_view( 'graph_tests_by_company', $data );
	}
	
	public function repeated_status_export()
	{
		$sep = CSV_SEPARATOR;
		
		$this->session_restrict( USER_TYPE_CPNY );
		
		require_once( LIBSPATH . 'graphs/graphview.php' );
		
		$data				= GraphView::gen_company_repeated_messages();
		
		csv_create_header( 'Estado de Mensajes Repetidos - data' );
		
		$v = $data['data'];
		csv_array_sanitize( $v );
		
		foreach ( $v as $packet )
		{
			$date			= date( "Y-m-d H:i:s",  $packet['time'] );
			
			echo '"' . $packet['name'] . '"' . $sep . '"' . $packet['total']  . '"' . $sep . '"' . $date . '"' . "\n";
		}
	}
	
	public function inst_graph()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		require_once( LIBSPATH . 'graphs/graphview.php' );
		
		$data = GraphView::gen_hardware_installed_by_month();
		
		$this->set_map_data( $data, TRUE, TRUE );
		
		$this->add_frame_view( 'graph_hw_installed', $data );
	}
	
	protected function build_hw_filters( $ignore_nucleators = FALSE )
	{
		$hw_active			= get_var( 'hw_active' );
		$hw_inactive		= get_var( 'hw_inactive' );
		$filter				= array(
			array(
				'field_name'	=>	'hw_name',
				'filter_val'	=>	get_var( 'hw_name' ),
				'filter_type'	=>	SQLFilterType::ILIKE
			),
			array(
				'field_name'	=>	'hw_serial',
				'filter_val'	=>	get_var( 'hw_serial' ),
				'val_convert'	=>	SQLConvertType::HEXDEC
			),
			array(
				'field_name'	=>	'hw_code',
				'filter_val'	=>	get_var( 'hw_code' ),
				'val_convert'	=>	SQLConvertType::HEXDEC
			),
			array(
				'field_name'	=>	'hw_state',
				'filter_val'	=>	( NULL != $hw_active && NULL == $hw_inactive ) ? 'ACTIVE' : ( NULL == $hw_active && NULL != $hw_inactive ? 'INACTIVE' : NULL )
			),
			array(
				'field_name'	=>	'ui_lastname',
				'filter_val'	=>	get_var( 'ui_lastname' ),
				'filter_type'	=>	SQLFilterType::ILIKE
			),
			array(
				'order_by'		=> get_var_def( 'order_by', 'hw_id' ),
				'order_fields'	=> array( 'hw_id', 'hw_name', 'hw_code', 'hw_inst_time', 'hw_serial', 'hw_state', 'ui_lastname' ),
				'order_dir'		=> get_var_def( 'order_dir', 'ASC' )
			)
		);
		
		if ( $ignore_nucleators )
		{
			$filter[] = array(
				'field_name'	=>	'hw_core',
				'filter_val'	=>	0,
				'field_type'	=>	SQLFieldType::INT
			);
		}
		
		if ( $this->user->is_logged_as_user() )
		{
			$filter[] = array(
				'field_name'	=>	'hw_user',
				'filter_val'	=>	$this->user->get_type_id()
			);
		}
		else if ( $this->user->is_logged_as_company() )
		{
			$filter[] = array(
				'field_name'	=>	'hw_user',
				'filter_val'	=>	get_var( 'hw_user' )
			);
		}
		
		if ( $this->user->is_logged_as_company() && NULL != get_var('groups') )
		{
			$filter[] = array(
				'join'			=>	'hardware_group_link',
				'on'			=>	'hw_id = hwgl_hw_id AND ' . SQL::get_or_filter( get_var('groups'), 'hwgl_group' )
			);
		}
		
		$hw_ids = get_post('ids');
		
		if ( isset( $hw_ids ) )
		{
			$ids = explode( ",", $hw_ids );
			
			$filter[] = array(
				'field_name'	=>	'hw_id',
				'filter_val'	=>	$ids
			);
		}
		
		$query_filter		= SQL::build_query_filter( $filter );
		
		return $query_filter;
	}
	
	public function all()
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->load->library('pagination');
		$this->load->model('Hardware_model');
		
		$page					= get_var_def( 'page_num', 1 );
		$config					= pagination_config();
		$query_filter			= $this->build_hw_filters();
		$data['hw_code']		= get_var( 'hw_code' );
		$data['hw_name']		= get_var( 'hw_name' );
		$data['hw_serial']		= get_var( 'hw_serial' );
		$data['hw_active']		= get_var( 'hw_active' );
		$data['hw_inactive']	= get_var( 'hw_inactive' );
		$config['total_rows']	= $data['total_hw']	= $this->Hardware_model->count( $this->user->get_company_ids(), $query_filter );
		$data['hws']			= $this->Hardware_model->get_all( $this->user->get_company_ids(), $query_filter, $config['per_page'], $page );
		$config['base_url']		= base_url( '/hw/all/?' . http_build_query_pagination() );

		$this->load->model('HardwareGroup_model');
		$data['groups']		= $this->HardwareGroup_model->get_all( $this->user->get_company_ids() );
				
		$this->pagination->initialize($config);
		
		$data['pagination']		= $this->pagination->create_links();
		
		$this->add_frame_view( 'hw_list', $data );
	}
	
	public function update()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$post = $this->input->post();
		
		$this->load->library('form_validation');
		
		$rules	= array(
			array(
				'field'   => 'name', 
				'label'   => 'Nombre', 
				'rules'   => 'trim|required|max_length[64]'
			),
			array(
				'field'   => 'lat', 
				'label'   => 'Latitud', 
				'rules'   => 'trim|decimal'
			),   
			array(
				'field'   => 'long', 
				'label'   => 'Longitud', 
				'rules'   => 'trim|decimal'
			),
			array(
				'field'   => 'address', 
				'label'   => 'Dirección', 
				'rules'   => 'trim|max_length[128]'
			),
			array(
				'field'   => 'state', 
				'label'   => 'Estado', 
				'rules'   => 'trim|required'
			),
			array(
				'field'   => 'icon', 
				'label'   => 'Ícono', 
				'rules'   => 'trim|required'
			)
		);
		
		$this->form_validation->set_rules( $rules );
		
		if ( $this->form_validation->run() != FALSE )
		{
			if ( $this->user->owns_hw( $post['hw_id'] ) )
			{
				$this->load->model( 'Hardware_model' );
				
				$hw = $this->Hardware_model->get_from_id( $post['hw_id'] );
				
				$this->Hardware_model->update( $post );
				
				$txt = '';
				
				if ( isset( $post['address'] ) && !empty( $post['address'] ) && $post['address'] != $hw['hw_address'] )
				{
					$this->load->model('Location_model');
					
					$loc = $this->Location_model->get( $hw['hw_city'] );
					
					if ( isset( $loc ) )
					{
						$gdc_status = '';
						
						$coords = Geocode::GetLatLong( $post['address'], $loc['loc_name'] . ', ' . $loc['loc_desc'], $gdc_status );
						
						if ( $coords )
						{
							$this->Hardware_model->update_pos( $post['hw_id'], $coords->lat, $coords->lng );
							
							$this->kajax->val( '#row_' . $post['hw_id'] . ' input[name=lat]', $coords->lat );
							$this->kajax->val( '#row_' . $post['hw_id'] . ' input[name=long]', $coords->lng );
						}
					}
				}
				
				$this->kajax->fancy_log_success( "Abonado número: " . $post['code'] . " guardado con éxito." );
				
				if ( $hw['hw_state'] == 'ACTIVE' && $post['state'] == 'INACTIVE' )
				{
					$del = '<button data-href="' . base_url( '/hw/delete/' . $hw['hw_id'] ) . '" data-text="¿Está seguro que desea eliminar el abonado ' . dechex( $hw['hw_code'] ) .'" class="submit_btn_table delete_btn" value="delete"><span>Eliminar</span></button>';
					
					$this->kajax->prepend( '#row_hidden_' . $post['hw_id'] . ' td', $del );
					
					$this->kajax->call( 'table_delete_click_register( $("#row_hidden_' . $post['hw_id'] . ' td button.delete_btn") )' );
				}
				else if ( $hw['hw_state'] == 'INACTIVE' && $post['state'] == 'ACTIVE' )
				{
					$this->kajax->remove( '#row_hidden_' . $post['hw_id'] . ' td button.delete_btn' );
				}
			}
			else
			{
				$this->kajax->fancy_log_error('No puedes modificar este abonado, no tienes suficientes permisos.');
			}
		}
		else
		{
			$this->kajax->fancy_log_error( validation_errors() );
		}
		
		$this->kajax_validation_set_input_states( $rules, $post['hw_id'] );
		
		$this->kajax->out();
	}
	
	public function update_pos( $hw_id )
	{
		$lat	= get_post( 'lat' );
		$long	= get_post( 'lng' );
		
		if ( $this->user->owns_hw( $hw_id ) )
		{
			$this->load->model('Hardware_model');
			
			$this->Hardware_model->update_pos( $hw_id, $lat, $long );
			
			$this->kajax->fancy_log_success( "Posición de abonado actualizada con éxito." );
		}
		else
		{
			$this->kajax->fancy_log_error('No puedes modificar este abonado, no tienes suficientes permisos.');
		}
		
		$this->kajax->out();
	}
	
	public function delete( $hw_id )
	{
		$this->session_restrict( USER_TYPE_CPNY );
	
		if ( $this->user->owns_hw( $hw_id ) )
		{
			$this->load->model('Hardware_model');
			
			$this->Hardware_model->delete( $hw_id );
			
			$this->kajax->fancy_log_success( "Abonado eliminado con éxito." );
			
			$this->kajax->remove( '#row_' . $hw_id );
			
			$this->kajax->remove( '#row_hidden_' . $hw_id );
		}
		else
		{
			$this->kajax->fancy_log_error('No puedes modificar este abonado, no tienes suficientes permisos.');
		}
		
		$this->kajax->out();
	}
	
	public function export( $type = 'csv', $ignore_nucleators = FALSE )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->load->model('Hardware_model');
		
		$query_filter	= $this->build_hw_filters( $ignore_nucleators );
		$data			= '';
		$res			= $this->Hardware_model->get_all( $this->user->get_company_ids(), $query_filter );
		$filename		= $this->user->get_name() . ' - abonados - ' . $type;
		
		if ( 'csv' == $type )
		{
			if ( isset( $res ) )
			{
				$sep		= CSV_SEPARATOR;
				
				csv_create_header( $filename );
				csv_array_sanitize( $res );
				
				foreach ( $res as $row )
				{
					$line = '"' . dechex( $row['hw_serial'] ) . '"'.$sep.'"' .dechex( $row['hw_code'] ) . '"'.$sep.'"' . $row['hw_name'] . '"'.$sep.'"' . $row['hw_address'] . '"'.$sep.'"' . $row['hw_lat'] . '"'.$sep.'"' . $row['hw_long'] . '"'.$sep.'"' . $row['hw_icon'] . '"'.$sep.'"' . $row['tl_tests_count'] . '"';
					$data.= str_replace( "\n", '', $line ) . "\n";
				}
			}
			
			echo $data;
		}
		else if ( 'pdf'== $type )
		{
			$data['hws'] = $res;
			
			$html = $this->load->view( 'hw_pdf', $data, TRUE );
			
			pdf_create( $html, $filename );
		}
	}
	
	public function autocomplete( $type = 'code' )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$res		= array();
		$hw_code	= get_var('search');
		
		$this->load->model('Hardware_model');
		
		if ( 'code' == $type )
		{
			$data	= $this->Hardware_model->get_all_codes( $this->user->get_company_ids(), $hw_code, $this->user->is_logged_as_user() ? $this->user->get_type_id() : NULL );
			
			if ( NULL != $data )
			{
				foreach ( $data as $r )
				{
					array_push( $res, array( 'id' => $r['hw_id'], 'name' => $r['hw_code'] ) );
				}
			}
		}
		else if ( 'name' == $type )
		{
			$data	= $this->Hardware_model->get_all_names( $this->user->get_company_ids(), $hw_code, $this->user->is_logged_as_user() ? $this->user->get_type_id() : NULL );
			
			if ( NULL != $data )
			{
				foreach ( $data as $r )
				{
					array_push( $res, array( 'id' => $r['hw_id'], 'name' => $r['hw_name'] ) );
				}
			}
		}
		else if ( 'serial' == $type )
		{
			$data	= $this->Hardware_model->get_all_serials( $this->user->get_company_ids(), $hw_code, $this->user->is_logged_as_user() ? $this->user->get_type_id() : NULL );
			
			if ( NULL != $data )
			{
				foreach ( $data as $r )
				{
					array_push( $res, array( 'id' => $r['hw_id'], 'name' => $r['hw_serial'] ) );
				}
			}
		}
		
		echo json_enc( $res );
	}
	
	public function events_export( $type = 'csv', $data )
	{
		$filename		= $this->user->get_name() . ' - eventos - ' . $type;
		
		if ( 'csv' == $type )
		{
			$res	= $data['events'];
			$ret	= '';
			$sep	= CSV_SEPARATOR;
			
			csv_create_header( $filename );
			
			if ( $this->user->get_type() >= USER_TYPE_CPNY )
			{
				$ret.= '"Abonado"' . $sep . '"Usuario"' . $sep;
			}
			
			$ret .= '"Objetivo"' . $sep . '"Fecha y Hora"' . $sep . '"Descripción"' . "\n";
			
			if ( isset( $res ) )
			{
				csv_array_sanitize( $res );
				
				foreach ( $res as $e )
				{
					if ( $this->user->get_type() >= USER_TYPE_CPNY )
					{
						$ret .= '"' . $e['hw_code'] . '"' . $sep . '"' . $e['user'] . '"' . $sep;
					}
					
					$ret.= '"' . $e['target'] . '"' . $sep . '"' . $e['time'] . '"' . $sep . '"' . $e['desc'] . '"' . "\n";
				}
			}
			
			echo $ret;
		}
		else if ( 'pdf'== $type )
		{
			$data['with_headers'] = TRUE;
			
			$html = $this->load->view( 'hardware_events_search', $data, TRUE );
			
			pdf_create( $html, $filename );
		}
	}
	
	public function events( $export = '', $type = '' )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->load->library('GlobalEvents');
		
		$now					= strftime( '%d/%m/%Y %H:%M', time() );
		$hour_ago				= strftime( '%d/%m/%Y %H:%M', time() - 3600 );
		
		$is_filtering			= get_var('hw_id') || get_var('user_id') || get_var('hw_serial') || get_var('hw_code');
		
		$from_ref				= NULL != get_var('from') ? substr( get_var('from'), strlen( 'Desde el ' ) ) : ( $is_filtering ? $hour_ago : NULL );
		$to_ref					= NULL != get_var('to') ? substr( get_var('to'), strlen( 'Hasta el ' ) ) : ( $is_filtering ? $now : NULL );
		
		$res					= $this->globalevents->search( $this->user, $from_ref, $to_ref, get_var('signal_frames'), get_var('hw_id'), get_var('user_id'), get_var('hw_serial'), get_var('hw_code') );
		$data					= array();
		$this->set_map_data( $data, TRUE, TRUE );
		$data['from']			= NULL != $from_ref ? $from_ref : $hour_ago;
		$data['to']				= NULL != $to_ref ? $to_ref : $now;
		$data['events']			= $res['events'];
		$data['scripts']		= $this->kajax->out( TRUE, TRUE );
		$data['hw_id']			= get_var( 'hw_id' );
		$data['hw_code']		= get_var( 'hw_code' );
		$data['hw_serial']		= get_var( 'hw_serial' );
		$data['user_id']		= get_var( 'user_id' );
		$data['user_name']		= get_var( 'user_name' );
		$data['was_filtering']	= NULL != get_var('from') && NULL != get_var('to');
		$data['signal_frames']	= get_var_def('signal_frames', FALSE);
		
		if ( 'csv' == $type || 'pdf' == $type )
		{
			$this->events_export( $type, $data );
		}
		else
		{
			if ( null != $data['hw_id'] )
			{
				$data['hw'] = array( 'hw_id' => $data['hw_id'] );
			}
			
			$this->add_frame_view( 'hardware_events_search', $data );
		}
	}
	
	public function view( $hw_id )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		if ( $this->user->owns_hw( $hw_id ) )
		{
			require_once( LIBSPATH . 'maps/maps.php' );
			
			$this->load->model('Hardware_model');
			$this->load->model('HardwareGroup_model');
			$this->load->model('KPanelMsgReceived_model');
			$this->load->model('Company_model');
			
			$data				= array();
			
			if ( $this->user->is_logged_as_god() )
			{
				$map_res		= HardwareMap::createmap_god();
			}
			else if ( $this->user->is_logged_as_company_ro() )
			{
				if ( $this->user->is_logged_as_company_meta() )
				{
					$map_res	= HardwareMap::createmap_company_meta();
				}
				else
				{
					$map_res	= HardwareMap::createmap_company();
				}
			}
			else
			{
				$map_res		= HardwareMap::createmap_user();
			}
			
			$data['map_html']	= $map_res['html'];
			$data['hours']		= get_var_def( 'ghours', 1 );
			$data['date_str']	= HardwareMap::$final_datetime_str;
			$data['map']		= $this->load->view( 'map', $data, TRUE );
			$data['hw']			= $this->Hardware_model->get( $hw_id );
			$data['groups']		= $this->HardwareGroup_model->get_groups_from_hw( $hw_id );
			$data['kpanel']		= $data['hw']['hw_is_kpanel'];

			if ( isset( $data['hw']['hw_imei'] ) )
			{
				if ( !isset( $data['hw']['hw_gsm_config'] ) || FALSE == json_decode( $data['hw']['hw_gsm_config'] ) )
				{
					$this->load->library('citymeshgsm');

					$data['hw']['hw_gsm_config'] = json_encode( $this->citymeshgsm->default_config() );
					// fix it
					$this->Hardware_model->update_gsm_config( $data['hw']['hw_imei'], $data['hw']['hw_gsm_config'] );
				}
				$data['hw']['gsm_config'] = json_decode( $data['hw']['hw_gsm_config'], TRUE );
			}

			$data['apiKey']		= $this->Company_model->get_api_key( User()->get_company() );

			$this->add_frame_view( 'hw_view', $data );
		}
	}
	
	public function search()
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->load->library('pagination');
		
		$this->load->model('Hardware_model');
		
		$data['js_cb']			= get_var( 'cb' );
		$data['row_id']			= get_var_def( 'row_id', 0 );
		$page					= get_var_def( 'page_num', 1 );
		$config					= pagination_config();
		$config['per_page']		= 12;
		$query_filter			= $this->build_hw_filters();
		$data['hw_code']		= get_var( 'hw_code' );
		$data['hw_name']		= get_var( 'hw_name' );
		$data['hw_serial']		= get_var( 'hw_serial' );
		$data['ui_lastname']	= get_var( 'ui_lastname' );
		$config['total_rows']	= $data['total_hws']	= $this->Hardware_model->count( $this->user->get_company_ids(), $query_filter );
		$data['hws']			= $this->Hardware_model->get_all( $this->user->get_company_ids(), $query_filter, $config['per_page'], $page );
		$config['base_url']		= base_url( '/hw/search/?' . http_build_query_pagination() );
		$config['anchor_class']	= 'class="ajax-paging-link ajax-clean" ';
		$data['base_url']		= $config['base_url'];
		
		$this->pagination->initialize($config);
		
		$data['pagination']		= $this->pagination->create_links();
		
		$this->load->view( 'hws_search_list', $data );
	}
	
	protected function groups_hw_move_to_groups( &$groups )
	{
		if ( NULL != $groups && !empty( $groups ) )
		{
			foreach ( $groups as &$group )
			{
				$group['hws']	= $this->HardwareGroup_model->get_group_links( $group['hwg_id'] );
				$group['count']	= count( $group['hws'] );
			}
		}
		
		return $groups;
	}
	
	public function groups()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->model( 'HardwareGroup_model' );
		
		$data['groups']			= $this->HardwareGroup_model->get_all( $this->user->get_company_ids() );
		$data['group_expand']	= get_var('show');
		
		$this->groups_hw_move_to_groups( $data['groups'] );
		
		$this->add_frame_view( 'hw_groups', $data );
	}
	
	public function group_add()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->model( 'HardwareGroup_model' );
		
		$name = $this->input->post('name');
		
		if ( '' != $name )
		{
			$id = $this->HardwareGroup_model->add( $name, $this->user->get_company() );
			
			if ( $id )
			{
				$data['group']				= array();
				$data['group']['hwg_id']	= $id;
				$data['group']['hwg_name']	= $name;
				$data['group']['count']		= 0;
				$data['is_adding']			= TRUE;
				
				$this->load->view('new_group', $data );
			}
		}
	}
	
	public function group_delete( $id )
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->model( 'HardwareGroup_model' );
		
		if ( $this->user->owns_group( $id ) )
		{
			$this->HardwareGroup_model->delete( $id );
			
			$this->kajax->remove('#group_but_expand_'.$id);
			
			$this->kajax->remove('#group_div_'.$id);
		}
		
		$this->kajax->out();
	}
	
	public function group_rename( $id )
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->model( 'HardwareGroup_model' );
		
		if ( $this->user->owns_group( $id ) )
		{
			$name = $this->input->post('name');
			
			$this->HardwareGroup_model->update( $name, $id );
			
			$this->kajax->text('#group_but_expand_'.$id.' .group_but b', $name);
		}
		
		$this->kajax->out();
	}
	
	public function group_add_link( $group, $hw_id )
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->model('Hardware_model');
		$this->load->model('HardwareGroup_model');
		
		if ( $this->user->owns_group( $group ) && $this->user->owns_hw( $hw_id ) )
		{
			if ( $this->HardwareGroup_model->link( $group, $hw_id ) )
			{
				$data['group']				= array();
				$data['group']['hwg_id']	= $group;
				$data['hw']					= $this->Hardware_model->get( $hw_id );
				$data['is_adding']			= TRUE;
				
				$this->load->view( 'new_group_hw_row', $data );
			}
		}
	}
	
	public function group_remove_link( $group, $hw_id )
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		if ( $this->user->owns_group( $group ) && $this->user->owns_hw( $hw_id ) )
		{
			$this->HardwareGroup_model->unlink( $group, $hw_id );
			
			$this->kajax->remove( '#row_'.$group.'_'.$hw_id );
			
			$this->kajax->call('elem_sum("#group_count_'.$group.'",-1)');
		}
		
		$this->kajax->out();
	}
	
	public function group_add_links()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$count	= 0;
		$ret	= '';
		$group	= $this->input->post('group');
		$macs	= $this->input->post('macs');
		
		$this->load->model('Hardware_model');
		$this->load->model('HardwareGroup_model');
		
		if ( !empty( $macs ) && $this->user->owns_group( $group ) )
		{
			$macs = str_replace( "\r", "", $macs );
			$macs = explode( "\n", $macs );
			
			foreach ( $macs as $mac )
			{
				$hw_serial = hexdec( $mac );
				
				if ( $this->user->owns_mac( $hw_serial ) )
				{
					$hw = $this->Hardware_model->get_from_serial( $hw_serial, ARRAY_A );
					
					if ( NULL != $hw )
					{
						if ( $this->HardwareGroup_model->link( $group, $hw['hw_id'] ) )
						{
							$data['group']				= array();
							$data['group']['hwg_id']	= $group;
							$data['hw']					= $hw;
							$data['is_adding']			= TRUE;
							
							$this->load->view( 'new_group_hw_row', $data );
						}
					}
				}
			}
		}
	}
	
	public function groups_show( $hw_id )
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->model('Hardware_model');
		$this->load->model('HardwareGroup_model');
		
		if ( $this->user->owns_hw( $hw_id ) )
		{
			$this->load->view( 'groups_modal', array( 'hw' => $this->Hardware_model->get( $hw_id ), 'groups' => $this->HardwareGroup_model->get_groups_from_hw( $hw_id ) ) );
		}
	}
	
	public function link( $ui_id, $hw_id )
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->model('Hardware_model');
		
		if ( $this->user->owns_hw( $hw_id ) && !$this->User_model->owns_hw( $ui_id, $hw_id ) )
		{
			$this->Hardware_model->link( $hw_id, $ui_id );
			
			$data['hw']	= $this->Hardware_model->get( $hw_id );
			
			$this->kajax->append( '#airmesh_box', $this->load->view( 'new_user_hw', $data, TRUE ) );
			$this->kajax->init_el( '#airmesh_box');
		}
		
		$this->kajax->out();
	}
	
	public function unlink( $hw_id )
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->model('Hardware_model');
		
		if ( $this->user->owns_hw( $hw_id ) )
		{
			$this->Hardware_model->unlink( $hw_id );
			
			$this->kajax->remove("#hw_$hw_id");
		}
		
		$this->kajax->out();
	}

	/////
	// Functions for GPRS devices.

	protected function update_config_state( $hw )
	{
		if ( isset( $hw['hw_cmd_timestamp'] ) )
		{
			if ( $hw['hw_cmd_state'] == 'WAITING_RESPONSE' )
			{
				if ( ( time() - $hw['hw_cmd_timestamp'] < AVL_CMD_TIMEOUT ) )
				{
					return false;
				}
				else
				{
					$this->load->model( 'Hardware_model' );
					
					$this->Hardware_model->update_cmd_state( $hw['hw_imei'], 'TIMEOUT' );
				}
			}
		}
		
		return true;
	}
	
	protected function is_config_state_valid( $hw )
	{
		return $this->update_config_state( $hw );
	}

	public function get_json( $imei )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		if ( $this->user->owns_hw( $imei ) )
		{
			$this->load->model( 'Hardware_model' );
			
			$hw = $this->Hardware_model->get_from_imei( $imei );
			
			$this->update_config_state( $hw );
			
			echo json_encode( $hw );
		}
	}

	protected function get_config_rules()
	{
		return array(
			array(
				'field'   => 'gsm', 
				'label'   => 'Host primario', 
				'rules'   => 'trim|required|callback_val_gsm'
			),
			array(
				'field'   => 'test_alr', 
				'label'   => 'Alarma de testeo', 
				'rules'   => 'trim|integer'
			),
			array(
				'field'   => 'recv', 
				'label'   => 'Host receptora', 
				'rules'   => 'trim|callback_val_ipdomport'
			),
			array(
				'field'   => 'firm_ver', 
				'label'   => 'Versión en ejecución', 
				'rules'   => 'trim|callback_val_version'
			),
			array(
				'field'   => 'upgr_ver', 
				'label'   => 'Versión en actualización', 
				'rules'   => 'trim|callback_val_version'
			)
		);
	}

	public function recover_config( $imei )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		if ( $this->user->owns_hw( $imei ) )
		{
			$this->load->library('citymeshgsm');
			$this->load->model( 'Hardware_model' );
			
			$hw	= $this->Hardware_model->get_from_imei( $imei );
			
			$this->load->library('form_validation');
			
			$rules	= $this->get_config_rules();
			
			$this->form_validation->set_rules( $rules );
			
			if ( $this->form_validation->run() != FALSE )
			{
				if ( isset( $hw )&& $this->is_config_state_valid( $hw ) )
				{
					$cfg	= $this->citymeshgsm->default_config();
					
					if ( isset( $hw['hw_gsm_config'] ) )
					{
						$oldcfg	= json_decode( $hw['hw_gsm_config'], TRUE );
						
						if ( $oldcfg )
						{
							$cfg	= array_merge_recursive_distinct( $cfg, $oldcfg );
						}
					}

					$newcfg	= $this->input->post();
					
					if ( isset( $newcfg['kajax'] ) )
					{
						unset( $newcfg['kajax'] );
					}
					
					$this->citymeshgsm->config_auto_cast( $newcfg );
					
					$cfg	= array_merge_recursive_distinct( $cfg, $newcfg );
					$json	= json_encode($cfg);
					
					$this->Hardware_model->update_gsm_config( $imei, $json );
				}
			}
		}
	}

	public function save_config( $imei )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		if ( $this->user->owns_hw( $imei ) )
		{
			$this->load->library('citymeshgsm');
			$this->load->model( 'Hardware_model' );
			
			$hw	= $this->Hardware_model->get_from_imei( $imei );
			
			$this->load->library('form_validation');
			
			$rules	= $this->get_config_rules();
			
			$this->form_validation->set_rules( $rules );
			
			if ( $this->form_validation->run() != FALSE )
			{
				if ( isset( $hw )&& $this->is_config_state_valid( $hw ) )
				{
					$cfg	= $this->citymeshgsm->default_config();
					
					if ( isset( $hw['hw_gsm_config'] ) )
					{
						$oldcfg	= json_decode( $hw['hw_gsm_config'], TRUE );
						
						if ( $oldcfg )
						{
							$cfg	= array_merge_recursive_distinct( $cfg, $oldcfg );
						}
					}

					$newcfg	= $this->input->post();
					
					if ( isset( $newcfg['kajax'] ) )
					{
						unset( $newcfg['kajax'] );
					}
					
					$this->citymeshgsm->config_auto_cast( $newcfg );
					
					$cfg	= array_merge_recursive_distinct( $cfg, $newcfg );
					$json	= json_encode($cfg);
					
					$this->Hardware_model->update_gsm_config( $imei, $json );
					$this->Hardware_model->update_cmd_state( $imei, 'WAITING_RESPONSE' );
					$this->Hardware_model->update_cmd_timestamp( $imei, time() );
					
					$this->citymeshgsm->send_msg( $imei, $this->citymeshgsm->gen_config( $imei, $cfg ) );
					
					$this->kajax->fancy_log_success( "Configuración guardada y enviada al equipo: $imei.<br/>Esperando respuesta del mismo." );
					
					$this->kajax->call( 'state_polling_start()' );
				}
				else
				{
					$this->kajax->fancy_log_error( "Aún se espera la confirmación del equipo del guardado de una configuración anterior." );
				}
			}
			else
			{
				$this->kajax->fancy_log_error( validation_errors() );
			}
		}
		else
		{
			$this->kajax->fancy_log_error('¡Usuario no autorizado!');
		}
		
		$this->kajax_validate_inputs( $rules, '.config_cont_city' );
		
		$this->kajax->out();
	}

	public function info_show( $hw_id )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->load->model( 'Hardware_model' );
		
		if ( $this->user->owns_hw( $hw_id ) )
		{
			$hw = $this->Hardware_model->get( $hw_id );
			
			$this->load->view( 'hw_info', array( 'hw_id' => $hw_id, 'hw_info' => $hw['hw_info'] ) );
		}
	}
	
	public function info_save()
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->load->model( 'Hardware_model' );
		
		$post = $this->input->post();
		
		if ( $this->user->owns_hw( $post['hw_id'] ) )
		{
			$this->Hardware_model->update_info( $post['hw_id'], $post['info'] );
			
			$this->kajax->fancy_log_success( 'Información del Equipo guardada con éxito.' );
			
		}
		else
		{
			$this->kajax->fancy_log_error( 'No tienes permisos para modificar el abonado.' );
		}
		
		
		$this->kajax->call('modal_dialog_close()');
		
		$this->kajax->out();
	}
	
	protected function build_hour_table( $hw_id )
	{
		$this->load->helper('hours');
		$this->load->model( 'HardwareHours_model' );
		
		$arr = array();
		
		$hours = $this->HardwareHours_model->get( $hw_id );
		
		if ( isset( $hours ) )
		{
			foreach ( $hours as $hour )
			{
				$arr[ 'hours_' . HoursSlot::turn_from_hour( $hour->hh_init, true ) . '_' . $hour->hh_day . '_ini' ] = substr( $hour->hh_init, 0, 5 );
				$arr[ 'hours_' . HoursSlot::turn_from_hour( $hour->hh_end, false ) . '_' . $hour->hh_day . '_fin' ] = substr( $hour->hh_end , 0, 5 );
			}
		}
		
		return $arr;
	}

	public function hours( $hw_id )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		if ( $this->user->owns_hw( $hw_id ) )
		{
			$this->load->helper('hours');
			$this->load->model('Hardware_model');
			
			$data['hw_id']			= $hw_id;
			$data['hw']				= $this->Hardware_model->get_from_id( $hw_id );
			$data['hours_table']	= $this->build_hour_table( $hw_id );
			
			$this->add_frame_view( 'hw_hours', $data );
		}
	}
	
	public function hours_save( $hw_id )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		if ( $this->user->owns_hw( $hw_id ) )
		{
			$this->load->model( 'HardwareHours_model' );
			
			$this->HardwareHours_model->save( $hw_id, $this->input->post() );
			
			$this->kajax->fancy_log_success( 'Franja Horaria Guardada Exitosamente' );
		}
		else
		{
			$this->kajax->fancy_log_error( "No puedes modificar la franja horaria de este abonado" );
		}
		
		$this->kajax->out();
	}
	
	public function setup_signal_history( $hw_id )
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		if ( $this->user->owns_hw( $hw_id ) )
		{
			$this->load->model( 'Hardware_model' );
			$this->load->model( 'HardwareSetupSignalHistory_model' );
			
			$data['hw'] = $this->Hardware_model->get( $hw_id );
			$data['setups'] = $this->HardwareSetupSignalHistory_model->get_from_id( $hw_id );
			
			$this->load->view( 'hw_setup_signal_history', $data );
		}
	}
	
	protected function build_inst_history_filters()
	{
		$filter				= array(
			array(
				'order_by'		=> get_var_def( 'order_by', 'hwsh_inst_time' ),
				'order_fields'	=> array( 'hwsh_inst_time', 'hwsh_hw_code', 'hwsh_hw_serial' ),
				'order_dir'		=> get_var_def( 'order_dir', 'DESC' ),
				'null_order'	=> 'LAST'
			),
			array(
				'group_by'		=> 'hardware.hw_id, hardware_setup_signal_history.hwsh_id'
			)
		);
		
		$query_filter		= SQL::build_query_filter( $filter );
		
		return $query_filter;
	}
	
	public function inst_history()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->library('pagination');
		$this->load->model( 'HardwareSetupSignalHistory_model' );
		
		$page					= get_var_def( 'page_num', 1 );
		$config					= pagination_config();
		$query_filter			= $this->build_inst_history_filters();
		$config['total_rows']	= $data['total_hw']	= $this->HardwareSetupSignalHistory_model->count( $this->user->get_company_ids(), $query_filter );
		$data['setups']			= $this->HardwareSetupSignalHistory_model->get_all( $this->user->get_company_ids(), $query_filter, $config['per_page'], $page );
		$config['base_url']		= base_url( '/hw/inst_history/?' . http_build_query_pagination() );

		$this->pagination->initialize($config);
		
		$data['pagination']		= $this->pagination->create_links();
		
		$this->add_frame_view( 'hw_inst_history', $data );
	}
	
	protected function build_inst_current_filters()
	{
		$filter				= array(
			array(
				'field_name'	=> 'hwsh_inst_time',
				'filter_val'	=> SQL::get_seconds_back( 3600 * 24 ),
				'filter_type'	=> SQLFilterType::BIGGER_OR_EQ,
				'val_convert'	=> SQLConvertType::NONE,
				'field_type'	=> SQLFieldType::ANY
			),
			array(
				'field_name'	=> 'hw_id',
				'filter_val'	=> NULL,
				'filter_type'	=> SQLFieldType::INT,
				'accept_null'	=> TRUE
			),
			array(
				'order_by'		=> get_var_def( 'order_by', 'hwsh_inst_time' ),
				'order_fields'	=> array( 'hwsh_inst_time', 'hwsh_hw_code', 'hwsh_hw_serial' ),
				'order_dir'		=> get_var_def( 'order_dir', 'DESC' ),
				'null_order'	=> 'LAST'
			),
			array(
				'group_by'		=> 'hardware_setup_signal_history.hwsh_id'
			)
		);
		
		$query_filter		= SQL::build_query_filter( $filter );
		
		return $query_filter;
	}
	
	public function inst_current()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->library('pagination');
		$this->load->model( 'HardwareSetupSignalHistory_model' );
		
		$page					= get_var_def( 'page_num', 1 );
		$config					= pagination_config();
		$query_filter			= $this->build_inst_current_filters();
		$config['total_rows']	= $data['total_hw']	= $this->HardwareSetupSignalHistory_model->count_current( $this->user->get_company_ids(), $query_filter );
		$data['setups']			= $this->HardwareSetupSignalHistory_model->get_all_current( $this->user->get_company_ids(), $query_filter, $config['per_page'], $page );
		$config['base_url']		= base_url( '/hw/inst_current/?' . http_build_query_pagination() );

		$this->pagination->initialize($config);
		
		$data['pagination']		= $this->pagination->create_links();
		
		$this->add_frame_view( 'hw_inst_current', $data );
	}
	
	public function get_last_instalation_id()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->model( 'HardwareSetupSignalHistory_model' );
		
		echo $this->HardwareSetupSignalHistory_model->get_last_id( $this->user->get_company_ids() );
	}
	
	public function hw_events_graph()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		require_once( LIBSPATH . 'graphs/graphview.php' );
		
		$data = GraphView::gen_hw_events_by_time();
		
		$this->set_map_data( $data, TRUE, TRUE );
		
		$data['no_sel'] = TRUE;
		
		$this->add_frame_view( 'graph_tests_by_company', $data );
	}
	
	public function actions( $hw_id )
	{
		$this->load->model( 'Hardware_model' );	
		
		$hw = $this->Hardware_model->get( $hw_id );
		
		if ( isset( $hw ) )
		{
			$data['hw']		= $hw;
			$data['hwc']	= array( 'actions' => Actions::get_last_states( $hw['hw_id'] ) );
		}
		
		$this->add_frame_view( 'actions', $data );
	}
	
	public function build_hw_tmp_filters()
	{
		$filter				= array(
			array(
				'order_by'		=> get_var_def( 'order_by', 'hwt_code' ),
				'order_fields'	=> array( 'hwt_code', 'hwt_serial', 'hwt_df_company', 'hwt_df_receiver', 'hwt_time_lasttest', 'hwt_testcount', 'com_name' ),
				'order_dir'		=> get_var_def( 'order_dir', 'ASC' ),
				'null_order'	=> 'LAST'
			)
		);
		
		$query_filter		= SQL::build_query_filter( $filter );
		
		return $query_filter;
	}
	
	public function tmp_hw()
	{
		$this->session_restrict( USER_TYPE_CPNY_RO );
		
		$this->load->library('pagination');
		$this->load->model( 'HardwareTmp_model' );
		
		$page					= get_var_def( 'page_num', 1 );
		$config					= pagination_config();
		$config['total_rows']	= $data['total_hw']	= $this->HardwareTmp_model->count( $this->user->get_company_ids(), $this->build_hw_tmp_filters() );
		$data['hws']			= $this->HardwareTmp_model->get_all( $this->user->get_company_ids(), $this->build_hw_tmp_filters(), $config['per_page'], $page );
		$config['base_url']		= base_url( '/hw/tmp_hw/?' . http_build_query_pagination() );
		
		$this->pagination->initialize($config);
		
		$data['pagination']		= $this->pagination->create_links();
		
		$this->add_frame_view( 'hw_tmp_list', $data );
	}
}
