<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Guest extends PAGE_Controller
{
	public function index()
	{
		$this->all();
	}
	
	public function all()
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->load->library('pagination');
		$this->load->model('RfidUser_model');
		$this->load->model('RfidVisit_model');
		$this->load->model('RfidUserPlot_model');
		
		if ( -1 == str_starts_with( 'Filtrar', get_var('from') ) )
		{
			$data['from'] = $from_ref	= NULL != get_var('from') ? substr( get_var('from'), strlen( 'Desde el ' ) ) : NULL;
		}
		else
		{
			$data['from'] = $from_ref	= NULL;
		}
		
		if ( -1 == str_starts_with( 'Filtrar', get_var('to') ) )
		{
			$data['to']	= $to_ref		= NULL != get_var('to') ? substr( get_var('to'), strlen( 'Hasta el ' ) ) : NULL;
		}
		else
		{
			$data['to']	= $to_ref		= NULL;
		}
		
		if ( $data['to'] < $data['from'] )
		{
			$new_from		= $data['to'];
			$data['to']		= $data['from'];
			$data['from']	= $new_from;
		}
		
		$data['urfid_name']			= get_var( 'urfid_name' );
		$data['urfid_dni']			= get_var( 'urfid_dni' );
		$data['urfid_plot']			= get_var( 'urfid_plot' );
		$page						= get_var_def( 'page_num', 1 );
		$config						= pagination_config();
		$urfid_id					= NULL;
		
		$data['user'] = $person		= $this->RfidUser_model->get_by_uid( $this->user->get_id() );
		
		$plots = $this->RfidUserPlot_model->get_arr( $person['urfid_id'] );
		
		$is_owner_view = NULL != $plots && NULL != $person && ( $person['urfid_user_type'] == RfIdUserType::OWNER || $person['urfid_user_type'] == RfIdUserType::NEIGHBOR );
		
		if ( $is_owner_view )
		{
			$this->load->model('RfidGallery_model');
			
			$urfid_id		= $person['urfid_id'];
			$data['family'] = $this->RfidUser_model->get_all( NULL, $this->build_family_filter( $person['urfid_id'], $plots ) );
			$data['workers'] = $this->RfidUser_model->get_all( NULL, $this->build_family_filter( $person['urfid_id'], $plots, array( RfIdUserType::SERVICE, RfidUserType::PROFESSIONAL, RfidUserType::WORKER ) ) );
			$data['general_photos'] = $this->RfidGallery_model->get_gallery_photos( $urfid_id, RfidGalleryType::GENERAL );
		}
		
		$query_filter				= $this->build_event_filters( $from_ref, $to_ref, NULL, $urfid_id );
		$config['total_rows']		= $data['total_events']	= $this->RfidVisit_model->count( $this->user->get_company_ids(), $query_filter );
		$data['events']				= $events = $this->RfidVisit_model->get_all( $this->user->get_company_ids(), $query_filter, $config['per_page'], $page );
		$config['base_url']			= base_url( '/dshield/guest/all/?' . http_build_query_pagination() );
		
		$this->pagination->initialize($config);
		
		$data['pagination']		= $this->pagination->create_links();
		
		if ( $is_owner_view )
		{
			$this->add_frame_view( 'dshield/owner_main', $data );
		}
		else
		{
			$this->add_frame_view( 'dshield/user_main', $data );
		}
	}
	
	public function add()
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->load->view('dshield/guest_add');
	}
	
	public function edit( $rv_id )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->load->model('RfidVisit_model');
		
		$data['person'] = $this->RfidVisit_model->get( $rv_id );
		
		$this->load->view('dshield/guest_add', $data);
	}
	
	public function insert()
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$post = $this->input->post();
		
		$this->load->model('RfidUser_model');
		$this->load->model('RfidUserPlot_model');
		$this->load->model('RfidVisit_model');
		
		$this->load->library('form_validation');
		
		$rfme = $this->RfidUser_model->get_by_uid( $this->user->get_user_id() );
		
		if ( !isset( $rfme ) )
		{
			$this->kajax->fancy_log_error( "No estás registrado en el sistema como usuario de control de accesos." );
			$this->kajax->out();
			return;
		}
		
		$plots = $this->RfidUserPlot_model->get_arr( $rfme['urfid_id'] );
		
		if ( !isset( $plots ) )
		{
			$this->kajax->fancy_log_error( "Tu usuario no corresponde a ningún lote, para generar visitas debes pertenecer a uno." );
			$this->kajax->out();
			return;
		}
		
		$rules	= array(
			array(
				'field'   => 'name', 
				'label'   => 'Nombre Completo', 
				'rules'   => 'trim|required|max_length[64]'
			),
			array(
				'field'   => 'dni', 
				'label'   => 'DNI', 
				'rules'   => 'trim|integer'
			),
			array(
				'field'   => 'from', 
				'label'   => 'Ingreso', 
				'rules'   => 'trim|required'
			),
			array(
				'field'   => 'to', 
				'label'   => 'Egreso', 
				'rules'   => 'trim|required'
			)
		);
		
		$this->form_validation->set_rules( $rules );
		
		$form_inputs = '.form-table input, .form-table textarea, .form-table select';
		$this->kajax->removeClass( $form_inputs, 'error' );
		$this->kajax->resetAnim( $form_inputs );
		
		if ( $this->form_validation->run() != FALSE )
		{
			$from_ref		= NULL != get_post('from') ? substr( get_post('from'), strlen( 'Desde el ' ) ) : '';
			$to_ref			= NULL != get_post('to') ? substr( get_post('to'), strlen( 'Hasta el ' ) ) : '';
			$from_unix_time	= get_timestamp_from_date_time( $from_ref );
			$to_unix_time	= get_timestamp_from_date_time( $to_ref );
			
			if ( $from_unix_time < $to_unix_time )
			{
				if ( !isset( $post['id'] ) || empty( $post['id'] ) || 0 == intval( $post['id'] ) )
				{
					$this->RfidVisit_model->create( $this->user->get_company(), $post['name'], $from_unix_time, $to_unix_time, 0, intval( $post['dni'] ) == 0 ? NULL : $post['dni'], $rfme['urfid_id'], $plots );
					
					$this->kajax->reload_target();
					$this->kajax->call('modal_dialog_close()');
					$this->kajax->fancy_log_success( 'Visita de ' . $post['name'] . ' añadida.' );
				}
				else
				{
					$rv = $this->RfidVisit_model->get( $post['id'] );
					
					if ( $this->user->owns_guest( $rv['rv_urfid_id'] ) )
					{
						$this->RfidVisit_model->update( $post['id'], $post['name'], $from_unix_time, $to_unix_time, intval( $post['dni'] ) == 0 ? NULL : $post['dni'], $rfme['urfid_id'], $plots );
						
						$this->kajax->reload_target();
						$this->kajax->call('modal_dialog_close()');
						$this->kajax->fancy_log_success( 'Visita de ' . $post['name'] . ' actualizada.' );
					}
					else
					{
						$this->kajax->fancy_log_error( "No tienes permisos para realizar esta acción." );
					}
				}
			}
			else
			{
				$this->kajax->fancy_log_error( "La fecha de ingreso debe ser anterior a la de egreso." );
			}
		}
		else
		{
			$this->kajax->fancy_log_error( validation_errors() );
		}
		
		$this->kajax_validate_inputs( $rules );
		
		$this->kajax->out();
	}
	
	public function insert_row( $rve_id )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$post = $this->input->post();
		
		$this->load->model('RfidUser_model');
		$this->load->model('RfidUserPlot_model');
		$this->load->model('RfidVisit_model');
		$this->load->model('RfidVisitEvent_model');
		
		$this->load->library('form_validation');
		
		$rfme = $this->RfidUser_model->get_by_uid( $this->user->get_user_id() );
		
		if ( !isset( $rfme ) )
		{
			$this->kajax->fancy_log_error( "No estás registrado en el sistema como usuario de control de accesos." );
			$this->kajax->out();
			return;
		}
		
		$plots = $this->RfidUserPlot_model->get_arr( $rfme['urfid_id'] );
		
		if ( !isset( $plots ) )
		{
			$this->kajax->fancy_log_error( "Tu usuario no corresponde a ningún lote, para generar visitas debes pertenecer a uno." );
			$this->kajax->out();
			return;
		}
		
		$rules	= array(
			array(
				'field'   => 'name', 
				'label'   => 'Nombre Completo', 
				'rules'   => 'trim|required|max_length[64]'
			),
			array(
				'field'   => 'dni', 
				'label'   => 'DNI', 
				'rules'   => 'trim|integer'
			)
		);
		
		$this->form_validation->set_rules( $rules );
		
		$rve = $this->RfidVisitEvent_model->get( $rve_id );
		
		if ( !isset($rve) )
		{
			$this->kajax->fancy_log_error( "Evento inexistente." );
			$this->kajax->out();
			return;
		}
		
		if ( $this->form_validation->run() != FALSE )
		{
			$from	= $rve['rve_time_start'];
			$to		= $rve['rve_time_end'];
			
			if ( !isset( $post['id'] ) || empty( $post['id'] ) || 0 == intval( $post['id'] ) )
			{
				$id = $this->RfidVisit_model->create( $this->user->get_company(), $post['name'], $from, $to, $rve_id, intval( $post['dni'] ) == 0 ? NULL : $post['dni'], $rve['rve_urfid_id'], $plots );
				
				$this->kajax->fancy_log_success( 'Visita de ' . $post['name'] . ' añadida.' );
				
				$this->kajax_replace_new_ids( $id, array( 'row_', 'row_hidden_' ) );
				
				$this->kajax->call( 'table_row_new_convert_to_id( ' . $id . ', "id", "' . base_url('/guest/cancel/'.$id) . '", "¿Seguro que quiere cancelar la visita de ' . $post['name'] . '?" )' );
			}
			else
			{
				$rv = $this->RfidVisit_model->get( $post['id'] );
				
				if ( $this->user->owns_guest( $rv['rv_urfid_id'] ) )
				{
					$this->RfidVisit_model->update( $post['id'], $post['name'], $from, $to, intval( $post['dni'] ) == 0 ? NULL : $post['dni'], $rve['rve_urfid_id'], $plots );
					
					$this->kajax->fancy_log_success( 'Visita de ' . $post['name'] . ' actualizada.' );
				}
				else
				{
					$this->kajax->fancy_log_error( "No tienes permisos para realizar esta acción." );
				}
			}
		}
		else
		{
			$this->kajax->fancy_log_error( validation_errors() );
		}
		
		$this->kajax_validation_set_input_states( $rules, $post['id'] );
		
		$this->kajax->out();
	}
	
	public function cancel( $rv_id )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->load->model('RfidVisit_model');
		
		$rv = $this->RfidVisit_model->get( $rv_id );
		
		if ( $this->user->owns_guest( $rv['rv_urfid_id'] ) )
		{
			$this->RfidVisit_model->delete( $rv_id );
			
			$this->kajax->fancy_log_success( 'Visita cancelada.' );
			
			$this->kajax->remove( '#row_' . $rv_id );
			$this->kajax->remove( '#row_hidden_' . $rv_id );
			
			$this->kajax->call('modal_dialog_close()');
		}
		else
		{
			$this->kajax->fancy_log_error( "No tienes permisos para realizar esta acción." );
		}
		
		$this->kajax->out();
	}
	
	public function event_add()
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->load->model('RfidUser_model');
		$this->load->model('RfidUserPlot_model');
		
		$rfme = $this->RfidUser_model->get_by_uid( $this->user->get_user_id() );
		
		if ( !isset( $rfme ) )
		{
			echo "No estás registrado en el sistema como usuario de control de accesos.";
			return;
		}
		
		$plots = $this->RfidUserPlot_model->get_arr( $rfme['urfid_id'] );
		
		if ( !isset( $plots ) )
		{
			echo "Tu usuario no corresponde a ningún lote, para generar visitas debes pertenecer a uno.";
			return;
		}
		
		$data['def_name'] = 'Evento en lote ' . $plots[0];
		
		$this->load->view( 'dshield/guest_event_add', $data );
	}
	
	public function event_edit( $rve_id )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->load->model('RfidVisitEvent_model');
		
		$data['event'] = $this->RfidVisitEvent_model->get( $rve_id );
		
		$this->load->view('dshield/guest_event_add', $data);
	}
	
	public function insert_event()
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$post = $this->input->post();
		
		$this->load->model('RfidUser_model');
		$this->load->model('RfidUserPlot_model');
		$this->load->model('RfidVisitEvent_model');
		
		$this->load->library('form_validation');
		
		$rfme = $this->RfidUser_model->get_by_uid( $this->user->get_user_id() );
		
		if ( !isset( $rfme ) )
		{
			$this->kajax->fancy_log_error( "No estás registrado en el sistema como usuario de control de accesos." );
			$this->kajax->out();
			return;
		}
		
		$plots = $this->RfidUserPlot_model->get_arr( $rfme['urfid_id'] );
		
		if ( !isset( $plots ) )
		{
			$this->kajax->fancy_log_error( "Tu usuario no corresponde a ningún lote, para generar visitas debes pertenecer a uno." );
			$this->kajax->out();
			return;
		}
		
		$rules	= array(
			array(
				'field'   => 'name', 
				'label'   => 'Nombre Completo', 
				'rules'   => 'trim|required|max_length[64]'
			),
			array(
				'field'   => 'from', 
				'label'   => 'Ingreso', 
				'rules'   => 'trim|required'
			),
			array(
				'field'   => 'to', 
				'label'   => 'Egreso', 
				'rules'   => 'trim|required'
			)
		);
		
		$this->form_validation->set_rules( $rules );
		
		$form_inputs = '.form-table input, .form-table textarea, .form-table select';
		$this->kajax->removeClass( $form_inputs, 'error' );
		$this->kajax->resetAnim( $form_inputs );
		
		if ( $this->form_validation->run() != FALSE )
		{
			$from_ref		= NULL != get_post('from') ? substr( get_post('from'), strlen( 'Desde el ' ) ) : '';
			$to_ref			= NULL != get_post('to') ? substr( get_post('to'), strlen( 'Hasta el ' ) ) : '';
			$from_unix_time	= get_timestamp_from_date_time( $from_ref );
			$to_unix_time	= get_timestamp_from_date_time( $to_ref );
			
			if ( $from_unix_time < $to_unix_time )
			{
				if ( !isset( $post['id'] ) || empty( $post['id'] ) || 0 == intval( $post['id'] ) )
				{
					$id = $this->RfidVisitEvent_model->add( $rfme['urfid_id'], $post['name'], $from_unix_time, $to_unix_time, '' );
					
					$this->kajax->call('modal_dialog_close()');
					
					$this->kajax->reload_target();
					
					$this->kajax->fancy_log_success( 'Evento "' . $post['name'] . '" añadido.' );
				}
				else
				{
					$rv = $this->RfidVisitEvent_model->get( $post['id'] );
					
					if ( $this->user->owns_guest( $rv['rve_urfid_id'] ) )
					{
						$this->RfidVisitEvent_model->update( $post['id'], $post['name'], $from_unix_time, $to_unix_time, '' );
						
						$this->kajax->reload_target();
						$this->kajax->call('modal_dialog_close()');
						$this->kajax->fancy_log_success( 'Evento "' . $post['name'] . '" actualizado.' );
					}
					else
					{
						$this->kajax->fancy_log_error( "No tienes permisos para realizar esta acción." );
					}
				}
			}
			else
			{
				$this->kajax->fancy_log_error( "La fecha de inicio del evento debe ser anterior a la de su finalización." );
			}
		}
		else
		{
			$this->kajax->fancy_log_error( validation_errors() );
		}
		
		$this->kajax_validate_inputs( $rules );
		
		$this->kajax->out();
	}
	
	public function event_cancel( $rve_id )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->load->model('RfidVisitEvent_model');
		
		$rve = $this->RfidVisitEvent_model->get( $rve_id );
		
		if ( $this->user->owns_guest( $rve['rve_urfid_id'] ) )
		{
			$this->RfidVisitEvent_model->delete( $rve_id );
			
			$this->kajax->fancy_log_success( 'Evento cancelado.' );
			
			$this->kajax->remove( '#rowe_' . $rve_id );
			
			$this->kajax->call('modal_dialog_close()');
		}
		else
		{
			$this->kajax->fancy_log_error( "No tienes permisos para realizar esta acción." );
		}
		
		$this->kajax->out();
	}
	
	public function event_visits( $rve_id )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->load->model('RfidVisitEvent_model');
		
		$rve = $this->RfidVisitEvent_model->get( $rve_id );
		
		if ( isset( $rve ) && $rve['rve_id'] == $rve_id )
		{
			$this->load->library('pagination');
			$this->load->model('RfidVisit_model');
			
			$data['urfid_name']			= get_var( 'urfid_name' );
			$data['urfid_dni']			= get_var( 'urfid_dni' );
			$page						= get_var_def( 'page_num', 1 );
			$config						= pagination_config();
			
			$query_filter				= $this->build_event_filters( NULL, NULL, $rve_id );
			$config['total_rows']		= $data['total_visits']	= $this->RfidVisit_model->count_visits( $this->user->get_company_ids(), $query_filter );
			$data['visits']				= $this->RfidVisit_model->get_visits( $this->user->get_company_ids(), $query_filter, $config['per_page'], $page );
			$data['event'] 				= $rve;
			$config['base_url']			= base_url( '/dshield/guest/event_visits/' . $rve_id . '/?' . http_build_query_pagination() );
			
			$this->pagination->initialize($config);
			
			$data['pagination']		= $this->pagination->create_links();
			
			$this->load->view( 'dshield/guest_event_visit', $data );
		}
		else
		{
			echo "No tienes permisos para realizar esta acción.";
		}
	}
	
	public function event_visits_modal( $rve_id )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->load->model('RfidVisitEvent_model');
		
		$rve = $this->RfidVisitEvent_model->get( $rve_id );
		
		if ( isset( $rve ) && $rve['rve_id'] == $rve_id )
		{
			$this->load->library('pagination');
			$this->load->model('RfidVisit_model');
			
			$data['urfid_name']			= get_var( 'urfid_name' );
			$data['urfid_dni']			= get_var( 'urfid_dni' );
			$page						= get_var_def( 'page_num', 1 );
			$config						= pagination_config();
			$config['per_page']			= 5;
			$query_filter				= $this->build_event_filters( NULL, NULL, $rve_id );
			$config['total_rows']		= $data['total_visits']	= $this->RfidVisit_model->count_visits( $this->user->get_company_ids(), $query_filter );
			$data['visits']				= $this->RfidVisit_model->get_visits( $this->user->get_company_ids(), $query_filter, $config['per_page'], $page );
			$data['event'] 				= $rve;
			$config['base_url']			= $data['base_url']		= base_url( '/dshield/guest/event_visits_modal/' . $rve_id . '/?' . http_build_query_pagination() );
			$config['anchor_class']		= 'class="ajax-paging-link ajax-clean" ';
			
			$this->pagination->initialize($config);
			
			$data['pagination']		= $this->pagination->create_links();
			
			$this->load->view( 'dshield/guest_event_visit_list', $data );
		}
		else
		{
			echo "No tienes permisos para realizar esta acción.";
		}
	}
}
