<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Geotrace extends PAGE_Controller
{
	protected function set_map_to_tpl( &$data, &$vehicles )
	{
		$data['geotrace_moving_count']		= 0;
		$data['geotrace_stopped_count']		= 0;
		$data['geotrace_noreport_count']	= 0;
		
		if ( NULL != $vehicles )
		{
			$data['geotrace_hw_count']			= count( $vehicles );
			
			foreach ( $vehicles as $v )
			{
				if ( 'NOREPORT' == $v['state'] || 'NOGPS' == $v['state'] )
				{
					$data['geotrace_noreport_count']++;
				}
				else if ( 'STOPPED' == $v['state'] )
				{
					$data['geotrace_stopped_count']++;
				}
				else if ( 'MOVING' == $v['state'] )
				{
					$data['geotrace_moving_count']++;
				}
			}
		}
		else
		{
			$data['geotrace_hw_count']			= 0;
		}
		
		if ( $data['geotrace_hw_count'] > 0 )
		{
			$data['geotrace_noreport_percent']		= intval( floor( floatval( $data['geotrace_noreport_count'] ) / floatval( $data['geotrace_hw_count'] ) * 100 ) );
			$data['geotrace_stopped_percent']		= intval( floor( floatval( $data['geotrace_stopped_count'] ) / floatval( $data['geotrace_hw_count'] )  * 100 ) );
			$data['geotrace_moving_percent']		= intval( floor( floatval( $data['geotrace_moving_count'] ) / floatval( $data['geotrace_hw_count'] ) * 100 ) );
		}
		else
		{
			$data['geotrace_noreport_percent']		= 100;
			$data['geotrace_stopped_percent']		= 0;
			$data['geotrace_moving_percent']		= 0;
		}
		
		$total_percent							= $data['geotrace_noreport_percent'] + $data['geotrace_stopped_percent'] + $data['geotrace_moving_percent'];
		
		if ( $total_percent < 100 )
		{
			$rest = 100 - $total_percent;
			
			if ( $data['geotrace_noreport_percent'] > 0 )
			{
				$data['geotrace_noreport_percent'] += $rest;
			}
			else if ( $data['geotrace_stopped_percent'] > 0 )
			{
				$data['geotrace_stopped_percent'] += $rest;
			}
			else if ( $data['geotrace_moving_percent'] > 0 )
			{
				$data['geotrace_moving_percent'] += $rest;
			}
		}
	}

	public function index()
	{
		$this->map();
	}
	
	protected function build_vehicles_filter()
	{
		$fields = array(
			array(
				'field_name'	=>	'ae_id',
				'filter_val'	=>	'( SELECT MAX(ae_id) FROM avl_event WHERE ae_imei = ahw_imei )',
				'field_type'	=>	SQLFieldType::ANY
			),
			/*array(
				'field_name'	=>	'ae_gpsstatus',
				'filter_val'	=>	'V',
				'filter_type'	=>	SQLFilterType::UNEQUALS
			),*/
			array(
				'order_by'		=>	'af_name',
				'order_dir'		=>	'ASC',
				'null_order'	=>	'LAST'
			),
			array(
				'order_by'		=>	'state',
				'order_dir'		=>	'ASC'
			)
		);
		
		return SQL::build_query_filter( $fields );
	}
	
	protected function map_get_basic_data( $uid = NULL )
	{
		$this->load->model( 'AvlHardware_model' );
		$this->load->model('AvlFleet_model');
		
		$data	= array();
		
		if ( $this->user->is_logged_as_user() )
		{
			$uid			= $this->user_id();
		}
		
		$filter_company		= $this->user->get_company() > 0 ? $this->user->get_company() : NULL;
		$data['vehicles']	= $this->AvlHardware_model->get_all_for_map( $filter_company, $this->build_vehicles_filter(), NULL, $uid, 'af_name, ' );
		$data['fleets']		= $this->AvlFleet_model->count( $this->user->get_company(), $this->build_fleet_filters() );
		$data['map_data']	= json_encode( $data['vehicles'] );
		$data['update_url']	= base_url('geotrace/map_update/'.$uid);
		
		if ( $this->user->is_logged_as_user() )
		{
			$data['hws']	= &$data['vehicles'];
		}
		
		$this->set_map_to_tpl( $data, $data['vehicles'] );
		
		return $data;
	}
	
	public function send_cmd( $imei, $cmd, $param1 = null, $param2 = null, $param3 = null, $param4 = null )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		if ( $this->user->owns_imei( $imei ) )
		{
			$this->load->library('meitrack');
		
			$this->meitrack->send_cmd( $imei, $cmd, $param1, $param2, $param3, $param4 );
		}
	}
	
	protected function update_config_state( $hw )
	{
		if ( isset( $hw['ahw_cmd_timestamp'] ) )
		{
			if ( $hw['ahw_cmd_state'] == 'WAITING_RESPONSE' )
			{
				if ( ( time() - $hw['ahw_cmd_timestamp'] < AVL_CMD_TIMEOUT ) )
				{
					return false;
				}
				else
				{
					$this->load->model( 'AvlHardware_model' );
					
					$this->AvlHardware_model->update_cmd_state( $hw['ahw_imei'], 'TIMEOUT' );
				}
			}
		}
		
		return true;
	}
	
	protected function is_config_state_valid( $hw )
	{
		return $this->update_config_state( $hw );
	}
	
	public function get_json( $imei )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		if ( $this->user->owns_imei( $imei ) )
		{
			$this->load->model( 'AvlHardware_model' );
			
			$hw = $this->AvlHardware_model->get( $imei );
			
			$this->update_config_state( $hw );
			
			echo json_encode( $hw );
		}
	}
	
	protected function get_config_rules()
	{
		return array(
			array(
				'field'   => 'time_alr', 
				'label'   => 'Intervalo máximo de reporte', 
				'rules'   => 'trim|required|integer'
			),
			array(
				'field'   => 'dist_alr', 
				'label'   => 'Distancia entre reporte', 
				'rules'   => 'trim|required|integer'
			),
			array(
				'field'   => 'speed_alr', 
				'label'   => 'Disparador de Velocidad', 
				'rules'   => 'trim|required|integer'
			),
			array(
				'field'   => 'head_alr', 
				'label'   => 'Ángulo de Giro para reporte', 
				'rules'   => 'trim|required|integer'
			),
			array(
				'field'   => 'heart_alr', 
				'label'   => 'Intervalo de Heartbeat', 
				'rules'   => 'trim|required|integer'
			),
			array(
				'field'   => 'domo_alr', 
				'label'   => 'Intervalo de Heartbeat (domo)', 
				'rules'   => 'trim|integer'
			),
			array(
				'field'   => 'sleep_lvl', 
				'label'   => 'Modo Ahorro de Energía', 
				'rules'   => 'trim|integer'
			),
			array(
				'field'   => 'park_alr', 
				'label'   => 'Intervalo en Estacionamiento', 
				'rules'   => 'trim|integer'
			),
			array(
				'field'   => 'gsm', 
				'label'   => 'Host primario', 
				'rules'   => 'trim|required|callback_val_gsm'
			),
			array(
				'field'   => 'dns', 
				'label'   => 'DNS', 
				'rules'   => 'trim|callback_val_ip'
			),
			array(
				'field'   => 'sec_gsm', 
				'label'   => 'Host secundario', 
				'rules'   => 'trim|callback_val_ipdomport'
			),
			array(
				'field'   => 'sims', 
				'label'   => 'Cantidad de sims', 
				'rules'   => 'trim|integer'
			),
			array(
				'field'   => 'firm_ver', 
				'label'   => 'Versión en ejecución', 
				'rules'   => 'trim|callback_val_version'
			),
			array(
				'field'   => 'upgr_ver', 
				'label'   => 'Versión en actualización', 
				'rules'   => 'trim|callback_val_version'
			),
			array(
				'field'   => 'in1', 
				'label'   => 'Entrada 1', 
				'rules'   => 'trim|callback_val_analog_input'
			),
			array(
				'field'   => 'in2', 
				'label'   => 'Entrada 2', 
				'rules'   => 'trim|callback_val_analog_input'
			),
			array(
				'field'   => 'out1', 
				'label'   => 'Salida 1', 
				'rules'   => 'trim|integer'
			),
			array(
				'field'   => 'out2', 
				'label'   => 'Salida 2', 
				'rules'   => 'trim|integer'
			),
			array(
				'field'   => 'out3', 
				'label'   => 'Salida 3', 
				'rules'   => 'trim|integer'
			),
			array(
				'field'   => 'out4', 
				'label'   => 'Salida 4', 
				'rules'   => 'trim|integer'
			)
		);
	}
	
	public function recover_config( $imei )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$rules	= $this->get_config_rules();
		
		if ( $this->user->owns_imei( $imei ) )
		{
			$this->load->library('meitrack');
			$this->load->model( 'AvlHardware_model' );
			
			$hw	= $this->AvlHardware_model->get( $imei );
			
			$this->load->library('form_validation');
			
			$this->form_validation->set_rules( $rules );
			
			if ( $this->form_validation->run() != FALSE )
			{
				if ( isset( $hw )&& $this->is_config_state_valid( $hw ) )
				{
					$cfg	= $this->meitrack->get_default_config();
					
					if ( isset( $hw['ahw_config'] ) )
					{
						$oldcfg	= json_decode( $hw['ahw_config'], TRUE );
						
						if ( $oldcfg )
						{
							$cfg	= array_merge_recursive_distinct( $cfg, $oldcfg );
						}
					}

					$newcfg	= $this->input->post();
					
					if ( isset( $newcfg['kajax'] ) )
					{
						unset( $newcfg['kajax'] );
					}
					
					$this->meitrack->config_auto_cast( $newcfg );
					
					$cfg	= array_merge_recursive_distinct( $cfg, $newcfg );
					$json	= json_encode($cfg);
					
					$this->AvlHardware_model->update_config( $imei, $json );
				}
			}
		}
	}
	
	public function save_config( $imei )
	{
		$this->session_restrict( USER_TYPE_CPNY_RO );
		
		$rules	= $this->get_config_rules();
		
		if ( $this->user->owns_imei( $imei ) )
		{
			$this->load->library('meitrack');
			$this->load->model( 'AvlHardware_model' );
			
			$hw	= $this->AvlHardware_model->get( $imei );
			
			$this->load->library('form_validation');
			
			$this->form_validation->set_rules( $rules );
			
			if ( $this->form_validation->run() != FALSE )
			{
				if ( isset( $hw )&& $this->is_config_state_valid( $hw ) )
				{
					$cfg	= $this->meitrack->get_default_config();
					
					if ( isset( $hw['ahw_config'] ) )
					{
						$oldcfg	= json_decode( $hw['ahw_config'], TRUE );
						
						if ( $oldcfg )
						{
							$cfg	= array_merge_recursive_distinct( $cfg, $oldcfg );
						}
					}

					$newcfg	= $this->input->post();
					
					if ( isset( $newcfg['kajax'] ) )
					{
						unset( $newcfg['kajax'] );
					}
					
					$this->meitrack->config_auto_cast( $newcfg );
					
					$cfg	= array_merge_recursive_distinct( $cfg, $newcfg );
					$json	= json_encode($cfg);
					
					$this->AvlHardware_model->update_config( $imei, $json );
					$this->AvlHardware_model->update_cmd_state( $imei, 'WAITING_RESPONSE' );
					$this->AvlHardware_model->update_cmd_timestamp( $imei, time() );
					
					$this->meitrack->send_msg( $imei, $this->meitrack->gen_config( $imei, $cfg ) );
					
					$this->kajax->fancy_log_success( "Configuración guardada y enviada al móvil: $imei.<br/>Esperando respuesta del mismo." );
					
					$this->kajax->call( 'state_polling_start()' );
				}
				else
				{
					$this->kajax->fancy_log_error( "Aún se espera la confirmación del móvil del guardado de una configuración anterior." );
				}
			}
			else
			{
				$this->kajax->fancy_log_error( validation_errors() );
			}
		}
		else
		{
			$this->kajax->fancy_log_error('¡Usuario no autorizado!');
		}
		
		$this->kajax_validate_inputs( $rules, '.config_cont' );
		
		$this->kajax->out();
	}
	
	public function map( $uid = NULL )
	{
		$this->session_restrict( USER_TYPE_USER );

		$this->add_frame_view( 'geotrace/main', $this->map_get_basic_data( $uid ) );
	}
	
	public function map_update( $uid = NULL )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		echo json_encode( $this->map_get_basic_data( $uid ) );
	}
	
	public function autocomplete()
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$data		= NULL;
		$res		= array();
		$what		= get_var('what');
		$search		= get_var('search');
		$uid		= NULL;
		
		$this->load->model('AvlHardware_model');
		
		if ( $this->user->is_logged_as_user() )
		{
			$uid	= $this->user_id();
		}
		
		if ( 'hw_name' == $what )
		{
			$data	= $this->AvlHardware_model->get_autocomplete_by_name( $this->user->get_company(), $uid, $search );
		}
		else if ( 'ui_name' == $what )
		{
			$data	= $this->AvlHardware_model->get_autocomplete_by_user( $this->user->get_company(), $uid, $search );
		}
		else if ( 'hw_imei' == $what )
		{
			$data	= $this->AvlHardware_model->get_autocomplete_by_imei( $this->user->get_company(), $uid, $search );
		}
		
		if ( NULL != $data )
		{
			foreach ( $data as $r )
			{
				array_push( $res, array( 'id' => $r['id'], 'name' => $r['name'] ) );
			}
		}
		
		echo json_enc( $res );
	}
	
	protected function export_vehicles( $type )
	{
		$this->load->model('AvlHardware_model');
		
		$filename		= $this->user->get_name() . ' - geotrace - moviles - ' . $type;
		
		$data['vehicles']			= $this->AvlHardware_model->get_all( $this->user->get_company_ids(), $this->build_user_filters() );
		
		if ( 'csv' == $type )
		{
			$res	= &$data['vehicles'];
			$ret	= '';
			$sep	= CSV_SEPARATOR;
			$rsep	= '"' . $sep . '"';
			
			csv_create_header( $filename );
			 
			$ret = implode( '"' . $sep . '"', array( '"IMEI', 'Nombre', 'Tipo', 'Estado', 'Licencia', 'Modelo', 'Usuario"' ) ) . "\n";
			
			if ( isset( $res ) )
			{
				csv_array_sanitize( $res );
				
				foreach ( $res as $e )
				{
					$ret.=	'"' . $e['ahw_imei'] 		. $rsep . $e['ahw_name'] 				. $rsep . $e['ahw_icon'] 			. '"' . $sep .
							'"' . $e['ahw_state'] 		. $rsep . $e['ahw_licenseplate'] 		. $rsep . $e['ahw_model'] 			. '"' . $sep .
							'"' . $e['ui_lastname']		. ' ' .$e['ui_name'] 	. '"' . "\n";
				}
			}
			
			echo $ret;
		}
		else if ( 'pdf'== $type )
		{
			$html = $this->add_frame_view( 'geotrace/vehicles_pdf', $data, FALSE, FALSE, TRUE );
			
			pdf_create( $html, $filename, 5000 );
		}
	}
	
	public function export( $type, $data = NULL )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		if ( NULL != $data && is_array($data) )
		{
			$filename		= $this->user->get_name() . ' - geotrace - historial - ' . $type;
			
			if ( 'csv' == $type )
			{
				$res	= $data['points'];
				$ret	= '';
				$sep	= CSV_SEPARATOR;
				$rsep	= '"' . $sep . '"';
				
				csv_create_header( $filename );
				 
				$ret = implode( '"' . $sep . '"', array( '"IMEI', 'Fecha', 'Velocidad', 'Código de Evento', 'Latitud', 'Longitud', 'Altitud', 'Orientación', 'HDOP', 'Señal de GSM', 'Estado de GPS', 'GPS número de satélites"' ) ) . "\n";
				
				if ( isset( $res ) )
				{
					csv_array_sanitize( $res );
					
					foreach ( $res as $e )
					{
						$ret.=	'"' . $e['ae_imei'] 		. $rsep . pp_date( $e['ae_timestamp'] )	. $rsep . $e['ae_speed'] 			. '"' . $sep .
								'"' . $e['ae_code'] 		. $rsep . $e['ae_lat'] 					. $rsep . $e['ae_long'] 			. '"' . $sep .
								'"' . $e['ae_altitude'] 	. $rsep . $e['ae_heading'] 				. $rsep . $e['ae_hdop'] 			. '"' . $sep .
								'"' . $e['ae_gsmsignal']	. $rsep . $e['ae_gpsstatus'] 			. $rsep . $e['ae_gpssatnum'] 		. '"' . "\n";
					}
				}
				
				echo $ret;
			}
			else if ( 'pdf'== $type )
			{
				$html = $this->add_frame_view( 'geotrace/vehicle_pdf', $data, FALSE, FALSE, TRUE );
				
				pdf_create( $html, $filename, 5000 );
			}
		}
		else
		{
			$this->export_vehicles( $type );
		}
	}
	
	protected function view_get_basic_data( $imei )
	{
		$this->load->model('AvlEvent_model');
		$this->load->model( 'AvlHardware_model' );
		$this->load->model('AvlFleet_model');
		$this->load->library('meitrack');
		
		$from_ref					= NULL != get_var('from') ? substr( get_var('from'), strlen( 'Desde el ' ) ) : NULL;
		$to_ref						= NULL != get_var('to') ? substr( get_var('to'), strlen( 'Hasta el ' ) ) : NULL;
		$data						= array();
		$data['from']				= NULL != $from_ref ? $from_ref : strftime( '%d/%m/%Y %H:%M', time() - 3600 );
		$data['to']					= NULL != $to_ref ? $to_ref : strftime( '%d/%m/%Y %H:%M', time() );
		$data['is_search']			= NULL != $to_ref;
		$query_filter				= NULL;
		
		if ( NULL != get_var('events') )
		{
			$filter = array( array(
				'field_name'	=>	'ae_code',
				'filter_val'	=>	get_var('events')
			) );
			
			$query_filter = SQL::build_query_filter( $filter );
		}
		
		$start_time					= get_timestamp_from_date_time( $data['from'] );
		$end_time					= get_timestamp_from_date_time( $data['to'] );
		$data['vehicles']			= $this->AvlHardware_model->get_for_map( $imei, $this->build_vehicles_filter() );
		$data['hw']					= $data['vehicles'][0];
		$data['map_data']			= json_encode( $data['vehicles'] );
		$data['points']				= $this->AvlEvent_model->get_tour( $imei, $start_time, $end_time, $query_filter );
		$data['map_data_points']	= json_encode( $data['points'] );
		$data['fleets']				= $this->AvlFleet_model->get_all( NULL, $this->build_fleet_filters() );
		$data['update_url']			= base_url('/geotrace/view_update/'.$imei);
		
		if ( !isset( $data['hw']['ahw_config'] ) || FALSE == json_decode( $data['hw']['ahw_config'] ) )
		{
			$data['hw']['ahw_config'] = json_encode( $this->meitrack->get_default_config() );
			
			// TODO: fix it
			$this->AvlHardware_model->update_config( $imei, $data['hw']['ahw_config'] );
		}

		$data['hw']['config'] = json_decode( $data['hw']['ahw_config'], TRUE );
		
		$data['hw']['config'] = array_merge( $this->meitrack->get_default_config(), $data['hw']['config'] );
		
		if ( $this->user->is_logged_as_god() )
		{
			$this->load->model('Company_model');
			$data['all_com']		= $this->Company_model->get_all_names();
		}
		
		return $data;
	}
	
	public function view( $imei, $export = '', $type = '' )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$data = $this->view_get_basic_data( $imei );

		if ( 'csv' == $type || 'pdf' == $type )
		{
			$this->export( $type, $data );
		}
		else
		{
			$this->add_frame_view( 'geotrace/vehicle', $data );
		}
	}
	
	public function view_update( $imei )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		echo json_encode( $this->view_get_basic_data( $imei ) );
	}
	
	public function update()
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$post = $this->input->post();
		
		$this->load->library('form_validation');
		
		$rules	= array(
			array(
				'field'   => 'name', 
				'label'   => 'Nombre', 
				'rules'   => 'trim|required|max_length[64]'
			),
			array(
				'field'   => 'model', 
				'label'   => 'Vehículo', 
				'rules'   => 'trim|max_length[64]'
			),
			array(
				'field'   => 'licenseplate', 
				'label'   => 'Licencia', 
				'rules'   => 'trim|max_length[32]'
			)
		);
		
		$this->form_validation->set_rules( $rules );
		
		if ( $this->form_validation->run() != FALSE )
		{
			if ( $this->user->owns_imei( $post['imei'] ) )
			{
				$this->load->model('AvlHardware_model');
				
				$this->AvlHardware_model->update( $post, $this->user );
				
				$this->kajax->fancy_log_success( "Vehículo número: " . $post['imei'] . " guardado con éxito." );
			}
			else
			{
				$this->kajax->fancy_log_error('No puedes modificar este vehículo, no tienes suficientes permisos.');
			}
		}
		else
		{
			$this->kajax->fancy_log_error( validation_errors() );
		}
		
		$this->kajax->out();
	}
	
	protected function build_user_filters()
	{
		$filter	= array(
			array(
				'field_name'	=>	'ahw_imei',
				'filter_val'	=>	get_var( 'ahw_imei' ),
				'filter_type'	=>	SQLFilterType::ILIKE
			),
			array(
				'field_name'	=>	'ahw_name',
				'filter_val'	=>	get_var( 'ahw_name' ),
				'filter_type'	=>	SQLFilterType::ILIKE
			),
			array(
				'field_name'	=>	'ahw_licenseplate',
				'filter_val'	=>	get_var( 'ahw_licenseplate' ),
				'filter_type'	=>	SQLFilterType::ILIKE
			),
			array(
				'field_name'	=>	'ahw_model',
				'filter_val'	=>	get_var( 'ahw_model' ),
				'filter_type'	=>	SQLFilterType::ILIKE
			),
			array(
				'field_name'	=>	'ahw_uid',
				'filter_val'	=>	get_var( 'ui_uid' )
			),
			array(
				'order_by'		=>	get_var_def( 'order_by', 'ahw_imei' ),
				'order_fields'	=>	array( 'ahw_imei', 'ahw_name', 'ahw_licenseplate', 'ahw_model' ),
				'order_dir'		=>	get_var_def( 'order_dir', 'ASC' )
			)
		);
		
		if ( $this->user->is_logged_as_user() )
		{
			$filter[] = array(
				'field_name'	=>	'ahw_uid',
				'filter_val'	=>	$this->user_id()
			);
		}
		
		$query_filter		= SQL::build_query_filter( $filter );
		
		return $query_filter;
	}
	
	protected function build_fleet_filters()
	{
		$filter = array(
			array(
				'order_by'		=>	get_var_def( 'order_by', 'af_name' ),
				'order_fields'	=>	array( 'af_name' ),
				'order_dir'		=>	get_var_def( 'order_dir', 'ASC' )
			)
		);
		
		if ( $this->user->is_logged_as_user() )
		{
			$filter[] = array(
				'field_name'	=>	'af_uid',
				'filter_val'	=>	$this->user_id()
			);
		}
		
		$query_filter		= SQL::build_query_filter( $filter );
		
		return $query_filter;
	}
	
	public function all()
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->load->library('pagination');
		
		$this->load->model('AvlHardware_model');
		
		$page						= get_var_def( 'page_num', 1 );
		$config						= pagination_config();
		$query_filter				= $this->build_user_filters();
		$data['ahw_imei']			= get_var( 'ahw_imei' );
		$data['ahw_name']			= get_var( 'ahw_name' );
		$data['ahw_uid']			= get_var( 'ahw_uid' );
		$data['ui_fullname']		= get_var( 'ui_fullname' );
		$config['total_rows'] 		= $data['total_vehicles']	= $this->AvlHardware_model->count( $this->user->get_company_ids(), $query_filter );
		$data['vehicles']			= $this->AvlHardware_model->get_all( $this->user->get_company_ids(), $query_filter, $config['per_page'], $page );
		$config['base_url']			= base_url( '/geotrace/all/?' . http_build_query_pagination() );
		$config['anchor_class']		= 'class="ajax-link" ';
		$data['base_url']			= $config['base_url'];
		
		if ( $this->user->is_logged_as_user() )
		{
			$this->load->model('AvlFleet_model');
			
			$data['fleets']			= $this->AvlFleet_model->get_all( NULL, $this->build_fleet_filters() );
		}
		else if ( $this->user->is_logged_as_god() )
		{
			$this->load->model('Company_model');
			
			$data['companies']		= $this->Company_model->get_all_names();
		}
		
		$this->pagination->initialize($config);
		
		$data['pagination']			= $this->pagination->create_links();
		
		$this->add_frame_view( 'geotrace/vehicles_list', $data );
	}
	
	public function search()
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->load->library('pagination');
		
		$this->load->model('AvlHardware_model');
		
		$data['js_cb']				= get_var( 'cb' );
		$data['row_id']				= get_var_def( 'row_id', 0 );
		$page						= get_var_def( 'page_num', 1 );
		$config						= pagination_config();
		$config['per_page']			= 12;
		$query_filter				= $this->build_user_filters();
		$data['ahw_imei']			= get_var( 'ahw_imei' );
		$data['ahw_name']			= get_var( 'ahw_name' );
		$data['ahw_licenseplate']	= get_var( 'ahw_licenseplate' );
		$data['ahw_model']			= get_var( 'ahw_model' );
		$data['ahw_uid']			= get_var( 'ahw_uid' );
		$data['ui_fullname']		= get_var( 'ui_fullname' );
		$config['total_rows'] 		= $data['total_vehicles']	= $this->AvlHardware_model->count( $this->user->get_company_ids(), $query_filter );
		$data['vehicles']			= $this->AvlHardware_model->get_all( $this->user->get_company_ids(), $query_filter, $config['per_page'], $page );
		$config['base_url']			= base_url( '/geotrace/search/?' . http_build_query_pagination() );
		$config['anchor_class']		= 'class="ajax-paging-link ajax-clean" ';
		$data['base_url']			= $config['base_url'];
		
		$this->pagination->initialize($config);
		
		$data['pagination']			= $this->pagination->create_links();
		
		$this->load->view( 'geotrace/vehicles_search_list', $data );
	}
	
	protected function fleet_id_replace( $id )
	{
		$this->kajax_replace_new_ids( 
			$id,
			array(	'row_', 
					'row_hidden_'
			)
		);
	}
	
	public function fleet_update()
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$post = $this->input->post();
		
		$this->load->library('form_validation');
		
		$rules	= array(
			array(
				'field'   => 'name', 
				'label'   => 'Nombre', 
				'rules'   => 'trim|required|max_length[64]'
			)
		);
		
		$this->form_validation->set_rules( $rules );
		
		if ( $this->form_validation->run() != FALSE )
		{
			$this->load->model('AvlFleet_model');
			
			if ( 0 != $post['id'] )
			{
				if ( $this->user->owns_fleet( $post['id'] ) )
				{
					$this->AvlFleet_model->update( $post['name'], $post['id'] );
					
					$this->kajax->fancy_log_success( "Flota: " . $post['name'] . " guardada con éxito." );
				}
				else
				{
					$this->kajax->fancy_log_error('No puedes modificar esta flota, no tienes suficientes permisos.');
				}
			}
			else
			{
				$id = $this->AvlFleet_model->add( $post['name'], $this->user_id() );
				
				$this->kajax->fancy_log_success( "Flota: " . $post['name'] . " añadida con éxito." );
				$this->fleet_id_replace( $id );
				$this->kajax->call( 'table_row_new_convert_to_id( ' . $id . ', "id", "' . base_url('/geotrace/fleet_delete/'.$id) . '", "¿Seguro que quiere eliminar esta flota?" )' );
			}
		}
		else
		{
			$this->kajax->fancy_log_error( validation_errors() );
		}
		
		$this->kajax->out();
	}
	
	public function fleet_delete( $id = NULL )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->load->model('AvlFleet_model');
		
		if ( $this->user->owns_fleet( $id ) )
		{
			$this->AvlFleet_model->delete( $id );
			
			$this->kajax->fancy_log_success( "Flota eliminada con éxito." );
			
			$this->kajax->remove( '#row_hidden_' . $id );
			$this->kajax->remove( '#row_' . $id );
		}
		
		$this->kajax->out();
	}
	
	public function fleets()
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->load->model('AvlFleet_model');
		
		$data['fleets']				= $this->AvlFleet_model->get_all( NULL, $this->build_fleet_filters() );
		
		$this->add_frame_view( 'geotrace/fleets_list', $data );
	}
	
	public function get_fleet_new_row()
	{
		$this->session_restrict( USER_TYPE_USER );
		
		$this->kajax->show('#fleets_list_table');
		$this->kajax->hide('#no_fleets');
		$this->kajax->prepend( '#fleets_list_table', $this->load->view( 'geotrace/new_row_fleet', NULL, TRUE ) );
		$this->kajax->out();
	}
	
	public function link( $uid, $imei )
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->model('AvlHardware_model');
		
		if ( $this->user->owns_imei( $imei ) && !$this->User_model->owns_imei( $uid, $imei ) )
		{
			$this->AvlHardware_model->link( $imei, $uid );
			
			$data['hw']	= $this->AvlHardware_model->get( $imei );
			
			$this->kajax->append( '#geotrace_box', $this->load->view( 'geotrace/new_user_ahw', $data, TRUE ) );
			$this->kajax->init_el( '#geotrace_box');
		}
		
		$this->kajax->out();
	}
	
	public function unlink( $imei )
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->model('AvlHardware_model');
		
		if ( $this->user->owns_imei( $imei ) )
		{
			$this->AvlHardware_model->unlink( $imei );
			
			$this->kajax->remove("#ahw_$imei");
		}
		
		$this->kajax->out();
	}
	
	public function get_lastest_events( $imei )
	{
		$this->session_restrict( USER_TYPE_USER );
		
		if ( isset( $imei ) && $this->user->owns_imei( $imei ) )
		{
			$this->load->model('GlobalEvent_model');
			
			$res = $this->GlobalEvent_model->get_lastest_geotrace_events( $imei );
			
			if ( isset ( $res ) )
			{
				foreach( $res as &$row )
				{
					$row['ftime'] = strftime( '%a %d/%b/%y - %H:%M:%S', $row["time"] );
				}
			}
			
			echo json_encode( $res );
		}
	}
	
	public function log()
	{
		$this->session_restrict( USER_TYPE_GOD );
		
		$this->add_frame_view( 'geotrace/log' );
	}
	
	public function download_log()
	{
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->model('ReceiverGeotraceLog_model');
		
		$com_id		= $this->user->get_type_id();
		$msgs		= $this->ReceiverGeotraceLog_model->get_from( format_date_time( get_var('from') ), format_date_time( get_var('to') ) );
		$filename	= 'geotrace - log';
		
		csv_create_header( $filename );
		
		$str = '';
		
		if ( isset( $msgs ) )
		{
			csv_array_sanitize( $msgs );
			
			foreach ( $msgs as $msg )
			{
				$str .= '"' . datetime_noms( $msg['time'] ) . '",';
				
				$msgs = explode( ' ', $msg['msg'] );
				
				foreach ( $msgs as $msg )
				{
					$str .= "\"$msg\";";
				}
				
				$str = substr($str, 0, strlen($str)-1);
				$str .= "\n";
			}
		}
		
		echo $str;
	}
	
	public function get_log()
	{	
		$this->session_restrict( USER_TYPE_CPNY );
		
		$this->load->model('ReceiverGeotraceLog_model');
		
		$msgs					= $this->ReceiverGeotraceLog_model->get( get_post('last_id' ) );
		$res['ok']				= true;
		$res['data']			= $msgs;
		
		echo json_encode( $res );
	}
}
