<?

class Dtrans_Api extends BASE_Controller
{
	protected function build_query_filter()
	{
		$filter = array(
			array(
				'field_name'	=>	'dt_serial',
				'filter_val'	=>	get_var( 'mac' ),
				'val_convert'	=>	SQLConvertType::HEXDEC
			),
			array(
				'field_name'	=>	'dt_timestamp',
				'filter_val'	=>	get_var_def( 'to', time() ),
				'filter_type'	=>	SQLFilterType::SMALLER_OR_EQ,
				'field_type'	=>	SQLFieldType::INT
			),
			array(
				'field_name'	=>	'dt_timestamp',
				'filter_val'	=>	get_var( 'from' ),
				'filter_type'	=>	SQLFilterType::BIGGER_OR_EQ,
				'field_type'	=>	SQLFieldType::INT
			),
			array(
				'order_by'		=> get_var_def( 'order_by', 'dt_timestamp' ),
				'order_fields'	=> array( 'dt_timestamp' ),
				'order_dir'		=> get_var_def( 'order_dir', 'DESC' )
			)
		);
		
		return SQL::build_query_filter( $filter );
	}
	
	public function query()
	{
		http_header_json_no_cache();
		
		$this->load->model('Company_model');
		$this->load->model('DTransFrames_model');
		
		$access_token = get_var('access_token');
		$api_key = get_var('api_key');
		$com = NULL;
		
		if( isset($api_key) && ( 'O850ex0lAslaBuUZi73n7g4ULlEw70np' == $access_token ) )
		{
			$com = $this->Company_model->get_from_apikey_base( $api_key );
		}
		
		if ( isset($com) )
		{
			$companies = array( $com['com_id'] );
			
			$query_filter = $this->build_query_filter();
			
			$data['count']	= intval( $this->DTransFrames_model->count( $companies, $query_filter ) );
			$data['offset']	= get_var_def('offset',0);
			$data['frames']	= $this->DTransFrames_model->get_all( $companies, $query_filter, 250, $data['offset'], 'dt_timestamp as timestamp, to_hex(dt_serial) as mac, dt_frame as frame' );
			
			echo json_encode( $data );
		}
		else
		{
			echo json_encode( array( 'status' => 'error' ) );
		}
	}
}
